
#include "comb/ksubset-twoclose-list.h"


#include "aux0/binomial.h"
#include "aux0/swap.h"

#include "bits/bitlow.h"  // lowest_one_idx()
#include "bits/bit2pow.h"  // one_bit_q()
#include "bits/bitcount.h"  // bit_count()

#include "fxtio.h"
#include "jjassert.h"
#include "nextarg.h"
#include "fxttypes.h"


//% k-subsets (kmin<=k<=kmax) in two-close order with homogeneous moves.
//% Representation as list of elements.

// Cf. comb/ksubset-twoclose-demo.cc
// Cf. comb/ksubset-twoclose-rec-demo.cc
// Cf. comb/ksubset-twoclose-list-rec-demo.cc

//#define TIMING  // uncomment to disable printing


int
main(int argc, char **argv)
{
    ulong n = 6;
    NXARG(n, "Subsets of n-element set.");
    ulong kmin = 2;
    NXARG(kmin, "Minimal number of elements in subsets.");
    ulong kmax = 4;
    NXARG(kmax, "Maximal number of elements in subsets.");

    if ( kmin > kmax )  swap2(kmin, kmax);
    if ( kmax > n )  kmax = n;
    if ( kmin > n )  kmin = n;

    bool w = false;
    NXARG(w, "Whether to modify ordering (bool).");

    ksubset_twoclose_list C(n, kmin, kmax, w);
    ulong ct = 0;

    do
    {
        ++ct;
#if defined TIMING
#else
        cout << setw(4) << ct << ":";
        C.print_deltaset("    ");
        C.print("    ");
        cout << endl;
#endif  // TIMING
    }
    while ( C.next() );

    cout << "ct=" << ct << endl;

    ulong z = 0;
    for (ulong k=kmin; k<=kmax; ++k)  z += binomial(n, k);
    jjassert( ct==z );

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 29 0 29
arg 1: 29 == n  [Subsets of n-element set.]  default=6
arg 2: 0 == kmin  [Minimal number of elements in subsets.]  default=2
arg 3: 29 == kmax  [Maximal number of elements in subsets.]  default=4
arg 4: 0 == w  [Whether to modify ordering (bool).]  default=0
ct=536870912
4.95user 0.00system 0:04.95elapsed 99%CPU
 ==> 536870912/4.95 == 108,458,770 per second

time ./bin 29 15 29
arg 1: 29 == n  [Subsets of n-element set.]  default=6
arg 2: 15 == kmin  [Minimal number of elements in subsets.]  default=2
arg 3: 29 == kmax  [Maximal number of elements in subsets.]  default=4
arg 4: 0 == w  [Whether to modify ordering (bool).]  default=0
ct=268435456
3.14user 0.00system 0:03.14elapsed 100%CPU
 ==> 268435456/3.14 == 85,488,998 per second

time ./bin 29 0 15
arg 1: 29 == n  [Subsets of n-element set.]  default=6
arg 2: 0 == kmin  [Minimal number of elements in subsets.]  default=2
arg 3: 15 == kmax  [Maximal number of elements in subsets.]  default=4
arg 4: 0 == w  [Whether to modify ordering (bool).]  default=0
ct=345994216
3.55user 0.00system 0:03.56elapsed 99%CPU
 ==> 345994216/3.55 == 97,463,159 per second

*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/ksubset-twoclose-list-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/ksubset-twoclose-list-demo.cc DEMOFLAGS=-DTIMING"
/// End:

