
#include "comb/ksubset-twoclose.h"


#include "aux0/binomial.h"
#include "aux0/swap.h"

#include "bits/bitlow.h"  // lowest_one_idx()
#include "bits/bit2pow.h"  // one_bit_q()
#include "bits/bitcount.h"  // bit_count()

#include "fxtio.h"
#include "jjassert.h"
#include "nextarg.h"
#include "fxttypes.h"


//% k-subsets (kmin<=k<=kmax) in two-close order with homogeneous moves.

// Cf. comb/ksubset-twoclose-rec-demo.cc
// Cf. comb/ksubset-twoclose-list-demo.cc
// Cf. comb/ksubset-twoclose-list-rec-demo.cc

//#define TIMING  // uncomment to disable printing

bool
test( const ulong *A, ulong n, ulong ct )
{
    static ulong bo = 0;  // bitset

    ulong b = 0;  // bitset
    for (ulong j=0; j<n; ++j)
        if ( A[j] )  { b |= (1UL << j); }

    bool ret = true;
    if ( ct >= 2 )
    {
        // check whether changes are two-close and homogeneous:
        ulong x = b ^ bo;
        const ulong bc = bit_count( x );
        if ( bc > 2 )  ret = false;
        if ( bc == 2 )
        {
            ulong x1 = lowest_one_idx(x);
            x ^= (1UL<<x1);
            ulong x2 = lowest_one_idx(x);  // x2 > x1
            if ( (x2-x1) > 2 )  ret = false;  // two-close?
            if ( (x2-x1) == 2 )  // homogeneous?
                if ( 0 != (b & (1UL<<(x1+1))) )
                    ret = false;
        }
    }

    bo = b;
    return ret;
}
// -------------------------


int
main(int argc, char **argv)
{
    ulong n = 6;
    NXARG(n, "Subsets of n-element set.");
    ulong kmin = 2;
    NXARG(kmin, "Minimal number of elements in subsets.");
    ulong kmax = 4;
    NXARG(kmax, "Maximal number of elements in subsets.");

    if ( kmin > kmax )  swap2(kmin, kmax);
    if ( kmax > n )  kmax = n;
    if ( kmin > n )  kmin = n;

    bool w = false;
    NXARG(w, "Whether to modify ordering (bool).");

    ksubset_twoclose C(n, kmin, kmax, w);
    ulong ct = 0;

    do
    {
        ++ct;
#if defined TIMING
#else
        cout << setw(4) << ct << ":";
        C.print("    ");
        C.print_set("    ");
        cout << endl;
        jjassert ( test( C.data(), n, ct ) );
#endif  // TIMING
    }
    while ( C.next() );

    cout << "ct=" << ct << endl;

    ulong z = 0;
    for (ulong k=kmin; k<=kmax; ++k)  z += binomial(n, k);
    jjassert( ct==z );

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 29 0 29
arg 1: 29 == n  [Subsets of n-element set.]  default=6
arg 2: 0 == kmin  [Minimal number of elements in subsets.]  default=2
arg 3: 29 == kmax  [Maximal number of elements in subsets.]  default=4
ct=536870912
4.45user 0.00system 0:04.45elapsed 100%CPU
 ==> 536870912/4.45 == 120,645,148 per second

time ./bin 29 15 29
arg 1: 29 == n  [Subsets of n-element set (n>=1).]  default=6
arg 2: 15 == kmin  [Minimal number of elements in subsets.]  default=2
arg 3: 29 == kmax  [Maximal number of elements in subsets.]  default=4
arg 4: 0 == w  [Whether to modify ordering (bool).]  default=0
ct=268435456
2.81user 0.00system 0:02.82elapsed 99%CPU
 ==> 268435456/2.81 == 95,528,632 per second

time ./bin 29 0 15
arg 1: 29 == n  [Subsets of n-element set (n>=1).]  default=6
arg 2: 0 == kmin  [Minimal number of elements in subsets.]  default=2
arg 3: 15 == kmax  [Maximal number of elements in subsets.]  default=4
arg 4: 0 == w  [Whether to modify ordering (bool).]  default=0
ct=345994216
3.47user 0.00system 0:03.47elapsed 100%CPU
 ==> 345994216/3.47 == 99,710,148 per second

*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/ksubset-twoclose-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/ksubset-twoclose-demo.cc DEMOFLAGS=-DTIMING"
/// End:

