
#include "comb/composition-nz-subdiagonal.h"

//#include "comb/partition-conj.h"

#include "comb/comb-print.h"

#include "fxtio.h"
#include "jjassert.h"

#include "fxttypes.h"
#include "nextarg.h"

//% Subdiagonal compositions: compositions a[1] + a[2] + ... + a[m] = n
//%   such that a[k] <= k.
//% Lexicographic order.
//% Cf. OEIS sequence A008930.

// Cf. comb/composition-nz-superdiagonal-demo.cc

//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong n = 9;
    NXARG(n, "subdiagonal compositions of n");

    bool aa = 0;
    NXARG(aa, "Whether to render as ASCII art");

    composition_nz_subdiagonal P(n);

    ulong ct = 0;


#if defined TIMING
    do  { ++ct; }  while ( P.next() );

#else  // TIMING

    ulong m = P.num_parts();
    do
    {
        ++ct;
        cout << setw(4) << ct << ": ";

        cout << " [" << setw(2) << m << "] ";

//        cout << " [" << setw(2) << n-m << "] ";
//        cout << " [" << setw(2) << P.data()[m-1] << "] ";

        P.print("  ");

        cout << endl;

        if ( aa )  // ASCII art
        {
            P.print_aa();
            cout << endl;
            cout << endl;
        }

        jjassert( P.OK() );
    }
    while ( 0 != (m=P.next()) );
#endif  // TIMING

    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 33
arg 1: 33 == n  [subdiagonal compositions of n]  default=9
arg 2: 0 == aa  [Whether to render as ASCII art]  default=0
 ct=1240771141
3.19user 0.00system 0:03.19elapsed 100%CPU
 ==> 1240771141/3.19 == 388,956,470 per second

*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/composition-nz-subdiagonal-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/composition-nz-subdiagonal-demo.cc DEMOFLAGS=-DTIMING"
/// End:

