
#include "comb/combination-lex.h"

#include "nextarg.h"

#include "fxttypes.h"
#include "fxtio.h"

#include "jjassert.h"


//% Combinations (n choose k) in lexicographic order.

//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong n = 7, k = 4;
    NXARG(n, "Combinations (n choose k) in lexicographic order:  n>0");
    NXARG(k, " 0 < k <= n");
    jjassert( 0<k );
    jjassert( k<=n );
    bool rq = 0;
    NXARG(rq, "Whether to reverse order");

    combination_lex C(n, k);

    if ( 0==rq )  C.first();
    else          C.last();

    ulong ct = 0;
#if defined TIMING
    if ( rq )  cout << "backwards:\n";
    if ( 0==rq )  do  { ++ct; }  while ( k!=C.next() );
    else          do  { ++ct; }  while ( k!=C.prev() );

#else

    ulong j = 0;
    do
    {
        ++ct;
        cout << setw(4) << ct << ":";
        C.print_set("    ");
        cout << "  " << j << "  ";
        C.print_deltaset("    ");
        cout << endl;
        if ( 0==rq )  j = C.next();
        else          j = C.prev();
    }
    while ( j < k );
    cout << endl;
#endif  // TIMING

    cout << " ct = " << ct << endl;

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 32 20 0
arg 1: 32 == n  [Combinations (n choose k) in lexicographic order:  n>0]  default=7
arg 2: 20 == k  [ 0 < k <= n]  default=4
arg 3: 0 == rq  [Whether to reverse order]  default=0
 ct = 225792840
0.71user 0.00system 0:00.71elapsed 99%CPU
 ==> 225792840/0.71 == 318,018,084 per second

 time ./bin 32 12 0
arg 1: 32 == n  [Combinations (n choose k) in lexicographic order:  n>0]  default=7
arg 2: 12 == k  [ 0 < k <= n]  default=4
arg 3: 0 == rq  [Whether to reverse order]  default=0
 ct = 225792840
0.50user 0.00system 0:00.50elapsed 100%CPU
 ==> 225792840/0.50 == 451,585,680 per second


 time ./bin 32 20 1
arg 1: 32 == n  [Combinations (n choose k) in lexicographic order:  n>0]  default=7
arg 2: 20 == k  [ 0 < k <= n]  default=4
arg 3: 1 == rq  [Whether to reverse order]  default=0
backwards:
 ct = 225792840
0.85user 0.00system 0:00.85elapsed 100%CPU
 ==> 225792840/0.85 == 265,638,635 per second

  time ./bin 32 12 1
arg 1: 32 == n  [Combinations (n choose k) in lexicographic order:  n>0]  default=7
arg 2: 12 == k  [ 0 < k <= n]  default=4
arg 3: 1 == rq  [Whether to reverse order]  default=0
backwards:
 ct = 225792840
0.59user 0.00system 0:00.59elapsed 100%CPU
 ==> 225792840/0.59 == 382,699,728 per second

*/

/*
BENCHARGS=32 20 0
BENCHARGS=32 12 0
BENCHARGS=32 20 1
BENCHARGS=32 12 1
*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/combination-lex-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/combination-lex-demo.cc DEMOFLAGS=-DTIMING"
/// End:

