"""
Gstreamer fuzzing project.
"""

from fusil.process.create import CreateProcess
from fusil.process.watch import WatchProcess
from fusil.process.stdout import WatchStdout
from fusil.auto_mangle import AutoMangle

def setupProject(project):
    GST_LAUNCH_BIN = '/usr/bin/gst-launch-0.10'
    TIMEOUT = 10

    # Create buggy input file
    orig_filename = project.application().getInputFilename("Audio or video file")
    mangle = AutoMangle(project, orig_filename)
    mangle.hard_max_op = 500
    mangle.max_size = 10*1024*1024

    # -f option: Do not install a fault handler
    # Another interresting option: --gst-fatal-warnings
    process = GstreamerProcess(project,
        [GST_LAUNCH_BIN, '-f', 'playbin', '<playbin_uri>'],
        timeout=TIMEOUT)
    WatchProcess(process, exitcode_score=0.20)
    #, timeout_score=0)
    stdout = WatchStdout(process)
    stdout.words['error'] = 0.10
    stdout.words['critical'] = 0.30
    del stdout.words['assertion']
    stdout.addRegex(r'Could not decode stream\.$', -1.0)
    stdout.addRegex(r'Could not (?:decode stream|determine type of stream|demultiplex stream)\.$', -1.0)
    stdout.addRegex(r'You might need to install the necessary plugins', 1.0)
    stdout.score_weight = 0.40

class GstreamerProcess(CreateProcess):
    def on_mangle_filenames(self, movie_filenames):
        self.cmdline.arguments[-1] = 'uri=file://' + movie_filenames[0]
        self.createProcess()

