from os.path import basename, join as path_join, exists as path_exists
from os import mkdir, listdir, getcwd
from shutil import rmtree

class Directory:
    def __init__(self, directory):
        self.directory = directory
        self.files = set()

    def ignore(self, filename):
        try:
            self.files.remove(filename)
        except KeyError:
            pass

    def mkdir(self):
        mkdir(self.directory)

    def isEmpty(self, ignore_generated=False):
        for filename in listdir(self.directory):
            if filename in ('.', '..'):
                continue
            if filename in self.files and ignore_generated:
                continue
            return False
        return True

    def rmtree(self):
        rmtree(self.directory)

    def _uniqueFilename(self, directory=None, name=None,
    count=None, count_format="%04d"):
        if not directory:
            directory = getcwd()
        if name:
            name_pattern = basename(name).split(".", 1)
            if count is None:
                count = 0
            count_format = "-" + count_format
            if 1 < len(name_pattern):
                name_pattern = name_pattern[0] + count_format + '.' + name_pattern[1]
            else:
                name_pattern = name_pattern[0] + count_format
        else:
            if count is None:
                count = 1
            name_pattern = count_format
        while True:
            if not name:
                name = "%04d" % count
            elif 0 < count:
                name = name_pattern % count
            if name not in self.files:
                filename = path_join(directory, name)
                if not path_exists(filename):
                    self.files.add(name)
                    return filename
            count += 1

