const iv = [ 0, 0, 0, 0, 0, 0, 0, 0x4a, 0, 0, 0, 0 ];
const plain =
  "Ladies and Gentlemen of the class of '99: If I could offer you only one tip " +
  "for the future, sunscreen would be it.";
const cipher = [
  0x6e, 0x2e, 0x35, 0x9a, 0x25, 0x68, 0xf9, 0x80, 0x41, 0xba, 0x07, 0x28, 0xdd,
  0x0d, 0x69, 0x81, 0xe9, 0x7e, 0x7a, 0xec, 0x1d, 0x43, 0x60, 0xc2, 0x0a, 0x27,
  0xaf, 0xcc, 0xfd, 0x9f, 0xae, 0x0b, 0xf9, 0x1b, 0x65, 0xc5, 0x52, 0x47, 0x33,
  0xab, 0x8f, 0x59, 0x3d, 0xab, 0xcd, 0x62, 0xb3, 0x57, 0x16, 0x39, 0xd6, 0x24,
  0xe6, 0x51, 0x52, 0xab, 0x8f, 0x53, 0x0c, 0x35, 0x9f, 0x08, 0x61, 0xd8, 0x07,
  0xca, 0x0d, 0xbf, 0x50, 0x0d, 0x6a, 0x61, 0x56, 0xa3, 0x8e, 0x08, 0x8a, 0x22,
  0xb6, 0x5e, 0x52, 0xbc, 0x51, 0x4d, 0x16, 0xcc, 0xf8, 0x06, 0x81, 0x8c, 0xe9,
  0x1a, 0xb7, 0x79, 0x37, 0x36, 0x5a, 0xf9, 0x0b, 0xbf, 0x74, 0xa3, 0x5b, 0xe6,
  0xb4, 0x0b, 0x8e, 0xed, 0xf2, 0x78, 0x5e, 0x42, 0x87, 0x4d ];

function main({ reserve, dump, my_print, hex, p32 }, imports) {
  let mem = imports.Karamel.mem;
  let start = reserve(mem, 1024);
  dump(mem, 2*1024);
  my_print("start =" + p32(start));

  // Allocating our parameters in the first 1k of the memory.
  let m8 = new Uint8Array(mem.buffer);
  let counter = 1;
  let len = plain.length;
  let p_key = start;
  for (let i = 0; i < 32; ++i)
    m8[p_key+i] = i;
  let p_iv = p_key + 32;
  for (let i = 0; i < iv.length; ++i)
    m8[p_iv + i] = iv[i];
  let p_plain = p_iv + iv.length;
  for (let i = 0; i < plain.length; ++i)
    m8[p_plain + i] = plain.charCodeAt(i);
  let p_cipher = p_plain + plain.length;

  let counter_mode = imports.Crypto_Symmetric_Chacha20.counter_mode;
  counter_mode(p_key, p_iv, counter, len, p_plain, p_cipher);

  my_print("p_plain =" + p32(p_plain));
  my_print("p_cipher =" + p32(p_cipher));
  dump(mem, 2*1024);

  my_print("Chacha20 finished (len="+len+")");
  my_print("Plaintext was:");
  my_print(hex(m8, p_plain, len));
  my_print("Ciphertext is:");
  my_print(hex(m8, p_cipher, len));

  for (let i = 0; i < len; ++i) {
    if (m8[p_cipher+i] != cipher[i]) {
      throw (new Error("Cipher & reference differ at byte "+i));
    }
  }

  dump(mem, 2*1024);

  my_print("SUCCESS");

  return 0;
}

if (typeof module !== "undefined")
  module.exports = {
    main: main
  }
