from pygments.lexer import RegexLexer, words
from pygments.token import *

# very rough lexer; not 100% precise
class CustomLexer(RegexLexer):
    name = 'FStar'
    aliases = ['fstar']
    filenames = ['*.fst', '*.fsti']
    keywords = (
        'attributes' ,
        'noeq'       ,
        'unopteq'    ,
        'and'        ,
        'assert'     ,
        'assume'     ,
        'begin'      ,
        'by'         ,
        'calc'       ,
        'class'      ,
        'decreases'  ,
        'effect'     ,
        'eliminate'  ,
        'else'       ,
        'end'        ,
        'ensures'    ,
        'exception'  ,
        'exists'     ,
        'false'      ,
        'friend'     ,
        'forall'     ,
        'fun'        ,
        'function'   ,
        'if'         ,
        'in'         ,
        'include'    ,
        'inline'     ,
        'inline_for_extraction'     ,
        'instance'   ,
        'introduce'  ,
        'irreducible',
        'let'        ,
        'logic'      ,
        'match'      ,
        'module'     ,
        'new'        ,
        'new_effect' ,
        'layered_effect'            ,
        'polymonadic_bind'          ,
        'polymonadic_subcomp'       ,
        'noextract',
        'of'         ,
        'open'       ,
        'opaque'     ,
        'private'    ,
        'range_of'   ,
        'rec'        ,
        'reifiable'  ,
        'reify'      ,
        'reflectable',
        'requires'   ,
        'returns'    ,
        'set_range_of',
        'sub_effect' ,
        'synth'      ,
        'then'       ,
        'total'      ,
        'true'       ,
        'try'        ,
        'type'       ,
        'unfold'     ,
        'unfoldable' ,
        'val'        ,
        'when'       ,
        'with'       ,
        '_'          ,
    )
    tokens = {
        'root': [
            (r' ', Text),
            (r'\n', Text),
            (r'\r', Text),
            (r'//.*\n', Comment),
            (r'\([*]([^*]|[*]+[^)])*[*]+\)', Comment),
            (words(keywords, suffix=r'\b'), Keyword),
            (r'0x[0-9a-fA-F_]+', Literal.Number),
            (r'[0-9_]+', Literal.Number),
            (r'[a-zA-Z_]+', Text),
            (r'.', Text),
        ]
    }

#class CustomFormatter:
