    /*********************************************************************\
    *  Copyright (c) 1991 by Wen-King Su (wen-king@vlsi.cs.caltech.edu)   *
    *  Copyright (c) 1993 by Phil Richards (pgr@prg.ox.ac.uk)             *
    *  Copyright (c) 2004 by Radim Kolar (hsn@netmag.cz)                  *
    *                                                                     *
    *  You may copy or modify this file in any manner you wish, provided  *
    *  that this notice is always included, and that you hold the author  *
    *  harmless for any loss or damage resulting from the installation or *
    *  use of this software.                                              *
    \*********************************************************************/

/* ---INFOBEGIN--- *  DO NOT DELETE THIS COMMENT BLOCK!!!
COMMAND mv NOGLOB "rename files on the remote system"
 *  ---INFOEND---  */

#include "client.h"
#include "table.h"
#include <stdlib.h>

static int dirty;

static int
do_mv(char *name,char *namedest)
{
    char *op,*op2;
    UBUF *ub;
    struct stat sbuf;
    unsigned char buf[UBUF_SPACE];

    if (!validate_operation(name, DIR_RENAME))
	return -1;

    if (util_stat(name, &sbuf) < 0)
    {
	ffprintf(STDERR,"mv: cannot rename `%s': no such file\n", name);
	return -1;
    }

    if (!S_ISREG(sbuf.st_mode))
    {
	ffprintf(STDERR,"mv: cannot rename `%s': not a file\n", name);
	return -1;
    }

    op = util_abs_path(name);
    op2= util_abs_path(namedest);

    if(strlen(op)+strlen(op2)+2>UBUF_SPACE)
    {
	ffprintf(STDERR,"mv: path too long\n");
	free(op);
	free(op2);
	return -1;
    }
    strcpy(buf,op);
    strcpy(buf+strlen(op)+1,op2);

    ub = client_interact(CC_RENAME, strlen(op2)+1, strlen(op)+1, buf, strlen(op2)+1, buf+strlen(op)+1);
    (void)free(op);
    (void)free(op2);

    if (client_intr_state > 1 || !ub)
	return -1;

    if (ub->cmd == CC_ERR)
    {
	ffprintf(STDERR,"mv: cannot rename `%s':%s\n", name, ub->buf);
	return -1;
    }

    dirty = 1;

    return 0;
}

/* ARGSUSED */
int
rmv_main(int argc, char *const*argv, char **envp)
{
    int retval;

    dirty = 0;

    if (argc < 3 )
    {
	ffprintf(STDERR,"mv: <source> <destination>\n");
	return -1;
    }

    retval = do_mv(argv[1],argv[2]);

    if (dirty)
	util_dirtydir(".");

    client_done();

    return retval;
}
