    /*********************************************************************\
    *  Copyright (c) 1991 by Wen-King Su (wen-king@vlsi.cs.caltech.edu)   *
    *  Copyright (c) 1993 by Phil Richards (pgr@prg.ox.ac.uk)             *
    *                                                                     *
    *  You may copy or modify this file in any manner you wish, provided  *
    *  that this notice is always included, and that you hold the author  *
    *  harmless for any loss or damage resulting from the installation or *
    *  use of this software.                                              *
    \*********************************************************************/

/* ---INFOBEGIN--- *  DO NOT DELETE THIS COMMENT BLOCK!!!
COMMAND mkdir none "make a directory on the remote system"
 *  ---INFOEND---  */

#include "client.h"
#include "table.h"
#include <stdlib.h>

static int dirty;

static int
do_make_dir(char *name)
{
    char *path;
    UBUF *ub;

    if (!validate_operation(name, DIR_MKDIR))
	return -1;

    path = util_abs_path(name);
    ub = client_interact(CC_MAKE_DIR, 0L, strlen(path), path + 1, 0, NULLP);
    (void)free(path);

    if (client_intr_state > 1 || !ub)
	return -1;

    if (ub->cmd == CC_ERR)
    {
	ffprintf(STDERR, "mkdir: cannot create `%s'\n", name);
	return(-1);
    }

    dirty = 1;
    ffprintf(STDINFO, "%s\t: %s\n", name, ub->buf);

    return 0;
}

/* ARGSUSED */
int
rmkdir_main(int argc, char *const*argv, char **envp)
{
    int retval = 0;

    dirty = 0;

    for (argv++; *argv; argv++)
	retval |= (do_make_dir(*argv) < 0);

    if (dirty)
	util_dirtydir(".");

    client_done();

    return retval;
}
