/******************************************************************************
* This file is Copyright 1993 by Philip G. Richards.  All Rights Reserved.
* See the file README that came with this distribution for permissions on
* code usage, copying, and distribution.  It comes with absolutely no warranty.
* email: <pgr@prg.ox.ac.uk>
******************************************************************************/

/* ---INFOBEGIN--- *  DO NOT DELETE THIS COMMENT BLOCK!!!
COMMAND lcd local "local cd"
 *  ---INFOEND---  */

#include "client.h"
#include "util.h"
#include "table.h"

int
llcd_main(int argc, char *const*argv, char **envp)
{
    char *newldir, **files;
    char cwdbuffer[256];

    if (argc < 2)
    {
        ffprintf(STDINFO,
		"Local directory now %s\n",getcwd(cwdbuffer,255));
	return 0;
    }
    else
	newldir = argv[1];

    if (newldir == 0)
	return 1;

    if ((files = glob(newldir)) != 0)
	newldir = files[0];

    if (chdir(newldir) < 0)
    {
	if (files)
	    free_glob(files);
        perror("lcd");
	return 1;
    }

    if (files)
	free_glob(files);

    return 0;
}
