#light

namespace Microsoft.FSharp.Collections

open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Collections

type Permutation =
    /// Create a permutation by specifying the result of permuting [| 0 .. n-1 |]. For example, 
    /// Permutation([| 1;2;0 |])  specifies a permutation that rotates all elements left one place.
    new : int array -> Permutation
    /// Create a permutation by specifying (source,destination) index pairs. For example,
    /// Permutation(3,[ (0,2);(1,0); (2,1) ]) specifies a permutation that rotates 
    /// all elements left one place. Not all elements need be given, e.g. 
    /// Permutation(5,[ (1,2);(2,1) |]) specifies a permutation that swaps elements at indexes
    /// 1 and 2.
    new : size:int * mappings:seq<int * int> -> Permutation
    /// The number of indices maintained by the permutation
    member Length : int
    /// Compute the inverse of the permutation
    member Inverse : Permutation

    interface System.IComparable 
    /// Return a permutation that, when applied, first applies p1 then applies p2.
    static member Compose : p1:Permutation * p2:Permutation -> Permutation
      
    /// Apply the composition to an index within the range 0..Length-1
    member Item : int -> int with get
    /// Return the iddentity permutation
    static member Identity : size:int -> Permutation
    /// Return a swaps the given two elements.
    static member Swap: size:int * n:int * m:int -> Permutation
    /// Return a permutation that, when applied, maps index 0 to N-1, N-1 to 0 etc.
    static member Reverse: size:int -> Permutation
    /// Return a permutation that rotates right by the given distance. If the distance
    /// is negative then a left rotation results.
    static member Rotate: size:int * ?distance:int -> Permutation
    