#!/usr/bin/perl -w 
# -*- Perl -*-
# $Id: fs-report.t.in,v 1.1 2004/10/15 07:25:37 rockyb Exp $
# Checks age parameter.
use strict;
# require 'driver-init.pl';

my $test='fs-report';

print "1..4\n";
my $output=`../fs-report --help 2>&1`;

if (! $output) {
    print "expecting output. Got none\n";
    print "not ok 1\n";
} else {
    print "ok 1\n";
}

#
# Test core file section
#
my $corefile = 'core';
if (!open(CORE, ">$corefile")) {
    print "Can't open core file $corefile for writing: $!\n";
    print "not ok 2\n";
} else {
    print CORE "testing\n";
    close CORE;
    my @output=`../fs-report --nocommon --core-pat core --nosize --nonewest 2>&1`;
    if (@output != 4) {
	printf "Expecting exactly 4 lines got %d\n", $#output+1;
	print "not ok 2\n";
    } else {
	print "ok 2\n";
    }
    unlink $corefile;
}

#
# Test file size section
#
my $size_lines = 3;
my @output=`../fs-report --nocommon --nocore --nonewest --size-lines $size_lines 2>&1`;
if (@output != $size_lines + 5) {
    printf "Expecting exactly %d lines got %d\n", 
    $size_lines + 5, $#output+1;
    print @output;
    print "not ok 3\n";
} else {
    print "ok 3\n";
}

#
# Test newest size section
#
my $newest_lines = 5;

my $newfile = 'new';
my $ok=1;
for my $i (1..$newest_lines) {
    if (!open(NEW, ">$newfile$i")) {
	print "Can't open new file $newfile$i for writing: $!\n";
	print "not ok 4\n";
	$ok=0;
	last;
    }
    close(NEW);
}

if ($ok) {
    my @output=`../fs-report --nocommon --nocore --nosize --newest-lines $newest_lines 2>&1`;
    if (@output != $newest_lines + 3) {
	printf "Expecting exactly %d lines got %d\n", 
	$newest_lines + 3, $#output+1;
	print @output;
	print "not ok 4\n";
    } else {
	print "ok 4\n";
    }
    for my $i (1..$newest_lines) {
	unlink "$newfile$i";
    }
}

#
# Test common size section
#
$output=`../fs-report --nocore 2>&1`;

