/* Copyright (c) 2010 Shlomi Fish
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */
/*
 * fcs_cl.h - the Freecell Solver command line arguments-like parsing routines.
 * Useful for more easily configuring a Freecell Solver instance.
 */
#ifndef FC_SOLVE__PORTABLE_INT64_H
#define FC_SOLVE__PORTABLE_INT64_H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef WIN32
typedef long long fcs_int64_t;

#define FCS_INT64_FORMAT "%lli"

#else
typedef __int64 fcs_int64_t;

#define FCS_INT64_FORMAT "%I64i"

#endif

#ifdef __cplusplus
};
#endif

#endif /* #ifndef FC_SOLVE__PORTABLE_INT64_H */
