/*
 * workloads.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2019 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#include "foundationdb/ClientWorkload.h"

#include <map>

struct IFDBWorkloadFactory {
	virtual std::shared_ptr<FDBWorkload> create() = 0;
};

struct FDBWorkloadFactoryImpl : FDBWorkloadFactory {
	~FDBWorkloadFactoryImpl();
	static std::map<std::string, IFDBWorkloadFactory*>& factories();
	std::shared_ptr<FDBWorkload> create(const std::string& name) override;
};

template <class WorkloadType>
struct FDBWorkloadFactoryT : IFDBWorkloadFactory {
	explicit FDBWorkloadFactoryT(const std::string& name) { FDBWorkloadFactoryImpl::factories()[name] = this; }

	std::shared_ptr<FDBWorkload> create() override { return std::make_shared<WorkloadType>(); }
};

extern "C" DLLEXPORT FDBWorkloadFactory* workloadFactory(FDBLogger*);
