![nlesolver-fortran](media/logo.png)
============

Nonlinear Equation Solver with Modern Fortran.

A basic Newton-Raphson type nonlinear equation solver for dense systems with `m` functions of `n` input variables.

A work in progress.

### Status

[![CI Status](https://github.com/jacobwilliams/nlesolver-fortran/actions/workflows/CI.yml/badge.svg)](https://github.com/jacobwilliams/nlesolver-fortran/actions)
[![GitHub release](https://img.shields.io/github/release/jacobwilliams/nlesolver-fortran.svg)](https://github.com/jacobwilliams/nlesolver-fortran/releases/latest)
[![codecov](https://codecov.io/gh/jacobwilliams/nlesolver-fortran/branch/master/graph/badge.svg)](https://codecov.io/gh/jacobwilliams/nlesolver-fortran)
[![last-commit](https://img.shields.io/github/last-commit/jacobwilliams/nlesolver-fortran)](https://github.com/jacobwilliams/nlesolver-fortran/commits/master)

### Features

  * Is object-oriented.
  * Works with square, under-determined, or over-determined systems.
  * Uses LAPACK routines (`dgesv` or `dgels`) to solve the linear system.
     * if `n=m`,  uses `dgesv` (LU decomposition)
     * if `n/=m`, uses `dgels` (if `m>n` uses QR factorization,
       if `m<n` uses LQ factorization)
  * Has a Broyden update option.
  * Has various line search options.
     * use a specified constant step size (0,1]
     * backtracking linesearch method
     * exact linesearch method using `fmin` minimizer
     * evaluate function at specified fixed points

### Compiling

* A [Fortran Package Manager](https://github.com/fortran-lang/fpm) file is also included, so that the library and tests cases can be compiled with FPM. For example:

```
fpm build --profile release
fpm test --profile release
```

By default, the library is built with double precision (`real64`) real values. Explicitly specifying the real kind can be done using the following preprocessor flags:

Preprocessor flag | Kind  | Number of bytes
----------------- | ----- | ---------------
`REAL32`  | `real(kind=real32)`  | 4
`REAL64`  | `real(kind=real64)`  | 8
`REAL128` | `real(kind=real128)` | 16

For example, to build a single precision version of the library, use:

```
fpm build --profile release --flag "-DREAL32"
```

To use `nlesolver` within your fpm project, add the following to your `fpm.toml` file:
```toml
[dependencies]
nlesolver-fortran = { git="https://github.com/jacobwilliams/nlesolver-fortran.git" }
```

Or to use a specific version:

```toml
[dependencies]
nlesolver-fortran = { git="https://github.com/jacobwilliams/nlesolver-fortran.git", tag="1.1.0" }
```

Note that LAPACK is required to build. The [fmin](https://github.com/jacobwilliams/fmin) library is also a dependency (which will be automatically downloaded by fpm).

### Documentation

 * The API documentation for the current ```master``` branch can be found [here](https://jacobwilliams.github.io/nlesolver-fortran/).  This is generated by processing the source files with [FORD](https://github.com/Fortran-FOSS-Programmers/ford).

### License

 * The NLESolver-Fortran source code and related files and documentation are distributed under a permissive free software [license](https://github.com/jacobwilliams/nlesolver-fortran/blob/master/LICENSE) (BSD-3).

### See also

  * [MINPACK](https://github.com/fortran-lang/minpack)
