add_rules("mode.debug", "mode.release")
set_languages("fortran")
add_fcflags("-Wall -std=f2008 -fmax-errors=1")

target("fortran-lua53")
    set_kind("static")
    add_fcflags("-fPIC")
    add_files("src/lua.f90")
    set_targetdir("build")
    set_values("fortran.moduledir", "$(buildir)")

target("fibonacci")
    set_kind("binary")
    add_deps("fortran-lua53")
    add_files("examples/fibonacci/fibonacci.f90")
    add_syslinks("lua-5.3")
    set_targetdir("examples/fibonacci/")

target("library")
    set_kind("shared")
    add_files("src/lua.f90")
    add_files("examples/library/fortran.f90")
    add_syslinks("lua-5.3")
    set_filename("fortran.so")
    set_targetdir("examples/library/")

target("string")
    set_kind("binary")
    add_deps("fortran-lua53")
    add_files("examples/string/string.f90")
    add_syslinks("lua-5.3")
    set_targetdir("examples/string/")

target("table")
    set_kind("binary")
    add_deps("fortran-lua53")
    add_files("examples/table/table.f90")
    add_syslinks("lua-5.3")
    set_targetdir("examples/table/")
