/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.txt;

import java.util.EnumMap;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fonts.DefaultFontConfig;
import org.apache.fop.render.RendererConfig;
import org.apache.fop.render.RendererConfigOption;

public final class TxtRendererConfig
implements RendererConfig {
    private final EnumMap<TxtRendererOption, Object> params = new EnumMap(TxtRendererOption.class);
    private final DefaultFontConfig fontConfig;

    private TxtRendererConfig(DefaultFontConfig fontConfig) {
        this.fontConfig = fontConfig;
    }

    public DefaultFontConfig getFontInfoConfig() {
        return this.fontConfig;
    }

    public String getEncoding() {
        return (String)this.params.get(TxtRendererOption.ENCODING);
    }

    public static final class TxtRendererConfigParser
    implements RendererConfig.RendererConfigParser {
        public TxtRendererConfig build(FOUserAgent userAgent, Configuration cfg) throws FOPException {
            TxtRendererConfig config = new TxtRendererConfig(new DefaultFontConfig.DefaultFontConfigParser().parse(cfg, userAgent.validateStrictly()));
            if (cfg != null) {
                TxtRendererOption option = TxtRendererOption.ENCODING;
                String value = cfg.getChild(option.getName(), true).getValue(null);
                config.params.put(option, value != null ? value : option.getDefaultValue());
            }
            return config;
        }

        public String getMimeType() {
            return "text/plain";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TxtRendererOption implements RendererConfigOption
    {
        ENCODING("encoding", "UTF-8");

        private final String name;
        private final Object defaultValue;

        private TxtRendererOption(String name, Object defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }
}

