/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.fop.accessibility.StructureTree2SAXEventAdapter;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

final class IFStructureTreeBuilder
implements StructureTreeEventHandler {
    private StructureTreeEventHandler delegate;
    private final List<SAXEventRecorder> pageSequenceEventRecorders = new ArrayList<SAXEventRecorder>();
    private int idCounter;

    IFStructureTreeBuilder() {
    }

    public void replayEventsForPageSequence(ContentHandler handler, int pageSequenceIndex) throws SAXException {
        this.pageSequenceEventRecorders.get(pageSequenceIndex).replay(handler);
    }

    public void startPageSequence(Locale locale, String role) {
        SAXEventRecorder eventRecorder = new SAXEventRecorder();
        this.pageSequenceEventRecorders.add(eventRecorder);
        this.delegate = StructureTree2SAXEventAdapter.newInstance(eventRecorder);
        this.delegate.startPageSequence(locale, role);
    }

    public void endPageSequence() {
        this.delegate.endPageSequence();
    }

    public StructureTreeElement startNode(String name, Attributes attributes) {
        this.delegate.startNode(name, attributes);
        return new IFStructureTreeElement();
    }

    public void endNode(String name) {
        this.delegate.endNode(name);
    }

    public StructureTreeElement startImageNode(String name, Attributes attributes) {
        String id = this.getNextID();
        AttributesImpl atts = this.addIDAttribute(attributes, id);
        this.delegate.startImageNode(name, atts);
        return new IFStructureTreeElement(id);
    }

    public StructureTreeElement startReferencedNode(String name, Attributes attributes) {
        String id = this.getNextID();
        AttributesImpl atts = this.addIDAttribute(attributes, id);
        this.delegate.startReferencedNode(name, atts);
        return new IFStructureTreeElement(id);
    }

    private String getNextID() {
        return Integer.toHexString(this.idCounter++);
    }

    private AttributesImpl addIDAttribute(Attributes attributes, String id) {
        AttributesImpl atts = new AttributesImpl(attributes);
        atts.addAttribute("http://xmlgraphics.apache.org/fop/internal", "struct-id", "foi:struct-id", "CDATA", id);
        return atts;
    }

    static class SAXEventRecorder
    extends DefaultHandler {
        private final List<Event> events = new ArrayList<Event>();

        SAXEventRecorder() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.events.add(new StartElement(uri, localName, qName, attributes));
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.events.add(new EndElement(uri, localName, qName));
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.events.add(new StartPrefixMapping(prefix, uri));
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.events.add(new EndPrefixMapping(prefix));
        }

        public void replay(ContentHandler handler) throws SAXException {
            for (Event e : this.events) {
                e.replay(handler);
            }
        }

        private static final class EndPrefixMapping
        extends Event {
            private final String prefix;

            private EndPrefixMapping(String prefix) {
                this.prefix = prefix;
            }

            void replay(ContentHandler handler) throws SAXException {
                handler.endPrefixMapping(this.prefix);
            }
        }

        private static final class StartPrefixMapping
        extends Event {
            private final String prefix;
            private final String uri;

            private StartPrefixMapping(String prefix, String uri) {
                this.prefix = prefix;
                this.uri = uri;
            }

            void replay(ContentHandler handler) throws SAXException {
                handler.startPrefixMapping(this.prefix, this.uri);
            }
        }

        private static final class EndElement
        extends Element {
            private EndElement(String uri, String localName, String qName) {
                super(uri, localName, qName);
            }

            void replay(ContentHandler handler) throws SAXException {
                handler.endElement(this.uri, this.localName, this.qName);
            }
        }

        private static final class StartElement
        extends Element {
            private final Attributes attributes;

            private StartElement(String uri, String localName, String qName, Attributes attributes) {
                super(uri, localName, qName);
                this.attributes = attributes;
            }

            void replay(ContentHandler handler) throws SAXException {
                handler.startElement(this.uri, this.localName, this.qName, this.attributes);
            }
        }

        private static abstract class Element
        extends Event {
            protected final String uri;
            protected final String localName;
            protected final String qName;

            private Element(String uri, String localName, String qName) {
                this.uri = uri;
                this.localName = localName;
                this.qName = qName;
            }
        }

        private static abstract class Event {
            private Event() {
            }

            abstract void replay(ContentHandler var1) throws SAXException;
        }
    }

    static final class IFStructureTreeElement
    implements StructureTreeElement {
        private final String id;

        IFStructureTreeElement() {
            this.id = null;
        }

        IFStructureTreeElement(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

