/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.GraphicsEnvironment;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.gvt.font.AWTFontFamily;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.UnresolvedFontFamily;

public class FontFamilyResolver {
    public static final AWTFontFamily defaultFont = new AWTFontFamily("SansSerif");
    protected static final Map fonts = new HashMap();
    protected static final Vector awtFontFamilies = new Vector();
    protected static final Vector awtFonts = new Vector();
    protected static Map resolvedFontFamilies;

    public static GVTFontFamily resolve(UnresolvedFontFamily fontFamily) {
        String familyName;
        GVTFontFamily resolvedFontFamily;
        if (resolvedFontFamilies == null) {
            resolvedFontFamilies = new HashMap();
        }
        if ((resolvedFontFamily = (GVTFontFamily)resolvedFontFamilies.get((familyName = fontFamily.getFamilyName()).toLowerCase())) == null) {
            String awtFamilyName = (String)fonts.get(familyName.toLowerCase());
            if (awtFamilyName != null) {
                resolvedFontFamily = new AWTFontFamily(awtFamilyName);
            }
            resolvedFontFamilies.put(familyName.toLowerCase(), resolvedFontFamily);
        }
        return resolvedFontFamily;
    }

    public static GVTFontFamily getFamilyThatCanDisplay(char c) {
        int i = 0;
        while (i < awtFontFamilies.size()) {
            AWTFontFamily fontFamily = (AWTFontFamily)awtFontFamilies.get(i);
            AWTGVTFont font = (AWTGVTFont)awtFonts.get(i);
            if (font.canDisplay(c) && fontFamily.getFamilyName().indexOf("Song") == -1) {
                return fontFamily;
            }
            ++i;
        }
        return null;
    }

    static {
        fonts.put("sans-serif", "SansSerif");
        fonts.put("serif", "Serif");
        fonts.put("times", "Serif");
        fonts.put("times new roman", "Serif");
        fonts.put("cursive", "Dialog");
        fonts.put("fantasy", "Symbol");
        fonts.put("monospace", "Monospaced");
        fonts.put("monospaced", "Monospaced");
        fonts.put("courier", "Monospaced");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = env.getAvailableFontFamilyNames();
        int nFonts = fontNames != null ? fontNames.length : 0;
        int i = 0;
        while (i < nFonts) {
            fonts.put(fontNames[i].toLowerCase(), fontNames[i]);
            StringTokenizer st = new StringTokenizer(fontNames[i]);
            String fontNameWithoutSpaces = "";
            while (st.hasMoreTokens()) {
                fontNameWithoutSpaces = fontNameWithoutSpaces + st.nextToken();
            }
            fonts.put(fontNameWithoutSpaces.toLowerCase(), fontNames[i]);
            String fontNameWithDashes = fontNames[i].replace(' ', '-');
            if (!fontNameWithDashes.equals(fontNames[i])) {
                fonts.put(fontNameWithDashes.toLowerCase(), fontNames[i]);
            }
            ++i;
        }
        awtFontFamilies.add(defaultFont);
        awtFonts.add(new AWTGVTFont(defaultFont.getFamilyName(), 0, 12));
        Collection fontValues = fonts.values();
        Iterator iter = fontValues.iterator();
        while (iter.hasNext()) {
            String fontFamily = (String)iter.next();
            AWTFontFamily awtFontFamily = new AWTFontFamily(fontFamily);
            awtFontFamilies.add(awtFontFamily);
            AWTGVTFont font = new AWTGVTFont(fontFamily, 0, 12);
            awtFonts.add(font);
        }
    }
}

