/* tpf-persona-store.c generated by valac 0.27.1.7-1a9de, the Vala compiler
 * generated from tpf-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2013 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 *       Xavier Claessens <xavier.claessens@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <telepathy-glib/telepathy-glib.h>
#include <folks/small-set.h>
#include <gio/gio.h>
#include <tp-zeitgeist.h>
#include <folks/small-set-internal.h>
#include <folks-internal.h>
#include <glib/gi18n-lib.h>
#include <tp-lowlevel.h>


#define TPF_TYPE_PERSONA_STORE (tpf_persona_store_get_type ())
#define TPF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStore))
#define TPF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))
#define TPF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE))
#define TPF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE))
#define TPF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))

typedef struct _TpfPersonaStore TpfPersonaStore;
typedef struct _TpfPersonaStoreClass TpfPersonaStoreClass;
typedef struct _TpfPersonaStorePrivate TpfPersonaStorePrivate;

#define TPF_TYPE_PERSONA (tpf_persona_get_type ())
#define TPF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA, TpfPersona))
#define TPF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA, TpfPersonaClass))
#define TPF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA))
#define TPF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA))
#define TPF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA, TpfPersonaClass))

typedef struct _TpfPersona TpfPersona;
typedef struct _TpfPersonaClass TpfPersonaClass;

#define TYPE_LOGGER (logger_get_type ())
#define LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOGGER, Logger))
#define LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOGGER, LoggerClass))
#define IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOGGER))
#define IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOGGER))
#define LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOGGER, LoggerClass))

typedef struct _Logger Logger;
typedef struct _LoggerClass LoggerClass;

#define TPF_TYPE_PERSONA_STORE_CACHE (tpf_persona_store_cache_get_type ())
#define TPF_PERSONA_STORE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE_CACHE, TpfPersonaStoreCache))
#define TPF_PERSONA_STORE_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE_CACHE, TpfPersonaStoreCacheClass))
#define TPF_IS_PERSONA_STORE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE_CACHE))
#define TPF_IS_PERSONA_STORE_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE_CACHE))
#define TPF_PERSONA_STORE_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE_CACHE, TpfPersonaStoreCacheClass))

typedef struct _TpfPersonaStoreCache TpfPersonaStoreCache;
typedef struct _TpfPersonaStoreCacheClass TpfPersonaStoreCacheClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TpfPersonaStorePrepareData TpfPersonaStorePrepareData;
typedef struct _TpfPersonaStoreInitialiseFavouriteContactsData TpfPersonaStoreInitialiseFavouriteContactsData;
typedef struct _Block1Data Block1Data;
typedef struct _TpfPersonaStoreNotifyConnectionCbAsyncData TpfPersonaStoreNotifyConnectionCbAsyncData;
#define __vala_TpContactInfoFieldSpec_free0(var) ((var == NULL) ? NULL : (var = (_vala_TpContactInfoFieldSpec_free (var), NULL)))
#define __g_list_free___vala_TpContactInfoFieldSpec_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free___vala_TpContactInfoFieldSpec_free0_ (var), NULL)))
typedef struct _TpfPersonaStoreLoadCacheData TpfPersonaStoreLoadCacheData;
typedef struct _TpfPersonaStoreFlushData TpfPersonaStoreFlushData;
typedef struct _TpfPersonaStoreStoreCacheData TpfPersonaStoreStoreCacheData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TpfPersonaStoreRemovePersonaData TpfPersonaStoreRemovePersonaData;
typedef struct _TpfPersonaStoreEnsurePersonaForIdData TpfPersonaStoreEnsurePersonaForIdData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _TpfPersonaStoreAddPersonaFromDetailsData TpfPersonaStoreAddPersonaFromDetailsData;
typedef struct _TpfPersonaStoreChangeIsFavouriteData TpfPersonaStoreChangeIsFavouriteData;
typedef struct _TpfPersonaStoreChangeAliasData TpfPersonaStoreChangeAliasData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define __vala_TpContactInfoField_free0(var) ((var == NULL) ? NULL : (var = (_vala_TpContactInfoField_free (var), NULL)))
typedef struct _TpfPersonaStoreChangeUserBirthdayData TpfPersonaStoreChangeUserBirthdayData;
typedef struct _TpfPersonaStoreChangeUserFullNameData TpfPersonaStoreChangeUserFullNameData;
typedef struct _TpfPersonaStoreChangeUserDetailsData TpfPersonaStoreChangeUserDetailsData;
#define __g_list_free___vala_TpContactInfoField_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free___vala_TpContactInfoField_free0_ (var), NULL)))
typedef struct _TpfPersonaStoreChangeUserContactInfoData TpfPersonaStoreChangeUserContactInfoData;
typedef struct _TpfPersonaStorePopulateCountersData TpfPersonaStorePopulateCountersData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TpfPersonaStore {
	FolksPersonaStore parent_instance;
	TpfPersonaStorePrivate * priv;
};

struct _TpfPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _TpfPersonaStorePrivate {
	gchar** _always_writeable_properties;
	gint _always_writeable_properties_length1;
	gint __always_writeable_properties_size_;
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	GeeHashSet* _persona_set;
	GeeHashMap* _contact_persona_map;
	FolksSmallSet* _favourite_ids;
	GeeHashMap* _avatars;
	TpConnection* _conn;
	TpAccountManager* _account_manager;
	Logger* _logger;
	TpfPersona* _self_persona;
	FolksMaybeBool _can_add_personas;
	FolksMaybeBool _can_alias_personas;
	FolksMaybeBool _can_group_personas;
	FolksMaybeBool _can_remove_personas;
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	gboolean _got_initial_members;
	gboolean _got_initial_self_contact;
	gboolean _disconnect_pending;
	gboolean _removal_pending;
	FolksDebug* _debug;
	TpfPersonaStoreCache* _cache;
	GCancellable* _load_cache_cancellable;
	gboolean _cache_needs_update;
	FolksSmallSet* _supported_fields;
	GeeSet* _supported_fields_ro;
	TpAccount* _account;
	FolksTpZeitgeistController* _zg_controller;
};

struct _TpfPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	TpAccountManager* _tmp5_;
	TpSimpleClientFactory* factory;
	TpAccountManager* _tmp6_;
	TpSimpleClientFactory* _tmp7_;
	TpSimpleClientFactory* _tmp8_;
	TpSimpleClientFactory* _tmp9_;
	TpContactFeature* _tmp10_;
	TpContactFeature* _tmp11_;
	gint _tmp11__length1;
	TpAccountManager* _tmp12_;
	TpAccountManager* _tmp13_;
	TpAccountManager* _tmp14_;
	TpAccountManager* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GeeHashMap* _tmp18_;
	FolksSmallSet* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	Logger* _tmp22_;
	Logger* _tmp23_;
	Logger* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	TpAccount* _tmp29_;
	TpAccount* _tmp30_;
	TpAccount* _tmp31_;
	TpAccount* _tmp32_;
	TpConnection* _tmp33_;
	TpConnection* _tmp34_;
	TpAccount* _tmp35_;
	TpAccount* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreInitialiseFavouriteContactsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	Logger* _tmp0_;
	Logger* _tmp1_;
	gchar** contacts;
	Logger* _tmp2_;
	gint _tmp3_;
	gchar** _tmp4_;
	gint contacts_length1;
	gint _contacts_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	TpfPersonaStore* self;
	GeeHashSet* old_personas;
};

struct _TpfPersonaStoreNotifyConnectionCbAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	TpAccount* _tmp4_;
	TpAccount* _tmp5_;
	TpConnection* _tmp6_;
	TpConnection* _tmp7_;
	GQuark _tmp8_;
	GQuark _tmp9_;
	GQuark _tmp10_;
	GQuark _tmp11_;
	GQuark _tmp12_;
	GQuark* _tmp13_;
	GQuark* _tmp14_;
	gint _tmp14__length1;
	TpAccount* _tmp15_;
	TpAccount* _tmp16_;
	TpConnection* _tmp17_;
	TpConnection* _tmp18_;
	GQuark _tmp19_;
	gboolean _tmp20_;
	GeeHashSet* _tmp21_;
	TpAccount* _tmp22_;
	TpAccount* _tmp23_;
	TpConnection* _tmp24_;
	TpConnection* _tmp25_;
	TpConnection* _tmp26_;
	TpConnection* _tmp27_;
	TpConnection* _tmp28_;
	TpConnection* _tmp29_;
	TpContactMetadataStorageType _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gchar* _tmp32_;
	TpConnection* _tmp33_;
	gboolean _tmp34_;
	FolksMaybeBool new_can_alias;
	TpConnection* _tmp35_;
	gboolean _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gchar* _tmp38_;
	FolksMaybeBool _tmp39_;
	TpConnection* _tmp40_;
	TpConnection* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreLoadCacheData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	GeeHashSet* old_personas;
	gboolean _tmp0_;
	TpAccount* _tmp1_;
	TpAccount* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	TpAccount* _tmp5_;
	TpAccount* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	TpAccount* _tmp10_;
	TpAccount* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	const gchar* _tmp14_;
	TpAccount* _tmp15_;
	TpAccount* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GCancellable* cancellable;
	GCancellable* _tmp23_;
	GCancellable* _tmp24_;
	GCancellable* _tmp25_;
	GCancellable* _tmp26_;
	GCancellable* _tmp27_;
	GCancellable* _tmp28_;
	GeeSet* cached_personas;
	TpfPersonaStoreCache* _tmp29_;
	GCancellable* _tmp30_;
	GeeSet* _tmp31_;
	GCancellable* _tmp32_;
	gboolean _tmp33_;
	GCancellable* _tmp34_;
	GeeHashSet* _tmp35_;
	GeeSet* _tmp36_;
	GeeIterator* _p_it;
	GeeSet* _tmp37_;
	GeeIterator* _tmp38_;
	GeeIterator* _tmp39_;
	gboolean _tmp40_;
	TpfPersona* p;
	GeeIterator* _tmp41_;
	gpointer _tmp42_;
	TpfPersona* _tmp43_;
	GeeSet* _tmp44_;
	GeeHashSet* _tmp45_;
	Logger* _tmp46_;
	gchar* _tmp47_;
	gchar** _tmp48_;
	gchar** _tmp49_;
};

struct _TpfPersonaStoreFlushData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeHashSet* _tmp2_;
};

struct _TpfPersonaStoreStoreCacheData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	GeeHashSet* old_personas;
	gboolean _tmp0_;
	TpAccount* _tmp1_;
	TpAccount* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	TpAccount* _tmp5_;
	TpAccount* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	TpfPersonaStoreCache* _tmp16_;
	GeeHashSet* _tmp17_;
};

struct _TpfPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	TpfPersona* tp_persona;
	FolksPersona* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* _tmp2_;
	TpContact* _tmp3_;
	TpContact* _tmp4_;
	TpfPersona* _tmp5_;
	gboolean _tmp6_;
	FolksPersona* _tmp7_;
	TpfPersona* _tmp8_;
	TpfPersona* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	TpfPersona* _tmp14_;
	TpContact* _tmp15_;
	TpContact* _tmp16_;
	GError* e;
	const gchar* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreEnsurePersonaForIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	gchar* contact_id;
	TpfPersona* result;
	TpContact* contact;
	TpConnection* _tmp0_;
	const gchar* _tmp1_;
	TpContactFeature* _tmp2_;
	TpContactFeature* _tmp3_;
	gint _tmp3__length1;
	TpContact* _tmp4_;
	TpContact* _tmp5_;
	TpfPersona* _tmp6_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	gchar* contact_id;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	gchar* add_message;
	GHashTable* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	TpConnectionStatus status;
	TpAccount* _tmp15_;
	TpAccount* _tmp16_;
	TpConnectionStatus _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	TpConnectionStatus _tmp20_;
	TpConnectionStatus _tmp21_;
	TpConnection* _tmp22_;
	const gchar* _tmp23_;
	GError* _tmp24_;
	TpfPersona* persona;
	const gchar* _tmp25_;
	TpfPersona* _tmp26_;
	gboolean already_exists;
	TpfPersona* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	TpfPersona* tp_persona;
	TpfPersona* _tmp30_;
	TpfPersona* _tmp31_;
	TpfPersona* _tmp32_;
	TpContact* _tmp33_;
	TpContact* _tmp34_;
	const gchar* _tmp35_;
	TpfPersona* _tmp36_;
	gboolean _tmp37_;
	TpfPersona* _tmp38_;
	FolksPersona* _tmp39_;
	GError* e;
	const gchar* _tmp40_;
	GError* _tmp41_;
	const gchar* _tmp42_;
	GError* _tmp43_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeIsFavouriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	gboolean is_favourite;
	Logger* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	FolksPersona* _tmp3_;
	TpContact* _tmp4_;
	TpContact* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	const gchar* id;
	FolksPersona* _tmp8_;
	TpContact* _tmp9_;
	TpContact* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	Logger* _tmp13_;
	const gchar* _tmp14_;
	Logger* _tmp15_;
	const gchar* _tmp16_;
	GError* e;
	const gchar* _tmp17_;
	FolksPersona* _tmp18_;
	TpContact* _tmp19_;
	TpContact* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GError* _tmp23_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeAliasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	gchar* alias;
	const gchar* _tmp0_;
	TpfPersona* _tmp2_;
	TpContact* _tmp3_;
	TpContact* _tmp4_;
	TpfPersona* _tmp5_;
	const gchar* _tmp6_;
	TpfPersona* _tmp7_;
	TpContact* _tmp8_;
	TpContact* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	TpConnection* _tmp12_;
	TpfPersona* _tmp13_;
	TpContact* _tmp14_;
	TpContact* _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	const gchar* _tmp18_;
	GError* e1;
	const gchar* _tmp19_;
	GError* _tmp20_;
	const gchar* _tmp21_;
	GError* _tmp22_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeUserBirthdayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	GDateTime* birthday;
	gchar* birthday_str;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_;
	FolksSmallSet* info_set;
	FolksSmallSet* _tmp4_;
	gchar** values;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint values_length1;
	gint _values_size_;
	gchar** parameters;
	gchar** _tmp8_;
	gint parameters_length1;
	gint _parameters_size_;
	TpContactInfoField* field;
	TpContactInfoField* _tmp9_;
	TpfPersona* _tmp10_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeUserFullNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	gchar* full_name;
	const gchar* _tmp0_;
	FolksSmallSet* info_set;
	FolksSmallSet* _tmp2_;
	gchar** values;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint values_length1;
	gint _values_size_;
	gchar** parameters;
	gchar** _tmp6_;
	gint parameters_length1;
	gint _parameters_size_;
	TpContactInfoField* field;
	TpContactInfoField* _tmp7_;
	TpfPersona* _tmp8_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeUserDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	GeeSet* details;
	gchar* field_name;
	FolksSmallSet* info_set;
	FolksSmallSet* _tmp0_;
	GeeIterator* _afd_it;
	GeeSet* _tmp1_;
	GeeIterator* _tmp2_;
	GeeIterator* _tmp3_;
	gboolean _tmp4_;
	FolksAbstractFieldDetails* afd;
	GeeIterator* _tmp5_;
	gpointer _tmp6_;
	gchar** values;
	FolksAbstractFieldDetails* _tmp7_;
	gconstpointer _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gint values_length1;
	gint _values_size_;
	gchar** parameters;
	gchar** _tmp12_;
	gint parameters_length1;
	gint _parameters_size_;
	GeeMapIterator* iter;
	FolksAbstractFieldDetails* _tmp13_;
	GeeMultiMap* _tmp14_;
	GeeMultiMap* _tmp15_;
	GeeMapIterator* _tmp16_;
	GeeMapIterator* _tmp17_;
	gboolean _tmp18_;
	gchar* param_name;
	GeeMapIterator* _tmp19_;
	gpointer _tmp20_;
	gchar* param_value;
	GeeMapIterator* _tmp21_;
	gpointer _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gchar** _tmp30_;
	TpContactInfoField* field;
	const gchar* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	gchar** _tmp33_;
	gint _tmp33__length1;
	TpContactInfoField* _tmp34_;
	FolksSmallSet* _tmp35_;
	TpContactInfoField* _tmp36_;
	TpfPersona* _tmp37_;
	FolksSmallSet* _tmp38_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeUserContactInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	FolksSmallSet* info_set;
	TpfPersona* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	GList* info_list;
	FolksSmallSet* _tmp5_;
	GList* _tmp6_;
	TpAccount* _tmp7_;
	TpAccount* _tmp8_;
	TpConnection* _tmp9_;
	TpConnection* _tmp10_;
	GError* _error_;
	gboolean success;
	gboolean _tmp11_;
	TpConnection* _tmp12_;
	GList* _tmp13_;
	gboolean _tmp14_;
	GError* e;
	GError* _tmp15_;
	GError* _tmp16_;
	gboolean _tmp17_;
	GError* _tmp18_;
	gboolean _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	GError* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GError* _tmp25_;
	GError * _inner_error_;
};

struct _TpfPersonaStorePopulateCountersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	FolksTpZeitgeistController* _tmp2_;
	FolksTpZeitgeistController* _tmp3_;
};


static gpointer tpf_persona_store_parent_class = NULL;
static GeeHashMap* tpf_persona_store__persona_stores_by_account;
static GStaticRecMutex __lock_tpf_persona_store__persona_stores_by_account = {0};
static GeeHashMap* tpf_persona_store__persona_stores_by_account = NULL;
static GeeMap* tpf_persona_store__persona_stores_by_account_ro;
static GeeMap* tpf_persona_store__persona_stores_by_account_ro = NULL;

GType tpf_persona_store_get_type (void) G_GNUC_CONST;
GType tpf_persona_get_type (void) G_GNUC_CONST;
GType logger_get_type (void) G_GNUC_CONST;
GType tpf_persona_store_cache_get_type (void) G_GNUC_CONST;
#define TPF_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TPF_TYPE_PERSONA_STORE, TpfPersonaStorePrivate))
enum  {
	TPF_PERSONA_STORE_DUMMY_PROPERTY,
	TPF_PERSONA_STORE_ACCOUNT,
	TPF_PERSONA_STORE_TYPE_ID,
	TPF_PERSONA_STORE_CAN_ADD_PERSONAS,
	TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	TPF_PERSONA_STORE_CAN_GROUP_PERSONAS,
	TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	TPF_PERSONA_STORE_IS_PREPARED,
	TPF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES,
	TPF_PERSONA_STORE_IS_QUIESCENT,
	TPF_PERSONA_STORE_PERSONAS,
	TPF_PERSONA_STORE_SUPPORTED_FIELDS
};
static void _tpf_persona_store_reset (TpfPersonaStore* self);
static void _tpf_persona_store_remove_store_from_map (TpfPersonaStore* store);
static void _tpf_persona_store_debug_print_status (TpfPersonaStore* self, FolksDebug* debug);
static void __tpf_persona_store_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self);
static void _tpf_persona_store_logger_invalidated_cb (TpfPersonaStore* self);
static void __tpf_persona_store_logger_invalidated_cb_logger_invalidated (Logger* _sender, gpointer self);
static void _tpf_persona_store_account_invalidated_cb (TpfPersonaStore* self, guint domain, gint code, const gchar* message);
static void __tpf_persona_store_account_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self);
static void _tpf_persona_store_account_manager_invalidated_cb (TpfPersonaStore* self, guint domain, gint code, const gchar* message);
static void __tpf_persona_store_account_manager_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self);
static void _tpf_persona_store_notify_if_is_quiescent (TpfPersonaStore* self);
static void _tpf_persona_store_force_quiescent (TpfPersonaStore* self);
TpfPersonaStore* tpf_persona_store_new (TpAccount* account);
TpfPersonaStore* tpf_persona_store_construct (GType object_type, TpAccount* account);
static gchar* _tpf_persona_store_format_maybe_bool (TpfPersonaStore* self, FolksMaybeBool input);
gboolean tpf_persona_get_is_in_contact_list (TpfPersona* self);
TpContact* tpf_persona_get_contact (TpfPersona* self);
TpAccount* tpf_persona_store_get_account (TpfPersonaStore* self);
static void _tpf_persona_store_self_contact_changed_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void __tpf_persona_store_self_contact_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_contact_list_state_changed_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void __tpf_persona_store_contact_list_state_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_contact_list_changed_cb (TpfPersonaStore* self, GPtrArray* added, GPtrArray* removed);
static void __tpf_persona_store_contact_list_changed_cb_tp_connection_contact_list_changed (TpConnection* _sender, GPtrArray* added, GPtrArray* removed, gpointer self);
static void _tpf_persona_store_contact_weak_notify_cb (TpfPersonaStore* self, GObject* obj);
static void __tpf_persona_store_contact_weak_notify_cb_gweak_notify (gpointer self, GObject* object);
static void _tpf_persona_store_remove_store (TpfPersonaStore* self, GeeSet* old_personas);
static void tpf_persona_store_real_prepare_data_free (gpointer _data);
static void tpf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_prepare_co (TpfPersonaStorePrepareData* _data_);
static void ___lambda10_ (TpfPersonaStore* self, TpAccount* a);
static void ____lambda10__tp_account_manager_account_removed (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void ___lambda11_ (TpfPersonaStore* self, TpAccount* a, gboolean valid);
static void ____lambda11__tp_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* account, gboolean valid, gpointer self);
static void ___lambda12_ (TpfPersonaStore* self, TpAccount* a);
static void ____lambda12__tp_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self);
Logger* logger_new (const gchar* account_path);
Logger* logger_construct (GType object_type, const gchar* account_path);
static void _tpf_persona_store_favourite_contacts_changed_cb (TpfPersonaStore* self, gchar** added, int added_length1, gchar** removed, int removed_length1);
static void __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed (Logger* _sender, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer self);
static void _tpf_persona_store_initialise_favourite_contacts (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_initialise_favourite_contacts_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void ___lambda13_ (TpfPersonaStore* self, GObject* o, GAsyncResult* r);
static void ____lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tpf_persona_store_notify_connection_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void __tpf_persona_store_notify_connection_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_load_cache (TpfPersonaStore* self, GeeHashSet* old_personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_load_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void tpf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_initialise_favourite_contacts_data_free (gpointer _data);
static gboolean _tpf_persona_store_initialise_favourite_contacts_co (TpfPersonaStoreInitialiseFavouriteContactsData* _data_);
void logger_prepare (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_prepare_finish (Logger* self, GAsyncResult* _res_, GError** error);
static void _tpf_persona_store_initialise_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void logger_get_favourite_contacts (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** logger_get_favourite_contacts_finish (Logger* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static TpfPersona* _tpf_persona_store_lookup_persona_by_id (TpfPersonaStore* self, const gchar* id);
void _tpf_persona_set_is_favourite (TpfPersona* self, gboolean is_favourite);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void _tpf_persona_store_set_cache_needs_update (TpfPersonaStore* self);
static void _tpf_persona_store_store_cache (TpfPersonaStore* self, GeeHashSet* old_personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_store_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void ____lambda14_ (Block1Data* _data1_, GObject* o, GAsyncResult* r);
static void ___lambda15_ (TpfPersonaStore* self, GObject* o2, GAsyncResult* r2);
static void ____lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _____lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tpf_persona_store_notify_connection_cb_async (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_notify_connection_cb_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void _tpf_persona_store_notify_connection_cb_async_data_free (gpointer _data);
static gboolean _tpf_persona_store_notify_connection_cb_async_co (TpfPersonaStoreNotifyConnectionCbAsyncData* _data_);
static void _tpf_persona_store_notify_connection_cb_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_unload_cache (TpfPersonaStore* self);
static void _tpf_persona_store_marshall_supported_fields (TpfPersonaStore* self);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
static TpContactInfoFieldSpec* _vala_TpContactInfoFieldSpec_copy (TpContactInfoFieldSpec* self);
static void _vala_TpContactInfoFieldSpec_free (TpContactInfoFieldSpec* self);
static void __vala_TpContactInfoFieldSpec_free0_ (gpointer var);
static void _g_list_free___vala_TpContactInfoFieldSpec_free0_ (GList* self);
static void _tpf_persona_store_load_cache_data_free (gpointer _data);
static gboolean _tpf_persona_store_load_cache_co (TpfPersonaStoreLoadCacheData* _data_);
static void _tpf_persona_store_load_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _tpf_persona_store_add_persona (TpfPersonaStore* self, TpfPersona* p);
static void tpf_persona_store_real_flush_data_free (gpointer _data);
static void tpf_persona_store_real_flush (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_flush_co (TpfPersonaStoreFlushData* _data_);
static void tpf_persona_store_flush_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_store_cache_data_free (gpointer _data);
static gboolean _tpf_persona_store_store_cache_co (TpfPersonaStoreStoreCacheData* _data_);
static void _tpf_persona_store_store_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void _tpf_persona_store_update_avatar_cache (TpfPersonaStore* self, const gchar* persona_iid, GFile* avatar_file);
GFile* _tpf_persona_store_query_avatar_cache (TpfPersonaStore* self, const gchar* persona_iid);
static gboolean _tpf_persona_store_remove_persona (TpfPersonaStore* self, TpfPersona* p);
void _tpf_persona_contact_weak_notify (TpfPersona* self);
TpfPersona* _tpf_persona_store_ensure_persona_for_contact (TpfPersonaStore* self, TpContact* contact);
TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store);
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store);
static void _g_object_unref0_ (gpointer var);
static void _tpf_persona_store_populate_counters (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_populate_counters_finish (TpfPersonaStore* self, GAsyncResult* _res_);
void tpf_persona_set_is_in_contact_list (TpfPersona* self, gboolean value);
static void tpf_persona_store_real_remove_persona_data_free (gpointer _data);
static void tpf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_remove_persona_co (TpfPersonaStoreRemovePersonaData* _data_);
static void tpf_persona_store_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_ensure_persona_for_id_data_free (gpointer _data);
static void _tpf_persona_store_ensure_persona_for_id (TpfPersonaStore* self, const gchar* contact_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static TpfPersona* _tpf_persona_store_ensure_persona_for_id_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean _tpf_persona_store_ensure_persona_for_id_co (TpfPersonaStoreEnsurePersonaForIdData* _data_);
static void _tpf_persona_store_ensure_persona_for_id_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void tpf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_add_persona_from_details_co (TpfPersonaStoreAddPersonaFromDetailsData* _data_);
static void tpf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_store_change_is_favourite_data_free (gpointer _data);
void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean tpf_persona_store_change_is_favourite_co (TpfPersonaStoreChangeIsFavouriteData* _data_);
void logger_add_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_add_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_store_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void logger_remove_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_remove_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_store_change_alias_data_free (gpointer _data);
void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean tpf_persona_store_change_alias_co (TpfPersonaStoreChangeAliasData* _data_);
static void tpf_persona_store_change_alias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_store_change_user_birthday_data_free (gpointer _data);
void tpf_persona_store_change_user_birthday (TpfPersonaStore* self, TpfPersona* persona, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_user_birthday_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean tpf_persona_store_change_user_birthday_co (TpfPersonaStoreChangeUserBirthdayData* _data_);
static TpContactInfoField* _vala_TpContactInfoField_copy (TpContactInfoField* self);
static void _vala_TpContactInfoField_free (TpContactInfoField* self);
static void _tpf_persona_store_change_user_contact_info (TpfPersonaStore* self, TpfPersona* persona, FolksSmallSet* info_set, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_change_user_contact_info_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_store_change_user_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_store_change_user_full_name_data_free (gpointer _data);
void tpf_persona_store_change_user_full_name (TpfPersonaStore* self, TpfPersona* persona, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_user_full_name_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean tpf_persona_store_change_user_full_name_co (TpfPersonaStoreChangeUserFullNameData* _data_);
static void tpf_persona_store_change_user_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_change_user_details_data_free (gpointer _data);
void _tpf_persona_store_change_user_details (TpfPersonaStore* self, TpfPersona* persona, GeeSet* details, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _tpf_persona_store_change_user_details_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean _tpf_persona_store_change_user_details_co (TpfPersonaStoreChangeUserDetailsData* _data_);
static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value);
static void _tpf_persona_store_change_user_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_change_user_contact_info_data_free (gpointer _data);
static gboolean _tpf_persona_store_change_user_contact_info_co (TpfPersonaStoreChangeUserContactInfoData* _data_);
static GList* _tpf_persona_store_contact_info_set_to_list (FolksSmallSet* info_set);
static void _tpf_persona_store_change_user_contact_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __vala_TpContactInfoField_free0_ (gpointer var);
static void _g_list_free___vala_TpContactInfoField_free0_ (GList* self);
GeeMap* tpf_persona_store_list_persona_stores (void);
static void _tpf_persona_store_store_removed_cb (FolksPersonaStore* store);
static void _tpf_persona_store_add_store_to_map (TpfPersonaStore* store);
static void __tpf_persona_store_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
TpfPersonaStore* tpf_persona_store_dup_for_account (TpAccount* account);
static void _tpf_persona_store_populate_counters_data_free (gpointer _data);
static gboolean _tpf_persona_store_populate_counters_co (TpfPersonaStorePopulateCountersData* _data_);
static void __lambda8_ (FolksPersona* p, GDateTime* dt);
void _tpf_persona_increase_im_interaction_counter (TpfPersona* self, GDateTime* converted_datetime);
static void ___lambda8__folks_tp_zeitgeist_controller_increase_persona_counter (FolksPersona* p, GDateTime* converted_datetime);
static void __lambda9_ (FolksPersona* p, GDateTime* dt);
void _tpf_persona_increase_last_call_interaction_counter (TpfPersona* self, GDateTime* converted_datetime);
static void ___lambda9__folks_tp_zeitgeist_controller_increase_persona_counter (FolksPersona* p, GDateTime* converted_datetime);
static void _tpf_persona_store_populate_counters_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_store_set_account (TpfPersonaStore* self, TpAccount* value);
GeeSet* tpf_persona_store_get_supported_fields (TpfPersonaStore* self);
static GObject * tpf_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
TpfPersonaStoreCache* tpf_persona_store_cache_new (TpfPersonaStore* store);
TpfPersonaStoreCache* tpf_persona_store_cache_construct (GType object_type, TpfPersonaStore* store);
static void tpf_persona_store_finalize (GObject* obj);
static void _vala_tpf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tpf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void __tpf_persona_store_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self) {
	_tpf_persona_store_debug_print_status ((TpfPersonaStore*) self, _sender);
}


static void __tpf_persona_store_logger_invalidated_cb_logger_invalidated (Logger* _sender, gpointer self) {
	_tpf_persona_store_logger_invalidated_cb ((TpfPersonaStore*) self);
}


static void __tpf_persona_store_account_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self) {
	_tpf_persona_store_account_invalidated_cb ((TpfPersonaStore*) self, domain, code, message);
}


static void __tpf_persona_store_account_manager_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self) {
	_tpf_persona_store_account_manager_invalidated_cb ((TpfPersonaStore*) self, domain, code, message);
}


static void _tpf_persona_store_notify_if_is_quiescent (TpfPersonaStore* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->_got_initial_members;
	if (_tmp2_ == TRUE) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->priv->_got_initial_self_contact;
		_tmp1_ = _tmp3_ == TRUE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->_is_quiescent;
		_tmp0_ = _tmp4_ == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) self, "is-quiescent");
	}
}


static void _tpf_persona_store_force_quiescent (TpfPersonaStore* self) {
	g_return_if_fail (self != NULL);
	self->priv->_got_initial_self_contact = TRUE;
	self->priv->_got_initial_members = TRUE;
	_tpf_persona_store_notify_if_is_quiescent (self);
}


/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to store the {@link Persona}s for the contacts
   * in the Telepathy account provided by ``account``.
   *
   * @param account the Telepathy account being represented by the persona store
   */
TpfPersonaStore* tpf_persona_store_construct (GType object_type, TpAccount* account) {
	TpfPersonaStore * self = NULL;
	TpAccount* _tmp0_ = NULL;
	TpAccount* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	TpAccount* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_val_if_fail (account != NULL, NULL);
	_tmp0_ = account;
	_tmp1_ = account;
	_tmp2_ = tp_account_get_display_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = account;
	_tmp5_ = tp_proxy_get_object_path ((TpProxy*) _tmp4_);
	self = (TpfPersonaStore*) g_object_new (object_type, "account", _tmp0_, "display-name", _tmp3_, "id", _tmp5_, NULL);
	return self;
}


TpfPersonaStore* tpf_persona_store_new (TpAccount* account) {
	return tpf_persona_store_construct (TPF_TYPE_PERSONA_STORE, account);
}


static gchar* _tpf_persona_store_format_maybe_bool (TpfPersonaStore* self, FolksMaybeBool input) {
	gchar* result = NULL;
	FolksMaybeBool _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = input;
	switch (_tmp0_) {
		case FOLKS_MAYBE_BOOL_UNSET:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("unset");
			result = _tmp1_;
			return result;
		}
		case FOLKS_MAYBE_BOOL_TRUE:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("true");
			result = _tmp2_;
			return result;
		}
		case FOLKS_MAYBE_BOOL_FALSE:
		{
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("false");
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _tpf_persona_store_debug_print_status (TpfPersonaStore* self, FolksDebug* debug) {
	static const char domain[] = FOLKS_DEBUG_STATUS_LOG_DOMAIN;
	static const GLogLevelFlags level = G_LOG_LEVEL_INFO;
	FolksDebug* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	FolksDebug* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	TpConnection* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	TpAccountManager* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	TpfPersona* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	FolksMaybeBool _tmp19_ = 0;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	FolksMaybeBool _tmp22_ = 0;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	FolksMaybeBool _tmp25_ = 0;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	FolksMaybeBool _tmp28_ = 0;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	FolksDebug* _tmp31_ = NULL;
	GeeHashSet* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	FolksDebug* _tmp35_ = NULL;
	FolksDebug* _tmp67_ = NULL;
	FolksDebug* _tmp68_ = NULL;
	GeeHashMap* _tmp69_ = NULL;
	gint _tmp70_ = 0;
	gint _tmp71_ = 0;
	FolksDebug* _tmp72_ = NULL;
	GeeMapIterator* iter1 = NULL;
	GeeHashMap* _tmp73_ = NULL;
	GeeMapIterator* _tmp74_ = NULL;
	FolksDebug* _tmp83_ = NULL;
	FolksDebug* _tmp84_ = NULL;
	FolksSmallSet* _tmp85_ = NULL;
	gint _tmp86_ = 0;
	gint _tmp87_ = 0;
	FolksDebug* _tmp88_ = NULL;
	FolksDebug* _tmp103_ = NULL;
	FolksDebug* _tmp104_ = NULL;
	GeeHashMap* _tmp105_ = NULL;
	gint _tmp106_ = 0;
	gint _tmp107_ = 0;
	FolksDebug* _tmp108_ = NULL;
	FolksDebug* _tmp121_ = NULL;
	FolksDebug* _tmp122_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (debug != NULL);
	_tmp0_ = debug;
	folks_debug_print_heading (_tmp0_, domain, level, "Tpf.PersonaStore (%p)", self);
	_tmp2_ = self->priv->_is_prepared;
	if (_tmp2_) {
		_tmp1_ = "yes";
	} else {
		_tmp1_ = "no";
	}
	_tmp4_ = self->priv->_got_initial_members;
	if (_tmp4_) {
		_tmp3_ = "yes";
	} else {
		_tmp3_ = "no";
	}
	_tmp6_ = self->priv->_got_initial_self_contact;
	if (_tmp6_) {
		_tmp5_ = "yes";
	} else {
		_tmp5_ = "no";
	}
	_tmp7_ = debug;
	_tmp8_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->_conn;
	_tmp11_ = g_strdup_printf ("%p", _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->_account_manager;
	_tmp14_ = g_strdup_printf ("%p", _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->_self_persona;
	_tmp17_ = g_strdup_printf ("%p", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->_can_add_personas;
	_tmp20_ = _tpf_persona_store_format_maybe_bool (self, _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->_can_alias_personas;
	_tmp23_ = _tpf_persona_store_format_maybe_bool (self, _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = self->priv->_can_group_personas;
	_tmp26_ = _tpf_persona_store_format_maybe_bool (self, _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = self->priv->_can_remove_personas;
	_tmp29_ = _tpf_persona_store_format_maybe_bool (self, _tmp28_);
	_tmp30_ = _tmp29_;
	folks_debug_print_key_value_pairs (_tmp7_, domain, level, "ID", _tmp9_, "Prepared?", _tmp1_, "Has initial members?", _tmp3_, "Has self contact?", _tmp5_, "TpConnection", _tmp12_, "TpAccountManager", _tmp15_, "Self-Persona", _tmp18_, "Can add personas?", _tmp21_, "Can alias personas?", _tmp24_, "Can group personas?", _tmp27_, "Can remove personas?", _tmp30_, NULL);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp12_);
	_tmp31_ = debug;
	_tmp32_ = self->priv->_persona_set;
	_tmp33_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp32_);
	_tmp34_ = _tmp33_;
	folks_debug_print_line (_tmp31_, domain, level, "%u Personas:", (guint) _tmp34_);
	_tmp35_ = debug;
	folks_debug_indent (_tmp35_);
	{
		GeeIterator* _persona_it = NULL;
		GeeHashSet* _tmp36_ = NULL;
		GeeIterator* _tmp37_ = NULL;
		_tmp36_ = self->priv->_persona_set;
		_tmp37_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp36_);
		_persona_it = _tmp37_;
		while (TRUE) {
			GeeIterator* _tmp38_ = NULL;
			gboolean _tmp39_ = FALSE;
			TpfPersona* persona = NULL;
			GeeIterator* _tmp40_ = NULL;
			gpointer _tmp41_ = NULL;
			FolksDebug* _tmp42_ = NULL;
			TpfPersona* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			TpfPersona* _tmp45_ = NULL;
			gboolean _tmp46_ = FALSE;
			gboolean _tmp47_ = FALSE;
			const gchar* _tmp48_ = NULL;
			TpfPersona* _tmp49_ = NULL;
			gboolean _tmp50_ = FALSE;
			gboolean _tmp51_ = FALSE;
			FolksDebug* _tmp52_ = NULL;
			TpfPersona* _tmp53_ = NULL;
			const gchar* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			TpfPersona* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			TpfPersona* _tmp59_ = NULL;
			const gchar* _tmp60_ = NULL;
			const gchar* _tmp61_ = NULL;
			TpfPersona* _tmp62_ = NULL;
			TpContact* _tmp63_ = NULL;
			TpContact* _tmp64_ = NULL;
			gchar* _tmp65_ = NULL;
			gchar* _tmp66_ = NULL;
			_tmp38_ = _persona_it;
			_tmp39_ = gee_iterator_next (_tmp38_);
			if (!_tmp39_) {
				break;
			}
			_tmp40_ = _persona_it;
			_tmp41_ = gee_iterator_get (_tmp40_);
			persona = (TpfPersona*) _tmp41_;
			_tmp42_ = debug;
			_tmp43_ = persona;
			folks_debug_print_heading (_tmp42_, domain, level, "Persona (%p)", _tmp43_);
			_tmp45_ = persona;
			_tmp46_ = folks_persona_get_is_user ((FolksPersona*) _tmp45_);
			_tmp47_ = _tmp46_;
			if (_tmp47_) {
				_tmp44_ = "yes";
			} else {
				_tmp44_ = "no";
			}
			_tmp49_ = persona;
			_tmp50_ = tpf_persona_get_is_in_contact_list (_tmp49_);
			_tmp51_ = _tmp50_;
			if (_tmp51_) {
				_tmp48_ = "yes";
			} else {
				_tmp48_ = "no";
			}
			_tmp52_ = debug;
			_tmp53_ = persona;
			_tmp54_ = folks_persona_get_uid ((FolksPersona*) _tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = persona;
			_tmp57_ = folks_persona_get_iid ((FolksPersona*) _tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = persona;
			_tmp60_ = folks_persona_get_display_id ((FolksPersona*) _tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = persona;
			_tmp63_ = tpf_persona_get_contact (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = g_strdup_printf ("%p", _tmp64_);
			_tmp66_ = _tmp65_;
			folks_debug_print_key_value_pairs (_tmp52_, domain, level, "UID", _tmp55_, "IID", _tmp58_, "Display ID", _tmp61_, "User?", _tmp44_, "In contact list?", _tmp48_, "TpContact", _tmp66_, NULL);
			_g_free0 (_tmp66_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp67_ = debug;
	folks_debug_unindent (_tmp67_);
	_tmp68_ = debug;
	_tmp69_ = self->priv->_contact_persona_map;
	_tmp70_ = gee_abstract_map_get_size ((GeeMap*) _tmp69_);
	_tmp71_ = _tmp70_;
	folks_debug_print_line (_tmp68_, domain, level, "%u TpContact–Persona mappings:", (guint) _tmp71_);
	_tmp72_ = debug;
	folks_debug_indent (_tmp72_);
	_tmp73_ = self->priv->_contact_persona_map;
	_tmp74_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp73_);
	iter1 = _tmp74_;
	while (TRUE) {
		GeeMapIterator* _tmp75_ = NULL;
		gboolean _tmp76_ = FALSE;
		FolksDebug* _tmp77_ = NULL;
		GeeMapIterator* _tmp78_ = NULL;
		gpointer _tmp79_ = NULL;
		const gchar* _tmp80_ = NULL;
		GeeMapIterator* _tmp81_ = NULL;
		gpointer _tmp82_ = NULL;
		_tmp75_ = iter1;
		_tmp76_ = gee_map_iterator_next (_tmp75_);
		if (!(_tmp76_ == TRUE)) {
			break;
		}
		_tmp77_ = debug;
		_tmp78_ = iter1;
		_tmp79_ = gee_map_iterator_get_key (_tmp78_);
		_tmp80_ = tp_contact_get_identifier ((TpContact*) _tmp79_);
		_tmp81_ = iter1;
		_tmp82_ = gee_map_iterator_get_value (_tmp81_);
		folks_debug_print_line (_tmp77_, domain, level, "%s → %p", _tmp80_, (TpfPersona*) _tmp82_);
	}
	_tmp83_ = debug;
	folks_debug_unindent (_tmp83_);
	_tmp84_ = debug;
	_tmp85_ = self->priv->_favourite_ids;
	_tmp86_ = gee_collection_get_size ((GeeCollection*) _tmp85_);
	_tmp87_ = _tmp86_;
	folks_debug_print_line (_tmp84_, domain, level, "%u favourite TpContact IDs:", (guint) _tmp87_);
	_tmp88_ = debug;
	folks_debug_indent (_tmp88_);
	{
		FolksSmallSet* _id_list = NULL;
		FolksSmallSet* _tmp89_ = NULL;
		FolksSmallSet* _tmp90_ = NULL;
		gint _id_size = 0;
		FolksSmallSet* _tmp91_ = NULL;
		gint _tmp92_ = 0;
		gint _tmp93_ = 0;
		gint _id_index = 0;
		_tmp89_ = self->priv->_favourite_ids;
		_tmp90_ = _g_object_ref0 (_tmp89_);
		_id_list = _tmp90_;
		_tmp91_ = _id_list;
		_tmp92_ = gee_collection_get_size ((GeeCollection*) _tmp91_);
		_tmp93_ = _tmp92_;
		_id_size = _tmp93_;
		_id_index = -1;
		while (TRUE) {
			gint _tmp94_ = 0;
			gint _tmp95_ = 0;
			gint _tmp96_ = 0;
			gchar* id = NULL;
			FolksSmallSet* _tmp97_ = NULL;
			gint _tmp98_ = 0;
			gconstpointer _tmp99_ = NULL;
			gchar* _tmp100_ = NULL;
			FolksDebug* _tmp101_ = NULL;
			const gchar* _tmp102_ = NULL;
			_tmp94_ = _id_index;
			_id_index = _tmp94_ + 1;
			_tmp95_ = _id_index;
			_tmp96_ = _id_size;
			if (!(_tmp95_ < _tmp96_)) {
				break;
			}
			_tmp97_ = _id_list;
			_tmp98_ = _id_index;
			_tmp99_ = folks_small_set_get (_tmp97_, _tmp98_);
			_tmp100_ = g_strdup ((const gchar*) _tmp99_);
			id = _tmp100_;
			_tmp101_ = debug;
			_tmp102_ = id;
			folks_debug_print_line (_tmp101_, domain, level, "%s", _tmp102_);
			_g_free0 (id);
		}
		_g_object_unref0 (_id_list);
	}
	_tmp103_ = debug;
	folks_debug_unindent (_tmp103_);
	_tmp104_ = debug;
	_tmp105_ = self->priv->_avatars;
	_tmp106_ = gee_abstract_map_get_size ((GeeMap*) _tmp105_);
	_tmp107_ = _tmp106_;
	folks_debug_print_line (_tmp104_, domain, level, "Cached avatars for %u personas:", (guint) _tmp107_);
	_tmp108_ = debug;
	folks_debug_indent (_tmp108_);
	{
		GeeIterator* _id_it = NULL;
		GeeHashMap* _tmp109_ = NULL;
		GeeSet* _tmp110_ = NULL;
		GeeSet* _tmp111_ = NULL;
		GeeSet* _tmp112_ = NULL;
		GeeIterator* _tmp113_ = NULL;
		GeeIterator* _tmp114_ = NULL;
		_tmp109_ = self->priv->_avatars;
		_tmp110_ = gee_abstract_map_get_keys ((GeeMap*) _tmp109_);
		_tmp111_ = _tmp110_;
		_tmp112_ = _tmp111_;
		_tmp113_ = gee_iterable_iterator ((GeeIterable*) _tmp112_);
		_tmp114_ = _tmp113_;
		_g_object_unref0 (_tmp112_);
		_id_it = _tmp114_;
		while (TRUE) {
			GeeIterator* _tmp115_ = NULL;
			gboolean _tmp116_ = FALSE;
			gchar* id = NULL;
			GeeIterator* _tmp117_ = NULL;
			gpointer _tmp118_ = NULL;
			FolksDebug* _tmp119_ = NULL;
			const gchar* _tmp120_ = NULL;
			_tmp115_ = _id_it;
			_tmp116_ = gee_iterator_next (_tmp115_);
			if (!_tmp116_) {
				break;
			}
			_tmp117_ = _id_it;
			_tmp118_ = gee_iterator_get (_tmp117_);
			id = (gchar*) _tmp118_;
			_tmp119_ = debug;
			_tmp120_ = id;
			folks_debug_print_line (_tmp119_, domain, level, "%s", _tmp120_);
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	_tmp121_ = debug;
	folks_debug_unindent (_tmp121_);
	_tmp122_ = debug;
	folks_debug_print_line (_tmp122_, domain, level, "");
	_g_object_unref0 (iter1);
}


static void __tpf_persona_store_self_contact_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona_store_self_contact_changed_cb ((TpfPersonaStore*) self, _sender, pspec);
}


static void __tpf_persona_store_contact_list_state_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona_store_contact_list_state_changed_cb ((TpfPersonaStore*) self, _sender, pspec);
}


static void __tpf_persona_store_contact_list_changed_cb_tp_connection_contact_list_changed (TpConnection* _sender, GPtrArray* added, GPtrArray* removed, gpointer self) {
	_tpf_persona_store_contact_list_changed_cb ((TpfPersonaStore*) self, added, removed);
}


static void __tpf_persona_store_contact_weak_notify_cb_gweak_notify (gpointer self, GObject* object) {
	_tpf_persona_store_contact_weak_notify_cb ((TpfPersonaStore*) self, object);
}


static void _tpf_persona_store_reset (TpfPersonaStore* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	TpAccount* _tmp3_ = NULL;
	TpAccount* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GeeHashMap* _tmp11_ = NULL;
	GeeHashMap* _tmp12_ = NULL;
	GeeMap* _tmp13_ = NULL;
	GeeMap* _tmp14_ = NULL;
	GeeHashSet* _tmp15_ = NULL;
	TpConnection* _tmp16_ = NULL;
	GeeHashMap* _tmp25_ = NULL;
	GeeHashMap* _tmp34_ = NULL;
	FolksSmallSet* _tmp35_ = NULL;
	FolksSmallSet* _tmp36_ = NULL;
	GeeSet* _tmp37_ = NULL;
	GeeSet* _tmp38_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona-store.vala:394: Resetting Tpf.PersonaStore %p ('%s')", self, _tmp1_);
	_tmp3_ = tpf_persona_store_get_account (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = tp_account_get_protocol_name (_tmp4_);
	_tmp6_ = _tmp5_;
	if (g_strcmp0 (_tmp6_, "local-xmpp") == 0) {
		_tmp2_ = TRUE;
	} else {
		TpAccount* _tmp7_ = NULL;
		TpAccount* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp7_ = tpf_persona_store_get_account (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = tp_account_get_protocol_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp2_ = g_strcmp0 (_tmp10_, "irc") == 0;
	}
	if (_tmp2_) {
		folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_NONE);
	} else {
		folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_PARTIAL);
	}
	_tmp11_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp11_;
	_tmp12_ = self->priv->_personas;
	_tmp13_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp12_);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp14_;
	_tmp15_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_set);
	self->priv->_persona_set = _tmp15_;
	self->priv->_cache_needs_update = FALSE;
	_tmp16_ = self->priv->_conn;
	if (_tmp16_ != NULL) {
		TpConnection* _tmp17_ = NULL;
		guint _tmp18_ = 0U;
		GQuark _tmp19_ = 0U;
		TpConnection* _tmp20_ = NULL;
		guint _tmp21_ = 0U;
		GQuark _tmp22_ = 0U;
		TpConnection* _tmp23_ = NULL;
		guint _tmp24_ = 0U;
		_tmp17_ = self->priv->_conn;
		g_signal_parse_name ("notify::self-contact", G_TYPE_OBJECT, &_tmp18_, &_tmp19_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp17_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp18_, _tmp19_, NULL, (GCallback) __tpf_persona_store_self_contact_changed_cb_g_object_notify, self);
		_tmp20_ = self->priv->_conn;
		g_signal_parse_name ("notify::contact-list-state", G_TYPE_OBJECT, &_tmp21_, &_tmp22_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp20_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp21_, _tmp22_, NULL, (GCallback) __tpf_persona_store_contact_list_state_changed_cb_g_object_notify, self);
		_tmp23_ = self->priv->_conn;
		g_signal_parse_name ("contact-list-changed", tp_connection_get_type (), &_tmp24_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp23_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp24_, 0, NULL, (GCallback) __tpf_persona_store_contact_list_changed_cb_tp_connection_contact_list_changed, self);
		_g_object_unref0 (self->priv->_conn);
		self->priv->_conn = NULL;
	}
	_tmp25_ = self->priv->_contact_persona_map;
	if (_tmp25_ != NULL) {
		GeeMapIterator* iter = NULL;
		GeeHashMap* _tmp26_ = NULL;
		GeeMapIterator* _tmp27_ = NULL;
		_tmp26_ = self->priv->_contact_persona_map;
		_tmp27_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp26_);
		iter = _tmp27_;
		while (TRUE) {
			GeeMapIterator* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			TpContact* contact = NULL;
			GeeMapIterator* _tmp30_ = NULL;
			gpointer _tmp31_ = NULL;
			TpContact* _tmp32_ = NULL;
			TpContact* _tmp33_ = NULL;
			_tmp28_ = iter;
			_tmp29_ = gee_map_iterator_next (_tmp28_);
			if (!(_tmp29_ == TRUE)) {
				break;
			}
			_tmp30_ = iter;
			_tmp31_ = gee_map_iterator_get_key (_tmp30_);
			_tmp32_ = _g_object_ref0 ((TpContact*) _tmp31_);
			contact = _tmp32_;
			_tmp33_ = contact;
			g_object_weak_unref ((GObject*) _tmp33_, __tpf_persona_store_contact_weak_notify_cb_gweak_notify, self);
			_g_object_unref0 (contact);
		}
		_g_object_unref0 (iter);
	}
	_tmp34_ = gee_hash_map_new (tp_contact_get_type (), NULL, NULL, TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_contact_persona_map);
	self->priv->_contact_persona_map = _tmp34_;
	_tmp35_ = folks_small_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_supported_fields);
	self->priv->_supported_fields = _tmp35_;
	_tmp36_ = self->priv->_supported_fields;
	_tmp37_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp36_);
	_tmp38_ = _tmp37_;
	_g_object_unref0 (self->priv->_supported_fields_ro);
	self->priv->_supported_fields_ro = _tmp38_;
	_g_object_unref0 (self->priv->_self_persona);
	self->priv->_self_persona = NULL;
}


static void _tpf_persona_store_remove_store (TpfPersonaStore* self, GeeSet* old_personas) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_personas != NULL);
	_tmp0_ = self->priv->_disconnect_pending;
	if (_tmp0_ == TRUE) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
		_tmp2_ = _tmp1_;
		g_debug ("tpf-persona-store.vala:444: Delaying removing store %s (%p) due to pen" \
"ding disconnect.", _tmp2_, self);
		self->priv->_removal_pending = TRUE;
	} else {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GeeSet* _tmp5_ = NULL;
		TpfPersonaStoreCache* _tmp6_ = NULL;
		_tmp3_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
		_tmp4_ = _tmp3_;
		g_debug ("tpf-persona-store.vala:450: Removing store %s (%p)", _tmp4_, self);
		self->priv->_removal_pending = FALSE;
		_tmp5_ = old_personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, _tmp5_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_tmp6_ = self->priv->_cache;
		folks_object_cache_clear_cache ((FolksObjectCache*) _tmp6_, NULL, NULL);
		g_signal_emit_by_name ((FolksPersonaStore*) self, "removed");
	}
}


static void tpf_persona_store_real_prepare_data_free (gpointer _data) {
	TpfPersonaStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStorePrepareData, _data_);
}


static void tpf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStorePrepareData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	tpf_persona_store_real_prepare_co (_data_);
}


static void tpf_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaStorePrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the PersonaStore for use.
   *
   * See {@link Folks.PersonaStore.prepare}.
   *
   * @throws GLib.Error currently unused
   */
static void ___lambda10_ (TpfPersonaStore* self, TpAccount* a) {
	TpAccount* _tmp0_ = NULL;
	TpAccount* _tmp1_ = NULL;
	TpAccount* _tmp2_ = NULL;
	g_return_if_fail (a != NULL);
	_tmp0_ = tpf_persona_store_get_account (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = a;
	if (_tmp1_ == _tmp2_) {
		TpAccount* _tmp3_ = NULL;
		TpAccount* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GeeHashSet* _tmp7_ = NULL;
		_tmp3_ = a;
		_tmp4_ = a;
		_tmp5_ = tp_account_get_display_name (_tmp4_);
		_tmp6_ = _tmp5_;
		g_debug ("tpf-persona-store.vala:510: Account %p (‘%s’) removed.", _tmp3_, _tmp6_);
		_tmp7_ = self->priv->_persona_set;
		_tpf_persona_store_remove_store (self, (GeeSet*) _tmp7_);
	}
}


static void ____lambda10__tp_account_manager_account_removed (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	___lambda10_ ((TpfPersonaStore*) self, account);
}


static void ___lambda11_ (TpfPersonaStore* self, TpAccount* a, gboolean valid) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (a != NULL);
	_tmp1_ = valid;
	if (!_tmp1_) {
		TpAccount* _tmp2_ = NULL;
		TpAccount* _tmp3_ = NULL;
		TpAccount* _tmp4_ = NULL;
		_tmp2_ = tpf_persona_store_get_account (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = a;
		_tmp0_ = _tmp3_ == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		TpAccount* _tmp5_ = NULL;
		TpAccount* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GeeHashSet* _tmp9_ = NULL;
		_tmp5_ = a;
		_tmp6_ = a;
		_tmp7_ = tp_account_get_display_name (_tmp6_);
		_tmp8_ = _tmp7_;
		g_debug ("tpf-persona-store.vala:519: Account %p (‘%s’) invalid.", _tmp5_, _tmp8_);
		_tmp9_ = self->priv->_persona_set;
		_tpf_persona_store_remove_store (self, (GeeSet*) _tmp9_);
	}
}


static void ____lambda11__tp_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* account, gboolean valid, gpointer self) {
	___lambda11_ ((TpfPersonaStore*) self, account, valid);
}


static void ___lambda12_ (TpfPersonaStore* self, TpAccount* a) {
	TpAccount* _tmp0_ = NULL;
	TpAccount* _tmp1_ = NULL;
	TpAccount* _tmp2_ = NULL;
	g_return_if_fail (a != NULL);
	_tmp0_ = tpf_persona_store_get_account (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = a;
	if (_tmp1_ == _tmp2_) {
		TpAccount* _tmp3_ = NULL;
		TpAccount* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GeeHashSet* _tmp7_ = NULL;
		_tmp3_ = a;
		_tmp4_ = a;
		_tmp5_ = tp_account_get_display_name (_tmp4_);
		_tmp6_ = _tmp5_;
		g_debug ("tpf-persona-store.vala:528: Account %p (‘%s’) disabled.", _tmp3_, _tmp6_);
		_tmp7_ = self->priv->_persona_set;
		_tpf_persona_store_remove_store (self, (GeeSet*) _tmp7_);
	}
}


static void ____lambda12__tp_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	___lambda12_ ((TpfPersonaStore*) self, account);
}


static void __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed (Logger* _sender, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer self) {
	_tpf_persona_store_favourite_contacts_changed_cb ((TpfPersonaStore*) self, added, added_length1, removed, removed_length1);
}


static void ___lambda13_ (TpfPersonaStore* self, GObject* o, GAsyncResult* r) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (r != NULL);
	{
		GAsyncResult* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp0_ = r;
		_tpf_persona_store_initialise_favourite_contacts_finish (self, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		_tmp1_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
		_tmp2_ = _tmp1_;
		folks_internal_profiling_end ("initialising favourite " "contacts in Tpf.PersonaStore (ID: %s)", _tmp2_, NULL);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_debug ("tpf-persona-store.vala:556: Failed to initialise favourite contacts: %" \
"s", _tmp4_);
		_g_object_unref0 (self->priv->_logger);
		self->priv->_logger = NULL;
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda13_ ((TpfPersonaStore*) self, source_object, res);
	g_object_unref (self);
}


static void __tpf_persona_store_notify_connection_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona_store_notify_connection_cb ((TpfPersonaStore*) self, _sender, pspec);
}


static void tpf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStorePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_real_prepare_co (_data_);
}


static gboolean tpf_persona_store_real_prepare_co (TpfPersonaStorePrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	folks_internal_profiling_start ("preparing Tpf.PersonaStore (ID: %s)", _data_->_tmp1_, NULL);
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp3_) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp4_ = FALSE;
		_data_->_tmp4_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp2_ = _data_->_tmp4_;
	}
	if (_data_->_tmp2_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = tp_account_manager_dup ();
		_g_object_unref0 (_data_->self->priv->_account_manager);
		_data_->self->priv->_account_manager = _data_->_tmp5_;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->self->priv->_account_manager;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = tp_proxy_get_factory ((TpProxy*) _data_->_tmp6_);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
		_data_->factory = _data_->_tmp8_;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->factory;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_new0 (TpContactFeature, 8);
		_data_->_tmp10_[0] = TP_CONTACT_FEATURE_ALIAS;
		_data_->_tmp10_[1] = TP_CONTACT_FEATURE_AVATAR_DATA;
		_data_->_tmp10_[2] = TP_CONTACT_FEATURE_AVATAR_TOKEN;
		_data_->_tmp10_[3] = TP_CONTACT_FEATURE_CAPABILITIES;
		_data_->_tmp10_[4] = TP_CONTACT_FEATURE_CLIENT_TYPES;
		_data_->_tmp10_[5] = TP_CONTACT_FEATURE_PRESENCE;
		_data_->_tmp10_[6] = TP_CONTACT_FEATURE_CONTACT_INFO;
		_data_->_tmp10_[7] = TP_CONTACT_FEATURE_CONTACT_GROUPS;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11__length1 = 0;
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp11__length1 = 8;
		tp_simple_client_factory_add_contact_features (_data_->_tmp9_, (guint) 8, _data_->_tmp11_);
		_data_->_tmp11_ = (g_free (_data_->_tmp11_), NULL);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->self->priv->_account_manager;
		g_signal_connect_object ((TpProxy*) _data_->_tmp12_, "invalidated", (GCallback) __tpf_persona_store_account_manager_invalidated_cb_tp_proxy_invalidated, _data_->self, 0);
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->self->priv->_account_manager;
		g_signal_connect_object (_data_->_tmp13_, "account-removed", (GCallback) ____lambda10__tp_account_manager_account_removed, _data_->self, 0);
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->self->priv->_account_manager;
		g_signal_connect_object (_data_->_tmp14_, "account-validity-changed", (GCallback) ____lambda11__tp_account_manager_account_validity_changed, _data_->self, 0);
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->self->priv->_account_manager;
		g_signal_connect_object (_data_->_tmp15_, "account-disabled", (GCallback) ____lambda12__tp_account_manager_account_disabled, _data_->self, 0);
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->_tmp16_;
		folks_internal_profiling_point ("created account manager in " "Tpf.PersonaStore (ID: %s)", _data_->_tmp17_);
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->self->priv->_avatars;
		gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp18_);
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->self->priv->_favourite_ids;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _data_->_tmp19_);
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = logger_new (_data_->_tmp21_);
		_g_object_unref0 (_data_->self->priv->_logger);
		_data_->self->priv->_logger = _data_->_tmp22_;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->self->priv->_logger;
		g_signal_connect_object (_data_->_tmp23_, "invalidated", (GCallback) __tpf_persona_store_logger_invalidated_cb_logger_invalidated, _data_->self, 0);
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->self->priv->_logger;
		g_signal_connect_object (_data_->_tmp24_, "favourite-contacts-changed", (GCallback) __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed, _data_->self, 0);
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->_tmp25_;
		folks_internal_profiling_start ("initialising favourite contacts in " "Tpf.PersonaStore (ID: %s)", _data_->_tmp26_, NULL);
		_tpf_persona_store_initialise_favourite_contacts (_data_->self, ____lambda13__gasync_ready_callback, g_object_ref (_data_->self));
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->_tmp27_;
		folks_internal_profiling_point ("created logger in Tpf.PersonaStore " "(ID: %s)", _data_->_tmp28_);
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = _data_->_tmp29_;
		g_signal_connect_object ((GObject*) _data_->_tmp30_, "notify::connection", (GCallback) __tpf_persona_store_notify_connection_cb_g_object_notify, _data_->self, 0);
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = tp_account_get_connection (_data_->_tmp32_);
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = _data_->_tmp33_;
		if (_data_->_tmp34_ != NULL) {
			_data_->_tmp35_ = NULL;
			_data_->_tmp35_ = tpf_persona_store_get_account (_data_->self);
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = _data_->_tmp35_;
			_tpf_persona_store_notify_connection_cb (_data_->self, (GObject*) _data_->_tmp36_, NULL);
		} else {
			_data_->_state_ = 1;
			_tpf_persona_store_load_cache (_data_->self, NULL, tpf_persona_store_prepare_ready, _data_);
			return FALSE;
			_state_1:
			_tpf_persona_store_load_cache_finish (_data_->self, _data_->_res_);
			_tpf_persona_store_force_quiescent (_data_->self);
		}
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = _data_->_tmp37_;
		folks_internal_profiling_point ("loaded cache in Tpf.PersonaStore " "(ID: %s)", _data_->_tmp38_);
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_g_object_unref0 (_data_->factory);
	}
	__finally6:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = _data_->_tmp39_;
	folks_internal_profiling_end ("preparing Tpf.PersonaStore (ID: %s)", _data_->_tmp40_, NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_account_manager_invalidated_cb (TpfPersonaStore* self, guint domain, gint code, const gchar* message) {
	guint _tmp0_ = 0U;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GeeHashSet* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = domain;
	_tmp1_ = code;
	_tmp2_ = message;
	_tmp3_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp4_ = _tmp3_;
	g_debug ("TpAccountManager invalidated (%u, %i, “%s”) for " "Tpf.PersonaStore %p (‘%s’).", _tmp0_, _tmp1_, _tmp2_, self, _tmp4_);
	_tmp5_ = self->priv->_persona_set;
	_tpf_persona_store_remove_store (self, (GeeSet*) _tmp5_);
}


static void _tpf_persona_store_account_invalidated_cb (TpfPersonaStore* self, guint domain, gint code, const gchar* message) {
	guint _tmp0_ = 0U;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GeeHashSet* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = domain;
	_tmp1_ = code;
	_tmp2_ = message;
	_tmp3_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp4_ = _tmp3_;
	g_debug ("TpAccount invalidated (%u, %i, “%s”) for " "Tpf.PersonaStore %p (‘%s’).", _tmp0_, _tmp1_, _tmp2_, self, _tmp4_);
	_tmp5_ = self->priv->_persona_set;
	_tpf_persona_store_remove_store (self, (GeeSet*) _tmp5_);
}


static void _tpf_persona_store_logger_invalidated_cb (TpfPersonaStore* self) {
	Logger* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_logger;
	g_signal_parse_name ("invalidated", TYPE_LOGGER, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __tpf_persona_store_logger_invalidated_cb_logger_invalidated, self);
	g_debug ("tpf-persona-store.vala:615: Lost connection to the telepathy-logger se" \
"rvice.");
	_g_object_unref0 (self->priv->_logger);
	self->priv->_logger = NULL;
}


static void _tpf_persona_store_initialise_favourite_contacts_data_free (gpointer _data) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreInitialiseFavouriteContactsData, _data_);
}


static void _tpf_persona_store_initialise_favourite_contacts (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	_data_ = g_slice_new0 (TpfPersonaStoreInitialiseFavouriteContactsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_initialise_favourite_contacts);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_initialise_favourite_contacts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tpf_persona_store_initialise_favourite_contacts_co (_data_);
}


static void _tpf_persona_store_initialise_favourite_contacts_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_initialise_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_initialise_favourite_contacts_co (_data_);
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean _tpf_persona_store_initialise_favourite_contacts_co (TpfPersonaStoreInitialiseFavouriteContactsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_logger;
	if (_data_->_tmp0_ == NULL) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->_logger;
	_data_->_state_ = 1;
	logger_prepare (_data_->_tmp1_, _tpf_persona_store_initialise_favourite_contacts_ready, _data_);
	return FALSE;
	_state_1:
	logger_prepare_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->_logger;
	_data_->_tmp3_ = 0;
	_data_->_state_ = 2;
	logger_get_favourite_contacts (_data_->_tmp2_, _tpf_persona_store_initialise_favourite_contacts_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = logger_get_favourite_contacts_finish (_data_->_tmp2_, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error_);
	_data_->contacts_length1 = 0;
	_data_->_contacts_size_ = 0;
	_data_->contacts = _data_->_tmp4_;
	_data_->contacts_length1 = _data_->_tmp3_;
	_data_->_contacts_size_ = _data_->contacts_length1;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = NULL;
	_data_->_tmp5__length1 = 0;
	_data_->_tmp5_ = _data_->contacts;
	_data_->_tmp5__length1 = _data_->contacts_length1;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_new0 (gchar*, 0 + 1);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7__length1 = 0;
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp7__length1 = 0;
	_tpf_persona_store_favourite_contacts_changed_cb (_data_->self, _data_->_tmp5_, _data_->_tmp5__length1, _data_->_tmp7_, 0);
	_data_->_tmp7_ = (_vala_array_free (_data_->_tmp7_, _data_->_tmp7__length1, (GDestroyNotify) g_free), NULL);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8__length1 = 0;
	_data_->_tmp8_ = _data_->self->priv->_always_writeable_properties;
	_data_->_tmp8__length1 = _data_->self->priv->_always_writeable_properties_length1;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = g_strdup ("is-favourite");
	_vala_array_add6 (&_data_->self->priv->_always_writeable_properties, &_data_->self->priv->_always_writeable_properties_length1, &_data_->self->priv->__always_writeable_properties_size_, _data_->_tmp9_);
	g_object_notify ((GObject*) _data_->self, "always-writeable-properties");
	_data_->contacts = (_vala_array_free (_data_->contacts, _data_->contacts_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static TpfPersona* _tpf_persona_store_lookup_persona_by_id (TpfPersonaStore* self, const gchar* id) {
	TpfPersona* result = NULL;
	GeeMapIterator* iter = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeMapIterator* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->_contact_persona_map;
	_tmp1_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GeeMapIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp2_ = iter;
		_tmp3_ = gee_map_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = gee_map_iterator_get_key (_tmp4_);
		_tmp6_ = tp_contact_get_identifier ((TpContact*) _tmp5_);
		_tmp7_ = id;
		if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
			GeeMapIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			_tmp8_ = iter;
			_tmp9_ = gee_map_iterator_get_value (_tmp8_);
			result = (TpfPersona*) _tmp9_;
			_g_object_unref0 (iter);
			return result;
		}
	}
	result = NULL;
	_g_object_unref0 (iter);
	return result;
}


static void _tpf_persona_store_favourite_contacts_changed_cb (TpfPersonaStore* self, gchar** added, int added_length1, gchar** removed, int removed_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = added;
	_tmp0__length1 = added_length1;
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp0_;
		id_collection_length1 = _tmp0__length1;
		for (id_it = 0; id_it < _tmp0__length1; id_it = id_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* id = NULL;
			_tmp1_ = g_strdup (id_collection[id_it]);
			id = _tmp1_;
			{
				FolksSmallSet* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				TpfPersona* p = NULL;
				const gchar* _tmp4_ = NULL;
				TpfPersona* _tmp5_ = NULL;
				TpfPersona* _tmp6_ = NULL;
				_tmp2_ = self->priv->_favourite_ids;
				_tmp3_ = id;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _tmp3_);
				_tmp4_ = id;
				_tmp5_ = _tpf_persona_store_lookup_persona_by_id (self, _tmp4_);
				p = _tmp5_;
				_tmp6_ = p;
				if (_tmp6_ != NULL) {
					TpfPersona* _tmp7_ = NULL;
					_tmp7_ = p;
					_tpf_persona_set_is_favourite (_tmp7_, TRUE);
				}
				_g_object_unref0 (p);
				_g_free0 (id);
			}
		}
	}
	_tmp8_ = removed;
	_tmp8__length1 = removed_length1;
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp8_;
		id_collection_length1 = _tmp8__length1;
		for (id_it = 0; id_it < _tmp8__length1; id_it = id_it + 1) {
			gchar* _tmp9_ = NULL;
			gchar* id = NULL;
			_tmp9_ = g_strdup (id_collection[id_it]);
			id = _tmp9_;
			{
				FolksSmallSet* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				TpfPersona* p = NULL;
				const gchar* _tmp12_ = NULL;
				TpfPersona* _tmp13_ = NULL;
				TpfPersona* _tmp14_ = NULL;
				_tmp10_ = self->priv->_favourite_ids;
				_tmp11_ = id;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp10_, _tmp11_);
				_tmp12_ = id;
				_tmp13_ = _tpf_persona_store_lookup_persona_by_id (self, _tmp12_);
				p = _tmp13_;
				_tmp14_ = p;
				if (_tmp14_ != NULL) {
					TpfPersona* _tmp15_ = NULL;
					_tmp15_ = p;
					_tpf_persona_set_is_favourite (_tmp15_, FALSE);
				}
				_g_object_unref0 (p);
				_g_free0 (id);
			}
		}
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		TpfPersonaStore* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->old_personas);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda15_ (TpfPersonaStore* self, GObject* o2, GAsyncResult* r2) {
	GAsyncResult* _tmp0_ = NULL;
	g_return_if_fail (r2 != NULL);
	_tmp0_ = r2;
	_tpf_persona_store_load_cache_finish (self, _tmp0_);
}


static void ____lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda15_ ((TpfPersonaStore*) self, source_object, res);
	g_object_unref (self);
}


static void ____lambda14_ (Block1Data* _data1_, GObject* o, GAsyncResult* r) {
	TpfPersonaStore* self;
	GAsyncResult* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = _data1_->self;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_tpf_persona_store_store_cache_finish (self, _tmp0_);
	self->priv->_disconnect_pending = FALSE;
	_tmp1_ = self->priv->_removal_pending;
	if (_tmp1_ == FALSE) {
		GeeHashSet* _tmp2_ = NULL;
		_tmp2_ = _data1_->old_personas;
		_tpf_persona_store_load_cache (self, _tmp2_, ____lambda15__gasync_ready_callback, g_object_ref (self));
	} else {
		gboolean _tmp3_ = FALSE;
		GeeHashSet* _tmp4_ = NULL;
		_tmp3_ = self->priv->_disconnect_pending;
		_vala_assert (_tmp3_ == FALSE, "this._disconnect_pending == false");
		_tmp4_ = _data1_->old_personas;
		_tpf_persona_store_remove_store (self, (GeeSet*) _tmp4_);
	}
}


static void _____lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	____lambda14_ (self, source_object, res);
	block1_data_unref (self);
}


static void _tpf_persona_store_notify_connection_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	TpAccount* account = NULL;
	GObject* _tmp0_ = NULL;
	TpAccount* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	TpAccount* _tmp4_ = NULL;
	TpConnection* _tmp5_ = NULL;
	TpConnection* _tmp6_ = NULL;
	TpAccount* _tmp7_ = NULL;
	TpConnection* _tmp8_ = NULL;
	TpConnection* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, tp_account_get_type ()) ? ((TpAccount*) _tmp0_) : NULL);
	account = _tmp1_;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = account;
	_tmp5_ = tp_account_get_connection (_tmp4_);
	_tmp6_ = _tmp5_;
	g_debug ("tpf-persona-store.vala:677: Account '%s' connection changed to %p", _tmp3_, _tmp6_);
	_tmp7_ = account;
	_tmp8_ = tp_account_get_connection (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		FolksSmallSet* _tmp10_ = NULL;
		TpConnection* _tmp11_ = NULL;
		_tmp10_ = self->priv->_supported_fields;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp10_);
		g_object_notify ((GObject*) self, "supported-fields");
		_tmp11_ = self->priv->_conn;
		if (_tmp11_ != NULL) {
			Block1Data* _data1_;
			GeeHashSet* _tmp12_ = NULL;
			GeeHashSet* _tmp13_ = NULL;
			gboolean old_cache_needs_update = FALSE;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			GeeHashSet* _tmp16_ = NULL;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			self->priv->_disconnect_pending = TRUE;
			_tmp12_ = self->priv->_persona_set;
			_tmp13_ = _g_object_ref0 (_tmp12_);
			_data1_->old_personas = _tmp13_;
			_tmp14_ = self->priv->_cache_needs_update;
			old_cache_needs_update = _tmp14_;
			_tpf_persona_store_reset (self);
			_tmp15_ = old_cache_needs_update;
			if (_tmp15_) {
				_tpf_persona_store_set_cache_needs_update (self);
			}
			_tmp16_ = _data1_->old_personas;
			_tpf_persona_store_store_cache (self, _tmp16_, _____lambda14__gasync_ready_callback, block1_data_ref (_data1_));
			block1_data_unref (_data1_);
			_data1_ = NULL;
		}
		_tpf_persona_store_force_quiescent (self);
		_g_object_unref0 (account);
		return;
	}
	_tpf_persona_store_notify_connection_cb_async (self, NULL, NULL);
	_g_object_unref0 (account);
}


static void _tpf_persona_store_notify_connection_cb_async_data_free (gpointer _data) {
	TpfPersonaStoreNotifyConnectionCbAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreNotifyConnectionCbAsyncData, _data_);
}


static void _tpf_persona_store_notify_connection_cb_async (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreNotifyConnectionCbAsyncData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	_data_ = g_slice_new0 (TpfPersonaStoreNotifyConnectionCbAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_notify_connection_cb_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_notify_connection_cb_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tpf_persona_store_notify_connection_cb_async_co (_data_);
}


static void _tpf_persona_store_notify_connection_cb_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreNotifyConnectionCbAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_notify_connection_cb_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreNotifyConnectionCbAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_notify_connection_cb_async_co (_data_);
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean _tpf_persona_store_notify_connection_cb_async_co (TpfPersonaStoreNotifyConnectionCbAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("tpf-persona-store.vala:749: _notify_connection_cb_async() for Tpf.Pers" \
"onaStore %p ('%s').", _data_->self, _data_->_tmp1_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	folks_internal_profiling_start ("notify connection for Tpf.PersonaStore " "(ID: %s)", _data_->_tmp3_, NULL);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = tp_account_get_connection (_data_->_tmp5_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = 0U;
	_data_->_tmp8_ = tp_connection_get_feature_quark_contact_list ();
	_data_->_tmp9_ = 0U;
	_data_->_tmp9_ = tp_connection_get_feature_quark_contact_groups ();
	_data_->_tmp10_ = 0U;
	_data_->_tmp10_ = tp_connection_get_feature_quark_contact_info ();
	_data_->_tmp11_ = 0U;
	_data_->_tmp11_ = tp_connection_get_feature_quark_connected ();
	_data_->_tmp12_ = 0U;
	_data_->_tmp12_ = tp_connection_get_feature_quark_aliasing ();
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = g_new0 (GQuark, 6);
	_data_->_tmp13_[0] = _data_->_tmp8_;
	_data_->_tmp13_[1] = _data_->_tmp9_;
	_data_->_tmp13_[2] = _data_->_tmp10_;
	_data_->_tmp13_[3] = _data_->_tmp11_;
	_data_->_tmp13_[4] = _data_->_tmp12_;
	_data_->_tmp13_[5] = (GQuark) 0;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14__length1 = 0;
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp14__length1 = 6;
	_data_->_state_ = 1;
	tp_proxy_prepare_async ((TpProxy*) _data_->_tmp7_, _data_->_tmp14_, _tpf_persona_store_notify_connection_cb_async_ready, _data_);
	return FALSE;
	_state_1:
	tp_proxy_prepare_finish ((TpProxy*) _data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp14_ = (g_free (_data_->_tmp14_), NULL);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = tp_account_get_connection (_data_->_tmp16_);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = 0U;
	_data_->_tmp19_ = tp_iface_quark_connection_interface_contact_list ();
	_data_->_tmp20_ = FALSE;
	_data_->_tmp20_ = tp_proxy_has_interface_by_id ((TpProxy*) _data_->_tmp18_, _data_->_tmp19_);
	if (!_data_->_tmp20_) {
		g_debug ("tpf-persona-store.vala:768: %s", "Connection does not implement ContactList iface; " "legacy CMs are not supported any more.");
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->self->priv->_persona_set;
		_tpf_persona_store_remove_store (_data_->self, (GeeSet*) _data_->_tmp21_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_tpf_persona_store_unload_cache (_data_->self);
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->_tmp22_;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = tp_account_get_connection (_data_->_tmp23_);
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _g_object_ref0 (_data_->_tmp25_);
	_g_object_unref0 (_data_->self->priv->_conn);
	_data_->self->priv->_conn = _data_->_tmp26_;
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = _data_->self->priv->_conn;
	g_signal_connect_object ((GObject*) _data_->_tmp27_, "notify::self-contact", (GCallback) __tpf_persona_store_self_contact_changed_cb_g_object_notify, _data_->self, 0);
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->self->priv->_conn;
	g_signal_connect_object ((GObject*) _data_->_tmp28_, "notify::contact-list-state", (GCallback) __tpf_persona_store_contact_list_state_changed_cb_g_object_notify, _data_->self, 0);
	g_object_freeze_notify ((GObject*) _data_->self);
	_tpf_persona_store_marshall_supported_fields (_data_->self);
	g_object_notify ((GObject*) _data_->self, "supported-fields");
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->self->priv->_conn;
	_data_->_tmp30_ = 0;
	_data_->_tmp30_ = tp_connection_get_group_storage (_data_->_tmp29_);
	if (_data_->_tmp30_ != TP_CONTACT_METADATA_STORAGE_TYPE_NONE) {
		_data_->self->priv->_can_group_personas = FOLKS_MAYBE_BOOL_TRUE;
		_data_->_tmp31_ = NULL;
		_data_->_tmp31__length1 = 0;
		_data_->_tmp31_ = _data_->self->priv->_always_writeable_properties;
		_data_->_tmp31__length1 = _data_->self->priv->_always_writeable_properties_length1;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = g_strdup ("groups");
		_vala_array_add7 (&_data_->self->priv->_always_writeable_properties, &_data_->self->priv->_always_writeable_properties_length1, &_data_->self->priv->__always_writeable_properties_size_, _data_->_tmp32_);
		g_object_notify ((GObject*) _data_->self, "always-writeable-properties");
	} else {
		_data_->self->priv->_can_group_personas = FOLKS_MAYBE_BOOL_FALSE;
	}
	g_object_notify ((GObject*) _data_->self, "can-group-personas");
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _data_->self->priv->_conn;
	_data_->_tmp34_ = FALSE;
	_data_->_tmp34_ = tp_connection_get_can_change_contact_list (_data_->_tmp33_);
	if (_data_->_tmp34_) {
		_data_->self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_TRUE;
		_data_->self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_TRUE;
	} else {
		_data_->self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_FALSE;
		_data_->self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_FALSE;
	}
	g_object_notify ((GObject*) _data_->self, "can-add-personas");
	g_object_notify ((GObject*) _data_->self, "can-remove-personas");
	_data_->new_can_alias = FOLKS_MAYBE_BOOL_FALSE;
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = _data_->self->priv->_conn;
	_data_->_tmp36_ = FALSE;
	_data_->_tmp36_ = tp_connection_can_set_contact_alias (_data_->_tmp35_);
	if (_data_->_tmp36_) {
		_data_->new_can_alias = FOLKS_MAYBE_BOOL_TRUE;
		_data_->_tmp37_ = NULL;
		_data_->_tmp37__length1 = 0;
		_data_->_tmp37_ = _data_->self->priv->_always_writeable_properties;
		_data_->_tmp37__length1 = _data_->self->priv->_always_writeable_properties_length1;
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = g_strdup ("alias");
		_vala_array_add8 (&_data_->self->priv->_always_writeable_properties, &_data_->self->priv->_always_writeable_properties_length1, &_data_->self->priv->__always_writeable_properties_size_, _data_->_tmp38_);
		g_object_notify ((GObject*) _data_->self, "always-writeable-properties");
	}
	_data_->_tmp39_ = 0;
	_data_->_tmp39_ = _data_->new_can_alias;
	_data_->self->priv->_can_alias_personas = _data_->_tmp39_;
	g_object_notify ((GObject*) _data_->self, "can-alias-personas");
	g_object_thaw_notify ((GObject*) _data_->self);
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = _data_->self->priv->_conn;
	_tpf_persona_store_self_contact_changed_cb (_data_->self, (GObject*) _data_->_tmp40_, NULL);
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = _data_->self->priv->_conn;
	_tpf_persona_store_contact_list_state_changed_cb (_data_->self, (GObject*) _data_->_tmp41_, NULL);
	_data_->_tmp42_ = NULL;
	_data_->_tmp42_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp43_ = NULL;
	_data_->_tmp43_ = _data_->_tmp42_;
	folks_internal_profiling_end ("notify connection for Tpf.PersonaStore " "(ID: %s)", _data_->_tmp43_, NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static TpContactInfoFieldSpec* _vala_TpContactInfoFieldSpec_copy (TpContactInfoFieldSpec* self) {
	return g_boxed_copy (tp_contact_info_field_spec_get_type (), self);
}


static gpointer __vala_TpContactInfoFieldSpec_copy0 (gpointer self) {
	return self ? _vala_TpContactInfoFieldSpec_copy (self) : NULL;
}


static void _vala_TpContactInfoFieldSpec_free (TpContactInfoFieldSpec* self) {
	g_boxed_free (tp_contact_info_field_spec_get_type (), self);
}


static void __vala_TpContactInfoFieldSpec_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_TpContactInfoFieldSpec_free (var), NULL));
}


static void _g_list_free___vala_TpContactInfoFieldSpec_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) __vala_TpContactInfoFieldSpec_free0_, NULL);
	g_list_free (self);
}


static void _tpf_persona_store_marshall_supported_fields (TpfPersonaStore* self) {
	TpConnection* connection = NULL;
	TpAccount* _tmp0_ = NULL;
	TpAccount* _tmp1_ = NULL;
	TpConnection* _tmp2_ = NULL;
	TpConnection* _tmp3_ = NULL;
	TpConnection* _tmp4_ = NULL;
	TpConnection* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tpf_persona_store_get_account (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = tp_account_get_connection (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	connection = _tmp4_;
	_tmp5_ = connection;
	if (_tmp5_ != NULL) {
		FolksSmallSet* _tmp6_ = NULL;
		TpContactInfoFlags ci_flags = 0;
		TpConnection* _tmp7_ = NULL;
		TpContactInfoFlags _tmp8_ = 0;
		TpContactInfoFlags _tmp9_ = 0;
		_tmp6_ = self->priv->_supported_fields;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp6_);
		_tmp7_ = connection;
		_tmp8_ = tp_connection_get_contact_info_flags (_tmp7_);
		ci_flags = _tmp8_;
		_tmp9_ = ci_flags;
		if ((_tmp9_ & TP_CONTACT_INFO_FLAG_CAN_SET) != 0) {
			GList* field_specs = NULL;
			TpConnection* _tmp10_ = NULL;
			GList* _tmp11_ = NULL;
			GList* _tmp12_ = NULL;
			_tmp10_ = connection;
			_tmp11_ = tp_connection_dup_contact_info_supported_fields (_tmp10_);
			field_specs = _tmp11_;
			_tmp12_ = field_specs;
			{
				GList* field_spec_collection = NULL;
				GList* field_spec_it = NULL;
				field_spec_collection = _tmp12_;
				for (field_spec_it = field_spec_collection; field_spec_it != NULL; field_spec_it = field_spec_it->next) {
					TpContactInfoFieldSpec* _tmp13_ = NULL;
					TpContactInfoFieldSpec* field_spec = NULL;
					_tmp13_ = __vala_TpContactInfoFieldSpec_copy0 ((TpContactInfoFieldSpec*) field_spec_it->data);
					field_spec = _tmp13_;
					{
						FolksSmallSet* _tmp14_ = NULL;
						TpContactInfoFieldSpec* _tmp15_ = NULL;
						const gchar* _tmp16_ = NULL;
						_tmp14_ = self->priv->_supported_fields;
						_tmp15_ = field_spec;
						_tmp16_ = _tmp15_->name;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp16_);
						__vala_TpContactInfoFieldSpec_free0 (field_spec);
					}
				}
			}
			__g_list_free___vala_TpContactInfoFieldSpec_free0_0 (field_specs);
		}
	}
	_g_object_unref0 (connection);
}


static void _tpf_persona_store_load_cache_data_free (gpointer _data) {
	TpfPersonaStoreLoadCacheData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->old_personas);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreLoadCacheData, _data_);
}


static void _tpf_persona_store_load_cache (TpfPersonaStore* self, GeeHashSet* old_personas, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreLoadCacheData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	GeeHashSet* _tmp2_ = NULL;
	_data_ = g_slice_new0 (TpfPersonaStoreLoadCacheData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_load_cache);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_load_cache_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = old_personas;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->old_personas);
	_data_->old_personas = _tmp2_;
	_tpf_persona_store_load_cache_co (_data_);
}


static void _tpf_persona_store_load_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreLoadCacheData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * If our account is disconnected, we want to continue to export a static
   * view of personas from the cache. old_personas will be notified as removed.
   *
   * This method is safe to call multiple times concurrently. Previous calls
   * will be cancelled by subsequent calls.
   */
static void _tpf_persona_store_load_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreLoadCacheData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_load_cache_co (_data_);
}


static gboolean _tpf_persona_store_load_cache_co (TpfPersonaStoreLoadCacheData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = FALSE;
	g_object_get (_data_->_tmp2_, "enabled", &_data_->_tmp3_, NULL);
	_data_->_tmp4_ = FALSE;
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_tmp4_ == FALSE) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = FALSE;
		g_object_get (_data_->_tmp6_, "valid", &_data_->_tmp7_, NULL);
		_data_->_tmp8_ = FALSE;
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp0_ = _data_->_tmp8_ == FALSE;
	}
	if (_data_->_tmp0_) {
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = FALSE;
		g_object_get (_data_->_tmp11_, "enabled", &_data_->_tmp12_, NULL);
		_data_->_tmp13_ = FALSE;
		_data_->_tmp13_ = _data_->_tmp12_;
		if (_data_->_tmp13_) {
			_data_->_tmp9_ = "yes";
		} else {
			_data_->_tmp9_ = "no";
		}
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = FALSE;
		g_object_get (_data_->_tmp16_, "valid", &_data_->_tmp17_, NULL);
		_data_->_tmp18_ = FALSE;
		_data_->_tmp18_ = _data_->_tmp17_;
		if (_data_->_tmp18_) {
			_data_->_tmp14_ = "yes";
		} else {
			_data_->_tmp14_ = "no";
		}
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_tmp19_;
		g_debug ("Skipping loading cache for Tpf.PersonaStore %p ('%s'): " "enabled: %s, valid: %s.", _data_->self, _data_->_tmp20_, _data_->_tmp9_, _data_->_tmp14_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->_tmp21_;
	g_debug ("tpf-persona-store.vala:889: Loading cache for Tpf.PersonaStore %p ('%s" \
"').", _data_->self, _data_->_tmp22_);
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = g_cancellable_new ();
	_data_->cancellable = _data_->_tmp23_;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->self->priv->_load_cache_cancellable;
	if (_data_->_tmp24_ != NULL) {
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->self->priv->_load_cache_cancellable;
		g_debug ("tpf-persona-store.vala:895:     Cancelling ongoing loading operation (" \
"cancellable: %p).", _data_->_tmp25_);
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->self->priv->_load_cache_cancellable;
		g_cancellable_cancel (_data_->_tmp26_);
	}
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = _data_->cancellable;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _g_object_ref0 (_data_->_tmp27_);
	_g_object_unref0 (_data_->self->priv->_load_cache_cancellable);
	_data_->self->priv->_load_cache_cancellable = _data_->_tmp28_;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->self->priv->_cache;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->cancellable;
	_data_->_state_ = 1;
	folks_object_cache_load_objects ((FolksObjectCache*) _data_->_tmp29_, _data_->_tmp30_, _tpf_persona_store_load_cache_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = folks_object_cache_load_objects_finish ((FolksObjectCache*) _data_->_tmp29_, _data_->_res_);
	_data_->cached_personas = _data_->_tmp31_;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->cancellable;
	_data_->_tmp33_ = FALSE;
	_data_->_tmp33_ = g_cancellable_is_cancelled (_data_->_tmp32_);
	if (_data_->_tmp33_ == TRUE) {
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = _data_->cancellable;
		g_debug ("tpf-persona-store.vala:909:     Cancelled (cancellable: %p).", _data_->_tmp34_);
		_g_object_unref0 (_data_->cached_personas);
		_g_object_unref0 (_data_->cancellable);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_tpf_persona_store_reset (_data_->self);
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (_data_->self->priv->_persona_set);
	_data_->self->priv->_persona_set = _data_->_tmp35_;
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = _data_->cached_personas;
	if (_data_->_tmp36_ != NULL) {
		{
			_data_->_tmp37_ = NULL;
			_data_->_tmp37_ = _data_->cached_personas;
			_data_->_tmp38_ = NULL;
			_data_->_tmp38_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp37_);
			_data_->_p_it = _data_->_tmp38_;
			while (TRUE) {
				_data_->_tmp39_ = NULL;
				_data_->_tmp39_ = _data_->_p_it;
				_data_->_tmp40_ = FALSE;
				_data_->_tmp40_ = gee_iterator_next (_data_->_tmp39_);
				if (!_data_->_tmp40_) {
					break;
				}
				_data_->_tmp41_ = NULL;
				_data_->_tmp41_ = _data_->_p_it;
				_data_->_tmp42_ = NULL;
				_data_->_tmp42_ = gee_iterator_get (_data_->_tmp41_);
				_data_->p = (TpfPersona*) _data_->_tmp42_;
				_data_->_tmp43_ = NULL;
				_data_->_tmp43_ = _data_->p;
				_tpf_persona_store_add_persona (_data_->self, _data_->_tmp43_);
				_g_object_unref0 (_data_->p);
			}
			_g_object_unref0 (_data_->_p_it);
		}
	}
	_data_->_tmp44_ = NULL;
	_data_->_tmp44_ = _data_->cached_personas;
	_data_->_tmp45_ = NULL;
	_data_->_tmp45_ = _data_->old_personas;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, _data_->_tmp44_, (GeeSet*) _data_->_tmp45_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_data_->self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_FALSE;
	_data_->self->priv->_can_alias_personas = FOLKS_MAYBE_BOOL_FALSE;
	_data_->self->priv->_can_group_personas = FOLKS_MAYBE_BOOL_FALSE;
	_data_->self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_FALSE;
	_data_->_tmp46_ = NULL;
	_data_->_tmp46_ = _data_->self->priv->_logger;
	if (_data_->_tmp46_ != NULL) {
		_data_->_tmp47_ = NULL;
		_data_->_tmp47_ = g_strdup ("is-favourite");
		_data_->_tmp48_ = NULL;
		_data_->_tmp48_ = g_new0 (gchar*, 1 + 1);
		_data_->_tmp48_[0] = _data_->_tmp47_;
		_data_->self->priv->_always_writeable_properties = (_vala_array_free (_data_->self->priv->_always_writeable_properties, _data_->self->priv->_always_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
		_data_->self->priv->_always_writeable_properties = _data_->_tmp48_;
		_data_->self->priv->_always_writeable_properties_length1 = 1;
		_data_->self->priv->__always_writeable_properties_size_ = _data_->self->priv->_always_writeable_properties_length1;
	} else {
		_data_->_tmp49_ = NULL;
		_data_->_tmp49_ = g_new0 (gchar*, 0 + 1);
		_data_->self->priv->_always_writeable_properties = (_vala_array_free (_data_->self->priv->_always_writeable_properties, _data_->self->priv->_always_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
		_data_->self->priv->_always_writeable_properties = _data_->_tmp49_;
		_data_->self->priv->_always_writeable_properties_length1 = 0;
		_data_->self->priv->__always_writeable_properties_size_ = _data_->self->priv->_always_writeable_properties_length1;
	}
	g_object_notify ((GObject*) _data_->self, "always-writeable-properties");
	_g_object_unref0 (_data_->cached_personas);
	_g_object_unref0 (_data_->cancellable);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_real_flush_data_free (gpointer _data) {
	TpfPersonaStoreFlushData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreFlushData, _data_);
}


static void tpf_persona_store_real_flush (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStoreFlushData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStoreFlushData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_flush);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_flush_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	tpf_persona_store_real_flush_co (_data_);
}


static void tpf_persona_store_real_flush_finish (FolksPersonaStore* base, GAsyncResult* _res_) {
	TpfPersonaStoreFlushData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_flush_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreFlushData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_real_flush_co (_data_);
}


static gboolean tpf_persona_store_real_flush_co (TpfPersonaStoreFlushData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("tpf-persona-store.vala:947: Flushing Tpf.PersonaStore %p (‘%s’).", _data_->self, _data_->_tmp1_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->_persona_set;
	_data_->_state_ = 1;
	_tpf_persona_store_store_cache (_data_->self, _data_->_tmp2_, tpf_persona_store_flush_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_store_store_cache_finish (_data_->self, _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Called when a contact property is set which is not accessible when either
   * the contact is offline or we're offline. For example, a contact's avatar.
   * This will cause the cache to be stored when the PersonaStore is destroyed.
   */
void _tpf_persona_store_set_cache_needs_update (TpfPersonaStore* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("Setting cache as needing an update for Tpf.PersonaStore " "%p (‘%s’).", self, _tmp1_);
	self->priv->_cache_needs_update = TRUE;
}


static void _tpf_persona_store_store_cache_data_free (gpointer _data) {
	TpfPersonaStoreStoreCacheData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->old_personas);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreStoreCacheData, _data_);
}


static void _tpf_persona_store_store_cache (TpfPersonaStore* self, GeeHashSet* old_personas, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreStoreCacheData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	GeeHashSet* _tmp2_ = NULL;
	_data_ = g_slice_new0 (TpfPersonaStoreStoreCacheData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_store_cache);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_store_cache_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = old_personas;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->old_personas);
	_data_->old_personas = _tmp2_;
	_tpf_persona_store_store_cache_co (_data_);
}


static void _tpf_persona_store_store_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreStoreCacheData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * When we're about to disconnect, store the current set of personas to the
   * cache file so that we can access them once offline.
   *
   * This method is safe to call multiple times concurrently.
   */
static void _tpf_persona_store_store_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreStoreCacheData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_store_cache_co (_data_);
}


static gboolean _tpf_persona_store_store_cache_co (TpfPersonaStoreStoreCacheData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = FALSE;
	g_object_get (_data_->_tmp2_, "enabled", &_data_->_tmp3_, NULL);
	_data_->_tmp4_ = FALSE;
	_data_->_tmp4_ = _data_->_tmp3_;
	if (!_data_->_tmp4_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = tpf_persona_store_get_account (_data_->self);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = FALSE;
		g_object_get (_data_->_tmp6_, "valid", &_data_->_tmp7_, NULL);
		_data_->_tmp8_ = FALSE;
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp0_ = !_data_->_tmp8_;
	}
	if (_data_->_tmp0_) {
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_tmp9_;
		g_debug ("Skipping storing cache for Tpf.PersonaStore %p (‘%s’) as " "its TpAccount is disabled or invalid.", _data_->self, _data_->_tmp10_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp11_ = FALSE;
		_data_->_tmp11_ = _data_->self->priv->_cache_needs_update;
		if (_data_->_tmp11_ == FALSE) {
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->_tmp12_;
			g_debug ("Skipping storing cache for Tpf.PersonaStore %p (‘%s’) as " "it doesn’t need an update.", _data_->self, _data_->_tmp13_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_tmp14_;
	g_debug ("tpf-persona-store.vala:989: Storing cache for Tpf.PersonaStore %p ('%s" \
"').", _data_->self, _data_->_tmp15_);
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->self->priv->_cache;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->old_personas;
	_data_->_state_ = 1;
	folks_object_cache_store_objects ((FolksObjectCache*) _data_->_tmp16_, (GeeSet*) _data_->_tmp17_, NULL, _tpf_persona_store_store_cache_ready, _data_);
	return FALSE;
	_state_1:
	folks_object_cache_store_objects_finish ((FolksObjectCache*) _data_->_tmp16_, _data_->_res_);
	_data_->self->priv->_cache_needs_update = FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * When our account is connected again, we can unload the the personas which
   * we're advertising from the cache.
   */
static void _tpf_persona_store_unload_cache (TpfPersonaStore* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	GeeHashSet* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona-store.vala:1001: Unloading cache for Tpf.PersonaStore %p (" \
"'%s').", self, _tmp1_);
	_tmp2_ = self->priv->_load_cache_cancellable;
	if (_tmp2_ != NULL) {
		GCancellable* _tmp3_ = NULL;
		GCancellable* _tmp4_ = NULL;
		_tmp3_ = self->priv->_load_cache_cancellable;
		g_debug ("tpf-persona-store.vala:1006:     Cancelling ongoing loading operation " \
"(cancellable: %p).", _tmp3_);
		_tmp4_ = self->priv->_load_cache_cancellable;
		g_cancellable_cancel (_tmp4_);
	}
	_tmp5_ = self->priv->_persona_set;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp5_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_tpf_persona_store_reset (self);
}


void _tpf_persona_store_update_avatar_cache (TpfPersonaStore* self, const gchar* persona_iid, GFile* avatar_file) {
	GFile* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona_iid != NULL);
	_tmp0_ = avatar_file;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = self->priv->_avatars;
		_tmp2_ = persona_iid;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, _tmp2_, NULL);
	} else {
		GeeHashMap* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		_tmp3_ = self->priv->_avatars;
		_tmp4_ = persona_iid;
		_tmp5_ = avatar_file;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_FILE, GFile));
	}
}


GFile* _tpf_persona_store_query_avatar_cache (TpfPersonaStore* self, const gchar* persona_iid) {
	GFile* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (persona_iid != NULL, NULL);
	_tmp0_ = self->priv->_avatars;
	_tmp1_ = persona_iid;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	result = (GFile*) _tmp2_;
	return result;
}


static gboolean _tpf_persona_store_add_persona (TpfPersonaStore* self, TpfPersona* p) {
	gboolean result = FALSE;
	GeeHashSet* _tmp0_ = NULL;
	TpfPersona* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = self->priv->_persona_set;
	_tmp1_ = p;
	_tmp2_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		TpfPersona* _tmp3_ = NULL;
		TpfPersona* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GeeHashMap* _tmp7_ = NULL;
		TpfPersona* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		TpfPersona* _tmp11_ = NULL;
		_tmp3_ = p;
		_tmp4_ = p;
		_tmp5_ = folks_persona_get_uid ((FolksPersona*) _tmp4_);
		_tmp6_ = _tmp5_;
		g_debug ("tpf-persona-store.vala:1038: Add persona %p with uid %s", _tmp3_, _tmp6_);
		_tmp7_ = self->priv->_personas;
		_tmp8_ = p;
		_tmp9_ = folks_persona_get_iid ((FolksPersona*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = p;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, _tmp10_, _tmp11_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean _tpf_persona_store_remove_persona (TpfPersonaStore* self, TpfPersona* p) {
	gboolean result = FALSE;
	GeeHashSet* _tmp0_ = NULL;
	TpfPersona* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = self->priv->_persona_set;
	_tmp1_ = p;
	_tmp2_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		TpfPersona* _tmp3_ = NULL;
		TpfPersona* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GeeHashMap* _tmp7_ = NULL;
		TpfPersona* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		TpfPersona* _tmp11_ = NULL;
		TpfPersona* _tmp12_ = NULL;
		_tmp3_ = p;
		_tmp4_ = p;
		_tmp5_ = folks_persona_get_uid ((FolksPersona*) _tmp4_);
		_tmp6_ = _tmp5_;
		g_debug ("tpf-persona-store.vala:1050: Remove persona %p with uid %s", _tmp3_, _tmp6_);
		_tmp7_ = self->priv->_personas;
		_tmp8_ = p;
		_tmp9_ = folks_persona_get_iid ((FolksPersona*) _tmp8_);
		_tmp10_ = _tmp9_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, _tmp10_, NULL);
		_tmp11_ = self->priv->_self_persona;
		_tmp12_ = p;
		if (_tmp11_ == _tmp12_) {
			_g_object_unref0 (self->priv->_self_persona);
			self->priv->_self_persona = NULL;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void _tpf_persona_store_contact_weak_notify_cb (TpfPersonaStore* self, GObject* obj) {
	GeeHashMap* _tmp0_ = NULL;
	TpContact* contact = NULL;
	GObject* _tmp1_ = NULL;
	TpContact* _tmp2_ = NULL;
	TpContact* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	TpfPersona* persona = NULL;
	GeeHashMap* _tmp5_ = NULL;
	TpContact* _tmp6_ = NULL;
	gpointer _tmp7_ = NULL;
	TpfPersona* _tmp8_ = NULL;
	TpfPersona* _tmp9_ = NULL;
	TpfPersona* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_tmp0_ = self->priv->_contact_persona_map;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = obj;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, tp_contact_get_type ()) ? ((TpContact*) _tmp1_) : NULL);
	contact = _tmp2_;
	_tmp3_ = contact;
	_tmp4_ = tp_contact_get_identifier (_tmp3_);
	g_debug ("tpf-persona-store.vala:1071: Weak notify for TpContact %s", _tmp4_);
	persona = NULL;
	_tmp5_ = self->priv->_contact_persona_map;
	_tmp6_ = contact;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, _tmp6_, &_tmp7_);
	_g_object_unref0 (persona);
	persona = _tmp7_;
	_tmp8_ = persona;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (persona);
		_g_object_unref0 (contact);
		return;
	}
	_tmp9_ = persona;
	_tpf_persona_contact_weak_notify (_tmp9_);
	_tmp10_ = persona;
	_tmp11_ = _tpf_persona_store_remove_persona (self, _tmp10_);
	if (_tmp11_) {
		FolksSmallSet* personas = NULL;
		FolksSmallSet* _tmp12_ = NULL;
		FolksSmallSet* _tmp13_ = NULL;
		TpfPersona* _tmp14_ = NULL;
		FolksSmallSet* _tmp15_ = NULL;
		g_warning ("tpf-persona-store.vala:1087: A TpContact part of the ContactList is di" \
"sposed");
		_tmp12_ = folks_small_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		personas = _tmp12_;
		_tmp13_ = personas;
		_tmp14_ = persona;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
		_tmp15_ = personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp15_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_g_object_unref0 (personas);
	}
	_g_object_unref0 (persona);
	_g_object_unref0 (contact);
}


TpfPersona* _tpf_persona_store_ensure_persona_for_contact (TpfPersonaStore* self, TpContact* contact) {
	TpfPersona* result = NULL;
	TpfPersona* persona = NULL;
	GeeHashMap* _tmp0_ = NULL;
	TpContact* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	TpfPersona* _tmp3_ = NULL;
	TpContact* _tmp6_ = NULL;
	TpfPersona* _tmp7_ = NULL;
	GeeHashMap* _tmp8_ = NULL;
	TpContact* _tmp9_ = NULL;
	TpfPersona* _tmp10_ = NULL;
	TpContact* _tmp11_ = NULL;
	gboolean is_favourite = FALSE;
	FolksSmallSet* _tmp12_ = NULL;
	TpContact* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	TpfPersona* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	TpfPersona* _tmp20_ = NULL;
	TpfPersona* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	TpContact* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = self->priv->_contact_persona_map;
	_tmp1_ = contact;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	persona = (TpfPersona*) _tmp2_;
	_tmp3_ = persona;
	if (_tmp3_ != NULL) {
		TpfPersona* _tmp4_ = NULL;
		TpfPersona* _tmp5_ = NULL;
		_tmp4_ = persona;
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TPF_TYPE_PERSONA, TpfPersona));
		result = _tmp5_;
		_g_object_unref0 (persona);
		return result;
	}
	_tmp6_ = contact;
	_tmp7_ = tpf_persona_new (_tmp6_, self);
	_g_object_unref0 (persona);
	persona = _tmp7_;
	_tmp8_ = self->priv->_contact_persona_map;
	_tmp9_ = contact;
	_tmp10_ = persona;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = contact;
	g_object_weak_ref ((GObject*) _tmp11_, __tpf_persona_store_contact_weak_notify_cb_gweak_notify, self);
	_tmp12_ = self->priv->_favourite_ids;
	_tmp13_ = contact;
	_tmp14_ = tp_contact_get_identifier (_tmp13_);
	_tmp15_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp12_, _tmp14_);
	is_favourite = _tmp15_;
	_tmp16_ = persona;
	_tmp17_ = is_favourite;
	_tpf_persona_set_is_favourite (_tmp16_, _tmp17_);
	_tmp19_ = is_favourite;
	if (_tmp19_) {
		_tmp18_ = "yes";
	} else {
		_tmp18_ = "no";
	}
	_tmp20_ = persona;
	_tmp21_ = persona;
	_tmp22_ = folks_persona_get_uid ((FolksPersona*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = contact;
	_tmp25_ = tp_contact_get_identifier (_tmp24_);
	g_debug ("tpf-persona-store.vala:1110: Persona %p with uid %s created for TpCont" \
"act %s, favourite: %s", _tmp20_, _tmp23_, _tmp25_, _tmp18_);
	result = persona;
	return result;
}


static void _tpf_persona_store_self_contact_changed_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	TpContact* contact = NULL;
	TpConnection* _tmp0_ = NULL;
	TpContact* _tmp1_ = NULL;
	TpContact* _tmp2_ = NULL;
	TpContact* _tmp3_ = NULL;
	FolksSmallSet* personas_added = NULL;
	FolksSmallSet* _tmp4_ = NULL;
	FolksSmallSet* personas_removed = NULL;
	FolksSmallSet* _tmp5_ = NULL;
	TpfPersona* self_persona = NULL;
	TpfPersona* _tmp6_ = NULL;
	TpfPersona* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	TpfPersona* _tmp10_ = NULL;
	TpContact* _tmp18_ = NULL;
	FolksSmallSet* _tmp25_ = NULL;
	FolksSmallSet* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->_conn;
	_tmp1_ = tp_connection_get_self_contact (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	contact = _tmp3_;
	_tmp4_ = folks_small_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	personas_added = _tmp4_;
	_tmp5_ = folks_small_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	personas_removed = _tmp5_;
	_tmp6_ = self->priv->_self_persona;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	self_persona = _tmp7_;
	_tmp10_ = self_persona;
	if (_tmp10_ != NULL) {
		TpfPersona* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		_tmp11_ = self_persona;
		_tmp12_ = tpf_persona_get_is_in_contact_list (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp9_ = !_tmp13_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		TpfPersona* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = self_persona;
		_tmp15_ = _tpf_persona_store_remove_persona (self, _tmp14_);
		_tmp8_ = _tmp15_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		FolksSmallSet* _tmp16_ = NULL;
		TpfPersona* _tmp17_ = NULL;
		_tmp16_ = personas_removed;
		_tmp17_ = self_persona;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
	}
	_g_object_unref0 (self->priv->_self_persona);
	self->priv->_self_persona = NULL;
	_tmp18_ = contact;
	if (_tmp18_ != NULL) {
		TpContact* _tmp19_ = NULL;
		TpfPersona* _tmp20_ = NULL;
		TpfPersona* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		_tmp19_ = contact;
		_tmp20_ = _tpf_persona_store_ensure_persona_for_contact (self, _tmp19_);
		_g_object_unref0 (self->priv->_self_persona);
		self->priv->_self_persona = _tmp20_;
		_tmp21_ = self->priv->_self_persona;
		_tmp22_ = _tpf_persona_store_add_persona (self, _tmp21_);
		if (_tmp22_) {
			FolksSmallSet* _tmp23_ = NULL;
			TpfPersona* _tmp24_ = NULL;
			_tmp23_ = personas_added;
			_tmp24_ = self->priv->_self_persona;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
		}
	}
	_tmp25_ = personas_added;
	_tmp26_ = personas_removed;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, (GeeSet*) _tmp25_, (GeeSet*) _tmp26_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	self->priv->_got_initial_self_contact = TRUE;
	_tpf_persona_store_notify_if_is_quiescent (self);
	_g_object_unref0 (self_persona);
	_g_object_unref0 (personas_removed);
	_g_object_unref0 (personas_added);
	_g_object_unref0 (contact);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _tpf_persona_store_contact_list_state_changed_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	TpConnection* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	TpConnection* _tmp3_ = NULL;
	TpConnection* _tmp4_ = NULL;
	GPtrArray* _tmp5_ = NULL;
	GPtrArray* _tmp6_ = NULL;
	GPtrArray* _tmp7_ = NULL;
	GPtrArray* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->_conn;
	_tmp1_ = tp_connection_get_contact_list_state (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((guint) TP_CONTACT_LIST_STATE_SUCCESS)) {
		return;
	}
	_tmp3_ = self->priv->_conn;
	g_signal_connect_object (_tmp3_, "contact-list-changed", (GCallback) __tpf_persona_store_contact_list_changed_cb_tp_connection_contact_list_changed, self, 0);
	_tmp4_ = self->priv->_conn;
	_tmp5_ = tp_connection_dup_contact_list (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_tmp8_ = _tmp7_;
	_tpf_persona_store_contact_list_changed_cb (self, _tmp6_, _tmp8_);
	_g_ptr_array_unref0 (_tmp8_);
	_g_ptr_array_unref0 (_tmp6_);
	self->priv->_got_initial_members = TRUE;
	_tpf_persona_store_populate_counters (self, NULL, NULL);
	_tpf_persona_store_notify_if_is_quiescent (self);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void _tpf_persona_store_contact_list_changed_cb (TpfPersonaStore* self, GPtrArray* added, GPtrArray* removed) {
	GeeHashSet* personas_added = NULL;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* personas_removed = NULL;
	GeeHashSet* _tmp1_ = NULL;
	GPtrArray* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GPtrArray* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GPtrArray* _tmp8_ = NULL;
	gpointer* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	GPtrArray* _tmp21_ = NULL;
	gpointer* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	GeeHashSet* _tmp37_ = NULL;
	GeeHashSet* _tmp38_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	_tmp0_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	personas_added = _tmp0_;
	_tmp1_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	personas_removed = _tmp1_;
	_tmp2_ = added;
	_tmp3_ = g_ptr_array_get_length (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = removed;
	_tmp6_ = g_ptr_array_get_length (_tmp5_);
	_tmp7_ = _tmp6_;
	g_debug ("tpf-persona-store.vala:1173: contact list changed: %d added, %d remove" \
"d", _tmp4_, _tmp7_);
	_tmp8_ = added;
	_tmp9_ = _tmp8_->pdata;
	_tmp9__length1 = (gint) _tmp8_->len;
	{
		TpContact** contact_collection = NULL;
		gint contact_collection_length1 = 0;
		gint _contact_collection_size_ = 0;
		gint contact_it = 0;
		contact_collection = _tmp9_;
		contact_collection_length1 = _tmp9__length1;
		for (contact_it = 0; contact_it < _tmp9__length1; contact_it = contact_it + 1) {
			TpContact* _tmp10_ = NULL;
			TpContact* contact = NULL;
			_tmp10_ = _g_object_ref0 (contact_collection[contact_it]);
			contact = _tmp10_;
			{
				TpfPersona* persona = NULL;
				TpContact* _tmp11_ = NULL;
				TpfPersona* _tmp12_ = NULL;
				TpfPersona* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				TpfPersona* _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
				_tmp11_ = contact;
				_tmp12_ = _tpf_persona_store_ensure_persona_for_contact (self, _tmp11_);
				persona = _tmp12_;
				_tmp13_ = persona;
				_tmp14_ = tpf_persona_get_is_in_contact_list (_tmp13_);
				_tmp15_ = _tmp14_;
				if (!_tmp15_) {
					TpfPersona* _tmp16_ = NULL;
					_tmp16_ = persona;
					tpf_persona_set_is_in_contact_list (_tmp16_, TRUE);
				}
				_tmp17_ = persona;
				_tmp18_ = _tpf_persona_store_add_persona (self, _tmp17_);
				if (_tmp18_) {
					GeeHashSet* _tmp19_ = NULL;
					TpfPersona* _tmp20_ = NULL;
					_tmp19_ = personas_added;
					_tmp20_ = persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
				}
				_g_object_unref0 (persona);
				_g_object_unref0 (contact);
			}
		}
	}
	_tmp21_ = removed;
	_tmp22_ = _tmp21_->pdata;
	_tmp22__length1 = (gint) _tmp21_->len;
	{
		TpContact** contact_collection = NULL;
		gint contact_collection_length1 = 0;
		gint _contact_collection_size_ = 0;
		gint contact_it = 0;
		contact_collection = _tmp22_;
		contact_collection_length1 = _tmp22__length1;
		for (contact_it = 0; contact_it < _tmp22__length1; contact_it = contact_it + 1) {
			TpContact* _tmp23_ = NULL;
			TpContact* contact = NULL;
			_tmp23_ = _g_object_ref0 (contact_collection[contact_it]);
			contact = _tmp23_;
			{
				TpfPersona* persona = NULL;
				GeeHashMap* _tmp24_ = NULL;
				TpContact* _tmp25_ = NULL;
				gpointer _tmp26_ = NULL;
				TpfPersona* _tmp27_ = NULL;
				TpfPersona* _tmp30_ = NULL;
				TpfPersona* _tmp31_ = NULL;
				TpfPersona* _tmp33_ = NULL;
				gboolean _tmp34_ = FALSE;
				_tmp24_ = self->priv->_contact_persona_map;
				_tmp25_ = contact;
				_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp24_, _tmp25_);
				persona = (TpfPersona*) _tmp26_;
				_tmp27_ = persona;
				if (_tmp27_ == NULL) {
					TpContact* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					_tmp28_ = contact;
					_tmp29_ = tp_contact_get_identifier (_tmp28_);
					g_warning ("tpf-persona-store.vala:1197: Unknown TpContact removed from ContactLis" \
"t: %s", _tmp29_);
					_g_object_unref0 (persona);
					_g_object_unref0 (contact);
					continue;
				}
				_tmp30_ = persona;
				_tmp31_ = self->priv->_self_persona;
				if (_tmp30_ == _tmp31_) {
					TpfPersona* _tmp32_ = NULL;
					_tmp32_ = persona;
					tpf_persona_set_is_in_contact_list (_tmp32_, FALSE);
					_g_object_unref0 (persona);
					_g_object_unref0 (contact);
					continue;
				}
				_tmp33_ = persona;
				_tmp34_ = _tpf_persona_store_remove_persona (self, _tmp33_);
				if (_tmp34_) {
					GeeHashSet* _tmp35_ = NULL;
					TpfPersona* _tmp36_ = NULL;
					_tmp35_ = personas_removed;
					_tmp36_ = persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp36_);
				}
				_g_object_unref0 (persona);
				_g_object_unref0 (contact);
			}
		}
	}
	_tmp37_ = personas_added;
	_tmp38_ = personas_removed;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, (GeeSet*) _tmp37_, (GeeSet*) _tmp38_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_g_object_unref0 (personas_removed);
	_g_object_unref0 (personas_added);
}


static void tpf_persona_store_real_remove_persona_data_free (gpointer _data) {
	TpfPersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreRemovePersonaData, _data_);
}


static void tpf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStoreRemovePersonaData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	FolksPersona* _tmp1_ = NULL;
	FolksPersona* _tmp2_ = NULL;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp2_;
	tpf_persona_store_real_remove_persona_co (_data_);
}


static void tpf_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   *
   * @throws Folks.PersonaStoreError.UNSUPPORTED_ON_USER if ``persona`` is the
   * local user — removing the local user isn’t supported
   * @throws Folks.PersonaStoreError.REMOVE_FAILED if removing the contact
   * failed
   */
static void tpf_persona_store_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreRemovePersonaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_real_remove_persona_co (_data_);
}


static gboolean tpf_persona_store_real_remove_persona_co (TpfPersonaStoreRemovePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->persona;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, TPF_TYPE_PERSONA, TpfPersona));
	_data_->tp_persona = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->tp_persona;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = tpf_persona_get_contact (_data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->tp_persona;
		g_warning ("Skipping server-side removal of Tpf.Persona %p because " "it has no attached TpContact", _data_->_tmp5_);
		_g_object_unref0 (_data_->tp_persona);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->persona;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->self->priv->_self_persona;
	if (_data_->_tmp7_ == G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, FOLKS_TYPE_PERSONA, FolksPersona)) {
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->tp_persona;
		_data_->_tmp10_ = FALSE;
		_data_->_tmp10_ = tpf_persona_get_is_in_contact_list (_data_->_tmp9_);
		_data_->_tmp11_ = FALSE;
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp6_ = _data_->_tmp11_ == FALSE;
	} else {
		_data_->_tmp6_ = FALSE;
	}
	if (_data_->_tmp6_) {
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _ ("Telepathy contacts representing the local user may not be removed.");
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER, _data_->_tmp12_);
		_data_->_inner_error_ = _data_->_tmp13_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->tp_persona);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->tp_persona;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = tpf_persona_get_contact (_data_->_tmp14_);
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_state_ = 1;
		tp_contact_remove_async (_data_->_tmp16_, tpf_persona_store_remove_persona_ready, _data_);
		return FALSE;
		_state_1:
		tp_contact_remove_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _ ("Failed to remove a persona from store: %s");
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->e;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_REMOVE_FAILED, _data_->_tmp17_, _data_->_tmp19_);
		_data_->_inner_error_ = _data_->_tmp20_;
		_g_error_free0 (_data_->e);
		goto __finally8;
	}
	__finally8:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->tp_persona);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->tp_persona);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_ensure_persona_for_id_data_free (gpointer _data) {
	TpfPersonaStoreEnsurePersonaForIdData* _data_;
	_data_ = _data;
	_g_free0 (_data_->contact_id);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreEnsurePersonaForIdData, _data_);
}


static void _tpf_persona_store_ensure_persona_for_id (TpfPersonaStore* self, const gchar* contact_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreEnsurePersonaForIdData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (TpfPersonaStoreEnsurePersonaForIdData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_ensure_persona_for_id);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_ensure_persona_for_id_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = contact_id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->contact_id);
	_data_->contact_id = _tmp2_;
	_tpf_persona_store_ensure_persona_for_id_co (_data_);
}


static TpfPersona* _tpf_persona_store_ensure_persona_for_id_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersona* result;
	TpfPersonaStoreEnsurePersonaForIdData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _tpf_persona_store_ensure_persona_for_id_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreEnsurePersonaForIdData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_ensure_persona_for_id_co (_data_);
}


static gboolean _tpf_persona_store_ensure_persona_for_id_co (TpfPersonaStoreEnsurePersonaForIdData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_conn;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->contact_id;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_new0 (TpContactFeature, 0);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3__length1 = 0;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp3__length1 = 0;
	_data_->_state_ = 1;
	tp_connection_dup_contact_by_id_async (_data_->_tmp0_, _data_->_tmp1_, (guint) 0, _data_->_tmp3_, _tpf_persona_store_ensure_persona_for_id_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = tp_connection_dup_contact_by_id_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp3_ = (g_free (_data_->_tmp3_), NULL);
	_data_->contact = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _tpf_persona_store_ensure_persona_for_contact (_data_->self, _data_->contact);
	_data_->result = _data_->_tmp6_;
	_g_object_unref0 (_data_->contact);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->contact);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreAddPersonaFromDetailsData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void tpf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = details;
	_tmp2_ = _g_hash_table_ref0 (_tmp1_);
	_g_hash_table_unref0 (_data_->details);
	_data_->details = _tmp2_;
	tpf_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* tpf_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   *
   * This method is safe to call multiple times concurrently for the same (or
   * different) contact IDs (assuming Telepathy is safe).
   *
   * @throws Folks.PersonaStoreError.INVALID_ARGUMENT if the ``contact`` key was
   * not provided in ``details``
   * @throws Folks.PersonaStoreError.STORE_OFFLINE if the CM is offline
   * @throws Folks.PersonaStoreError.CREATE_FAILED if adding the contact failed
   */
static void tpf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_real_add_persona_from_details_co (_data_);
}


static gboolean tpf_persona_store_real_add_persona_from_details_co (TpfPersonaStoreAddPersonaFromDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->details;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = tp_asv_get_string (_data_->_tmp0_, "contact");
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
	_data_->contact_id = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->contact_id;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _ ("Persona store (%s, %s) requires the following details:\n" \
"    contact (provided: '%s')\n");
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = folks_persona_store_get_type_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->contact_id;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT, _data_->_tmp4_, _data_->_tmp6_, _data_->_tmp8_, _data_->_tmp9_);
		_data_->_inner_error_ = _data_->_tmp10_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->contact_id);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->contact_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->details;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = tp_asv_get_string (_data_->_tmp11_, "message");
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
	_data_->add_message = _data_->_tmp13_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->add_message;
	if (g_strcmp0 (_data_->_tmp14_, "") == 0) {
		_g_free0 (_data_->add_message);
		_data_->add_message = NULL;
	}
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = 0;
	_data_->_tmp17_ = tp_account_get_connection_status (_data_->_tmp16_, NULL);
	_data_->status = _data_->_tmp17_;
	_data_->_tmp20_ = 0;
	_data_->_tmp20_ = _data_->status;
	if (_data_->_tmp20_ == TP_CONNECTION_STATUS_DISCONNECTED) {
		_data_->_tmp19_ = TRUE;
	} else {
		_data_->_tmp21_ = 0;
		_data_->_tmp21_ = _data_->status;
		_data_->_tmp19_ = _data_->_tmp21_ == TP_CONNECTION_STATUS_CONNECTING;
	}
	if (_data_->_tmp19_) {
		_data_->_tmp18_ = TRUE;
	} else {
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->self->priv->_conn;
		_data_->_tmp18_ = _data_->_tmp22_ == NULL;
	}
	if (_data_->_tmp18_) {
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _ ("Cannot create a new Telepathy contact while offline.");
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _data_->_tmp23_);
		_data_->_inner_error_ = _data_->_tmp24_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->add_message);
			_g_free0 (_data_->contact_id);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->add_message);
			_g_free0 (_data_->contact_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->contact_id;
		_data_->_state_ = 1;
		_tpf_persona_store_ensure_persona_for_id (_data_->self, _data_->_tmp25_, tpf_persona_store_add_persona_from_details_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _tpf_persona_store_ensure_persona_for_id_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->persona = _data_->_tmp26_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->persona;
		_data_->_tmp28_ = FALSE;
		_data_->_tmp28_ = tpf_persona_get_is_in_contact_list (_data_->_tmp27_);
		_data_->_tmp29_ = FALSE;
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->already_exists = _data_->_tmp29_;
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = _data_->persona;
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp30_, TPF_TYPE_PERSONA, TpfPersona));
		_data_->tp_persona = _data_->_tmp31_;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = _data_->tp_persona;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = tpf_persona_get_contact (_data_->_tmp32_);
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = _data_->_tmp33_;
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = _data_->add_message;
		_data_->_state_ = 2;
		tp_contact_request_subscription_async (_data_->_tmp34_, _data_->_tmp35_, tpf_persona_store_add_persona_from_details_ready, _data_);
		return FALSE;
		_state_2:
		tp_contact_request_subscription_finish (_data_->_tmp34_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->tp_persona);
			_g_object_unref0 (_data_->persona);
			goto __catch9_g_error;
		}
		_data_->_tmp37_ = FALSE;
		_data_->_tmp37_ = _data_->already_exists;
		if (_data_->_tmp37_) {
			_data_->_tmp36_ = NULL;
		} else {
			_data_->_tmp38_ = NULL;
			_data_->_tmp38_ = _data_->persona;
			_data_->_tmp36_ = _data_->_tmp38_;
		}
		_data_->_tmp39_ = NULL;
		_data_->_tmp39_ = _g_object_ref0 ((FolksPersona*) _data_->_tmp36_);
		_data_->result = _data_->_tmp39_;
		_g_object_unref0 (_data_->tp_persona);
		_g_object_unref0 (_data_->persona);
		_g_free0 (_data_->add_message);
		_g_free0 (_data_->contact_id);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally9;
	__catch9_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp40_ = NULL;
		_data_->_tmp40_ = _ ("Failed to add a persona from details: %s");
		_data_->_tmp41_ = NULL;
		_data_->_tmp41_ = _data_->e;
		_data_->_tmp42_ = NULL;
		_data_->_tmp42_ = _data_->_tmp41_->message;
		_data_->_tmp43_ = NULL;
		_data_->_tmp43_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED, _data_->_tmp40_, _data_->_tmp42_);
		_data_->_inner_error_ = _data_->_tmp43_;
		_g_error_free0 (_data_->e);
		goto __finally9;
	}
	__finally9:
	if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->add_message);
		_g_free0 (_data_->contact_id);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_g_free0 (_data_->add_message);
		_g_free0 (_data_->contact_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_free0 (_data_->add_message);
	_g_free0 (_data_->contact_id);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_is_favourite_data_free (gpointer _data) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeIsFavouriteData, _data_);
}


void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	FolksPersona* _tmp1_ = NULL;
	FolksPersona* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeIsFavouriteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_is_favourite);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_is_favourite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp2_;
	_tmp3_ = is_favourite;
	_data_->is_favourite = _tmp3_;
	tpf_persona_store_change_is_favourite_co (_data_);
}


void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the favourite status of a persona in this store.
   *
   * This function is idempotent, but relies upon having a connection to the
   * Telepathy logger service, so may fail if that connection is not present.
   */
static void tpf_persona_store_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_change_is_favourite_co (_data_);
}


static gboolean tpf_persona_store_change_is_favourite_co (TpfPersonaStoreChangeIsFavouriteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_logger;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _ ("Failed to change favorite without a connection to the telepathy-logger" \
" service.");
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp1_);
		_data_->_inner_error_ = _data_->_tmp2_;
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->persona;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = tpf_persona_get_contact (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, TPF_TYPE_PERSONA, TpfPersona));
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	if (_data_->_tmp5_ == NULL) {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _ ("Failed to change favorite status of Telepathy Persona because it has n" \
"o attached TpContact.");
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_INVALID_VALUE, _data_->_tmp6_);
		_data_->_inner_error_ = _data_->_tmp7_;
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->persona;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = tpf_persona_get_contact (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, TPF_TYPE_PERSONA, TpfPersona));
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = tp_contact_get_identifier (_data_->_tmp10_);
		_data_->id = _data_->_tmp11_;
		_data_->_tmp12_ = FALSE;
		_data_->_tmp12_ = _data_->is_favourite;
		if (_data_->_tmp12_) {
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->self->priv->_logger;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->id;
			_data_->_state_ = 1;
			logger_add_favourite_contact (_data_->_tmp13_, _data_->_tmp14_, tpf_persona_store_change_is_favourite_ready, _data_);
			return FALSE;
			_state_1:
			logger_add_favourite_contact_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch10_g_error;
			}
		} else {
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->self->priv->_logger;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->id;
			_data_->_state_ = 2;
			logger_remove_favourite_contact (_data_->_tmp15_, _data_->_tmp16_, tpf_persona_store_change_is_favourite_ready, _data_);
			return FALSE;
			_state_2:
			logger_remove_favourite_contact_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch10_g_error;
			}
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _ ("Failed to change favorite status for Telepathy contact ‘%s’.");
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->persona;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = tpf_persona_get_contact (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, TPF_TYPE_PERSONA, TpfPersona));
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = tp_contact_get_identifier (_data_->_tmp20_);
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = g_error_new (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp17_, _data_->_tmp22_);
		_data_->_inner_error_ = _data_->_tmp23_;
		_g_error_free0 (_data_->e);
		goto __finally10;
	}
	__finally10:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_alias_data_free (gpointer _data) {
	TpfPersonaStoreChangeAliasData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_free0 (_data_->alias);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeAliasData, _data_);
}


void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeAliasData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	TpfPersona* _tmp1_ = NULL;
	TpfPersona* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeAliasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_alias);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_alias_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp2_;
	_tmp3_ = alias;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->alias);
	_data_->alias = _tmp4_;
	tpf_persona_store_change_alias_co (_data_);
}


void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeAliasData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_change_alias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeAliasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_change_alias_co (_data_);
}


static gboolean tpf_persona_store_change_alias_co (TpfPersonaStoreChangeAliasData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->alias;
	if (_data_->_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("");
		_g_free0 (_data_->alias);
		_data_->alias = _tmp1_;
	}
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->persona;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = tpf_persona_get_contact (_data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->persona;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->alias;
		g_warning ("Skipping Tpf.Persona %p alias change to '%s' because it " "has no attached TpContact", _data_->_tmp5_, _data_->_tmp6_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->persona;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = tpf_persona_get_contact (_data_->_tmp7_);
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = tp_contact_get_identifier (_data_->_tmp9_);
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->alias;
		g_debug ("tpf-persona-store.vala:1394: Changing alias of persona %s to '%s'.", _data_->_tmp10_, _data_->_tmp11_);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->self->priv->_conn;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->persona;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = tpf_persona_get_contact (_data_->_tmp13_);
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = 0U;
		_data_->_tmp16_ = tp_contact_get_handle (_data_->_tmp15_);
		_data_->_tmp17_ = 0U;
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->alias;
		_data_->_state_ = 1;
		folks_tp_lowlevel_connection_set_contact_alias_async (_data_->_tmp12_, (guint) ((TpHandle) _data_->_tmp17_), _data_->_tmp18_, tpf_persona_store_change_alias_ready, _data_);
		return FALSE;
		_state_1:
		folks_tp_lowlevel_connection_set_contact_alias_finish (_data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		_data_->e1 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _ ("Failed to change contact's alias: %s");
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->e1;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->_tmp20_->message;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = g_error_new (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp19_, _data_->_tmp21_);
		_data_->_inner_error_ = _data_->_tmp22_;
		_g_error_free0 (_data_->e1);
		goto __finally11;
	}
	__finally11:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_user_birthday_data_free (gpointer _data) {
	TpfPersonaStoreChangeUserBirthdayData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_date_time_unref0 (_data_->birthday);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeUserBirthdayData, _data_);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


void tpf_persona_store_change_user_birthday (TpfPersonaStore* self, TpfPersona* persona, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserBirthdayData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	TpfPersona* _tmp1_ = NULL;
	TpfPersona* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	GDateTime* _tmp4_ = NULL;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeUserBirthdayData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_user_birthday);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_user_birthday_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp2_;
	_tmp3_ = birthday;
	_tmp4_ = _g_date_time_ref0 (_tmp3_);
	_g_date_time_unref0 (_data_->birthday);
	_data_->birthday = _tmp4_;
	tpf_persona_store_change_user_birthday_co (_data_);
}


void tpf_persona_store_change_user_birthday_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeUserBirthdayData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gchar* g_date_time_to_string (GDateTime* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}


static TpContactInfoField* _vala_TpContactInfoField_copy (TpContactInfoField* self) {
	return g_boxed_copy (tp_contact_info_field_get_type (), self);
}


static void _vala_TpContactInfoField_free (TpContactInfoField* self) {
	g_boxed_free (tp_contact_info_field_get_type (), self);
}


static void tpf_persona_store_change_user_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserBirthdayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_change_user_birthday_co (_data_);
}


static gboolean tpf_persona_store_change_user_birthday_co (TpfPersonaStoreChangeUserBirthdayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->birthday;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = g_strdup ("");
		_g_free0 (_data_->birthday_str);
		_data_->birthday_str = _data_->_tmp1_;
	} else {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->birthday;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_date_time_to_string (_data_->_tmp2_);
		_g_free0 (_data_->birthday_str);
		_data_->birthday_str = _data_->_tmp3_;
	}
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = folks_small_set_new (tp_contact_info_field_get_type (), (GBoxedCopyFunc) _vala_TpContactInfoField_copy, _vala_TpContactInfoField_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->info_set = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->birthday_str;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp7_[0] = _data_->_tmp6_;
	_data_->values_length1 = 0;
	_data_->_values_size_ = 0;
	_data_->values = _data_->_tmp7_;
	_data_->values_length1 = 1;
	_data_->_values_size_ = _data_->values_length1;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp8_[0] = NULL;
	_data_->parameters_length1 = 0;
	_data_->_parameters_size_ = 0;
	_data_->parameters = _data_->_tmp8_;
	_data_->parameters_length1 = 1;
	_data_->_parameters_size_ = _data_->parameters_length1;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = tp_contact_info_field_new ("bday", _data_->parameters, _data_->values);
	_data_->field = _data_->_tmp9_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->info_set, _data_->field);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->persona;
	_data_->_state_ = 1;
	_tpf_persona_store_change_user_contact_info (_data_->self, _data_->_tmp10_, _data_->info_set, tpf_persona_store_change_user_birthday_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_store_change_user_contact_info_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			__vala_TpContactInfoField_free0 (_data_->field);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->info_set);
			_g_free0 (_data_->birthday_str);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			__vala_TpContactInfoField_free0 (_data_->field);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->info_set);
			_g_free0 (_data_->birthday_str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	__vala_TpContactInfoField_free0 (_data_->field);
	_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
	_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->info_set);
	_g_free0 (_data_->birthday_str);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_user_full_name_data_free (gpointer _data) {
	TpfPersonaStoreChangeUserFullNameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_free0 (_data_->full_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeUserFullNameData, _data_);
}


void tpf_persona_store_change_user_full_name (TpfPersonaStore* self, TpfPersona* persona, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserFullNameData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	TpfPersona* _tmp1_ = NULL;
	TpfPersona* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeUserFullNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_user_full_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_user_full_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp2_;
	_tmp3_ = full_name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->full_name);
	_data_->full_name = _tmp4_;
	tpf_persona_store_change_user_full_name_co (_data_);
}


void tpf_persona_store_change_user_full_name_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeUserFullNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_change_user_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserFullNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_change_user_full_name_co (_data_);
}


static gboolean tpf_persona_store_change_user_full_name_co (TpfPersonaStoreChangeUserFullNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->full_name;
	if (_data_->_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("");
		_g_free0 (_data_->full_name);
		_data_->full_name = _tmp1_;
	}
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = folks_small_set_new (tp_contact_info_field_get_type (), (GBoxedCopyFunc) _vala_TpContactInfoField_copy, _vala_TpContactInfoField_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->info_set = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->full_name;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp5_[0] = _data_->_tmp4_;
	_data_->values_length1 = 0;
	_data_->_values_size_ = 0;
	_data_->values = _data_->_tmp5_;
	_data_->values_length1 = 1;
	_data_->_values_size_ = _data_->values_length1;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp6_[0] = NULL;
	_data_->parameters_length1 = 0;
	_data_->_parameters_size_ = 0;
	_data_->parameters = _data_->_tmp6_;
	_data_->parameters_length1 = 1;
	_data_->_parameters_size_ = _data_->parameters_length1;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = tp_contact_info_field_new ("fn", _data_->parameters, _data_->values);
	_data_->field = _data_->_tmp7_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->info_set, _data_->field);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->persona;
	_data_->_state_ = 1;
	_tpf_persona_store_change_user_contact_info (_data_->self, _data_->_tmp8_, _data_->info_set, tpf_persona_store_change_user_full_name_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_store_change_user_contact_info_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			__vala_TpContactInfoField_free0 (_data_->field);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->info_set);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			__vala_TpContactInfoField_free0 (_data_->field);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->info_set);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	__vala_TpContactInfoField_free0 (_data_->field);
	_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
	_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->info_set);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_change_user_details_data_free (gpointer _data) {
	TpfPersonaStoreChangeUserDetailsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->details);
	_g_free0 (_data_->field_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeUserDetailsData, _data_);
}


void _tpf_persona_store_change_user_details (TpfPersonaStore* self, TpfPersona* persona, GeeSet* details, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserDetailsData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	TpfPersona* _tmp1_ = NULL;
	TpfPersona* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	GeeSet* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeUserDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_change_user_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_change_user_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp2_;
	_tmp3_ = details;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->details);
	_data_->details = _tmp4_;
	_tmp5_ = field_name;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->field_name);
	_data_->field_name = _tmp6_;
	_tpf_persona_store_change_user_details_co (_data_);
}


void _tpf_persona_store_change_user_details_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeUserDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _tpf_persona_store_change_user_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_change_user_details_co (_data_);
}


static gboolean _tpf_persona_store_change_user_details_co (TpfPersonaStoreChangeUserDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_small_set_new (tp_contact_info_field_get_type (), (GBoxedCopyFunc) _vala_TpContactInfoField_copy, _vala_TpContactInfoField_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->info_set = _data_->_tmp0_;
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->details;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp1_);
		_data_->_afd_it = _data_->_tmp2_;
		while (TRUE) {
			_data_->_tmp3_ = NULL;
			_data_->_tmp3_ = _data_->_afd_it;
			_data_->_tmp4_ = FALSE;
			_data_->_tmp4_ = gee_iterator_next (_data_->_tmp3_);
			if (!_data_->_tmp4_) {
				break;
			}
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = _data_->_afd_it;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = gee_iterator_get (_data_->_tmp5_);
			_data_->afd = (FolksAbstractFieldDetails*) _data_->_tmp6_;
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = _data_->afd;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = folks_abstract_field_details_get_value (_data_->_tmp7_);
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = g_strdup ((const gchar*) _data_->_tmp9_);
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = g_new0 (gchar*, 1 + 1);
			_data_->_tmp11_[0] = _data_->_tmp10_;
			_data_->values_length1 = 0;
			_data_->_values_size_ = 0;
			_data_->values = _data_->_tmp11_;
			_data_->values_length1 = 1;
			_data_->_values_size_ = _data_->values_length1;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = g_new0 (gchar*, 0 + 1);
			_data_->parameters_length1 = 0;
			_data_->_parameters_size_ = 0;
			_data_->parameters = _data_->_tmp12_;
			_data_->parameters_length1 = 0;
			_data_->_parameters_size_ = _data_->parameters_length1;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->afd;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = folks_abstract_field_details_get_parameters (_data_->_tmp13_);
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = gee_multi_map_map_iterator (_data_->_tmp15_);
			_data_->iter = _data_->_tmp16_;
			while (TRUE) {
				_data_->_tmp17_ = NULL;
				_data_->_tmp17_ = _data_->iter;
				_data_->_tmp18_ = FALSE;
				_data_->_tmp18_ = gee_map_iterator_next (_data_->_tmp17_);
				if (!_data_->_tmp18_) {
					break;
				}
				_data_->_tmp19_ = NULL;
				_data_->_tmp19_ = _data_->iter;
				_data_->_tmp20_ = NULL;
				_data_->_tmp20_ = gee_map_iterator_get_key (_data_->_tmp19_);
				_data_->param_name = (gchar*) _data_->_tmp20_;
				_data_->_tmp21_ = NULL;
				_data_->_tmp21_ = _data_->iter;
				_data_->_tmp22_ = NULL;
				_data_->_tmp22_ = gee_map_iterator_get_value (_data_->_tmp21_);
				_data_->param_value = (gchar*) _data_->_tmp22_;
				_data_->_tmp23_ = NULL;
				_data_->_tmp23__length1 = 0;
				_data_->_tmp23_ = _data_->parameters;
				_data_->_tmp23__length1 = _data_->parameters_length1;
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = _data_->param_name;
				_data_->_tmp25_ = NULL;
				_data_->_tmp25_ = string_to_string (_data_->_tmp24_);
				_data_->_tmp26_ = NULL;
				_data_->_tmp26_ = _data_->param_value;
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = string_to_string (_data_->_tmp26_);
				_data_->_tmp28_ = NULL;
				_data_->_tmp28_ = g_strconcat (_data_->_tmp25_, "=", _data_->_tmp27_, NULL);
				_vala_array_add9 (&_data_->parameters, &_data_->parameters_length1, &_data_->_parameters_size_, _data_->_tmp28_);
				_g_free0 (_data_->param_value);
				_g_free0 (_data_->param_name);
			}
			_data_->_tmp29_ = NULL;
			_data_->_tmp29__length1 = 0;
			_data_->_tmp29_ = _data_->parameters;
			_data_->_tmp29__length1 = _data_->parameters_length1;
			if (_data_->_tmp29__length1 == 0) {
				_data_->_tmp30_ = NULL;
				_data_->_tmp30_ = g_new0 (gchar*, 1 + 1);
				_data_->_tmp30_[0] = NULL;
				_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
				_data_->parameters = _data_->_tmp30_;
				_data_->parameters_length1 = 1;
				_data_->_parameters_size_ = _data_->parameters_length1;
			}
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = _data_->field_name;
			_data_->_tmp32_ = NULL;
			_data_->_tmp32__length1 = 0;
			_data_->_tmp32_ = _data_->parameters;
			_data_->_tmp32__length1 = _data_->parameters_length1;
			_data_->_tmp33_ = NULL;
			_data_->_tmp33__length1 = 0;
			_data_->_tmp33_ = _data_->values;
			_data_->_tmp33__length1 = _data_->values_length1;
			_data_->_tmp34_ = NULL;
			_data_->_tmp34_ = tp_contact_info_field_new (_data_->_tmp31_, _data_->_tmp32_, _data_->_tmp33_);
			_data_->field = _data_->_tmp34_;
			_data_->_tmp35_ = NULL;
			_data_->_tmp35_ = _data_->info_set;
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = _data_->field;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp35_, _data_->_tmp36_);
			__vala_TpContactInfoField_free0 (_data_->field);
			_g_object_unref0 (_data_->iter);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_free), NULL);
			_data_->values = (_vala_array_free (_data_->values, _data_->values_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->afd);
		}
		_g_object_unref0 (_data_->_afd_it);
	}
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->persona;
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = _data_->info_set;
	_data_->_state_ = 1;
	_tpf_persona_store_change_user_contact_info (_data_->self, _data_->_tmp37_, _data_->_tmp38_, _tpf_persona_store_change_user_details_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_store_change_user_contact_info_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->info_set);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->info_set);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->info_set);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_change_user_contact_info_data_free (gpointer _data) {
	TpfPersonaStoreChangeUserContactInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->info_set);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeUserContactInfoData, _data_);
}


static void _tpf_persona_store_change_user_contact_info (TpfPersonaStore* self, TpfPersona* persona, FolksSmallSet* info_set, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserContactInfoData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	TpfPersona* _tmp1_ = NULL;
	TpfPersona* _tmp2_ = NULL;
	FolksSmallSet* _tmp3_ = NULL;
	FolksSmallSet* _tmp4_ = NULL;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeUserContactInfoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_change_user_contact_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_change_user_contact_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp2_;
	_tmp3_ = info_set;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->info_set);
	_data_->info_set = _tmp4_;
	_tpf_persona_store_change_user_contact_info_co (_data_);
}


static void _tpf_persona_store_change_user_contact_info_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreChangeUserContactInfoData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_change_user_contact_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeUserContactInfoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_change_user_contact_info_co (_data_);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void __vala_TpContactInfoField_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_TpContactInfoField_free (var), NULL));
}


static void _g_list_free___vala_TpContactInfoField_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) __vala_TpContactInfoField_free0_, NULL);
	g_list_free (self);
}


static gboolean _tpf_persona_store_change_user_contact_info_co (TpfPersonaStoreChangeUserContactInfoData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->persona;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = folks_persona_get_is_user ((FolksPersona*) _data_->_tmp0_);
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = _data_->_tmp1_;
	if (!_data_->_tmp2_) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _ ("Extended information may only be set on the user's Telepathy contact.");
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_NON_USER, _data_->_tmp3_);
		_data_->_inner_error_ = _data_->_tmp4_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->info_set;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _tpf_persona_store_contact_info_set_to_list (_data_->_tmp5_);
	_data_->info_list = _data_->_tmp6_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = tp_account_get_connection (_data_->_tmp8_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_tmp9_;
	if (_data_->_tmp10_ != NULL) {
		_data_->_error_ = NULL;
		_data_->success = FALSE;
		{
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->self->priv->_conn;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->info_list;
			_data_->_state_ = 1;
			tp_connection_set_contact_info_async (_data_->_tmp12_, _data_->_tmp13_, _tpf_persona_store_change_user_contact_info_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp14_ = FALSE;
			_data_->_tmp14_ = tp_connection_set_contact_info_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp11_ = _data_->_tmp14_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch12_g_error;
			}
			_data_->success = _data_->_tmp11_;
		}
		goto __finally12;
		__catch12_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->e;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
			_g_error_free0 (_data_->_error_);
			_data_->_error_ = _data_->_tmp16_;
			_g_error_free0 (_data_->e);
		}
		__finally12:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_error_free0 (_data_->_error_);
				__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_error_free0 (_data_->_error_);
				__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->_error_;
		if (_data_->_tmp18_ != NULL) {
			_data_->_tmp17_ = TRUE;
		} else {
			_data_->_tmp19_ = FALSE;
			_data_->_tmp19_ = _data_->success;
			_data_->_tmp17_ = !_data_->_tmp19_;
		}
		if (_data_->_tmp17_) {
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->_error_;
			if (_data_->_tmp21_ != NULL) {
				_data_->_tmp22_ = NULL;
				_data_->_tmp22_ = _data_->_error_;
				_data_->_tmp23_ = NULL;
				_data_->_tmp23_ = _data_->_tmp22_->message;
				_data_->_tmp20_ = _data_->_tmp23_;
			} else {
				_data_->_tmp20_ = "(reason unknown)";
			}
			g_warning ("Failed to set extended information on user's " "Telepathy contact: %s", _data_->_tmp20_);
		}
		_g_error_free0 (_data_->_error_);
	} else {
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _ ("Extended information cannot be written because the store is disconnect" \
"ed.");
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _data_->_tmp24_);
		_data_->_inner_error_ = _data_->_tmp25_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	__g_list_free___vala_TpContactInfoField_free0_0 (_data_->info_list);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gpointer __vala_TpContactInfoField_copy0 (gpointer self) {
	return self ? _vala_TpContactInfoField_copy (self) : NULL;
}


static GList* _tpf_persona_store_contact_info_set_to_list (FolksSmallSet* info_set) {
	GList* result = NULL;
	GList* info_list = NULL;
	g_return_val_if_fail (info_set != NULL, NULL);
	info_list = NULL;
	{
		FolksSmallSet* _info_field_list = NULL;
		FolksSmallSet* _tmp0_ = NULL;
		FolksSmallSet* _tmp1_ = NULL;
		gint _info_field_size = 0;
		FolksSmallSet* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _info_field_index = 0;
		_tmp0_ = info_set;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_info_field_list = _tmp1_;
		_tmp2_ = _info_field_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_info_field_size = _tmp4_;
		_info_field_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			TpContactInfoField* info_field = NULL;
			FolksSmallSet* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gconstpointer _tmp10_ = NULL;
			TpContactInfoField* _tmp11_ = NULL;
			TpContactInfoField* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			TpContactInfoField* _tmp14_ = NULL;
			gchar** _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			TpContactInfoField* _tmp16_ = NULL;
			gchar** _tmp17_ = NULL;
			gint _tmp17__length1 = 0;
			TpContactInfoField* _tmp18_ = NULL;
			_tmp5_ = _info_field_index;
			_info_field_index = _tmp5_ + 1;
			_tmp6_ = _info_field_index;
			_tmp7_ = _info_field_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _info_field_list;
			_tmp9_ = _info_field_index;
			_tmp10_ = folks_small_set_get (_tmp8_, _tmp9_);
			_tmp11_ = __vala_TpContactInfoField_copy0 ((TpContactInfoField*) _tmp10_);
			info_field = _tmp11_;
			_tmp12_ = info_field;
			_tmp13_ = _tmp12_->field_name;
			_tmp14_ = info_field;
			_tmp15_ = _tmp14_->parameters;
			_tmp15__length1 = _vala_array_length (_tmp14_->parameters);
			_tmp16_ = info_field;
			_tmp17_ = _tmp16_->field_value;
			_tmp17__length1 = _vala_array_length (_tmp16_->field_value);
			_tmp18_ = tp_contact_info_field_new (_tmp13_, _tmp15_, _tmp17_);
			info_list = g_list_prepend (info_list, _tmp18_);
			__vala_TpContactInfoField_free0 (info_field);
		}
		_g_object_unref0 (_info_field_list);
	}
	info_list = g_list_reverse (info_list);
	result = info_list;
	return result;
}


/**
   * Get a map of all the currently constructed {@link Tpf.PersonaStore}s.
   *
   * If a {@link Folks.BackendStore} has been prepared, this map will be
   * complete, containing every store known to the Telepathy account manager. If
   * no {@link Folks.BackendStore} has been prepared, this map will only contain
   * the stores which have been created by calling
   * {@link Tpf.PersonaStore.dup_for_account}.
   *
   * This map is read-only. Use {@link Folks.BackendStore} or
   * {@link Tpf.PersonaStore.dup_for_account} to add stores.
   *
   * @return map from {@link Folks.PersonaStore.id} to {@link Tpf.PersonaStore}
   * @since 0.6.6
   */
GeeMap* tpf_persona_store_list_persona_stores (void) {
	GeeMap* result = NULL;
	GeeMap* store = NULL;
	GError * _inner_error_ = NULL;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = tpf_persona_store__persona_stores_by_account;
		g_static_rec_mutex_lock (&__lock_tpf_persona_store__persona_stores_by_account);
		{
			GeeHashMap* _tmp1_ = NULL;
			GeeMap* _tmp6_ = NULL;
			_tmp1_ = tpf_persona_store__persona_stores_by_account;
			if (_tmp1_ == NULL) {
				GeeHashMap* _tmp2_ = NULL;
				GeeHashMap* _tmp3_ = NULL;
				GeeMap* _tmp4_ = NULL;
				GeeMap* _tmp5_ = NULL;
				_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TPF_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account);
				tpf_persona_store__persona_stores_by_account = _tmp2_;
				_tmp3_ = tpf_persona_store__persona_stores_by_account;
				_tmp4_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp3_);
				_tmp5_ = _tmp4_;
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account_ro);
				tpf_persona_store__persona_stores_by_account_ro = _tmp5_;
			}
			_tmp6_ = tpf_persona_store__persona_stores_by_account_ro;
			store = _tmp6_;
		}
		__finally13:
		{
			GeeHashMap* _tmp7_ = NULL;
			_tmp7_ = tpf_persona_store__persona_stores_by_account;
			g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = store;
	return result;
}


static void _tpf_persona_store_store_removed_cb (FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_ = NULL;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tpf_persona_store_remove_store_from_map (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore));
}


static void __tpf_persona_store_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	_tpf_persona_store_store_removed_cb (_sender);
}


static void _tpf_persona_store_add_store_to_map (TpfPersonaStore* store) {
	TpfPersonaStore* _tmp0_ = NULL;
	TpfPersonaStore* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("tpf-persona-store.vala:1583: Adding PersonaStore %p ('%s') to map.", _tmp0_, _tmp3_);
	{
		GeeHashMap* _tmp4_ = NULL;
		_tmp4_ = tpf_persona_store__persona_stores_by_account;
		g_static_rec_mutex_lock (&__lock_tpf_persona_store__persona_stores_by_account);
		{
			GeeHashMap* _tmp5_ = NULL;
			GeeHashMap* _tmp10_ = NULL;
			TpfPersonaStore* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			GeeHashMap* _tmp15_ = NULL;
			TpfPersonaStore* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			TpfPersonaStore* _tmp19_ = NULL;
			TpfPersonaStore* _tmp20_ = NULL;
			_tmp5_ = tpf_persona_store__persona_stores_by_account;
			if (_tmp5_ == NULL) {
				GeeHashMap* _tmp6_ = NULL;
				GeeHashMap* _tmp7_ = NULL;
				GeeMap* _tmp8_ = NULL;
				GeeMap* _tmp9_ = NULL;
				_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TPF_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account);
				tpf_persona_store__persona_stores_by_account = _tmp6_;
				_tmp7_ = tpf_persona_store__persona_stores_by_account;
				_tmp8_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp7_);
				_tmp9_ = _tmp8_;
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account_ro);
				tpf_persona_store__persona_stores_by_account_ro = _tmp9_;
			}
			_tmp10_ = tpf_persona_store__persona_stores_by_account;
			_tmp11_ = store;
			_tmp12_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp10_, _tmp13_);
			g_return_if_fail (!_tmp14_);
			_tmp15_ = tpf_persona_store__persona_stores_by_account;
			_tmp16_ = store;
			_tmp17_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = store;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp18_, _tmp19_);
			_tmp20_ = store;
			g_signal_connect ((FolksPersonaStore*) _tmp20_, "removed", (GCallback) __tpf_persona_store_store_removed_cb_folks_persona_store_removed, NULL);
		}
		__finally14:
		{
			GeeHashMap* _tmp21_ = NULL;
			_tmp21_ = tpf_persona_store__persona_stores_by_account;
			g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void _tpf_persona_store_remove_store_from_map (TpfPersonaStore* store) {
	TpfPersonaStore* _tmp0_ = NULL;
	TpfPersonaStore* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("tpf-persona-store.vala:1608: Removing PersonaStore %p ('%s') from map.", _tmp0_, _tmp3_);
	{
		GeeHashMap* _tmp4_ = NULL;
		_tmp4_ = tpf_persona_store__persona_stores_by_account;
		g_static_rec_mutex_lock (&__lock_tpf_persona_store__persona_stores_by_account);
		{
			gboolean _tmp5_ = FALSE;
			GeeHashMap* _tmp6_ = NULL;
			TpfPersonaStore* _tmp13_ = NULL;
			guint _tmp14_ = 0U;
			GeeHashMap* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			_tmp6_ = tpf_persona_store__persona_stores_by_account;
			if (_tmp6_ == NULL) {
				_tmp5_ = TRUE;
			} else {
				GeeHashMap* _tmp7_ = NULL;
				TpfPersonaStore* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				_tmp7_ = tpf_persona_store__persona_stores_by_account;
				_tmp8_ = store;
				_tmp9_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, _tmp10_, NULL);
				_tmp5_ = !_tmp11_;
			}
			if (_tmp5_) {
				{
					GeeHashMap* _tmp12_ = NULL;
					_tmp12_ = tpf_persona_store__persona_stores_by_account;
					g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
				}
				return;
			}
			_tmp13_ = store;
			g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp14_, NULL, FALSE);
			g_signal_handlers_disconnect_matched ((FolksPersonaStore*) _tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) __tpf_persona_store_store_removed_cb_folks_persona_store_removed, NULL);
			_tmp15_ = tpf_persona_store__persona_stores_by_account;
			_tmp16_ = gee_abstract_map_get_size ((GeeMap*) _tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ == 0) {
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account_ro);
				tpf_persona_store__persona_stores_by_account_ro = NULL;
				_g_object_unref0 (tpf_persona_store__persona_stores_by_account);
				tpf_persona_store__persona_stores_by_account = NULL;
			}
		}
		__finally15:
		{
			GeeHashMap* _tmp18_ = NULL;
			_tmp18_ = tpf_persona_store__persona_stores_by_account;
			g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
   * Look up a {@link Tpf.PersonaStore} by its {@link TelepathyGLib.Account}.
   *
   * If found, a new reference to the persona store will be returned. If not
   * found, a new {@link Tpf.PersonaStore} will be created for the account.
   *
   * See the documentation for {@link Tpf.PersonaStore.list_persona_stores} for
   * information on the lifecycle of these stores when a
   * {@link Folks.BackendStore} is and is not present.
   *
   * @param account the Telepathy account of the persona store
   * @return the persona store associated with the account
   * @since 0.6.6
   */
TpfPersonaStore* tpf_persona_store_dup_for_account (TpAccount* account) {
	TpfPersonaStore* result = NULL;
	TpfPersonaStore* store = NULL;
	TpAccount* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (account != NULL, NULL);
	store = NULL;
	_tmp0_ = account;
	g_debug ("tpf-persona-store.vala:1650: Tpf.PersonaStore.dup_for_account (%p):", _tmp0_);
	{
		GeeHashMap* _tmp1_ = NULL;
		_tmp1_ = tpf_persona_store__persona_stores_by_account;
		g_static_rec_mutex_lock (&__lock_tpf_persona_store__persona_stores_by_account);
		{
			GeeHashMap* _tmp2_ = NULL;
			TpfPersonaStore* _tmp7_ = NULL;
			_tmp2_ = tpf_persona_store__persona_stores_by_account;
			if (_tmp2_ != NULL) {
				GeeHashMap* _tmp3_ = NULL;
				TpAccount* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gpointer _tmp6_ = NULL;
				_tmp3_ = tpf_persona_store__persona_stores_by_account;
				_tmp4_ = account;
				_tmp5_ = tp_proxy_get_object_path ((TpProxy*) _tmp4_);
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp5_);
				_g_object_unref0 (store);
				store = (TpfPersonaStore*) _tmp6_;
			}
			_tmp7_ = store;
			if (_tmp7_ == NULL) {
				TpAccount* _tmp8_ = NULL;
				TpfPersonaStore* _tmp9_ = NULL;
				g_debug ("tpf-persona-store.vala:1666:     Creating new PersonaStore.");
				_tmp8_ = account;
				_tmp9_ = tpf_persona_store_new (_tmp8_);
				_g_object_unref0 (store);
				store = _tmp9_;
			} else {
				TpfPersonaStore* _tmp10_ = NULL;
				TpfPersonaStore* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				_tmp10_ = store;
				_tmp11_ = store;
				_tmp12_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp11_);
				_tmp13_ = _tmp12_;
				g_debug ("tpf-persona-store.vala:1671:     Found existing PersonaStore %p ('%s')" \
".", _tmp10_, _tmp13_);
			}
		}
		__finally16:
		{
			GeeHashMap* _tmp14_ = NULL;
			_tmp14_ = tpf_persona_store__persona_stores_by_account;
			g_static_rec_mutex_unlock (&__lock_tpf_persona_store__persona_stores_by_account);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (store);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = store;
	return result;
}


static void _tpf_persona_store_populate_counters_data_free (gpointer _data) {
	TpfPersonaStorePopulateCountersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStorePopulateCountersData, _data_);
}


static void _tpf_persona_store_populate_counters (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStorePopulateCountersData* _data_;
	TpfPersonaStore* _tmp0_ = NULL;
	_data_ = g_slice_new0 (TpfPersonaStorePopulateCountersData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_populate_counters);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_populate_counters_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tpf_persona_store_populate_counters_co (_data_);
}


static void _tpf_persona_store_populate_counters_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStorePopulateCountersData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void __lambda8_ (FolksPersona* p, GDateTime* dt) {
	TpfPersona* persona = NULL;
	FolksPersona* _tmp0_ = NULL;
	TpfPersona* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	g_return_if_fail (p != NULL);
	g_return_if_fail (dt != NULL);
	_tmp0_ = p;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TPF_TYPE_PERSONA) ? ((TpfPersona*) _tmp0_) : NULL);
	persona = _tmp1_;
	_vala_assert (persona != NULL, "persona != null");
	_tmp2_ = dt;
	_tpf_persona_increase_im_interaction_counter (persona, _tmp2_);
	_g_object_unref0 (persona);
}


static void ___lambda8__folks_tp_zeitgeist_controller_increase_persona_counter (FolksPersona* p, GDateTime* converted_datetime) {
	__lambda8_ (p, converted_datetime);
}


static void __lambda9_ (FolksPersona* p, GDateTime* dt) {
	TpfPersona* persona = NULL;
	FolksPersona* _tmp0_ = NULL;
	TpfPersona* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	g_return_if_fail (p != NULL);
	g_return_if_fail (dt != NULL);
	_tmp0_ = p;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TPF_TYPE_PERSONA) ? ((TpfPersona*) _tmp0_) : NULL);
	persona = _tmp1_;
	_vala_assert (persona != NULL, "persona != null");
	_tmp2_ = dt;
	_tpf_persona_increase_last_call_interaction_counter (persona, _tmp2_);
	_g_object_unref0 (persona);
}


static void ___lambda9__folks_tp_zeitgeist_controller_increase_persona_counter (FolksPersona* p, GDateTime* converted_datetime) {
	__lambda9_ (p, converted_datetime);
}


static void _tpf_persona_store_populate_counters_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStorePopulateCountersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_populate_counters_co (_data_);
}


static gboolean _tpf_persona_store_populate_counters_co (TpfPersonaStorePopulateCountersData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = tpf_persona_store_get_account (_data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = folks_tp_zeitgeist_controller_new ((FolksPersonaStore*) _data_->self, _data_->_tmp1_, ___lambda8__folks_tp_zeitgeist_controller_increase_persona_counter, ___lambda9__folks_tp_zeitgeist_controller_increase_persona_counter);
	_g_object_unref0 (_data_->self->priv->_zg_controller);
	_data_->self->priv->_zg_controller = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->priv->_zg_controller;
	_data_->_state_ = 1;
	folks_tp_zeitgeist_controller_populate_counters (_data_->_tmp3_, _tpf_persona_store_populate_counters_ready, _data_);
	return FALSE;
	_state_1:
	folks_tp_zeitgeist_controller_populate_counters_finish (_data_->_tmp3_, _data_->_res_);
	_tpf_persona_store_notify_if_is_quiescent (_data_->self);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


TpAccount* tpf_persona_store_get_account (TpfPersonaStore* self) {
	TpAccount* result;
	TpAccount* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void tpf_persona_store_set_account (TpfPersonaStore* self, TpAccount* value) {
	TpAccount* _tmp0_ = NULL;
	TpAccount* _tmp1_ = NULL;
	TpAccount* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_account);
	self->priv->_account = _tmp1_;
	_tmp2_ = self->priv->_account;
	g_signal_connect_object ((TpProxy*) _tmp2_, "invalidated", (GCallback) __tpf_persona_store_account_invalidated_cb_tp_proxy_invalidated, self, 0);
	g_object_notify ((GObject *) self, "account");
}


static const gchar* tpf_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	TpfPersonaStore* self;
	self = (TpfPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_ = 0;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_add_personas;
	result = _tmp0_;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_ = 0;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_alias_personas;
	result = _tmp0_;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_ = 0;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_group_personas;
	result = _tmp0_;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_ = 0;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_remove_personas;
	result = _tmp0_;
	return result;
}


static gboolean tpf_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	TpfPersonaStore* self;
	gboolean _tmp0_ = FALSE;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gchar** tpf_persona_store_real_get_always_writeable_properties (FolksPersonaStore* base, int* result_length1) {
	gchar** result;
	TpfPersonaStore* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_always_writeable_properties;
	_tmp0__length1 = self->priv->_always_writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gboolean tpf_persona_store_real_get_is_quiescent (FolksPersonaStore* base) {
	gboolean result;
	TpfPersonaStore* self;
	gboolean _tmp0_ = FALSE;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static GeeMap* tpf_persona_store_real_get_personas (FolksPersonaStore* base) {
	GeeMap* result;
	TpfPersonaStore* self;
	GeeMap* _tmp0_ = NULL;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_personas_ro;
	result = _tmp0_;
	return result;
}


GeeSet* tpf_persona_store_get_supported_fields (TpfPersonaStore* self) {
	GeeSet* result;
	GeeSet* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_supported_fields_ro;
	result = _tmp0_;
	return result;
}


static GObject * tpf_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TpfPersonaStore * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	TpAccount* _tmp2_ = NULL;
	TpAccount* _tmp3_ = NULL;
	FolksDebug* _tmp4_ = NULL;
	FolksDebug* _tmp5_ = NULL;
	TpfPersonaStoreCache* _tmp6_ = NULL;
	parent_class = G_OBJECT_CLASS (tpf_persona_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TPF_TYPE_PERSONA_STORE, TpfPersonaStore);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = tpf_persona_store_get_account (self);
	_tmp3_ = _tmp2_;
	g_debug ("tpf-persona-store.vala:257: Creating new Tpf.PersonaStore %p ('%s') fo" \
"r TpAccount %p.", self, _tmp1_, _tmp3_);
	_tmp4_ = folks_debug_dup ();
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = _tmp4_;
	_tmp5_ = self->priv->_debug;
	g_signal_connect_object (_tmp5_, "print-status", (GCallback) __tpf_persona_store_debug_print_status_folks_debug_print_status, self, 0);
	_tpf_persona_store_add_store_to_map (self);
	_tmp6_ = tpf_persona_store_cache_new (self);
	_g_object_unref0 (self->priv->_cache);
	self->priv->_cache = _tmp6_;
	_tpf_persona_store_reset (self);
	return obj;
}


static void tpf_persona_store_class_init (TpfPersonaStoreClass * klass) {
	tpf_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TpfPersonaStorePrivate));
	((FolksPersonaStoreClass *) klass)->prepare = tpf_persona_store_real_prepare;
	((FolksPersonaStoreClass *) klass)->prepare_finish = tpf_persona_store_real_prepare_finish;
	((FolksPersonaStoreClass *) klass)->flush = tpf_persona_store_real_flush;
	((FolksPersonaStoreClass *) klass)->flush_finish = tpf_persona_store_real_flush_finish;
	((FolksPersonaStoreClass *) klass)->remove_persona = tpf_persona_store_real_remove_persona;
	((FolksPersonaStoreClass *) klass)->remove_persona_finish = tpf_persona_store_real_remove_persona_finish;
	((FolksPersonaStoreClass *) klass)->add_persona_from_details = tpf_persona_store_real_add_persona_from_details;
	((FolksPersonaStoreClass *) klass)->add_persona_from_details_finish = tpf_persona_store_real_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = tpf_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = tpf_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = tpf_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = tpf_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = tpf_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = tpf_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_always_writeable_properties = tpf_persona_store_real_get_always_writeable_properties;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_quiescent = tpf_persona_store_real_get_is_quiescent;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = tpf_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_tpf_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tpf_persona_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = tpf_persona_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = tpf_persona_store_finalize;
	/**
	   * The Telepathy account this store is based upon.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_ACCOUNT, g_param_spec_object ("account", "basis account", "Telepathy account this store is based upon", tp_account_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The type of persona store this is.
	   *
	   * See {@link Folks.PersonaStore.type_id}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_TYPE_ID, g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_ADD_PERSONAS, g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS, g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_GROUP_PERSONAS, g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS, g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES, g_param_spec_boxed ("always-writeable-properties", "always-writeable-properties", "always-writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   *
	   * See {@link Folks.PersonaStore.personas}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_PERSONAS, g_param_spec_object ("personas", "personas", "personas", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_SUPPORTED_FIELDS, g_param_spec_object ("supported-fields", "supported-fields", "supported-fields", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_static_rec_mutex_init (&__lock_tpf_persona_store__persona_stores_by_account);
}


static void tpf_persona_store_instance_init (TpfPersonaStore * self) {
	gchar** _tmp0_ = NULL;
	FolksSmallSet* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	self->priv = TPF_PERSONA_STORE_GET_PRIVATE (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->_always_writeable_properties = _tmp0_;
	self->priv->_always_writeable_properties_length1 = 0;
	self->priv->__always_writeable_properties_size_ = self->priv->_always_writeable_properties_length1;
	_tmp1_ = folks_small_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_favourite_ids = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_avatars = _tmp2_;
	self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_alias_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_group_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
	self->priv->_got_initial_members = FALSE;
	self->priv->_got_initial_self_contact = FALSE;
	self->priv->_disconnect_pending = FALSE;
	self->priv->_removal_pending = FALSE;
	self->priv->_load_cache_cancellable = NULL;
	self->priv->_cache_needs_update = FALSE;
}


static void tpf_persona_store_finalize (GObject* obj) {
	TpfPersonaStore * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	FolksDebug* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Logger* _tmp4_ = NULL;
	TpAccount* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	TpAccountManager* _tmp9_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TPF_TYPE_PERSONA_STORE, TpfPersonaStore);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona-store.vala:274: Destroying Tpf.PersonaStore %p ('%s').", self, _tmp1_);
	_tpf_persona_store_reset (self);
	_tpf_persona_store_remove_store_from_map (self);
	_tmp2_ = self->priv->_debug;
	g_signal_parse_name ("print-status", FOLKS_TYPE_DEBUG, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) __tpf_persona_store_debug_print_status_folks_debug_print_status, self);
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = NULL;
	_tmp4_ = self->priv->_logger;
	if (_tmp4_ != NULL) {
		Logger* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		_tmp5_ = self->priv->_logger;
		g_signal_parse_name ("invalidated", TYPE_LOGGER, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) __tpf_persona_store_logger_invalidated_cb_logger_invalidated, self);
	}
	_tmp7_ = self->priv->_account;
	g_signal_parse_name ("invalidated", tp_proxy_get_type (), &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((TpProxy*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) __tpf_persona_store_account_invalidated_cb_tp_proxy_invalidated, self);
	_tmp9_ = self->priv->_account_manager;
	if (_tmp9_ != NULL) {
		TpAccountManager* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		_tmp10_ = self->priv->_account_manager;
		g_signal_parse_name ("invalidated", tp_proxy_get_type (), &_tmp11_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((TpProxy*) _tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) __tpf_persona_store_account_manager_invalidated_cb_tp_proxy_invalidated, self);
		_g_object_unref0 (self->priv->_account_manager);
		self->priv->_account_manager = NULL;
	}
	_g_object_unref0 (self->priv->_zg_controller);
	self->priv->_zg_controller = NULL;
	self->priv->_always_writeable_properties = (_vala_array_free (self->priv->_always_writeable_properties, self->priv->_always_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	_g_object_unref0 (self->priv->_persona_set);
	_g_object_unref0 (self->priv->_contact_persona_map);
	_g_object_unref0 (self->priv->_favourite_ids);
	_g_object_unref0 (self->priv->_avatars);
	_g_object_unref0 (self->priv->_conn);
	_g_object_unref0 (self->priv->_account_manager);
	_g_object_unref0 (self->priv->_logger);
	_g_object_unref0 (self->priv->_self_persona);
	_g_object_unref0 (self->priv->_debug);
	_g_object_unref0 (self->priv->_cache);
	_g_object_unref0 (self->priv->_load_cache_cancellable);
	_g_object_unref0 (self->priv->_supported_fields);
	_g_object_unref0 (self->priv->_supported_fields_ro);
	_g_object_unref0 (self->priv->_account);
	_g_object_unref0 (self->priv->_zg_controller);
	G_OBJECT_CLASS (tpf_persona_store_parent_class)->finalize (obj);
}


/**
 * A persona store which is associated with a single Telepathy account. It will
 * create {@link Persona}s for each of the contacts in the account's
 * contact list.
 *
 * User must define contact features it wants on the #TpSimpleClientFactory of
 * the default #TpAccountManager returned by tp_account_manager_dup() *before*
 * preparing telepathy stores. Note that this is a behaviour change since
 * 0.7.0, folks won't force preparing any feature anymore.
 */
GType tpf_persona_store_get_type (void) {
	static volatile gsize tpf_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&tpf_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TpfPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tpf_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TpfPersonaStore), 0, (GInstanceInitFunc) tpf_persona_store_instance_init, NULL };
		GType tpf_persona_store_type_id;
		tpf_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "TpfPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&tpf_persona_store_type_id__volatile, tpf_persona_store_type_id);
	}
	return tpf_persona_store_type_id__volatile;
}


static void _vala_tpf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TpfPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TPF_TYPE_PERSONA_STORE, TpfPersonaStore);
	switch (property_id) {
		case TPF_PERSONA_STORE_ACCOUNT:
		g_value_set_object (value, tpf_persona_store_get_account (self));
		break;
		case TPF_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_ADD_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_GROUP_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) self, &length));
		}
		break;
		case TPF_PERSONA_STORE_IS_QUIESCENT:
		g_value_set_boolean (value, folks_persona_store_get_is_quiescent ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_PERSONAS:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_SUPPORTED_FIELDS:
		g_value_set_object (value, tpf_persona_store_get_supported_fields (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tpf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TpfPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TPF_TYPE_PERSONA_STORE, TpfPersonaStore);
	switch (property_id) {
		case TPF_PERSONA_STORE_ACCOUNT:
		tpf_persona_store_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



