#include <stdlib.h>
#include <check.h>
#include <string.h>
#include <glib.h>
#include <fmt-ptrn/fmt-ptrn.h>

START_TEST(test_fmt_ptrn_get_keys)
{
	GList *keys;
	GList *node;
	fmt_ptrn_t x;
	const char *pattern = "%(FOO) %(upper BAR)";

	fmt_ptrn_init(&x);
	keys = fmt_ptrn_get_keys(&x, pattern);

	node = g_list_first(keys);
	fail_unless(strcmp(node->data, "FOO") == 0,
		    "fmt_ptrn_get_keys test failed");
	keys = g_list_remove(keys, node->data);

	node = g_list_first(keys);
	fail_unless(strcmp(node->data, "BAR") == 0,
		    "fmt_ptrn_get_keys test failed");
	keys = g_list_remove(keys, node->data);

	fail_unless(g_list_length(keys) == 0,
		    "fmt_ptrn_get_keys test failed");

	fmt_ptrn_close(&x);
}
END_TEST

static Suite *fmt_ptrn_suite(void)
{
	Suite *s = suite_create("fmt_ptrn");

	TCase *tc_fmt_ptrn_get_keys = tcase_create("test_fmt_ptrn_get_keys");

	tcase_add_test(tc_fmt_ptrn_get_keys, test_fmt_ptrn_get_keys);

	suite_add_tcase(s, tc_fmt_ptrn_get_keys);

	return s;
}

int main(void)
{
	int nf;
	Suite *s = fmt_ptrn_suite();
	SRunner *sr = srunner_create(s);
	srunner_run_all(sr, CK_NORMAL);
	nf = srunner_ntests_failed(sr);
	srunner_free(sr);
	return (nf == 0) ? EXIT_SUCCESS : EXIT_FAILURE;
}
