/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SyntaxHighlightingUtils {
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^(<span class=\".*\">)*--.*(</span>)*$");
    private static final Pattern CAPITAL_WORD_PATTERN = Pattern.compile("\\b([A-Z]+)\\b");

    public static String addSyntaxHighlightingTagsToLine(String line) {
        Matcher commentMatcher = COMMENT_PATTERN.matcher(line);
        if (commentMatcher.matches()) {
            line = "<span class=\"comment\">" + line + "</span>";
        } else {
            Matcher capitalWord = CAPITAL_WORD_PATTERN.matcher(line);
            if (capitalWord.find()) {
                line = capitalWord.replaceAll("<span class=\"keyword\">$1</span>");
            }
        }
        return line;
    }
}

