/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check.utils;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.text.diff.CommandVisitor;
import org.apache.commons.text.diff.StringsComparator;
import org.flywaydb.check.utils.SyntaxHighlightingUtils;

public class DiffUtils {
    public static String generateHTML(String before, String after) {
        before = before.replace("\\r\\n", "\n").replace("\\n", "\n");
        after = after.replace("\\r\\n", "\n").replace("\\n", "\n");
        CharacterCommandVisitor characterCommandVisitor = new CharacterCommandVisitor();
        new StringsComparator(before, after).getScript().visit((CommandVisitor)characterCommandVisitor);
        return characterCommandVisitor.generateHTML();
    }

    private static class CharacterCommandVisitor
    implements CommandVisitor<Character> {
        private static final String INSERTION = "<insert>${text}</insert>";
        private static final String DELETION = "<delete>${text}</delete>";
        private String left = "";
        private String right = "";

        private CharacterCommandVisitor() {
        }

        public void visitKeepCommand(Character c) {
            this.left = this.left + c.toString();
            this.right = this.right + c.toString();
        }

        public void visitInsertCommand(Character c) {
            this.right = this.right + INSERTION.replace("${text}", c.toString());
        }

        public void visitDeleteCommand(Character c) {
            this.left = this.left + DELETION.replace("${text}", c.toString());
        }

        public String generateHTML() {
            return "<div style=\"display: flex\">\n<div style=\"width: 50%; overflow: auto;\" class=\"before\"><pre>" + this.wrapLinesInCodeTags(this.left) + "</pre></div>\n<div style=\"width: 50%; overflow: auto;\" class=\"after\"><pre>" + this.wrapLinesInCodeTags(this.right) + "</pre></div>\n</div>";
        }

        private String wrapLinesInCodeTags(String text) {
            return Arrays.stream(text.replace("<insert>\n</insert>", "\n").replace("<delete>\n</delete>", "\n").split("\n")).map(line -> "<code>" + line + "</code>").map(this::condenseTags).map(this::replaceTags).map(SyntaxHighlightingUtils::addSyntaxHighlightingTagsToLine).collect(Collectors.joining("\n"));
        }

        private String condenseTags(String text) {
            return text.replace("</insert><insert>", "").replace("</delete><delete>", "");
        }

        private String replaceTags(String text) {
            return text.replace("<insert>", "<span class=\"textInsert\">").replace("<delete>", "<span class=\"textDelete\">").replace("</insert>", "</span>").replace("</delete>", "</span>");
        }
    }
}

