/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check.reports.html;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.flywaydb.check.dryrun.DryRunResult;
import org.flywaydb.check.utils.SyntaxHighlightingUtils;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.HtmlRenderer;

public class DryRunResultHtmlRenderer
implements HtmlRenderer<DryRunResult> {
    public String render(DryRunResult result, Configuration config) {
        return "<pre>" + Arrays.stream(result.sql.split("\n")).map(SyntaxHighlightingUtils::addSyntaxHighlightingTagsToLine).collect(Collectors.joining("\n")) + "</pre>";
    }

    public String tabTitle(DryRunResult result, Configuration config) {
        return "Dry Run";
    }

    public Class<DryRunResult> getType() {
        return DryRunResult.class;
    }
}

