/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check.codeanalysis;

import java.util.Arrays;

public enum RulesEngineDialect {
    ANSI(null),
    BIGQUERY("bigquery"),
    DB2("db2"),
    MYSQL("mysql"),
    ORACLE("oracle"),
    POSTGRES("postgresql"),
    REDSHIFT("redshift"),
    SNOWFLAKE("snowflake"),
    SQLITE("sqlite"),
    TSQL("sqlserver"),
    TEXT(null);

    private final String jdbcType;

    public static RulesEngineDialect fromUrl(String url) {
        if (url == null) {
            return TEXT;
        }
        return Arrays.stream(RulesEngineDialect.values()).filter(d -> url.contains(":" + d.jdbcType + ":")).findFirst().orElse(TEXT);
    }

    private RulesEngineDialect(String jdbcType) {
        this.jdbcType = jdbcType;
    }
}

