/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check.codeanalysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.check.CheckConfigurationExtension;
import org.flywaydb.check.codeanalysis.CodeAnalysisTelemetryModel;
import org.flywaydb.check.codeanalysis.RulesEngine;
import org.flywaydb.check.codeanalysis.RulesEngineResult;
import org.flywaydb.check.utils.HtmlResultUtils;
import org.flywaydb.check.utils.RulesEngineUtils;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.exception.FlywayEngineMissingException;

public class CodeCommandExtension
implements CommandExtension {
    private static final Log LOG = LogFactory.getLog(CodeCommandExtension.class);
    public static final String COMMAND = "code";

    public boolean handlesCommand(String command) {
        return command.equals(COMMAND);
    }

    public boolean handlesParameter(String parameter) {
        return false;
    }

    public OperationResult handle(String command, Configuration config, List<String> flags, FlywayTelemetryManager flywayTelemetryManager) throws FlywayException {
        RulesEngineResult rulesEngineResult;
        CodeAnalysisTelemetryModel telemetryModel = new CodeAnalysisTelemetryModel(flywayTelemetryManager);
        try {
            ArrayList<RulesEngineResult> results = new ArrayList<RulesEngineResult>();
            CheckConfigurationExtension configurationExtension = (CheckConfigurationExtension)config.getPluginRegister().getPlugin(CheckConfigurationExtension.class);
            List rulesEngines = config.getPluginRegister().getLicensedPlugins(RulesEngine.class, config);
            rulesEngines.forEach(rulesEngine -> {
                try {
                    RulesEngineResult rulesEngineResult = rulesEngine.run(configurationExtension, config);
                    if (rulesEngineResult != null) {
                        HtmlResultUtils.logSummary(rulesEngine.getClass().getSimpleName() + " code analysis summary:", this.getSummaryText(rulesEngineResult), rulesEngineResult, config);
                        results.add(rulesEngineResult);
                    }
                }
                catch (FlywayEngineMissingException e) {
                    if (rulesEngines.size() == 1) {
                        throw e;
                    }
                    LOG.warn(e.getMessage());
                }
            });
            RulesEngineResult mergedResults = RulesEngineUtils.mergeResults(results);
            String majorException = this.throwOnViolation(mergedResults, configurationExtension.getMajorRules(), configurationExtension.getMajorTolerance(), "major", config);
            String minorException = this.throwOnViolation(mergedResults, configurationExtension.getMinorRules(), configurationExtension.getMinorTolerance(), "minor", config);
            mergedResults.setMajorViolationException(majorException);
            mergedResults.setMinorViolationException(minorException);
            telemetryModel.setFailOnMinorViolationsEnabled(configurationExtension.getMinorTolerance() > -1);
            telemetryModel.setFailOnMajorViolationsEnabled(configurationExtension.getMajorTolerance() > -1);
            rulesEngineResult = mergedResults;
        }
        catch (Throwable throwable) {
            try {
                try {
                    telemetryModel.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FlywayException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FlywayException((Throwable)e);
            }
        }
        telemetryModel.close();
        return rulesEngineResult;
    }

    private String throwOnViolation(RulesEngineResult rulesEngineResult, String[] rules, int tolerance, String label, Configuration config) {
        if (rules != null && rules.length > 0 && tolerance > -1) {
            LicenseGuard.guard((Configuration)config, Arrays.asList(Edition.PRO, Edition.ENTERPRISE, Edition.TIER3), (String)"flyway check -code (Fail on error)");
            List violations = rulesEngineResult.results.stream().flatMap(r -> r.violations.stream()).filter(v -> Arrays.stream(rules).anyMatch(rule -> rule.equals(v.code))).collect(Collectors.toList());
            if (violations.size() > tolerance) {
                String violationList = violations.stream().map(violation -> violation.code + ": " + violation.description + ". Line " + violation.line_no).collect(Collectors.joining(System.lineSeparator()));
                return "Code Analysis " + label + " exception" + System.lineSeparator() + violationList;
            }
        }
        return null;
    }

    private String getSummaryText(RulesEngineResult result) {
        int violationCount = result.results.stream().map(r -> r.violations.size()).reduce(0, Integer::sum);
        String files = ": " + result.results.size();
        String violations = ": " + violationCount;
        return "Files with violations" + files + "        Violations" + violations;
    }
}

