/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check.changes;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.check.CheckConfigurationExtension;
import org.flywaydb.check.CompareEngine;
import org.flywaydb.check.result.CompareResult;
import org.flywaydb.check.utils.CompareEngineUtils;
import org.flywaydb.check.utils.CompareResultUtils;
import org.flywaydb.check.utils.HtmlResultUtils;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.internal.license.Edition;

public class ChangesCommandExtension
implements CommandExtension {
    public static final String COMMAND = "changes";

    public boolean handlesCommand(String command) {
        return command.equals(COMMAND);
    }

    public boolean handlesParameter(String parameter) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OperationResult handle(String command, Configuration config, List<String> flags, FlywayTelemetryManager flywayTelemetryManager) throws FlywayException {
        EventTelemetryModel telemetryModel = new EventTelemetryModel("change", flywayTelemetryManager);
        try {
            try {
                LicenseGuard.guard((Configuration)config, Collections.singletonList(Edition.TIER3), (String)"flyway check -changes");
            }
            catch (Exception e) {
                telemetryModel.setException(e);
                CompareResult compareResult2 = new CompareResult();
                compareResult2.setException(e);
                compareResult2.setLicenseFailed(true);
                CompareResult compareResult3 = compareResult2;
                telemetryModel.close();
                return compareResult3;
            }
            CheckConfigurationExtension configurationExtension = (CheckConfigurationExtension)config.getPluginRegister().getPlugin(CheckConfigurationExtension.class);
            List<CompareEngine> compareEngines = config.getPluginRegister().getPlugins(CompareEngine.class).stream().sorted().collect(Collectors.toList());
            CompareEngine compareEngine = CompareEngineUtils.getCompareEngine(configurationExtension, compareEngines, COMMAND);
            CompareResult compareResult4 = compareEngine.generateChangeReport(configurationExtension, config);
            compareResult4 = CompareResultUtils.filterObject(CompareResultUtils.filterObject(compareResult4, config.getTable()), config.getTable() + "_s_idx");
            HtmlResultUtils.logSummary("Change report summary:", this.getSummaryText(compareResult4), compareResult4, config);
            CompareResult compareResult = compareResult4;
            return compareResult;
        }
        finally {
            try {
                telemetryModel.close();
            }
            catch (Throwable throwable2) {
                Throwable throwable;
                throwable.addSuppressed(throwable2);
            }
        }
    }

    private String getSummaryText(CompareResult result) {
        if (result.onlyInTarget == null || result.onlyInSource == null || result.differences == null) {
            return "";
        }
        String added = ": " + result.onlyInTarget.size();
        String deleted = ": " + result.onlyInSource.size();
        String modified = ": " + result.differences.size();
        return "Added" + added + "        Deleted" + deleted + "        Modified" + modified;
    }
}

