/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.check.CheckConfigurationExtension;
import org.flywaydb.check.changes.ChangesCommandExtension;
import org.flywaydb.check.codeanalysis.CodeCommandExtension;
import org.flywaydb.check.codeanalysis.RulesEngineResult;
import org.flywaydb.check.drift.DriftCommandExtension;
import org.flywaydb.check.drift.DriftResult;
import org.flywaydb.check.dryrun.DryRunCommandExtension;
import org.flywaydb.check.result.EmptyResult;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CompositeResult;
import org.flywaydb.core.api.output.HtmlResult;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.ConfigurationParameter;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;

public class CheckCommandExtension
implements CommandExtension {
    private static final Log LOG = LogFactory.getLog(CheckCommandExtension.class);
    public static final String CHANGES = "-changes";
    public static final String DRIFT = "-drift";
    public static final String CODE = "-code";
    public static final String DRY_RUN = "-dryrun";
    public static final List<String> PARAMETERS = Arrays.asList("-changes", "-drift", "-code", "-dryrun");
    public static final String COMMAND = "check";
    private final List<CommandExtension> parameterCommandExtensions = Arrays.asList(new ChangesCommandExtension(), new DriftCommandExtension(), new CodeCommandExtension(), new DryRunCommandExtension());

    public boolean handlesCommand(String command) {
        return command.equals(COMMAND);
    }

    public boolean handlesParameter(String parameter) {
        return PARAMETERS.contains(parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult handle(String command, Configuration config, List<String> flags, FlywayTelemetryManager flywayTelemetryManager) throws FlywayException {
        if (flags.stream().noneMatch(PARAMETERS::contains)) {
            LOG.info(this.getHelpText());
            return new EmptyResult();
        }
        CheckConfigurationExtension configurationExtension = (CheckConfigurationExtension)config.getPluginRegister().getPlugin(CheckConfigurationExtension.class);
        configurationExtension.validate(flags);
        if (!StringUtils.hasText((String)configurationExtension.getUrl())) {
            configurationExtension.setUrl(config.getUrl());
        }
        if (!StringUtils.hasText((String)configurationExtension.getUser())) {
            configurationExtension.setUser(config.getUser());
        }
        if (!StringUtils.hasText((String)configurationExtension.getPassword())) {
            configurationExtension.setPassword(config.getPassword());
        }
        if (!StringUtils.hasText((String)configurationExtension.getBuildUser())) {
            configurationExtension.setBuildUser(config.getUser());
        }
        if (!StringUtils.hasText((String)configurationExtension.getBuildPassword())) {
            configurationExtension.setBuildPassword(config.getPassword());
        }
        if (StringUtils.hasText((String)configurationExtension.getReportFilename())) {
            if (config instanceof ClassicConfiguration) {
                ClassicConfiguration classic = (ClassicConfiguration)config;
                classic.setReportFilename(configurationExtension.getReportFilename());
            }
            if (config instanceof FluentConfiguration) {
                FluentConfiguration fluent = (FluentConfiguration)config;
                fluent.reportFilename(configurationExtension.getReportFilename());
            }
        }
        CompositeResult result = new CompositeResult();
        block23: for (String parameter : PARAMETERS.stream().filter(flags::contains).collect(Collectors.toList())) {
            CommandExtension commandExtension = this.parameterCommandExtensions.stream().filter(e -> e.handlesCommand(parameter.substring(1))).findFirst().orElseThrow(() -> new FlywayException("No implementation found to handle flag " + parameter));
            switch (parameter) {
                case "-drift": {
                    DriftResult driftResult = new DriftResult();
                    try {
                        driftResult = (DriftResult)commandExtension.handle(parameter.substring(1), config, flags, flywayTelemetryManager);
                        if (!driftResult.driftDetected || !configurationExtension.isFailOnDrift()) continue block23;
                        throw new FlywayException("Drift detected");
                    }
                    catch (Exception e2) {
                        driftResult.setException(e2);
                        continue block23;
                    }
                    finally {
                        result.individualResults.add(driftResult);
                        continue block23;
                    }
                }
                case "-code": {
                    RulesEngineResult rulesEngineResult = new RulesEngineResult();
                    try {
                        rulesEngineResult = (RulesEngineResult)commandExtension.handle(parameter.substring(1), config, flags, flywayTelemetryManager);
                        FlywayException violationException = null;
                        if (rulesEngineResult.getMajorViolationException() != null) {
                            violationException = new FlywayException(rulesEngineResult.getMajorViolationException());
                        }
                        if (rulesEngineResult.getMinorViolationException() != null) {
                            if (violationException != null) {
                                violationException.addSuppressed((Throwable)new FlywayException(rulesEngineResult.getMinorViolationException()));
                            } else {
                                violationException = new FlywayException(rulesEngineResult.getMinorViolationException());
                            }
                        }
                        if (violationException == null) continue block23;
                        throw violationException;
                    }
                    catch (Exception e3) {
                        rulesEngineResult.setException(e3);
                        continue block23;
                    }
                    finally {
                        result.individualResults.add(rulesEngineResult);
                        continue block23;
                    }
                }
                default: {
                    HtmlResult htmlResult = new HtmlResult();
                    try {
                        htmlResult = (HtmlResult)commandExtension.handle(parameter.substring(1), config, flags, flywayTelemetryManager);
                        continue block23;
                    }
                    catch (Exception e4) {
                        htmlResult.setException(e4);
                        htmlResult.setOperation(parameter.substring(1));
                        continue block23;
                    }
                    finally {
                        result.individualResults.add(htmlResult);
                        continue block23;
                    }
                }
            }
        }
        return result;
    }

    public String getDescription() {
        return "Produces reports to increase confidence in your migrations";
    }

    public List<ConfigurationParameter> getConfigurationParameters() {
        ArrayList<ConfigurationParameter> configurationParameters = new ArrayList<ConfigurationParameter>();
        configurationParameters.add(new ConfigurationParameter(CheckConfigurationExtension.COMPARE_BUILD_URL, "[DEPRECATED] URL for the build database. Note: This database will be cleaned! Will be replaced by check.buildEnvironment in Flyway 10.0", false));
        configurationParameters.add(new ConfigurationParameter(CheckConfigurationExtension.COMPARE_BUILD_USER, "[DEPRECATED] Username for the build database. Defaults to 'flyway.user'. Will be replaced by check.buildEnvironment in Flyway 10.0", false));
        configurationParameters.add(new ConfigurationParameter(CheckConfigurationExtension.COMPARE_BUILD_PASSWORD, "[DEPRECATED] Password for the build database. Defaults to 'flyway.password'. Will be replaced by check.buildEnvironment in Flyway 10.0", false));
        configurationParameters.add(new ConfigurationParameter(CheckConfigurationExtension.COMPARE_REPORT_FILENAME, "[DEPRECATED] Destination filename for reports. Please use flyway.reportFilename", false));
        configurationParameters.add(new ConfigurationParameter(CheckConfigurationExtension.COMPARE_NEXT_SNAPSHOT, "A snapshot containing all migrations including those that are pending", false));
        configurationParameters.add(new ConfigurationParameter(CheckConfigurationExtension.COMPARE_DEPLOYED_SNAPSHOT, "A snapshot containing all applied migrations and thus matching what should be in the target", false));
        configurationParameters.add(new ConfigurationParameter(CheckConfigurationExtension.COMPARE_APPLIED_MIGRATIONS, "A comma-separated list of migration ids (migration versions or repeatable descriptions) to apply to create snapshots", false));
        configurationParameters.add(new ConfigurationParameter(CheckConfigurationExtension.COMPARE_MAJOR_RULES, "A comma-separated list of rule codes that are considered to be 'major' issues", false));
        configurationParameters.add(new ConfigurationParameter(CheckConfigurationExtension.COMPARE_MINOR_RULES, "A comma-separated list of rule codes that are considered to be 'minor' issues", false));
        configurationParameters.add(new ConfigurationParameter(CheckConfigurationExtension.COMPARE_MAJOR_TOLERANCE, "The number of 'major' issues to be tolerated before throwing an error", false));
        configurationParameters.add(new ConfigurationParameter(CheckConfigurationExtension.COMPARE_MINOR_TOLERANCE, "The number of 'minor' issues to be tolerated before throwing an error", false));
        configurationParameters.add(new ConfigurationParameter(CheckConfigurationExtension.COMPARE_RULES_LOCATION, "File location to scan for Regex Rule files. Defaults to `rules/` in installation directory", false));
        configurationParameters.add(new ConfigurationParameter(CheckConfigurationExtension.COMPARE_RULES_DIALECT, "The dialect of SQL to be validated by `-code`. Default is determined by database or TEXT", false));
        return configurationParameters;
    }

    public List<ConfigurationParameter> getFlags() {
        ArrayList<ConfigurationParameter> flags = new ArrayList<ConfigurationParameter>();
        flags.add(new ConfigurationParameter(CHANGES, "[enterprise] Compares current database with all migrations", false));
        flags.add(new ConfigurationParameter(DRIFT, "[enterprise] Compares current database with applied migrations", false));
        flags.add(new ConfigurationParameter(CODE, "Performs code analysis on your migrations", false));
        flags.add(new ConfigurationParameter(DRY_RUN, "[teams] Performs a 'dry run', showing what changes would be applied in a real deployment", false));
        return flags;
    }

    public String getExample() {
        return "flyway check -changes -" + CheckConfigurationExtension.COMPARE_BUILD_URL.substring("flyway.".length()) + "=jdbc:example:jdbcurl -" + CheckConfigurationExtension.COMPARE_BUILD_USER.substring("flyway.".length()) + "=username -" + CheckConfigurationExtension.COMPARE_BUILD_PASSWORD.substring("flyway.".length()) + "=password -" + CheckConfigurationExtension.COMPARE_REPORT_FILENAME.substring("flyway.".length()) + "=changeReport.html";
    }

    public List<Pair<String, String>> getUsage() {
        return Collections.singletonList(Pair.of((Object)COMMAND, (Object)this.getDescription()));
    }
}

