/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.rulesengine.sqlfluff.utils;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.rulesengine.sqlfluff.exception.FlywaySqlFluffDialectMissingException;
import org.flywaydb.rulesengine.sqlfluff.exception.FlywaySqlFluffMissingException;

public class SqlFluffUtils {
    private static final Log LOG = LogFactory.getLog(SqlFluffUtils.class);
    private static final String REQUIRED_VERSION = "1.2.1";

    public static void validateInstallation() {
        String installedVersion;
        try {
            installedVersion = SqlFluffUtils.runSqlFluff("version", new String[0]);
        }
        catch (Exception e) {
            throw new FlywaySqlFluffMissingException(REQUIRED_VERSION, e);
        }
        installedVersion = installedVersion.trim();
        if (!REQUIRED_VERSION.equals(installedVersion)) {
            throw new FlywaySqlFluffMissingException(REQUIRED_VERSION, installedVersion);
        }
    }

    public static String runSqlFluff(String operation, String ... args) {
        try {
            if (VersionPrinter.EDITION == Edition.TIER3) {
                SqlFluffUtils.installSqlFluffPlugin();
            }
            ArrayList<String> command = new ArrayList<String>(Arrays.asList("sqlfluff", operation));
            command.addAll(Arrays.asList(args));
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            String fullCommand = String.join((CharSequence)" ", command);
            LOG.debug("Executing " + fullCommand);
            Process process = builder.start();
            String stdOut = FileUtils.copyToString((Reader)new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            int returnCode = process.waitFor();
            if (returnCode == 1) {
                throw new FlywayException(fullCommand + " failed with return code " + returnCode + ". Output: " + stdOut);
            }
            return stdOut;
        }
        catch (FlywayException e) {
            if (e.getMessage().contains("No dialect was specified")) {
                throw new FlywaySqlFluffDialectMissingException((Exception)((Object)e));
            }
            throw e;
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
    }

    public static String processSqlFluffResult(String stdOut) {
        Pair<String, String> parsedOutput = SqlFluffUtils.parseSqlFluffOutput(stdOut);
        String message = (String)parsedOutput.getLeft();
        if (StringUtils.hasText((String)message)) {
            LOG.info(message);
        }
        return (String)parsedOutput.getRight();
    }

    private static void installSqlFluffPlugin() throws Exception {
        ProcessBuilder builder = new ProcessBuilder(Arrays.asList("pip", "install", "-e", "."));
        builder.directory(Paths.get(ClassUtils.getLibDir(SqlFluffUtils.class), "sqlfluff-plugin-flyway").toFile());
        builder.redirectErrorStream(true);
        Process process = builder.start();
        String stdOut = FileUtils.copyToString((Reader)new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        int returnCode = process.waitFor();
        if (returnCode > 0) {
            LOG.warn("Failed to install SQLFluff Flyway Plugin. Output: " + stdOut);
            LOG.warn("Flyway's additional SQL Fluff rules will not be available.");
        }
    }

    private static Pair<String, String> parseSqlFluffOutput(String text) {
        StringBuilder json = new StringBuilder();
        StringBuilder message = new StringBuilder();
        String[] lines = text.replace("\r\n", "\n").split("\n");
        boolean isJson = false;
        for (String line : lines) {
            if (line.startsWith("[")) {
                isJson = true;
            }
            if (isJson) {
                json.append(line).append("\n");
                continue;
            }
            message.append(line).append("\n");
        }
        return Pair.of((Object)message.toString().trim(), (Object)json.toString().trim());
    }

    private SqlFluffUtils() {
    }
}

