/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.schemahistory;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.callback.NoopCallbackExecutor;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.schemahistory.JdbcTableSchemaHistory;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.schemahistory.teams.InMemorySchemaHistory;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;

public class SchemaHistoryFactory {
    private static final Log LOG = LogFactory.getLog(SchemaHistoryFactory.class);

    public static SchemaHistory getSchemaHistory(Configuration configuration, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, Database database, Schema schema, StatementInterceptor statementInterceptor) {
        Table table = schema.getTable(configuration.getTable());
        JdbcTableSchemaHistory jdbcTableSchemaHistory = new JdbcTableSchemaHistory(sqlScriptExecutorFactory, sqlScriptFactory, database, table);
        if (configuration.getDryRunOutput() != null) {
            return new InMemorySchemaHistory(jdbcTableSchemaHistory.exists(), jdbcTableSchemaHistory.allAppliedMigrations(), table, database.getInstalledBy(), statementInterceptor, configuration);
        }
        return jdbcTableSchemaHistory;
    }

    public static SchemaHistory getSchemaHistory(Configuration configuration) {
        JdbcConnectionFactory jdbcConnectionFactory = new JdbcConnectionFactory(configuration.getDataSource(), configuration, null);
        DatabaseType databaseType = jdbcConnectionFactory.getDatabaseType();
        ParsingContext parsingContext = new ParsingContext();
        SqlScriptFactory sqlScriptFactory = databaseType.createSqlScriptFactory(configuration, parsingContext);
        SqlScriptExecutorFactory noCallbackSqlScriptExecutorFactory = databaseType.createSqlScriptExecutorFactory(jdbcConnectionFactory, NoopCallbackExecutor.INSTANCE, null);
        Database database = databaseType.createDatabase(configuration, true, jdbcConnectionFactory, null);
        Pair<Schema, List<Schema>> schemas = SchemaHistoryFactory.prepareSchemas(configuration, database);
        Schema defaultSchema = schemas.getLeft();
        SchemaHistory schemaHistory = SchemaHistoryFactory.getSchemaHistory(configuration, noCallbackSqlScriptExecutorFactory, sqlScriptFactory, database, defaultSchema, null);
        return schemaHistory;
    }

    public static Pair<Schema, List<Schema>> prepareSchemas(Configuration configuration, Database database) {
        Object[] schemaNames;
        Object defaultSchemaName = configuration.getDefaultSchema();
        if (!SchemaHistoryFactory.isDefaultSchemaValid((String)defaultSchemaName, (String[])(schemaNames = configuration.getSchemas()))) {
            throw new FlywayException("The defaultSchema property is specified but is not a member of the schemas property");
        }
        LOG.debug("Schemas: " + StringUtils.arrayToCommaDelimitedString(schemaNames));
        LOG.debug("Default schema: " + (String)defaultSchemaName);
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        if (schemaNames.length == 0) {
            Schema schema = ((Connection)database.getMainConnection()).getCurrentSchema();
            if (schema == null) {
                throw new FlywayException("Unable to determine schema for the schema history table. Set a default schema for the connection or specify one using the defaultSchema property!");
            }
            schemas.add(schema);
        } else {
            for (Object schemaName : schemaNames) {
                schemas.add(((Connection)database.getMainConnection()).getSchema((String)schemaName));
            }
            if (defaultSchemaName == null) {
                defaultSchemaName = schemaNames[0];
            }
        }
        Schema schema = defaultSchemaName != null ? ((Connection)database.getMainConnection()).getSchema((String)defaultSchemaName) : ((Connection)database.getMainConnection()).getCurrentSchema();
        return Pair.of(schema, schemas);
    }

    private static boolean isDefaultSchemaValid(String defaultSchema, String[] schemas) {
        if (defaultSchema == null) {
            return true;
        }
        for (String schema : schemas) {
            if (!defaultSchema.equals(schema)) continue;
            return true;
        }
        return false;
    }

    private SchemaHistoryFactory() {
    }
}

