/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.teams;

import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.oracle.OracleResults;
import org.flywaydb.core.internal.database.oracle.teams.AbstractSQLPlusParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusPlaceholderProvider;
import org.flywaydb.core.internal.database.oracle.teams.ServerOutputFormat;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;

public class SQLPlusSetParsedSqlStatement
extends AbstractSQLPlusParsedSqlStatement {
    private static final Log LOG = LogFactory.getLog(SQLPlusSetParsedSqlStatement.class);
    private Boolean echo;
    private Boolean heading;
    private Boolean termOut;
    private Boolean time;
    private Boolean timing;
    private Boolean serverOutput;
    String serverOutputSize;
    private ServerOutputFormat serverOutputFormat;
    private String flagger;
    Integer feedback;
    private Integer lineSize;
    String nullText;
    private String unknown;

    public SQLPlusSetParsedSqlStatement(int pos, int line, int col, String sql, List<Token> tokens, SQLPlusPlaceholderProvider sqlPlusPlaceholderProvider) {
        super(pos, line, col, sql);
        tokens = this.filterTokens(tokens);
        if (tokens.size() == 1) {
            throw new FlywayException("SP2-0545: SET command requires an argument.");
        }
        for (int current = 1; current < tokens.size(); ++current) {
            if (this.tokenMatches(tokens, current, "SERVEROUT(PUT)?")) {
                this.serverOutput = this.tokenEquals(tokens, ++current, "ON");
                if (this.serverOutput.booleanValue()) {
                    if (!this.tokenEquals(tokens, ++current, "SIZE")) continue;
                    this.serverOutputSize = this.getToken(tokens, ++current);
                    if (!this.tokenMatches(tokens, current + 1, "FOR(MAT)?") || !this.tokenMatches(tokens, current + 2, "(WRA(PPED)?)|(WOR(D_WRAPPED)?)|(TRUN(CATED)?)")) continue;
                    ++current;
                    this.serverOutputFormat = ServerOutputFormat.fromText(this.getToken(tokens, ++current));
                    continue;
                }
                this.serverOutputSize = "UNLIMITED";
                this.serverOutputFormat = ServerOutputFormat.WORD_WRAPPED;
                continue;
            }
            if (this.tokenEquals(tokens, current, "NULL")) {
                this.nullText = this.getToken(tokens, ++current);
                continue;
            }
            if (this.tokenMatches(tokens, current, "DEF(INE)?")) {
                if (this.tokenEquals(tokens, ++current, "ON")) {
                    sqlPlusPlaceholderProvider.setDefineOn(true);
                    sqlPlusPlaceholderProvider.setDefineChar('&');
                    continue;
                }
                if (this.tokenEquals(tokens, current, "OFF")) {
                    sqlPlusPlaceholderProvider.setDefineOn(false);
                    continue;
                }
                if (this.tokenMatches(tokens, current, "[^A-Z0-9 ]")) {
                    sqlPlusPlaceholderProvider.setDefineOn(true);
                    sqlPlusPlaceholderProvider.setDefineChar(this.getToken(tokens, current).charAt(0));
                    continue;
                }
                throw new FlywayException("Missing argument for SET DEFINE");
            }
            if (this.tokenMatches(tokens, current, "ESC(APE)?")) {
                if (this.tokenEquals(tokens, ++current, "ON")) {
                    sqlPlusPlaceholderProvider.setEscapeOn(true);
                    continue;
                }
                if (this.tokenEquals(tokens, current, "OFF")) {
                    sqlPlusPlaceholderProvider.setEscapeOn(false);
                    continue;
                }
                if (this.tokenMatches(tokens, current, "[^A-Z0-9 ]")) {
                    sqlPlusPlaceholderProvider.setEscapeChar(this.getToken(tokens, current).charAt(0));
                    continue;
                }
                throw new FlywayException("Missing argument for SET ESCAPE");
            }
            if (this.tokenMatches(tokens, current, "FEED(BACK)?")) {
                if (this.tokenEquals(tokens, ++current, "ON")) {
                    this.feedback = 1;
                    continue;
                }
                if (this.tokenEquals(tokens, current, "OFF")) {
                    this.feedback = 0;
                    continue;
                }
                if (this.tokenMatches(tokens, current, "[0-9]{1,5}")) {
                    this.feedback = Integer.parseInt(this.getToken(tokens, current));
                    continue;
                }
                String feedbackValue = this.getToken(tokens, current);
                if ("ONLY".equals(feedbackValue)) {
                    LOG.warn("Feedback option ONLY is not supported by Flyway. Defaulting to 6");
                    this.feedback = 6;
                    continue;
                }
                throw new FlywayException("SP2-0267: feedback option " + feedbackValue + " out of range (0 through 50000)");
            }
            if (this.tokenEquals(tokens, current, "FLAGGER")) {
                if (this.tokenMatches(tokens, ++current, "OFF|ENTRY|INTERMED(IATE)?|FULL")) {
                    this.flagger = this.getToken(tokens, current);
                    continue;
                }
                throw new FlywayException("Missing argument for SET FLAGGER");
            }
            if (this.tokenEquals(tokens, current, "SCAN")) {
                if (this.tokenEquals(tokens, ++current, "ON")) {
                    sqlPlusPlaceholderProvider.setDefineOn(true);
                    continue;
                }
                if (this.tokenEquals(tokens, current, "OFF")) {
                    sqlPlusPlaceholderProvider.setDefineOn(false);
                    continue;
                }
                throw new FlywayException("SP2-0265: scan must be set ON or OFF");
            }
            if (this.tokenEquals(tokens, current, "ECHO")) {
                if (this.tokenEquals(tokens, ++current, "ON")) {
                    this.echo = true;
                    continue;
                }
                if (this.tokenEquals(tokens, current, "OFF")) {
                    this.echo = false;
                    continue;
                }
                throw new FlywayException("SP2-0265: echo must be set ON or OFF");
            }
            if (this.tokenMatches(tokens, current, "HEA(DING)?")) {
                if (this.tokenEquals(tokens, ++current, "ON")) {
                    this.heading = true;
                    continue;
                }
                if (this.tokenEquals(tokens, current, "OFF")) {
                    this.heading = false;
                    continue;
                }
                throw new FlywayException("SP2-0265: heading must be set ON or OFF");
            }
            if (this.tokenMatches(tokens, current, "TERM(OUT)?")) {
                if (this.tokenEquals(tokens, ++current, "ON")) {
                    this.termOut = true;
                    continue;
                }
                if (this.tokenEquals(tokens, current, "OFF")) {
                    this.termOut = false;
                    continue;
                }
                throw new FlywayException("SP2-0265: termout must be set ON or OFF");
            }
            if (this.tokenMatches(tokens, current, "SUF(FIX)?")) {
                sqlPlusPlaceholderProvider.setSuffix(this.getToken(tokens, ++current));
                continue;
            }
            if (this.tokenMatches(tokens, current, "LIN(ESIZE)?")) {
                if (this.tokenMatches(tokens, ++current, "[0-9]{1,5}")) {
                    this.lineSize = Integer.parseInt(this.getToken(tokens, current));
                    sqlPlusPlaceholderProvider.setLineSize(this.lineSize);
                    continue;
                }
                throw new FlywayException("SP2-0268: linesize option not a valid number");
            }
            if (this.tokenMatches(tokens, current, "TI(ME)?")) {
                if (this.tokenEquals(tokens, ++current, "ON")) {
                    this.time = true;
                    continue;
                }
                if (this.tokenEquals(tokens, current, "OFF")) {
                    this.time = false;
                    continue;
                }
                throw new FlywayException("SP2-0265: time must be set ON or OFF");
            }
            if (this.tokenMatches(tokens, current, "TIMI(NG)?")) {
                if (this.tokenEquals(tokens, ++current, "ON")) {
                    this.timing = true;
                    continue;
                }
                if (this.tokenEquals(tokens, current, "OFF")) {
                    this.timing = false;
                    continue;
                }
                throw new FlywayException("SP2-0265: timing must be set ON or OFF");
            }
            if (this.tokenMatches(tokens, current, "VER(IFY)?")) {
                if (this.tokenEquals(tokens, ++current, "ON")) {
                    sqlPlusPlaceholderProvider.setVerifyOn(true);
                    continue;
                }
                if (this.tokenEquals(tokens, current, "OFF")) {
                    sqlPlusPlaceholderProvider.setVerifyOn(false);
                    continue;
                }
                throw new FlywayException("SP2-0265: verify must be set ON or OFF");
            }
            this.unknown = this.getToken(tokens, current);
        }
    }

    private String getToken(List<Token> tokens, int pos) {
        if (pos >= tokens.size()) {
            return null;
        }
        return tokens.get(pos).getRawText();
    }

    private boolean tokenMatches(List<Token> tokens, int pos, String regex) {
        if (pos >= tokens.size()) {
            return false;
        }
        Token token = tokens.get(pos);
        String text = token.getText();
        if (text == null) {
            if (TokenType.STRING.equals((Object)token.getType())) {
                return false;
            }
            throw new FlywayException("Flyway parser bug: token text is null (" + (Object)((Object)token.getType()) + " -> " + token.getLine() + ":" + token.getCol() + ")");
        }
        return text.matches(regex);
    }

    private boolean tokenEquals(List<Token> tokens, int pos, String str) {
        if (pos >= tokens.size()) {
            return false;
        }
        return str.equals(tokens.get(pos).getText());
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        if (Boolean.TRUE.equals(this.serverOutput)) {
            OracleResults oracleResults = new OracleResults(jdbcTemplate.executeStatement("BEGIN\nDBMS_OUTPUT.ENABLE(" + (this.serverOutputSize != null && this.serverOutputSize.matches("[0-9]{4,7}") ? this.serverOutputSize : "buffer_size => NULL") + ");\nEND;"));
            oracleResults.setServerOutput(true);
            if (this.serverOutputSize != null) {
                oracleResults.setServerOutputSize(this.serverOutputSize);
            }
            if (this.serverOutputFormat != null) {
                oracleResults.setServerOutputFormat(this.serverOutputFormat);
            }
            return oracleResults;
        }
        if (Boolean.FALSE.equals(this.serverOutput)) {
            OracleResults oracleResults = new OracleResults(jdbcTemplate.executeStatement("BEGIN\nDBMS_OUTPUT.DISABLE;\nEND;"));
            oracleResults.setServerOutput(false);
            return oracleResults;
        }
        if (this.nullText != null) {
            OracleResults oracleResults = new OracleResults();
            oracleResults.setNullText(this.nullText);
            return oracleResults;
        }
        if (this.echo != null) {
            OracleResults oracleResults = new OracleResults();
            oracleResults.setEcho(this.echo);
            return oracleResults;
        }
        if (this.flagger != null) {
            return jdbcTemplate.executeStatement("ALTER SESSION SET FLAGGER=" + this.flagger);
        }
        if (this.heading != null) {
            OracleResults oracleResults = new OracleResults();
            oracleResults.setHeading(this.heading);
            return oracleResults;
        }
        if (this.termOut != null) {
            OracleResults oracleResults = new OracleResults();
            oracleResults.setTermOut(this.termOut);
            return oracleResults;
        }
        if (this.time != null) {
            OracleResults oracleResults = new OracleResults();
            oracleResults.setTime(this.time);
            return oracleResults;
        }
        if (this.timing != null) {
            OracleResults oracleResults = new OracleResults();
            oracleResults.setTiming(this.timing);
            return oracleResults;
        }
        if (this.lineSize != null) {
            if (this.lineSize < 1 || this.lineSize > Short.MAX_VALUE) {
                throw new FlywayException("SP2-0267: linesize option " + this.lineSize + " out of range (1 through 32767)");
            }
            OracleResults oracleResults = new OracleResults();
            oracleResults.setLineSize(this.lineSize);
            return oracleResults;
        }
        if (this.feedback != null) {
            if (this.feedback < 0 || this.feedback > 50000) {
                throw new FlywayException("SP2-0267: feedback option " + this.feedback + " out of range (0 through 50000)");
            }
            OracleResults oracleResults = new OracleResults();
            oracleResults.setFeedback(this.feedback);
            return oracleResults;
        }
        if (this.unknown != null) {
            LOG.warn("SP2-0158: unknown SET option \"" + this.unknown + "\"");
        }
        return new OracleResults();
    }
}

