/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.secretsmanagement;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.extensibility.ConfigurationProvider;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeRequiredException;
import org.flywaydb.core.internal.license.VersionPrinter;

public class DaprConfigurationProvider
implements ConfigurationProvider {
    public static final String DAPR_URL = "flyway.dapr.url";
    public static final String DAPR_SECRETS = "flyway.dapr.secrets";

    public boolean isConfigured(Map<String, String> configuration) {
        boolean isConfigured;
        boolean bl = isConfigured = configuration.containsKey(DAPR_URL) && configuration.containsKey(DAPR_SECRETS);
        if (isConfigured && VersionPrinter.EDITION != Edition.ENTERPRISE) {
            throw new FlywayTeamsUpgradeRequiredException("Dapr");
        }
        return isConfigured;
    }

    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        switch (environmentVariable) {
            case "FLYWAY_DAPR_URL": {
                return DAPR_URL;
            }
            case "FLYWAY_DAPR_SECRETS": {
                return DAPR_SECRETS;
            }
        }
        return null;
    }

    public Map<String, String> getConfiguration(Map<String, String> currentConfiguration) throws Exception {
        if (VersionPrinter.EDITION != Edition.ENTERPRISE) {
            throw new FlywayTeamsUpgradeRequiredException("Dapr");
        }
        String daprUrl = currentConfiguration.remove(DAPR_URL);
        String[] daprSecrets = currentConfiguration.remove(DAPR_SECRETS).split(",");
        return ConfigUtils.loadConfigurationFromString((String)DaprConfigurationProvider.getConfiguration(daprUrl, daprSecrets));
    }

    public static String getConfiguration(String url, String ... secrets) throws Exception {
        String urlWithoutSlash = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        StringBuilder daprConf = new StringBuilder();
        for (String secret : secrets) {
            if (!secret.contains("/")) {
                daprConf.append(DaprConfigurationProvider.readSecret(urlWithoutSlash, secret)).append("\n");
                continue;
            }
            daprConf.append(DaprConfigurationProvider.readSecretWithPath(urlWithoutSlash, secret)).append("\n");
        }
        return daprConf.toString();
    }

    private static String readSecretWithPath(String url, String secret) throws Exception {
        if (!secret.startsWith("/")) {
            secret = "/" + secret;
        }
        String path = secret.substring(0, secret.lastIndexOf("/"));
        String secretName = secret.substring(secret.lastIndexOf("/") + 1);
        return DaprConfigurationProvider.readSecret(url + path, secretName);
    }

    private static String readSecret(String url, String secret) throws Exception {
        url = url + "/" + secret;
        URLConnection conn = new URL(url).openConnection();
        return DaprConfigurationProvider.readSecret(conn, secret);
    }

    private static String readSecret(URLConnection conn, String secret) throws Exception {
        JsonObject secretResponse = (JsonObject)new Gson().fromJson(DaprConfigurationProvider.getSecretFromDapr(conn), JsonObject.class);
        JsonObject secretObj = secretResponse.getAsJsonObject();
        if (!secretObj.has(secret)) {
            throw new FlywayException("'" + secret + "' is not a valid Dapr secret");
        }
        return secretObj.get(secret).getAsString();
    }

    private static String getSecretFromDapr(URLConnection conn) throws Exception {
        StringBuilder rawSecret = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            while ((line = br.readLine()) != null) {
                rawSecret.append(line);
            }
        }
        catch (FileNotFoundException e) {
            throw new FlywayException("Dapr secret location '" + conn.getURL() + "' could not be found. Ensure the path to your secret is correct.");
        }
        return rawSecret.toString();
    }
}

