/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AadInstanceDiscoveryResponse;
import com.microsoft.aad.msal4j.Authority;
import com.microsoft.aad.msal4j.AuthorityType;
import com.microsoft.aad.msal4j.CurrentRequest;
import com.microsoft.aad.msal4j.HttpHelper;
import com.microsoft.aad.msal4j.HttpMethod;
import com.microsoft.aad.msal4j.HttpRequest;
import com.microsoft.aad.msal4j.IHttpResponse;
import com.microsoft.aad.msal4j.InstanceDiscoveryMetadataEntry;
import com.microsoft.aad.msal4j.JsonHelper;
import com.microsoft.aad.msal4j.MsalClientException;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.MsalServiceException;
import com.microsoft.aad.msal4j.MsalServiceExceptionFactory;
import com.microsoft.aad.msal4j.RegionTelemetry;
import com.microsoft.aad.msal4j.ServiceBundle;
import com.microsoft.aad.msal4j.StringHelper;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AadInstanceDiscoveryProvider {
    private static final String DEFAULT_TRUSTED_HOST = "login.microsoftonline.com";
    private static final String AUTHORIZE_ENDPOINT_TEMPLATE = "https://{host}/{tenant}/oauth2/v2.0/authorize";
    private static final String INSTANCE_DISCOVERY_ENDPOINT_TEMPLATE = "https://{host}/common/discovery/instance";
    private static final String INSTANCE_DISCOVERY_ENDPOINT_TEMPLATE_WITH_REGION = "https://{region}.{host}/common/discovery/instance";
    private static final String INSTANCE_DISCOVERY_REQUEST_PARAMETERS_TEMPLATE = "?api-version=1.1&authorization_endpoint={authorizeEndpoint}";
    private static final String REGION_NAME = "REGION_NAME";
    private static final String DEFAULT_API_VERSION = "2020-06-01";
    private static final String IMDS_ENDPOINT = "https://169.254.169.254/metadata/instance/compute/location?2020-06-01&format=text";
    static final TreeSet<String> TRUSTED_HOSTS_SET = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private static final Logger log = LoggerFactory.getLogger(HttpHelper.class);
    static ConcurrentHashMap<String, InstanceDiscoveryMetadataEntry> cache = new ConcurrentHashMap();

    AadInstanceDiscoveryProvider() {
    }

    static InstanceDiscoveryMetadataEntry getMetadataEntry(URL authorityUrl, boolean validateAuthority, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        InstanceDiscoveryMetadataEntry result = cache.get(authorityUrl.getAuthority());
        if (result == null) {
            AadInstanceDiscoveryProvider.doInstanceDiscoveryAndCache(authorityUrl, validateAuthority, msalRequest, serviceBundle);
        }
        return cache.get(authorityUrl.getAuthority());
    }

    static Set<String> getAliases(String host) {
        if (cache.containsKey(host)) {
            return cache.get(host).aliases();
        }
        return Collections.singleton(host);
    }

    static AadInstanceDiscoveryResponse parseInstanceDiscoveryMetadata(String instanceDiscoveryJson) {
        AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse;
        try {
            aadInstanceDiscoveryResponse = JsonHelper.convertJsonToObject(instanceDiscoveryJson, AadInstanceDiscoveryResponse.class);
        }
        catch (Exception ex) {
            throw new MsalClientException("Error parsing instance discovery response. Data must be in valid JSON format. For more information, see https://aka.ms/msal4j-instance-discovery", "invalid_instance_discovery_metadata");
        }
        return aadInstanceDiscoveryResponse;
    }

    static void cacheInstanceDiscoveryMetadata(String host, AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse) {
        if (aadInstanceDiscoveryResponse != null && aadInstanceDiscoveryResponse.metadata() != null) {
            for (InstanceDiscoveryMetadataEntry entry : aadInstanceDiscoveryResponse.metadata()) {
                for (String alias : entry.aliases()) {
                    cache.put(alias, entry);
                }
            }
        }
        cache.putIfAbsent(host, InstanceDiscoveryMetadataEntry.builder().preferredCache(host).preferredNetwork(host).aliases(Collections.singleton(host)).build());
    }

    private static String getAuthorizeEndpoint(String host, String tenant) {
        return AUTHORIZE_ENDPOINT_TEMPLATE.replace("{host}", host).replace("{tenant}", tenant);
    }

    private static String getInstanceDiscoveryEndpoint(String host) {
        String discoveryHost = TRUSTED_HOSTS_SET.contains(host) ? host : DEFAULT_TRUSTED_HOST;
        return INSTANCE_DISCOVERY_ENDPOINT_TEMPLATE.replace("{host}", discoveryHost);
    }

    private static String getInstanceDiscoveryEndpointWithRegion(String host, String region) {
        String discoveryHost = TRUSTED_HOSTS_SET.contains(host) ? host : DEFAULT_TRUSTED_HOST;
        return INSTANCE_DISCOVERY_ENDPOINT_TEMPLATE_WITH_REGION.replace("{region}", region).replace("{host}", discoveryHost);
    }

    private static AadInstanceDiscoveryResponse sendInstanceDiscoveryRequest(URL authorityUrl, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        String instanceDiscoveryRequestUrl;
        IHttpResponse httpResponse = null;
        String providedRegion = msalRequest.application().azureRegion();
        String detectedRegion = null;
        int regionOutcomeTelemetryValue = 0;
        String regionToUse = null;
        if (providedRegion != null) {
            detectedRegion = AadInstanceDiscoveryProvider.discoverRegion(msalRequest, serviceBundle);
            regionToUse = providedRegion;
            regionOutcomeTelemetryValue = AadInstanceDiscoveryProvider.determineRegionOutcome(detectedRegion, providedRegion, msalRequest.application().autoDetectRegion());
        } else if (msalRequest.application().autoDetectRegion()) {
            detectedRegion = AadInstanceDiscoveryProvider.discoverRegion(msalRequest, serviceBundle);
            if (detectedRegion != null) {
                regionToUse = detectedRegion;
            }
            regionOutcomeTelemetryValue = AadInstanceDiscoveryProvider.determineRegionOutcome(detectedRegion, providedRegion, msalRequest.application().autoDetectRegion());
        }
        if (regionToUse != null) {
            instanceDiscoveryRequestUrl = AadInstanceDiscoveryProvider.getInstanceDiscoveryEndpointWithRegion(authorityUrl.getAuthority(), regionToUse) + AadInstanceDiscoveryProvider.formInstanceDiscoveryParameters(authorityUrl);
            try {
                httpResponse = AadInstanceDiscoveryProvider.executeRequest(instanceDiscoveryRequestUrl, msalRequest.headers().getReadonlyHeaderMap(), msalRequest, serviceBundle);
            }
            catch (MsalClientException ex) {
                log.warn("Could not retrieve regional instance discovery metadata, falling back to global endpoint");
            }
        }
        if (detectedRegion == null && providedRegion == null || httpResponse == null || httpResponse.statusCode() != 200) {
            instanceDiscoveryRequestUrl = AadInstanceDiscoveryProvider.getInstanceDiscoveryEndpoint(authorityUrl.getAuthority()) + AadInstanceDiscoveryProvider.formInstanceDiscoveryParameters(authorityUrl);
            httpResponse = AadInstanceDiscoveryProvider.executeRequest(instanceDiscoveryRequestUrl, msalRequest.headers().getReadonlyHeaderMap(), msalRequest, serviceBundle);
        }
        if (httpResponse.statusCode() != 200) {
            throw MsalServiceExceptionFactory.fromHttpResponse(httpResponse);
        }
        serviceBundle.getServerSideTelemetry().getCurrentRequest().regionOutcome(regionOutcomeTelemetryValue);
        return JsonHelper.convertJsonToObject(httpResponse.body(), AadInstanceDiscoveryResponse.class);
    }

    private static int determineRegionOutcome(String detectedRegion, String providedRegion, boolean autoDetect) {
        int regionOutcomeTelemetryValue = 0;
        if (providedRegion != null) {
            regionOutcomeTelemetryValue = detectedRegion == null ? RegionTelemetry.REGION_OUTCOME_DEVELOPER_AUTODETECT_FAILED.telemetryValue : (providedRegion.equals(detectedRegion) ? RegionTelemetry.REGION_OUTCOME_DEVELOPER_AUTODETECT_MATCH.telemetryValue : RegionTelemetry.REGION_OUTCOME_DEVELOPER_AUTODETECT_MISMATCH.telemetryValue);
        } else if (autoDetect) {
            regionOutcomeTelemetryValue = detectedRegion != null ? RegionTelemetry.REGION_OUTCOME_AUTODETECT_SUCCESS.telemetryValue : RegionTelemetry.REGION_OUTCOME_AUTODETECT_FAILED.telemetryValue;
        }
        return regionOutcomeTelemetryValue;
    }

    private static String formInstanceDiscoveryParameters(URL authorityUrl) {
        return INSTANCE_DISCOVERY_REQUEST_PARAMETERS_TEMPLATE.replace("{authorizeEndpoint}", AadInstanceDiscoveryProvider.getAuthorizeEndpoint(authorityUrl.getAuthority(), Authority.getTenant(authorityUrl, Authority.detectAuthorityType(authorityUrl))));
    }

    private static IHttpResponse executeRequest(String requestUrl, Map<String, String> headers, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, requestUrl, headers);
        return HttpHelper.executeHttpRequest(httpRequest, msalRequest.requestContext(), serviceBundle);
    }

    private static String discoverRegion(MsalRequest msalRequest, ServiceBundle serviceBundle) {
        CurrentRequest currentRequest = serviceBundle.getServerSideTelemetry().getCurrentRequest();
        if (System.getenv(REGION_NAME) != null) {
            log.info("Region found in environment variable: " + System.getenv(REGION_NAME));
            currentRequest.regionSource(RegionTelemetry.REGION_SOURCE_ENV_VARIABLE.telemetryValue);
            return System.getenv(REGION_NAME);
        }
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Metadata", "true");
            IHttpResponse httpResponse = AadInstanceDiscoveryProvider.executeRequest(IMDS_ENDPOINT, headers, msalRequest, serviceBundle);
            if (httpResponse.statusCode() == 200 && !httpResponse.body().isEmpty()) {
                log.info("Region retrieved from IMDS endpoint: " + httpResponse.body());
                currentRequest.regionSource(RegionTelemetry.REGION_SOURCE_IMDS.telemetryValue);
                return httpResponse.body();
            }
            log.warn(String.format("Call to local IMDS failed with status code: %s, or response was empty", httpResponse.statusCode()));
            currentRequest.regionSource(RegionTelemetry.REGION_SOURCE_FAILED_AUTODETECT.telemetryValue);
            return null;
        }
        catch (Exception e) {
            log.warn(String.format("Exception during call to local IMDS endpoint: %s", e.getMessage()));
            currentRequest.regionSource(RegionTelemetry.REGION_SOURCE_FAILED_AUTODETECT.telemetryValue);
            return null;
        }
    }

    private static void doInstanceDiscoveryAndCache(URL authorityUrl, boolean validateAuthority, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse = null;
        if (msalRequest.application().authenticationAuthority.authorityType.equals((Object)AuthorityType.AAD)) {
            aadInstanceDiscoveryResponse = AadInstanceDiscoveryProvider.sendInstanceDiscoveryRequest(authorityUrl, msalRequest, serviceBundle);
            if (validateAuthority) {
                AadInstanceDiscoveryProvider.validate(aadInstanceDiscoveryResponse);
            }
        }
        AadInstanceDiscoveryProvider.cacheInstanceDiscoveryMetadata(authorityUrl.getAuthority(), aadInstanceDiscoveryResponse);
    }

    private static void validate(AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse) {
        if (StringHelper.isBlank(aadInstanceDiscoveryResponse.tenantDiscoveryEndpoint())) {
            throw new MsalServiceException(aadInstanceDiscoveryResponse);
        }
    }

    static {
        TRUSTED_HOSTS_SET.addAll(Arrays.asList("login.windows.net", "login.chinacloudapi.cn", "login-us.microsoftonline.com", "login.microsoftonline.de", DEFAULT_TRUSTED_HOST, "login.microsoftonline.us"));
    }
}

