/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.util.Collections;
import javax.net.ssl.HttpsURLConnection;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.license.VersionPrinter;

public class MavenVersionChecker {
    private static final Log LOG = LogFactory.getLog(MavenVersionChecker.class);
    private static final String FLYWAY_URL = "https://search.maven.org/solrsearch/select?q=a:flyway-core";

    private static boolean canConnectToMaven() {
        try {
            InetAddress address = InetAddress.getByName("maven.org");
            return address.isReachable(500);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForVersionUpdates() {
        if (!MavenVersionChecker.canConnectToMaven()) {
            return;
        }
        try {
            URL url = new URL(FLYWAY_URL);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            try {
                MavenDoc[] mavenDocs;
                connection.setRequestMethod("GET");
                StringBuilder response = new StringBuilder();
                try (BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String line;
                    while ((line = rd.readLine()) != null) {
                        response.append(line).append('\r');
                    }
                }
                MavenObject obj = (MavenObject)new Gson().fromJson(response.toString(), MavenObject.class);
                MigrationVersion current = MigrationVersion.fromVersion((String)VersionPrinter.getVersion());
                MigrationVersion latest = null;
                String groupID = "org.flywaydb";
                groupID = "org.flywaydb.enterprise";
                for (MavenDoc mavenDoc : mavenDocs = obj.response.docs) {
                    if (!mavenDoc.g.equals(groupID)) continue;
                    latest = MigrationVersion.fromVersion((String)mavenDoc.latestVersion);
                    break;
                }
                if (current.compareTo(latest) < 0) {
                    LOG.warn("This version of Flyway is out of date. Upgrade to Flyway " + latest + ": " + "https://rd.gt/3rXiSlV" + "\n");
                }
            }
            finally {
                if (Collections.singletonList(connection).get(0) != null) {
                    connection.disconnect();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private MavenVersionChecker() {
    }

    private static class MavenObject {
        public MavenResponse response;

        private MavenObject() {
        }
    }

    private static class MavenDoc {
        public String latestVersion;
        public String g;

        private MavenDoc() {
        }
    }

    private static class MavenResponse {
        public MavenDoc[] docs;

        private MavenResponse() {
        }
    }
}

