/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.secretsmanagement;

import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import java.util.Map;
import org.flywaydb.core.extensibility.ConfigurationProvider;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeRequiredException;
import org.flywaydb.core.internal.license.VersionPrinter;

public class GcsmConfigurationProvider
implements ConfigurationProvider {
    public static final String GCSM_PROJECT = "flyway.gcsm.project";
    public static final String GCSM_SECRETS = "flyway.gcsm.secrets";

    public boolean isConfigured(Map<String, String> configuration) {
        boolean isConfigured;
        boolean bl = isConfigured = configuration.containsKey(GCSM_PROJECT) && configuration.containsKey(GCSM_SECRETS);
        if (isConfigured && VersionPrinter.EDITION != Edition.ENTERPRISE) {
            throw new FlywayTeamsUpgradeRequiredException("Google Cloud Secret Manager");
        }
        return isConfigured;
    }

    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        switch (environmentVariable) {
            case "FLYWAY_GCSM_PROJECT": {
                return GCSM_PROJECT;
            }
            case "FLYWAY_GCSM_SECRETS": {
                return GCSM_SECRETS;
            }
        }
        return null;
    }

    public Map<String, String> getConfiguration(Map<String, String> currentConfiguration) throws Exception {
        if (VersionPrinter.EDITION != Edition.ENTERPRISE) {
            throw new FlywayTeamsUpgradeRequiredException("Google Cloud Secret Manager");
        }
        String gcsmProject = currentConfiguration.remove(GCSM_PROJECT);
        String[] gcsmSecrets = currentConfiguration.remove(GCSM_SECRETS).split(",");
        return ConfigUtils.loadConfigurationFromString((String)GcsmConfigurationProvider.getConfiguration(gcsmProject, gcsmSecrets));
    }

    public static String getConfiguration(String project, String ... secrets) throws Exception {
        StringBuilder gcsmConf = new StringBuilder();
        for (String secret : secrets) {
            gcsmConf.append(GcsmConfigurationProvider.readSecret(project, secret)).append("\n");
        }
        return gcsmConf.toString();
    }

    private static String readSecret(String project, String secret) throws Exception {
        try (SecretManagerServiceClient client = SecretManagerServiceClient.create();){
            SecretVersionName secretVersionName = SecretVersionName.of((String)project, (String)secret, (String)"latest");
            AccessSecretVersionResponse response = client.accessSecretVersion(secretVersionName);
            String string = response.getPayload().getData().toStringUtf8();
            return string;
        }
    }
}

