/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.pki.NZNative;
import oracle.security.pki.OracleCertExtension;
import oracle.security.pki.OracleLDAP;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIECPrivateKey;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.internal.OraclePKIX509CertHelper;
import oracle.security.pki.internal.OraclePKIX509CertReqHelper;
import oracle.security.pki.internal.OracleTrustFlagHelper;
import oracle.security.pki.resources.OraclePKIMsgID;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.pki.util.CertType;
import oracle.security.pki.util.SignatureAlgorithms;

public class OracleWalletTextUI {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    static String b = "wallet:\ncreate [-wallet [wallet]] [[-pwd <pwd>] [-auto_login|-auto_login_local]] | [-auto_login_only] [-with_trust_flags] [-compat_v12]\ndisplay [-wallet [wallet]] <-summary|-complete> [-pwd <pwd>]\nconvert [-wallet [wallet]] [-pwd <pwd>] | [-auto_login_only] [-compat_v12]\nchange_pwd [-wallet [wallet]] [-oldpwd <oldpwd>] [-newpwd <newpwd>]\nenable_trust_flags [-wallet [wallet]] [-pwd <pwd>] | [-auto_login_only] <-untrust_all>\nadd [-wallet [wallet]] <[-dn [dn]]> <-asym_alg [RSA|ECC]> <[-keysize [512|1024|2048|4096|8192|16384]] |\n                                                           [-eccurve [p192|p224|p256|p384|p521|k163|k233|k283|k409|k571|b163|b233|b283|b409|b571]]>\n     <-self_signed [-validity [days]] | [-valid_from [mm/dd/yyyy] -valid_until [mm/dd/yyyy]]\n                   [-serial_file <file_loc>] | [-serial_num <serial_num>]> <-addext_ski>\n                   <-addext_ku digitalSignature,nonRepudiation,keyEncipherment,dataEncipherment,keyAgreement,keyCertSign,cRLSign,encipherOnly,decipherOnly> \n                   <-addext_basic_cons [CA] | [-pathLen [pathlen]]]> \n                    <-addext_san <[DNS|IPV4Address|IPV6Address]:<value>[,[DNS|IPV4Address|IPV6Address]:<value>]...>> \n     <[-cert [filename]] [-trusted_cert|-user_cert]> [-pwd <pwd>] | [-auto_login_only]\n                   [-sign_alg <md5|sha1|sha256|sha384|sha512|ecdsasha1|ecdsasha256|ecdsasha384|ecdsasha512>]\n     <-trust_flags [SERVER_AUTH,CLIENT_AUTH|VALID_PEER|NULL]>\nassign_trust_flags [-wallet [wallet]] [-pwd <pwd>] [-trust_flags [SERVER_AUTH,CLIENT_AUTH|VALID_PEER|NULL]]\n     [-dn [cert_dn]] <-issuer [issuer_dn]> <-serial_num [serial_num]>\nremove [-wallet [wallet]] [-dn [subject_dn]] [-issuer_dn [issuer_dn]] [-serial_num <serial_num>]\n     [-trusted_cert_all|-trusted_cert|-user_cert|-cert_req]  [-pwd <pwd>] | [-auto_login_only]\nreplace [-wallet [wallet]] [-issuer_dn <issuer_dn>] [-serial_num <serial_num>] [-cert [filename]]\n     [-trusted_cert|-user_cert]> <-trust_flags [SERVER_AUTH,CLIENT_AUTH|VALID_PEER|NULL]> [-pwd <pwd>]\nexport [-wallet [wallet]] [-dn [dn]] [-cert [filename] | -request [filename]] [-pwd <pwd>]\n     <-issuer_dn [issuer_dn]> <-serial_num [serial_num]>\nexport_trust_chain [-wallet [wallet]] [-certchain [filename]] [-dn [user_cert_dn]] [-pwd <pwd>]\n     <-issuer_dn [issuer_dn]> <-serial_num [serial_num]>\nexport_private_key [-wallet [wallet]] [-pwd <pwd>] [-pvtkeyfile [filename]] [-alias [pvtkey_alias]] [-pvtkeypwd <pwd>] [-salt salt]\nimport_private_key [-wallet [wallet]] [-pwd <pwd>] [-alias [pvtkey_alias]] [-pvtkeyfile [filename]] [-pvtkeypwd <pwd>] [-salt salt] [-cert [certfilename]] [-cacert [cacertfilename]]\nupload [-wallet [wallet]] [-ldap [host:port]] [-user [user]] [-userpwd [userpwd]] [-pwd <pwd>]\ndownload [-wallet [wallet]] [-ldap [host:nonsslport]] [-user [user]] [-userpwd [userpwd]] [-pwd <pwd>]\njks_to_pkcs12 [-wallet [wallet]] [-pwd <pwd>] [-keystore [keystore]] [-jkspwd [jkspwd]]\n     <-aliases [alias:alias..]>\npkcs12_to_jks [-wallet [wallet]] [-pwd <pwd>] [-jksKeyStoreLoc <jksKSloc> -jksKeyStorepwd <jksKS_pwd>]\n     [-jksTrustStoreLoc <loc> -jksTrustStorepwd <pwd>]\np11_add [-wallet [wallet]] [-p11_lib <pkcs11Lib>] [-p11_tokenlabel <tokenLabel>]\n     [-p11_tokenpw <tokenPassphrase>] [-p11_certlabel <certlabel>] [-pwd <pwd>]\np11_verify [-wallet [wallet]] [-pwd <pwd>]\nimport_pkcs12 [-wallet <wallet>] [[-pwd <pwd>] | [-auto_login_only]] [-pkcs12file <pkcs12Loc>] [-pkcs12pwd <pkcs12Pwd>]\nhelp\n";

    public static int command(String[] stringArray) {
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        if (stringArray[0].equals("help")) {
            System.out.println(b);
            n = -1;
            return n;
        }
        if (stringArray[0].equals("display")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            n = OracleWalletTextUI.display(stringArray2);
        } else if (stringArray[0].equals("create")) {
            String[] stringArray3 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray3.length);
            n = OracleWalletTextUI.create(stringArray3);
        } else if (stringArray[0].equals("remove")) {
            String[] stringArray4 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray4, 0, stringArray4.length);
            n = OracleWalletTextUI.remove(stringArray4);
        } else if (stringArray[0].equals("replace")) {
            String[] stringArray5 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray5, 0, stringArray5.length);
            n = OracleWalletTextUI.replace(stringArray5);
        } else if (stringArray[0].equals("test_api")) {
            String[] stringArray6 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray6, 0, stringArray6.length);
            n = OracleWalletTextUI.test_api(stringArray6);
        } else if (stringArray[0].equals("change_pwd")) {
            String[] stringArray7 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray7, 0, stringArray7.length);
            n = OracleWalletTextUI.change_pwd(stringArray7);
        } else if (stringArray[0].equals("enable_trust_flags")) {
            String[] stringArray8 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray8, 0, stringArray8.length);
            n = OracleWalletTextUI.enable_trust_flags(stringArray8);
        } else if (stringArray[0].equals("assign_trust_flags")) {
            String[] stringArray9 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray9, 0, stringArray9.length);
            n = OracleWalletTextUI.assign_trust_flags(stringArray9);
        } else if (stringArray[0].equals("add")) {
            String[] stringArray10 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray10, 0, stringArray10.length);
            n = OracleWalletTextUI.add(stringArray10);
        } else if (stringArray[0].equals("p11_add")) {
            String[] stringArray11 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray11, 0, stringArray11.length);
            n = OracleWalletTextUI.p11_add(stringArray11);
        } else if (stringArray[0].equals("p11_verify")) {
            String[] stringArray12 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray12, 0, stringArray12.length);
            n = OracleWalletTextUI.p11_verify(stringArray12);
        } else if (stringArray[0].equals("p11_test")) {
            String[] stringArray13 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray13, 0, stringArray13.length);
            n = OracleWalletTextUI.p11_test(stringArray13);
        } else if (stringArray[0].equals("export")) {
            String[] stringArray14 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray14, 0, stringArray14.length);
            n = OracleWalletTextUI.export(stringArray14);
        } else if (stringArray[0].equals("export_trust_chain")) {
            String[] stringArray15 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray15, 0, stringArray15.length);
            n = OracleWalletTextUI.exportchain(stringArray15);
        } else if (stringArray[0].equals("export_private_key")) {
            String[] stringArray16 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray16, 0, stringArray16.length);
            n = OracleWalletTextUI.exportPvtKey(stringArray16);
        } else if (stringArray[0].equals("import_private_key")) {
            String[] stringArray17 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray17, 0, stringArray17.length);
            n = OracleWalletTextUI.importPvtKey(stringArray17);
        } else if (stringArray[0].equals("upload")) {
            String[] stringArray18 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray18, 0, stringArray18.length);
            OracleWalletTextUI.uploadWallet(stringArray18);
        } else if (stringArray[0].equals("download")) {
            String[] stringArray19 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray19, 0, stringArray19.length);
            OracleWalletTextUI.downloadWallet(stringArray19);
        } else if (stringArray[0].equals("verify_trust_chain")) {
            String[] stringArray20 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray20, 0, stringArray20.length);
            n = OracleWalletTextUI.verifychain(stringArray20);
        } else if (stringArray[0].equals("is_tcert_used_in_chain")) {
            String[] stringArray21 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray21, 0, stringArray21.length);
            n = OracleWalletTextUI.isTrustedCertUsedInChain(stringArray21);
        } else if (stringArray[0].equals("get_certreq_info")) {
            String[] stringArray22 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray22, 0, stringArray22.length);
            n = OracleWalletTextUI.getCertreqInfo(stringArray22);
        } else if (stringArray[0].equals("get_certreq_count_dns")) {
            String[] stringArray23 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray23, 0, stringArray23.length);
            n = OracleWalletTextUI.getCertReqCountDNs(stringArray23);
        } else if (stringArray[0].equals("validate_pswd")) {
            String[] stringArray24 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray24, 0, stringArray24.length);
            n = OracleWalletTextUI.isValidPassword(stringArray24);
        } else if (stringArray[0].equals("get_keysizes")) {
            String[] stringArray25 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray25, 0, stringArray25.length);
            n = OracleWalletTextUI.getKeysizes(stringArray25);
        } else if (stringArray[0].equals("jks_to_pkcs12")) {
            String[] stringArray26 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray26, 0, stringArray26.length);
            n = OracleWalletTextUI.migrateJKStoPKCS12(stringArray26);
        } else if (stringArray[0].equals("list_aliases")) {
            String[] stringArray27 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray27, 0, stringArray27.length);
            n = OracleWalletTextUI.listAliases(stringArray27);
        } else if (stringArray[0].equals("pkcs12_to_jks")) {
            String[] stringArray28 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray28, 0, stringArray28.length);
            n = OracleWalletTextUI.testJks_mig(stringArray28);
        } else if (stringArray[0].equals("test_jks_crt")) {
            String[] stringArray29 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray29, 0, stringArray29.length);
            n = OracleWalletTextUI.testJks_crt(stringArray29);
        } else if (stringArray[0].equals("test_jks_crt_ss")) {
            String[] stringArray30 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray30, 0, stringArray30.length);
            n = OracleWalletTextUI.testJks_crt_ss(stringArray30);
        } else if (stringArray[0].equals("test_jks_imp")) {
            String[] stringArray31 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray31, 0, stringArray31.length);
            n = OracleWalletTextUI.testJks_imp(stringArray31);
        } else if (stringArray[0].equals("test_jks_info")) {
            String[] stringArray32 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray32, 0, stringArray32.length);
            n = OracleWalletTextUI.testJks_info(stringArray32);
        } else if (stringArray[0].equals("test_jks_exp")) {
            String[] stringArray33 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray33, 0, stringArray33.length);
            n = OracleWalletTextUI.testJks_exp(stringArray33);
        } else if (stringArray[0].equals("test_jks_rem")) {
            String[] stringArray34 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray34, 0, stringArray34.length);
            n = OracleWalletTextUI.testJks_rem(stringArray34);
        } else if (stringArray[0].equals("test_jks_dis")) {
            String[] stringArray35 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray35, 0, stringArray35.length);
            n = OracleWalletTextUI.testJks_dis(stringArray35);
        } else if (stringArray[0].equals("test_jks_rem_all_tps")) {
            String[] stringArray36 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray36, 0, stringArray36.length);
            n = OracleWalletTextUI.testJks_rem_all_tps(stringArray36);
        } else if (stringArray[0].equals("import_pkcs12")) {
            String[] stringArray37 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray37, 0, stringArray37.length);
            n = OracleWalletTextUI.importPKCS12ToOracleWallet(stringArray37);
        } else if (stringArray[0].equals("convert")) {
            String[] stringArray38 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray38, 0, stringArray38.length);
            n = OracleWalletTextUI.convert(stringArray38);
        } else {
            System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[0]);
            System.out.println(b);
            n = -1;
            return n;
        }
        return n;
    }

    public static int uploadWallet(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "389";
        String string5 = "";
        String string6 = null;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-ldap")) {
                    int n2;
                    if ((n2 = stringArray[++i].indexOf(58)) > 0) {
                        string3 = stringArray[i].substring(0, n2);
                        string4 = stringArray[i].substring(n2 + 1);
                        continue;
                    }
                    string3 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-user")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-userpwd")) {
                    string6 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        OracleWallet oracleWallet = null;
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
        }
        catch (Exception exception) {
            try {
                oracleWallet = new OracleWallet();
                oracleWallet.open(string, null);
                if (oracleWallet.isAutoLoginOnly()) {
                    System.out.println("Found Auto Login Only (ALO) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                } else {
                    System.out.println("Found Auto Login (AL) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                }
            }
            catch (Exception exception2) {
                System.out.println(exception.getLocalizedMessage());
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                n = -1;
                return n;
            }
        }
        try {
            OracleLDAP.uploadWallet(string3, string4, string5, string6.toCharArray(), string, string2.toCharArray());
        }
        catch (Exception exception) {
            System.out.println("Upload wallet failed : " + exception.getLocalizedMessage());
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            n = -1;
            return n;
        }
        return n;
    }

    public static int downloadWallet(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "389";
        String string5 = "";
        String string6 = null;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-ldap")) {
                    int n2;
                    if ((n2 = stringArray[++i].indexOf(58)) > 0) {
                        string3 = stringArray[i].substring(0, n2);
                        string4 = stringArray[i].substring(n2 + 1);
                        continue;
                    }
                    string3 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-user")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-userpwd")) {
                    string6 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        byte[] byArray = null;
        try {
            byArray = OracleLDAP.downloadWallet(string3, string4, string5, string6.toCharArray());
            OracleWallet oracleWallet = new OracleWallet();
            oracleWallet.setWalletArray(byArray, string2.toCharArray());
            oracleWallet.saveAs(string);
        }
        catch (Exception exception) {
            System.out.println("Download wallet failed : " + exception.getLocalizedMessage());
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            n = -1;
            return n;
        }
        return n;
    }

    public static int testJks_crt(String[] stringArray) {
        OracleWallet oracleWallet;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = 0;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-request")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-dn")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-keysize")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-alias")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string3 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            oracleWallet = OracleWallet.getInstance("jks");
            oracleWallet.create(OraclePKIGenFunc.getCreatePassword(string3, false));
            oracleWallet.saveAs(string);
        }
        catch (IOException iOException) {
            System.out.println("Unable to save wallet at " + string);
            n = -1;
            return n;
        }
        try {
            String string7;
            oracleWallet = OracleWallet.getInstance("jks");
            oracleWallet.open(string, string3.toCharArray());
            if (null == string5 || string5.isEmpty()) {
                System.out.println(a.getString("PKI-07021"));
                n = -1;
                return n;
            }
            int n2 = Integer.parseInt(string5);
            oracleWallet.addCertRequest(new X500Principal(string4), n2, null, string6);
            oracleWallet.saveAs(string);
            if (null != string6) {
                string7 = oracleWallet.exportCertReqB64(string6);
                if (null == string7) {
                    System.out.println(a.getString("PKI-04005"));
                    n = -1;
                    return n;
                }
            } else {
                System.out.println(a.getString("PKI-07018"));
                n = -1;
                return n;
            }
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(string7);
            fileWriter.flush();
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            System.out.println("jks test failed.");
            exception.printStackTrace();
            n = -1;
            return n;
        }
        return n;
    }

    public static int testJks_crt_ss(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = 0;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-dn")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-keysize")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-alias")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-serial_num")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            OracleWallet oracleWallet = OracleWallet.getInstance("jks");
            oracleWallet.open(string, string2.toCharArray());
            if (null == string6 || string6.isEmpty() || null == string4 || string4.isEmpty()) {
                System.out.println(a.getString("PKI-07022"));
                n = -1;
                return n;
            }
            BigInteger bigInteger = new BigInteger(string6);
            int n2 = Integer.parseInt(string4);
            oracleWallet.createSelfSigned(new X500Principal(string3), n2, 3650, bigInteger, null, string5);
            oracleWallet.saveAs(string);
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            System.out.println("jks test failed.");
            exception.printStackTrace();
            n = -1;
            return n;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int testJks_imp(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = "jks";
        boolean bl = false;
        boolean bl2 = false;
        String string4 = null;
        String string5 = null;
        int n = 0;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-trusted_cert")) {
                    bl = true;
                    bl2 = false;
                    continue;
                }
                if (stringArray[i].equals("-user_cert")) {
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-cert")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-alias")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                return -1;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return -1;
        }
        if (string4 == null) return n;
        try {
            InputStream inputStream;
            try {
                inputStream = new URL(string4).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                inputStream = new FileInputStream(string4);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = inputStream.read();
            while (n2 != -1) {
                byteArrayOutputStream.write((byte)n2);
                n2 = inputStream.read();
            }
            OracleWallet oracleWallet = OracleWallet.getInstance("jks");
            oracleWallet.open(string, string2.toCharArray());
            if (null != string5) {
                if (bl) {
                    oracleWallet.importCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), true, string5, null);
                } else {
                    if (!bl2) throw new IOException("User or trusted cert flag should be specified.");
                    oracleWallet.importCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), false, string5, null);
                }
            } else {
                System.out.println(a.getString("PKI-07018"));
                return -1;
            }
            oracleWallet.saveAs(string);
            return n;
        }
        catch (Exception exception) {
            System.out.println("Unable to import the certificate. " + exception.getLocalizedMessage());
            return -1;
        }
    }

    public static int testJks_info(String[] stringArray) {
        int n;
        block12: {
            String string = null;
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            boolean bl2 = false;
            n = 0;
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("-wallet")) {
                        string = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-alias")) {
                        string3 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-pwd")) {
                        string2 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-trusted_cert")) {
                        bl = true;
                        bl2 = false;
                        continue;
                    }
                    if (stringArray[i].equals("-user_cert")) {
                        bl = false;
                        bl2 = true;
                        continue;
                    }
                    System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                    System.out.println(b);
                    n = -1;
                    return n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println(b);
                n = -1;
                return n;
            }
            try {
                OracleWallet oracleWallet = OracleWallet.getInstance("jks");
                boolean bl3 = oracleWallet.exists(string);
                oracleWallet.open(string, string2.toCharArray());
                String string4 = "welcome34";
                oracleWallet.changePassword(string4.toCharArray());
                oracleWallet.changePassword(string2.toCharArray());
                InputStream inputStream = oracleWallet.getWalletArray(false);
                OracleWallet oracleWallet2 = OracleWallet.getInstance("jks");
                oracleWallet2.setWalletArray(inputStream, string2.toCharArray());
                byte[] byArray = oracleWallet.getWalletArrayB(false);
                OracleWallet oracleWallet3 = OracleWallet.getInstance("jks");
                oracleWallet3.setWalletArray(byArray, string2.toCharArray());
                if (bl) {
                    oracleWallet.getTrustpointInfo(0, string3);
                    X509Certificate x509Certificate = oracleWallet.getTrustpoint(0, 1);
                    X500Principal[] x500PrincipalArray = oracleWallet.getTrustpointDNs(0);
                    int n2 = oracleWallet.getTrustpointCount(0);
                    String[] stringArray2 = oracleWallet.getTrustpointAliases(0);
                    ArrayList arrayList = oracleWallet.getTrustpointDNalias(0);
                    String string5 = oracleWallet.exportTrustedB64(string3);
                    break block12;
                }
                if (bl2) {
                    oracleWallet.getCertInfo(0, string3);
                    oracleWallet.getCertReqInfo(0, string3);
                    X509Certificate x509Certificate = oracleWallet.getCert(0, 1);
                    String[] stringArray3 = oracleWallet.getCertReqAliases(0);
                    int n3 = oracleWallet.getCertReqCount(0);
                    X500Principal[] x500PrincipalArray = oracleWallet.getCertReqDNs(0);
                    String[] stringArray4 = oracleWallet.getCertReqInfo(0, 0);
                    ArrayList arrayList = oracleWallet.getCertReqDNalias(0);
                    X500Principal[] x500PrincipalArray2 = oracleWallet.getCertDNs(0);
                    int n4 = oracleWallet.getCertCount(0);
                    String[] stringArray5 = oracleWallet.getCertAliases(0);
                    ArrayList arrayList2 = oracleWallet.getCertDNalias(0);
                    Enumeration enumeration = oracleWallet.listAliases();
                    break block12;
                }
                throw new IOException("User or trusted cert flag should be specified.");
            }
            catch (Exception exception) {
                System.out.println(exception.getLocalizedMessage());
                n = -1;
                return n;
            }
        }
        return n;
    }

    public static int testJks_exp(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-cert")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-certchain")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-alias")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        if (string3 != null) {
            try {
                OracleWallet oracleWallet = OracleWallet.getInstance("jks");
                oracleWallet.open(string, string2.toCharArray());
                String string6 = oracleWallet.exportCertB64(string5);
                FileWriter fileWriter = new FileWriter(string3);
                fileWriter.write(string6);
                fileWriter.flush();
            }
            catch (Exception exception) {
                System.out.println("Unable to export certificate in jks. " + exception.getLocalizedMessage());
                n = -1;
                return n;
            }
        }
        if (string4 != null) {
            try {
                OracleWallet oracleWallet = OracleWallet.getInstance("jks");
                oracleWallet.open(string, string2.toCharArray());
                String string7 = oracleWallet.exportCertChainB64(string5);
                FileWriter fileWriter = new FileWriter(string4);
                fileWriter.write(string7);
                fileWriter.flush();
            }
            catch (Exception exception) {
                System.out.println("Unable to export certificate chain in jks. " + exception.getLocalizedMessage());
                n = -1;
                return n;
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int testJks_rem(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-alias")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-trusted_cert")) {
                    bl = true;
                    bl2 = false;
                    continue;
                }
                if (stringArray[i].equals("-user_cert")) {
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                return -1;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return -1;
        }
        try {
            OracleWallet oracleWallet = OracleWallet.getInstance("jks");
            oracleWallet.open(string, string2.toCharArray());
            if (null != string3) {
                if (bl) {
                    oracleWallet.removeTrustpoint(string3);
                } else {
                    if (!bl2) throw new IOException("User or trusted cert flag should be specified.");
                    oracleWallet.deleteCert(string3);
                }
            } else {
                System.out.println(a.getString("PKI-07018"));
                return -1;
            }
            oracleWallet.saveAs(string);
            return n;
        }
        catch (Exception exception) {
            System.out.println("Unable to remove certificate. " + exception.getLocalizedMessage());
            return -1;
        }
    }

    public static int testJks_mig(String[] stringArray) {
        int n;
        block20: {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            n = 0;
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("-wallet")) {
                        string = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-jksKeyStoreLoc")) {
                        string3 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-jksKeyStorepwd")) {
                        if (OracleWallet.isValidPassword((string4 = stringArray[++i]).toCharArray())) continue;
                        System.out.println(a.getString("PKI-01002"));
                        n = -1;
                        return n;
                    }
                    if (stringArray[i].equals("-pwd")) {
                        string2 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-jksTrustStoreLoc")) {
                        string5 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-jksTrustStorepwd")) {
                        if (OracleWallet.isValidPassword((string6 = stringArray[++i]).toCharArray())) continue;
                        System.out.println(a.getString("PKI-01002"));
                        n = -1;
                        return n;
                    }
                    System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                    System.out.println(b);
                    n = -1;
                    return n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println(b);
                n = -1;
                return n;
            }
            OracleWallet oracleWallet = new OracleWallet();
            boolean bl = false;
            try {
                if (string2 == null) {
                    try {
                        oracleWallet.open(string, null);
                    }
                    catch (Exception exception) {
                        oracleWallet.open(string, OraclePKIGenFunc.getPassword("WALLET_PASSWORD_PROMPT"));
                        bl = true;
                    }
                    if (!oracleWallet.isAutoLoginOnly() && !bl) {
                        System.out.println("Can not convert regular SSO wallet to JKS.\nPlease provide corresponding p12 wallet with password.");
                        n = -1;
                        return n;
                    }
                } else {
                    oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
                }
                if (null != string3) {
                    char[] cArray = OraclePKIGenFunc.getPassword(string4, false, "ENTER_KEYSTORE_PASSWORD");
                    if (string5 == null) {
                        OracleWallet oracleWallet2 = oracleWallet.migratePKCS12toJKS(cArray, 0);
                        oracleWallet2.saveAs(string3);
                    } else {
                        char[] cArray2 = OraclePKIGenFunc.getPassword(string6, false, "ENTER_TRUSTSTORE_PASSWORD");
                        OracleWallet oracleWallet3 = oracleWallet.migratePKCS12toJKS(cArray, 1);
                        oracleWallet3.saveAs(string3);
                        OracleWallet oracleWallet4 = oracleWallet.migratePKCS12toJKS(cArray2, 2);
                        oracleWallet4.saveAs(string5);
                    }
                    break block20;
                }
                System.out.println(a.getString("PKI-07013"));
                n = -1;
                return n;
            }
            catch (Exception exception) {
                System.out.println("Unable to perform operation :" + exception.getLocalizedMessage());
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                n = -1;
                return n;
            }
        }
        return n;
    }

    public static int testJks_dis(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            OracleWallet oracleWallet = OracleWallet.getInstance("jks");
            oracleWallet.open(string, string2.toCharArray());
            KeyStore keyStore = oracleWallet.getKeyStore();
            Enumeration<String> enumeration = null;
            enumeration = keyStore.aliases();
            System.out.println("Keystore contains " + keyStore.size() + " entries.");
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                if (keyStore.isKeyEntry(string3)) {
                    System.out.println("keyEntry:" + string3);
                    Certificate[] certificateArray = keyStore.getCertificateChain(string3);
                    for (int i = 0; i < certificateArray.length; ++i) {
                        if (((X509Certificate)certificateArray[i]).getIssuerDN().equals(((X509Certificate)certificateArray[i]).getSubjectDN())) {
                            System.out.print("  " + (i + 1) + " (self-signed)");
                        } else {
                            System.out.print("  " + (i + 1));
                        }
                        System.out.println("  " + ((X509Certificate)certificateArray[i]).getSubjectDN());
                    }
                    continue;
                }
                if (!keyStore.isCertificateEntry(string3)) continue;
                System.out.println("trustedCertEntry:" + string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = -1;
            return n;
        }
        return n;
    }

    public static int testJks_rem_all_tps(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println("wallet:\ntest_jks_rem_all_tps [-jksKeyStoreLoc <jksKSloc> -jksKeyStorepwd <jksKS_pwd>]\nhelp");
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-jksKeyStoreLoc")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-jksKeyStorepwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println("wallet:\ntest_jks_rem_all_tps [-jksKeyStoreLoc <jksKSloc> -jksKeyStorepwd <jksKS_pwd>]\nhelp");
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("wallet:\ntest_jks_rem_all_tps [-jksKeyStoreLoc <jksKSloc> -jksKeyStorepwd <jksKS_pwd>]\nhelp");
            n = -1;
            return n;
        }
        try {
            OracleWallet oracleWallet = OracleWallet.getInstance("jks");
            oracleWallet.open(string, string2.toCharArray());
            oracleWallet.removeTrustpoints();
            oracleWallet.saveAs(string);
        }
        catch (Exception exception) {
            System.out.println("Could not remove trustpoints: " + exception.getLocalizedMessage());
            n = -1;
            return n;
        }
        return n;
    }

    public static int test_bug5610097(String[] stringArray) {
        int n = 0;
        String string = "/scratch/rchahal/temp/dgoswami/wall1";
        try {
            OracleWallet oracleWallet = new OracleWallet();
            oracleWallet.createSSO();
            oracleWallet.saveAs(string);
            OracleWallet oracleWallet2 = new OracleWallet();
            oracleWallet2.open(string, null);
            OracleSecretStore oracleSecretStore = oracleWallet2.getSecretStore();
            if (oracleSecretStore != null && oracleWallet2 != null) {
                oracleSecretStore.setSecret(new String("alias"), "secret".toCharArray());
                oracleWallet2.setSecretStore(oracleSecretStore);
            }
            if (oracleWallet2 != null) {
                oracleWallet2.save();
            }
            if (oracleWallet2 != null) {
                oracleSecretStore.setSecret(new String("alias2"), "secret2".toCharArray());
                oracleWallet2.setSecretStore(oracleSecretStore);
            }
            if (oracleWallet2 != null) {
                oracleWallet2.save();
            }
            if (oracleWallet2 != null) {
                oracleWallet2.save();
            }
        }
        catch (IOException iOException) {
            System.out.println(a.getString("GEN_UNKNOWN_ERROR") + string);
            if (OraclePKIDebug.getDebugFlag()) {
                iOException.printStackTrace();
            }
            n = -1;
            return n;
        }
        catch (OracleSecretStoreException oracleSecretStoreException) {
            System.out.println(oracleSecretStoreException.getLocalizedMessage());
            if (OraclePKIDebug.getDebugFlag()) {
                oracleSecretStoreException.printStackTrace();
            }
            n = -1;
            return n;
        }
        return n;
    }

    public static int migrateJKStoPKCS12(String[] stringArray) {
        String string = null;
        String string2 = null;
        char[] cArray = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String[] stringArray2 = null;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println("wallet:\njks_to_pkcs12 [-wallet [wallet]] [-pwd [pwd]] [-keystore [keystore]] [-jkspwd [jkspwd]] <-aliases [alias:alias..]>\nhelp");
            n = -1;
            return n;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-keystore")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-jkspwd")) {
                string2 = stringArray[++i];
                cArray = string2.toCharArray();
                continue;
            }
            if (stringArray[i].equals("-aliases")) {
                string5 = stringArray[++i];
                stringArray2 = string5.split(":");
                continue;
            }
            System.out.println("wallet:\njks_to_pkcs12 [-wallet [wallet]] [-pwd [pwd]] [-keystore [keystore]] [-jkspwd [jkspwd]] <-aliases [alias:alias..]>\nhelp");
            n = -1;
            return n;
        }
        OracleWallet oracleWallet = new OracleWallet();
        boolean bl = false;
        try {
            if (string4 == null) {
                try {
                    oracleWallet.open(string3, null);
                }
                catch (Exception exception) {
                    oracleWallet.open(string3, OraclePKIGenFunc.getPassword("WALLET_PASSWORD_PROMPT"));
                    bl = true;
                }
                if (!oracleWallet.isAutoLoginOnly() && !bl) {
                    System.out.println("Can not convert JKS to regular SSO wallet.\nPlease provide p12 wallet with password or provide editable SSO wallet.");
                    n = -1;
                    return n;
                }
            } else {
                oracleWallet = OraclePKIGenFunc.openAWallet(string3, string4, false, true);
            }
            KeyStore keyStore = KeyStore.getInstance("jks");
            FileInputStream fileInputStream = new FileInputStream(string);
            keyStore.load(fileInputStream, cArray);
            oracleWallet.migrateJKStoPKCS12(keyStore, cArray, stringArray2);
            oracleWallet.save();
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
            n = -1;
            return n;
        }
        System.out.println(a.getString("SUCCESSFUL_OPERATION"));
        return n;
    }

    public static int listAliases(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nlist_aliases [-wallet [wallet]] [-pwd [pwd]]\nhelp");
            n = -1;
            return n;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string2 = stringArray[++i];
                continue;
            }
            System.out.println("wallet:\nlist_aliases [-wallet [wallet]] [-pwd [pwd]]\nhelp");
            n = -1;
            return n;
        }
        try {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
            Enumeration enumeration = oracleWallet.listAliases();
            while (enumeration.hasMoreElements()) {
                System.out.println("alias : " + enumeration.nextElement());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
            n = -1;
        }
        return n;
    }

    public static int convert(String[] stringArray) {
        String string = "wallet:\nconvert [-wallet <wallet>] [-pwd <pwd>] | [-auto_login_only] [-compat_v12]\nhelp";
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(string);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-compat_v12")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-auto_login_only")) {
                    bl3 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(string);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        if (!bl || bl3 && string3 != null) {
            System.out.println(b);
            n = -1;
            return n;
        }
        OracleWallet oracleWallet = null;
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string2, string3, bl2, true);
            if (oracleWallet.isAutoLoginOnly() && !bl3 || !oracleWallet.isAutoLoginOnly() && bl3) {
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            n = -1;
            return n;
        }
        try {
            oracleWallet.saveAs(string2, (byte)1);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            n = -1;
            return n;
        }
        System.out.println(a.getString("SUCCESSFUL_OPERATION"));
        return n;
    }

    public static int enable_trust_flags(String[] stringArray) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        boolean bl3 = false;
        HashMap hashMap = new HashMap();
        byte by = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-auto_login_only")) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equals("-untrust_all")) {
                    bl2 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (OraclePKIDebug.getDebugFlag()) {
                arrayIndexOutOfBoundsException.printStackTrace();
            }
            System.out.println(b);
            n = -1;
            return n;
        }
        if (bl3 && string2 != null) {
            System.out.println(b);
            n = -1;
            return n;
        }
        OracleWallet oracleWallet = new OracleWallet();
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, bl, true);
            if (oracleWallet.isAutoLoginOnly() && !bl3 || !oracleWallet.isAutoLoginOnly() && bl3) {
                System.out.println(b);
                n = -1;
                return n;
            }
            if (!oracleWallet.areTrustFlagsEnabled()) {
                if (bl2) {
                    oracleWallet.addTrustFlagsToCertificates(true);
                } else {
                    oracleWallet.addTrustFlagsToCertificates(false);
                }
            } else {
                n = -1;
                System.out.println(a.getString("PKI-02016"));
                return n;
            }
            by = (byte)(by | 2);
            oracleWallet.saveAs(string, by);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getLocalizedMessage());
            System.out.println(a.getString("PKI-02003") + string);
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            n = -1;
            return n;
        }
        System.out.println(a.getString("SUCCESSFUL_OPERATION"));
        return n;
    }

    public static int assign_trust_flags(String[] stringArray) {
        OracleWallet oracleWallet;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-trust_flags")) {
                    if (OracleTrustFlagHelper.validateTrustFlags(string3 = stringArray[++i])) continue;
                    System.out.println(a.getString("PKI-04021"));
                    System.out.println(b);
                    n = -1;
                    return n;
                }
                if (stringArray[i].equals("-dn")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-issuer")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-serial_num")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-auto_login_only")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (OraclePKIDebug.getDebugFlag()) {
                arrayIndexOutOfBoundsException.printStackTrace();
            }
            System.out.println(b);
            n = -1;
            return n;
        }
        if (string3 == null) {
            System.out.println(b);
            n = -1;
            return n;
        }
        if (bl2 && string2 != null) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, bl);
            if (oracleWallet.isAutoLoginOnly() && !bl2 || !oracleWallet.isAutoLoginOnly() && bl2) {
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            System.out.println(a.getString("PKI-02003") + string);
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            n = -1;
            return n;
        }
        try {
            if (!oracleWallet.areTrustFlagsEnabled()) {
                System.out.println(a.getString("PKI-02015"));
                return -1;
            }
        }
        catch (Exception exception) {
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            System.out.println("Error Reading Wallet: " + exception.toString());
            return -1;
        }
        if (string4 == null) {
            System.out.println(b);
            return -1;
        }
        if (string4.trim().equals("")) {
            System.out.println(a.getString("PKI-01001") + "-dn");
            System.out.println(b);
            return -1;
        }
        if (!(string6 == null || string6.matches("^[0-9]+$") || string6.matches(".*[a-fA-F]+.*") || string6.startsWith("0x") || string6.startsWith("0X"))) {
            System.out.println(a.getString("PKI-04022"));
            System.out.println(b);
            return -1;
        }
        if (string5 != null && string5.trim().equals("")) {
            System.out.println(a.getString("PKI-01001") + "-issuer");
            System.out.println(b);
            return -1;
        }
        try {
            oracleWallet.assignTrustFlagstoCertificate(string4, string5, string6, string3);
            oracleWallet.saveAs(string);
        }
        catch (Exception exception) {
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            System.out.println(exception.toString());
            n = -1;
            return n;
        }
        System.out.println(a.getString("SUCCESSFUL_OPERATION"));
        return n;
    }

    public static int create(String[] stringArray) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string = null;
        String string2 = null;
        boolean bl6 = false;
        boolean bl7 = false;
        byte by = 0;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-auto_login")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-auto_login_local")) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equals("-auto_login_only")) {
                    bl4 = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    if (OracleWallet.isValidPassword((string2 = stringArray[++i]).toCharArray())) continue;
                    System.out.println(a.getString("PKI-01002"));
                    n = -1;
                    return n;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl6 = true;
                    continue;
                }
                if (stringArray[i].equals("-with_trust_flags")) {
                    bl5 = true;
                    by = (byte)(by | 2);
                    continue;
                }
                if (stringArray[i].equals("-compat_v12")) {
                    bl7 = true;
                    by = (byte)(by | 1);
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        if (bl2 && bl3 || bl2 && bl4 || bl3 && bl4) {
            System.out.println(b);
            n = -1;
            return n;
        }
        if (string2 != null && bl4) {
            System.out.println(b);
            n = -1;
            return n;
        }
        OracleWallet oracleWallet = new OracleWallet();
        try {
            if (string == null) {
                System.out.println("specify wallet directory [-wallet]\n");
                System.out.println(b);
                n = -1;
                return n;
            }
            OracleWallet oracleWallet2 = new OracleWallet();
            bl = oracleWallet2.exists(string, bl4);
        }
        catch (IOException iOException) {
            System.out.println(a.getString("GEN_UNKNOWN_ERROR") + string);
            n = -1;
            return n;
        }
        if (bl) {
            if (bl2 || bl3) {
                try {
                    oracleWallet.open(string, OraclePKIGenFunc.getPassword(string2, bl6, "WALLET_PASSWORD_PROMPT"));
                }
                catch (Exception exception) {
                    System.out.println(exception.getLocalizedMessage());
                    System.out.println(a.getString("PKI-02003") + string);
                    n = -1;
                    return n;
                }
            }
            System.out.println(a.getString("PKI-02001") + string);
            n = -1;
            return n;
        }
        if (!bl4) {
            try {
                oracleWallet.create(OraclePKIGenFunc.getCreatePassword(string2, bl6), by);
                oracleWallet.saveAs(string, by);
            }
            catch (IOException iOException) {
                System.out.println("Unable to save wallet at " + string);
                n = -1;
                return n;
            }
            catch (Exception exception) {
                System.out.println("Unable to save wallet at " + string);
                n = -1;
                return n;
            }
        }
        if (bl2) {
            try {
                oracleWallet.saveSSO();
            }
            catch (IOException iOException) {
                System.out.println("Unable to save wallet at " + string);
                n = -1;
                return n;
            }
        }
        if (bl3) {
            try {
                oracleWallet.saveLSSO();
            }
            catch (IOException iOException) {
                System.out.println("Unable to save wallet at " + string);
                n = -1;
                return n;
            }
        }
        if (bl4) {
            try {
                oracleWallet.createSSO();
                oracleWallet.saveAs(string, by);
            }
            catch (IOException iOException) {
                System.out.println("Unable to create auto-login-only wallet: " + iOException.toString());
                if (OraclePKIDebug.getDebugFlag()) {
                    iOException.printStackTrace();
                }
                n = -1;
                return n;
            }
            catch (Exception exception) {
                System.out.println("Unable to save wallet at " + string);
                n = -1;
                return n;
            }
        }
        System.out.println(a.getString("SUCCESSFUL_OPERATION"));
        return n;
    }

    public static int display(String[] stringArray) {
        boolean bl = true;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        boolean bl3 = false;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-summary")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-complete")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl3 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        OracleWallet oracleWallet = null;
        KeyStore keyStore = null;
        OracleSecretStore oracleSecretStore = null;
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, bl3);
            keyStore = oracleWallet.getKeyStore();
            oracleSecretStore = oracleWallet.getSecretStore();
        }
        catch (Exception exception) {
            try {
                oracleWallet = new OracleWallet();
                oracleWallet.open(string, null);
                keyStore = oracleWallet.getKeyStore();
                oracleSecretStore = oracleWallet.getSecretStore();
                if (oracleWallet.isAutoLoginOnly()) {
                    System.out.println("Found Auto Login Only (ALO) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                } else {
                    System.out.println("Found Auto Login (AL) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                }
            }
            catch (Exception exception2) {
                System.out.println(exception.getLocalizedMessage());
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                n = -1;
                return n;
            }
        }
        if (bl) {
            Object object;
            try {
                object = oracleWallet.getPkcs11Info();
                if (object != null && object[0] != null) {
                    System.out.println("PKCS11 token information:");
                    System.out.println("  Library:" + object[0]);
                    if (object[1] != null) {
                        System.out.println("  Token label:" + object[1]);
                    }
                    if (object[2] != null) {
                        System.out.println("  Token passphrase:<...>");
                    }
                    if (object[3] != null) {
                        System.out.println("  Certificate label:" + object[3]);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println(a.getString("GEN_UNKNOWN_ERROR") + string);
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                n = -1;
                return n;
            }
            object = null;
            try {
                object = oracleWallet.getMapTrustFlagsValue();
            }
            catch (Exception exception) {
                System.out.println(exception.getLocalizedMessage());
                System.out.println(a.getString("PKI-02003") + string + exception);
                n = -1;
                return n;
            }
            try {
                String string3;
                Object object2;
                Object object3;
                Object object4;
                System.out.println("Requested Certificates: ");
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    object4 = enumeration.nextElement();
                    if (!keyStore.isKeyEntry((String)object4) || keyStore.getCertificate((String)object4) != null) continue;
                    object3 = null;
                    object2 = keyStore.getKey((String)object4, null);
                    if (object2.getAlgorithm().equals("RSA")) {
                        object3 = ((OraclePKIRSAPrivateKey)object2).getCertificateRequest();
                    } else if (object2.getAlgorithm().equals("EC")) {
                        object3 = ((OraclePKIECPrivateKey)object2).getCertificateRequest();
                    }
                    if (object3 == null) continue;
                    string3 = ((CertificateRequest)object3).getSubject().toString();
                    string3 = string3.replaceAll("EmailAddress=", "EMAIL=");
                    System.out.println("Subject:        " + string3);
                    if (!bl2) continue;
                    System.out.println("Key Length:     " + ((CertificateRequest)object3).getPublicKey().getBitLength());
                    System.out.println("");
                }
                System.out.println("User Certificates:");
                enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    object4 = enumeration.nextElement();
                    if (!keyStore.isKeyEntry((String)object4) || (object3 = (OraclePKIX509CertImpl)keyStore.getCertificate((String)object4)) == null) continue;
                    object2 = ((OraclePKIX509CertImpl)object3).getSubjectDN().toString();
                    object2 = ((String)object2).replaceAll("EmailAddress=", "EMAIL=");
                    System.out.println("Subject:        " + (String)object2);
                    if (!bl2) continue;
                    string3 = ((OraclePKIX509CertImpl)object3).getIssuerDN().toString();
                    string3 = string3.replaceAll("EmailAddress=", "EMAIL=");
                    System.out.println("Issuer:         " + string3);
                    System.out.println("Serial Number:  " + ((OraclePKIX509CertImpl)object3).getHexSerialNumber());
                    System.out.println("Key Length      " + ((OraclePKIX509CertImpl)object3).getPublicKeyLength());
                    if (TransitionMode.isFIPS140ModeEnabled()) {
                        System.out.println("SHA-256 digest: " + ((OraclePKIX509CertImpl)object3).getSHA256Digest());
                    } else {
                        System.out.println("MD5 digest:     " + ((OraclePKIX509CertImpl)object3).getMD5Digest());
                    }
                    System.out.println("SHA digest:     " + ((OraclePKIX509CertImpl)object3).getSHADigest());
                    System.out.println();
                }
                object4 = oracleWallet.getSecretStore().internalAliases();
                if (object4.hasMoreElements()) {
                    System.out.println(a.getString("ENTRIES_LIST"));
                }
                while (object4.hasMoreElements()) {
                    System.out.println(object4.nextElement());
                }
                System.out.println("Trusted Certificates: ");
                enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String string4;
                    object3 = enumeration.nextElement();
                    if (!keyStore.isCertificateEntry((String)object3)) continue;
                    object2 = (OraclePKIX509CertImpl)keyStore.getCertificate((String)object3);
                    string3 = ((OraclePKIX509CertImpl)object2).getSubjectDN().toString();
                    string3 = string3.replaceAll("EmailAddress=", "EMAIL=");
                    System.out.println("Subject:        " + string3);
                    if (object != null && ((HashMap)object).size() > 0) {
                        string4 = "";
                        String string5 = "";
                        string5 = CertType.a.b() + ((OraclePKIX509CertImpl)object2).getSubjectDN().toString() + ((OraclePKIX509CertImpl)object2).getIssuerDN().toString() + ((OraclePKIX509CertImpl)object2).getSerialNumber().toString();
                        string4 = (String)((HashMap)object).get(string5);
                        if (string4 != null && !"".equals(string4)) {
                            System.out.println(a.getString("GEN_TRUSTFLAGS_OUT") + string4);
                        }
                    }
                    if (!bl2) continue;
                    string4 = ((OraclePKIX509CertImpl)object2).getIssuerDN().toString();
                    string4 = string4.replaceAll("EmailAddress=", "EMAIL=");
                    System.out.println("Issuer:         " + string4);
                    System.out.println("Serial Number:  " + ((OraclePKIX509CertImpl)object2).getHexSerialNumber());
                    System.out.println("Key Length      " + ((OraclePKIX509CertImpl)object2).getPublicKeyLength());
                    if (TransitionMode.isFIPS140ModeEnabled()) {
                        System.out.println("SHA-256 digest: " + ((OraclePKIX509CertImpl)object2).getSHA256Digest());
                    } else {
                        System.out.println("MD5 digest:     " + ((OraclePKIX509CertImpl)object2).getMD5Digest());
                    }
                    System.out.println("SHA digest:     " + ((OraclePKIX509CertImpl)object2).getSHADigest());
                    System.out.println();
                }
            }
            catch (Exception exception) {
                System.out.println(a.getString("GEN_UNKNOWN_ERROR") + string + exception);
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                n = -1;
                return n;
            }
        }
        return n;
    }

    public static int change_pwd(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-oldpwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-newpwd")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd_old")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-obpwd_new")) {
                    bl2 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        char[] cArray = OraclePKIGenFunc.getPassword(string2, bl, "WALLET_PASSWORD_PROMPT");
        char[] cArray2 = OraclePKIGenFunc.getPassword(string3, bl2, "WALLET_NEW_PASSWORD_PROMPT");
        char[] cArray3 = OraclePKIGenFunc.getPassword(string3, bl2, "WALLET_CONFIRM_PASSWORD_PROMPT");
        if (!Arrays.equals(cArray3, cArray2)) {
            System.out.println("Unable to change the password, the passwords did not match.");
            n = -1;
            return n;
        }
        if (!OracleWallet.isValidPassword(cArray2)) {
            System.out.println(a.getString("PKI-01002"));
            n = -1;
            return n;
        }
        if (Arrays.equals(cArray, cArray2)) {
            System.out.println("Unable to change the password, old and new password should not be same.");
            n = -1;
            return n;
        }
        OracleWallet oracleWallet = new OracleWallet();
        try {
            oracleWallet.open(string, cArray);
            oracleWallet.changePassword(cArray2);
            oracleWallet.saveAs(string);
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            System.out.println(a.getString("PKI-02003") + string);
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            n = -1;
            return n;
        }
        System.out.println(a.getString("WALLET_PASSWORD_CHANGED"));
        return n;
    }

    public static int p11_verify(String[] stringArray) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        char[] cArray = OraclePKIGenFunc.getPassword(string2, bl, "WALLET_PASSWORD_PROMPT");
        int n2 = 0;
        try {
            n2 = NZNative.Pkcs11Verify("file:" + string, new String(cArray));
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            System.out.println(a.getString("PKI-02003") + string);
            System.out.println("Error: " + n2);
            n = -1;
            return n;
        }
        return n;
    }

    public static int p11_add(String[] stringArray) {
        OracleWallet oracleWallet;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-p11_lib")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-p11_tokenlabel")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-p11_tokenpw")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-p11_certlabel")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        char[] cArray = OraclePKIGenFunc.getPassword(string6, bl, "WALLET_PASSWORD_PROMPT");
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string6, bl, true);
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            System.out.println(a.getString("PKI-02003") + string);
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            n = -1;
            return n;
        }
        try {
            if (string2 == null) {
                System.out.println("pkcs11 library location is required");
                n = -1;
                return n;
            }
            oracleWallet.addP11Lib(string2);
            if (string3 != null) {
                oracleWallet.addP11TokenLabel(string3);
            }
            if (string4 != null) {
                oracleWallet.addP11TokenPwd(string4);
            }
            if (string5 != null) {
                oracleWallet.addP11CertLbl(string5);
            }
            oracleWallet.saveAs(string);
        }
        catch (Exception exception) {
            System.out.println("Add pkcs11 info to wallet failed: " + exception.toString());
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            n = -1;
        }
        return n;
    }

    public static int replace(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string6 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        String string7 = null;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-issuer_dn")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-serial_num")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-cert")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-trusted_cert")) {
                    bl = true;
                    bl2 = false;
                    continue;
                }
                if (stringArray[i].equals("-user_cert")) {
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-trust_flags")) {
                    if (OracleTrustFlagHelper.validateTrustFlags(string6 = stringArray[++i])) continue;
                    System.out.println(a.getString("PKI-04021"));
                    System.out.println(b);
                    n = -1;
                    return n;
                }
                if (stringArray[i].equals("-pwd")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equals("-auto_login_only")) {
                    bl4 = true;
                    continue;
                }
                if (stringArray[i].equals("-alias")) {
                    string7 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        if (bl4 && string5 != null) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            block47: {
                OracleWallet oracleWallet;
                block46: {
                    try {
                        oracleWallet = OraclePKIGenFunc.openAWallet(string, string5, bl3, true);
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getLocalizedMessage());
                        System.out.println(a.getString("PKI-02003") + string);
                        if (OraclePKIDebug.getDebugFlag()) {
                            exception.printStackTrace();
                        }
                        n = -1;
                        return n;
                    }
                    if (oracleWallet.isAutoLoginOnly() && !bl4 || !oracleWallet.isAutoLoginOnly() && bl4) {
                        System.out.println(b);
                        n = -1;
                        return n;
                    }
                    if (string4 != null) {
                        try {
                            InputStream inputStream;
                            try {
                                inputStream = new URL(string4).openStream();
                            }
                            catch (MalformedURLException malformedURLException) {
                                inputStream = new FileInputStream(string4);
                            }
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            int n2 = inputStream.read();
                            while (n2 != -1) {
                                byteArrayOutputStream.write((byte)n2);
                                n2 = inputStream.read();
                            }
                            if (bl) {
                                try {
                                    if (oracleWallet.areTrustFlagsEnabled() && string6 == null) {
                                        string6 = OraclePKIMsgID.bf;
                                    } else if (!oracleWallet.areTrustFlagsEnabled() && string6 != null) {
                                        throw new Exception(a.getString("PKI-02015"));
                                    }
                                    if (string7 != null) {
                                        oracleWallet.replaceTrustpoint(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), string7, string6);
                                    } else {
                                        oracleWallet.replaceTrustpoint(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), string3, string2, string6);
                                    }
                                    break block46;
                                }
                                catch (Exception exception) {
                                    System.out.println(exception.getLocalizedMessage());
                                    if (OraclePKIDebug.getDebugFlag()) {
                                        exception.printStackTrace();
                                    }
                                    n = -1;
                                    return n;
                                }
                            }
                            if (bl2) {
                                try {
                                    if (string7 != null) {
                                        oracleWallet.replaceUserCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), string7);
                                    } else {
                                        oracleWallet.replaceUserCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), string3, string2);
                                    }
                                    break block46;
                                }
                                catch (Exception exception) {
                                    System.out.println(exception.getLocalizedMessage());
                                    if (OraclePKIDebug.getDebugFlag()) {
                                        exception.printStackTrace();
                                    }
                                    n = -1;
                                    return n;
                                }
                            }
                            System.out.println(b);
                            n = -1;
                            return n;
                        }
                        catch (IOException iOException) {
                            System.out.println("Unable to read certificate at " + string4);
                            n = -1;
                        }
                    } else {
                        System.out.println("Please provide : -cert [filename]");
                        n = -1;
                        return n;
                    }
                }
                try {
                    oracleWallet.saveAs(string);
                }
                catch (IOException iOException) {
                    System.out.println("Wallet save failed.");
                    if (!OraclePKIDebug.getDebugFlag()) break block47;
                    iOException.printStackTrace();
                }
            }
            return n;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            n = -1;
            return n;
        }
    }

    public static int p11_test(String[] stringArray) {
        int n;
        block13: {
            OracleWallet oracleWallet;
            boolean bl;
            String string;
            String string2;
            block12: {
                string2 = null;
                string = null;
                bl = false;
                n = 0;
                String string3 = "/usr/lunasa/lib/libCryptoki2.so";
                String string4 = "partition_1";
                String string5 = "....";
                if (stringArray.length == 0) {
                    System.out.println(b);
                    n = -1;
                    return n;
                }
                try {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].equals("-wallet")) {
                            string2 = stringArray[++i];
                            continue;
                        }
                        if (stringArray[i].equals("-pwd")) {
                            string = stringArray[++i];
                            continue;
                        }
                        if (stringArray[i].equals("-obpwd")) {
                            bl = true;
                            continue;
                        }
                        System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                        System.out.println(b);
                        n = -1;
                        return n;
                    }
                }
                catch (Exception exception) {
                    System.out.println("pkcs11 test failed: " + exception.toString());
                    if (!OraclePKIDebug.getDebugFlag()) break block12;
                    exception.printStackTrace();
                }
            }
            char[] cArray = OraclePKIGenFunc.getPassword(string, bl, "WALLET_PASSWORD_PROMPT");
            try {
                oracleWallet = OraclePKIGenFunc.openAWallet(string2, string, bl);
            }
            catch (Exception exception) {
                System.out.println(exception.getLocalizedMessage());
                System.out.println(a.getString("PKI-02003") + string2);
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                n = -1;
                return n;
            }
            try {
                X509Certificate x509Certificate = oracleWallet.getSSLCert(true);
                byte[] byArray = x509Certificate.getEncoded();
                String string6 = oracleWallet.getSSLCertAlias(true);
                byte[] byArray2 = oracleWallet.getPPvtBytesUnEnc(0, string6);
                oracleWallet.removePrivateKey(string6);
                oracleWallet.saveAs(string2);
            }
            catch (Exception exception) {
                System.out.println("Add pvt key to HSM failed: " + exception.toString());
                if (!OraclePKIDebug.getDebugFlag()) break block13;
                exception.printStackTrace();
            }
        }
        return n;
    }

    public static int test_api(String[] stringArray) {
        boolean bl = false;
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-auto_login")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl2 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            Object object;
            OracleWallet oracleWallet;
            OracleWallet oracleWallet2 = OraclePKIGenFunc.openAWallet(string, string2, bl2);
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            if (string2 != null) {
                inputStream = oracleWallet2.getWalletArray(false);
                inputStream2 = oracleWallet2.getWalletArray(true);
            } else {
                inputStream2 = oracleWallet2.getWalletArray(true);
            }
            if (string2 != null) {
                oracleWallet = new OracleWallet();
                oracleWallet.setWalletArray(inputStream, string2.toCharArray());
            }
            oracleWallet = new OracleWallet();
            oracleWallet.setWalletArray(inputStream2, null);
            boolean bl3 = oracleWallet.isAutoLoginOnly();
            if (bl3) {
                System.out.println("Wallet is auto login only (ALO).");
            } else {
                System.out.println("Wallet is not auto login only (ALO).");
            }
            int n2 = oracleWallet.getPersonaCount();
            X500Principal[] x500PrincipalArray = oracleWallet.getCertReqDNs(0);
            System.out.println("Number of certificate requests in wallet:" + oracleWallet.getCertReqCount(0));
            for (int i = 0; i < x500PrincipalArray.length; ++i) {
                String[] stringArray2 = oracleWallet.getCertReqInfo(0, i);
                System.out.println("   DN:" + stringArray2[0] + ", keysize:" + stringArray2[1] + " bytes,  keytype:" + stringArray2[2]);
            }
            X500Principal[] x500PrincipalArray2 = oracleWallet.getCertDNs(0);
            System.out.println("Number of certs in wallet:" + oracleWallet.getCertCount(0));
            for (int i = 0; i < x500PrincipalArray2.length; ++i) {
                X509Certificate x509Certificate = oracleWallet.getCert(0, i);
                System.out.println("  " + x509Certificate.getSubjectX500Principal());
            }
            X500Principal[] x500PrincipalArray3 = oracleWallet.getTrustpointDNs(0);
            System.out.println("Number of trusted certs in wallet:" + oracleWallet.getTrustpointCount(0));
            for (int i = 0; i < x500PrincipalArray3.length; ++i) {
                object = oracleWallet.getTrustpoint(0, i);
                System.out.println("  " + ((X509Certificate)object).getSubjectX500Principal());
            }
            X509Certificate x509Certificate = oracleWallet.getSSLCert(false);
            if (x509Certificate != null) {
                System.out.println("During SSL cert with DN \"" + x509Certificate.getSubjectDN() + "\" will be used");
            } else {
                System.out.println("No SSL cert found in wallet.");
            }
            object = "-----BEGIN CERTIFICATE-----\nMIIBKzCB1gIBADANBgkqhkiG9w0BAQQFADAhMQswCQYDVQQGEwJVUzESMBAGA1UEAwwJcm9vdF90\nZXN0MB4XDTA2MDQyNzE5MTM1N1oXDTE2MDQyNDE5MTM1N1owITELMAkGA1UEBhMCVVMxEjAQBgNV\nBAMMCXRlc3RfdGVzdDBcMA0GCSqGSIb3DQEBAQUAA0sAMEgCQQCd8QhmcTRmq9/GN+xATEZsQC7C\nnvkOl8Mfy5qXClyU/UdMFBZPC3oCylxjdekg286Kjlf3UPKHYkMg8EHk6ULZAgMBAAEwDQYJKoZI\nhvcNAQEEBQADQQBlEVBYPyavz07/8NrgbEMYJpQ/r1D517w1eVx6XqUpW64rEYV1aBYh73yyTleN\n4FTnoda3JkKujFFaYVBWAogA\n-----END CERTIFICATE-----";
            String string3 = OraclePKIX509CertHelper.removeCertHeaderFooter((String)object);
            String string4 = OraclePKIX509CertHelper.addCertHeaderFooter(string3);
            OracleWallet oracleWallet3 = new OracleWallet();
            oracleWallet3.createSSO();
            oracleWallet3.importCert(new ByteArrayInputStream(string4.getBytes()), true);
            String string5 = "-----BEGIN NEW CERTIFICATE REQUEST-----\nMIHbMIGGAgEAMCExCzAJBgNVBAYTAlVTMRIwEAYDVQQDDAl0ZXN0X3Rlc3QwXDANBgkqhkiG9w0B\nAQEFAANLADBIAkEAnfEIZnE0ZqvfxjfsQExGbEAuwp75DpfDH8ualwpclP1HTBQWTwt6AspcY3Xp\nINvOio5X91Dyh2JDIPBB5OlC2QIDAQABoAAwDQYJKoZIhvcNAQEEBQADQQAo3oNVwcYy4yhXMHIc\n7u8E2u8zJkTYRgZ7S7W1D0QutglTMbvB+wmeMkgQEPqM4M3NUg3z0VsgVxA0eizUhCWt\n-----END NEW CERTIFICATE REQUEST-----";
            String string6 = OraclePKIX509CertReqHelper.removeCertReqHeaderFooter(string5);
            String string7 = OraclePKIX509CertReqHelper.addCertReqHeaderFooter(string6);
            OraclePKIX509CertReqHelper.readB64CertReqFrom(new StringReader(string7));
        }
        catch (Exception exception) {
            System.out.println("test_api failed: " + exception.toString());
            n = -1;
            return n;
        }
        return n;
    }

    public static int remove(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-dn")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-trusted_cert_all")) {
                    bl = true;
                    bl2 = false;
                    bl3 = false;
                    bl4 = false;
                    continue;
                }
                if (stringArray[i].equals("-trusted_cert")) {
                    bl = false;
                    bl2 = true;
                    bl3 = false;
                    bl4 = false;
                    continue;
                }
                if (stringArray[i].equals("-user_cert")) {
                    bl = false;
                    bl2 = false;
                    bl3 = true;
                    bl4 = false;
                    continue;
                }
                if (stringArray[i].equals("-cert_req")) {
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                    bl4 = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl5 = true;
                    continue;
                }
                if (stringArray[i].equals("-auto_login_only")) {
                    bl6 = true;
                    continue;
                }
                if (stringArray[i].equals("-alias")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-issuer_dn")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-serial_num")) {
                    string6 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        if (bl6 && string3 != null) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            OracleWallet oracleWallet;
            try {
                oracleWallet = OraclePKIGenFunc.openAWallet(string, string3, bl5, true);
            }
            catch (Exception exception) {
                System.out.println(exception.getLocalizedMessage());
                System.out.println(a.getString("PKI-02003") + string);
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                n = -1;
                return n;
            }
            if (oracleWallet.isAutoLoginOnly() && !bl6 || !oracleWallet.isAutoLoginOnly() && bl6) {
                System.out.println(b);
                n = -1;
                return n;
            }
            if (bl) {
                try {
                    oracleWallet.removeTrustpoints();
                }
                catch (Exception exception) {
                    System.out.println(exception.getLocalizedMessage());
                    if (OraclePKIDebug.getDebugFlag()) {
                        exception.printStackTrace();
                    }
                    n = -1;
                    return n;
                }
            } else if (bl2) {
                try {
                    if (string2 != null) {
                        oracleWallet.removeTrustpoint(new X500Principal(string2), string5, string6);
                    }
                    if (string4 != null) {
                        oracleWallet.removeTrustpoint(string4);
                    }
                    System.out.println("Please provide DN or alias");
                    n = -1;
                    return n;
                }
                catch (Exception exception) {
                    System.out.println(exception.getLocalizedMessage());
                    if (OraclePKIDebug.getDebugFlag()) {
                        exception.printStackTrace();
                    }
                    n = -1;
                    return n;
                }
            } else if (bl3) {
                try {
                    if (string2 != null) {
                        oracleWallet.deleteCert(new X500Principal(string2), string5, string6);
                    }
                    if (string4 != null) {
                        oracleWallet.deleteCert(string4);
                    }
                    System.out.println("Please provide DN or alias");
                    n = -1;
                    return n;
                }
                catch (Exception exception) {
                    System.out.println(exception.getLocalizedMessage());
                    if (OraclePKIDebug.getDebugFlag()) {
                        exception.printStackTrace();
                    }
                    n = -1;
                    return n;
                }
            } else if (bl4) {
                try {
                    if (string2 != null) {
                        oracleWallet.deleteCertReq(new X500Principal(string2));
                    }
                    if (string4 != null) {
                        oracleWallet.deleteCertReq(string4);
                    }
                    System.out.println("Please provide DN or alias");
                    n = -1;
                    return n;
                }
                catch (Exception exception) {
                    System.out.println(exception.getLocalizedMessage());
                    if (OraclePKIDebug.getDebugFlag()) {
                        exception.printStackTrace();
                    }
                    n = -1;
                    return n;
                }
            } else {
                System.out.println(b);
                n = -1;
                return n;
            }
            try {
                oracleWallet.saveAs(string);
            }
            catch (IOException iOException) {
                System.out.println("Wallet save failed.");
                if (OraclePKIDebug.getDebugFlag()) {
                    iOException.printStackTrace();
                }
                n = -1;
                return n;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            n = -1;
            return n;
        }
        System.out.println(a.getString("SUCCESSFUL_OPERATION"));
        return n;
    }

    public static int verifychain(String[] stringArray) {
        Object object;
        OracleWallet oracleWallet;
        String string = null;
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl2 = false;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-dn")) {
                string5 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-trustchain")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-cert")) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-obpwd")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-lowestTp")) {
                bl2 = true;
                continue;
            }
            System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, bl);
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            System.out.println(a.getString("PKI-02003"));
            n = -1;
            return n;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = new FileInputStream(string3);
            int n2 = ((InputStream)object).read();
            while (n2 != -1) {
                byteArrayOutputStream.write((byte)n2);
                n2 = ((InputStream)object).read();
            }
        }
        catch (IOException iOException) {
            System.out.println("Unable to read cert chain at " + string3);
            n = -1;
            return n;
        }
        try {
            object = oracleWallet.trustpointNeededB64(byteArrayOutputStream.toString(), string5, bl2);
            if (object == null) {
                System.out.println("Matching trustpoint exists in wallet.");
                n = -1;
                return n;
            }
            FileWriter fileWriter = new FileWriter(string4);
            fileWriter.write((String)object);
            fileWriter.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = -1;
            return n;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int add(String[] stringArray) {
        int n;
        block165: {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            String string11 = null;
            boolean bl4 = false;
            boolean bl5 = false;
            String string12 = null;
            String string13 = null;
            String string14 = null;
            BigInteger bigInteger = null;
            boolean bl6 = false;
            int n2 = 0;
            boolean bl7 = false;
            String string15 = null;
            boolean bl8 = false;
            String string16 = null;
            String string17 = null;
            String string18 = null;
            n = 0;
            ArrayList<GeneralName> arrayList = null;
            if (stringArray.length == 0) {
                System.out.println(b);
                return -1;
            }
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("-wallet")) {
                        string = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-asym_alg")) {
                        string2 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-dn")) {
                        string3 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-keysize")) {
                        string4 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-eccurve")) {
                        string5 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-validity")) {
                        string6 = stringArray[++i];
                        try {
                            n2 = Integer.parseInt(string6);
                            if (n2 <= 0) {
                                throw new NumberFormatException("");
                            }
                            if (n2 <= 182500) continue;
                            System.out.println("Validity should not be more than 182500 days.");
                            return -1;
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Validity must be a positive integer.");
                            return -1;
                        }
                    }
                    if (stringArray[i].equals("-valid_from")) {
                        string7 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-valid_until")) {
                        string8 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-self_signed")) {
                        bl = true;
                        continue;
                    }
                    if (stringArray[i].equals("-request")) {
                        string9 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-cert")) {
                        string10 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-trusted_cert")) {
                        bl2 = true;
                        bl3 = false;
                        continue;
                    }
                    if (stringArray[i].equals("-user_cert")) {
                        bl2 = false;
                        bl3 = true;
                        continue;
                    }
                    if (stringArray[i].equals("-pwd")) {
                        string11 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-obpwd")) {
                        bl4 = true;
                        continue;
                    }
                    if (stringArray[i].equals("-trust_flags")) {
                        if (OracleTrustFlagHelper.validateTrustFlags(string14 = stringArray[++i])) continue;
                        System.out.println(a.getString("PKI-04021"));
                        System.out.println(b);
                        return -1;
                    }
                    if (stringArray[i].equals("-addext_ski")) {
                        bl7 = true;
                        continue;
                    }
                    if (stringArray[i].equals("-addext_ku")) {
                        string15 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-addext_basic_cons")) {
                        if (stringArray.length > i + 1 && stringArray[i + 1].equalsIgnoreCase("CA")) {
                            ++i;
                            bl8 = true;
                            string16 = null;
                            continue;
                        }
                        if (stringArray.length > i + 1 && stringArray[i + 1].equalsIgnoreCase("-pathLen")) {
                            ++i;
                            bl8 = true;
                            string16 = stringArray[++i];
                            continue;
                        }
                        bl8 = false;
                        string16 = "0";
                        continue;
                    }
                    if (stringArray[i].equals("-addext_san")) {
                        if (null == stringArray[++i] || (arrayList = OraclePKIGenFunc.a(stringArray[i])) != null) continue;
                        return -1;
                    }
                    if (stringArray[i].equals("-auto_login_only")) {
                        bl5 = true;
                        continue;
                    }
                    if (stringArray[i].equals("-serial_file")) {
                        string12 = stringArray[++i];
                        bigInteger = OraclePKIGenFunc.getSerialNum(string12);
                        bigInteger = bigInteger.add(BigInteger.ONE);
                        bl6 = true;
                        continue;
                    }
                    if (stringArray[i].equals("-serial_num")) {
                        string13 = stringArray[++i];
                        bigInteger = OraclePKIGenFunc.calculateSerialNumber(string13);
                        bl6 = true;
                        continue;
                    }
                    if (stringArray[i].equals("-alias")) {
                        string17 = stringArray[++i];
                        continue;
                    }
                    if (!stringArray[i].equals("-sign_alg")) {
                        System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                        System.out.println(b);
                        return -1;
                    }
                    if (!SignatureAlgorithms.c(stringArray[++i])) {
                        System.out.println("Unsupported Signature Algorithm - " + stringArray[i]);
                        return -1;
                    }
                    string18 = stringArray[i];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println(b);
                return -1;
            }
            if (string4 != null && string5 != null) {
                System.out.println(a.getString("PKI-01004"));
                return -1;
            }
            if (string11 != null && bl5) {
                System.out.println(b);
                return -1;
            }
            if (bl && bl6 && bigInteger == null) {
                System.out.println("Serial number should not be null....");
                return -1;
            }
            try {
                block176: {
                    OracleWallet oracleWallet;
                    block168: {
                        try {
                            oracleWallet = OraclePKIGenFunc.openAWallet(string, string11, bl4, true);
                        }
                        catch (Exception exception) {
                            System.out.println(exception.getLocalizedMessage());
                            System.out.println(a.getString("PKI-02003") + string);
                            if (!OraclePKIDebug.getDebugFlag()) return -1;
                            exception.printStackTrace();
                            return -1;
                        }
                        if (oracleWallet.isAutoLoginOnly() && !bl5 || !oracleWallet.isAutoLoginOnly() && bl5) {
                            System.out.println(b);
                            return -1;
                        }
                        if (!bl) break block168;
                        if (string7 == null && string8 != null || string7 != null && string8 == null || string7 == null && string8 == null && string6 == null || string7 != null && string8 != null && string6 != null) {
                            System.out.println("Please specify [-validity] alone OR both [-valid_from] and [-valid_until]");
                            return -1;
                        }
                        if (string18 != null) {
                            oracleWallet.setCertSignAlgorithm(string18);
                        }
                        int n3 = 0;
                        boolean bl9 = true;
                        if (string2 == null || string2.equals("RSA")) {
                            if (string4 == null) {
                                throw new IOException(a.getString("PKI-070010"));
                            }
                            n3 = Integer.parseInt(string4);
                        } else if (string2.equals("ECC")) {
                            if (string5 == null) {
                                throw new IOException(a.getString("PKI-07011"));
                            }
                            bl9 = false;
                        }
                        try {
                            block164: {
                                block175: {
                                    block173: {
                                        OracleCertExtension oracleCertExtension;
                                        block174: {
                                            block169: {
                                                Date date;
                                                Date date2;
                                                block172: {
                                                    block170: {
                                                        OracleCertExtension oracleCertExtension2;
                                                        block171: {
                                                            if (n2 != 0) break block169;
                                                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
                                                            date2 = simpleDateFormat.parse(string7, new ParsePosition(0));
                                                            date = simpleDateFormat.parse(string8, new ParsePosition(0));
                                                            if (date2 == null || date == null) {
                                                                System.out.println("Please follow the format [mm/dd/yyyy] for valid_from and valid_until");
                                                                return -1;
                                                            }
                                                            if (!bl7 && string15 == null && !bl8 && string16 == null && null == arrayList) break block170;
                                                            oracleCertExtension2 = new OracleCertExtension();
                                                            if (bl7) {
                                                                oracleCertExtension2.setSubjectKeyId(true);
                                                            }
                                                            if (string15 != null) {
                                                                oracleCertExtension2.setKeyUsage(string15);
                                                            }
                                                            if (bl8) {
                                                                oracleCertExtension2.setBasicConstraints(bl8);
                                                            }
                                                            if (string16 != null) {
                                                                oracleCertExtension2.setBasicConstraints(string16);
                                                            }
                                                            if (null != arrayList) {
                                                                oracleCertExtension2.setSubjectAlternativeNamesList(arrayList);
                                                            }
                                                            if (bl6) break block171;
                                                            if (string17 == null) {
                                                                if (bl9) {
                                                                    oracleWallet.createSelfSigned(new X500Principal(string3), n3, date2, date, new BigInteger(128, JCEUtil.getSecureRandom()), oracleCertExtension2);
                                                                    break block164;
                                                                } else {
                                                                    oracleWallet.createSelfSigned(new X500Principal(string3), string5, date2, date, new BigInteger(128, JCEUtil.getSecureRandom()), oracleCertExtension2);
                                                                }
                                                                break block164;
                                                            } else if (bl9) {
                                                                oracleWallet.createSelfSigned(new X500Principal(string3), n3, date2, date, new BigInteger(128, JCEUtil.getSecureRandom()), oracleCertExtension2, string17);
                                                                break block164;
                                                            } else {
                                                                oracleWallet.createSelfSigned(new X500Principal(string3), string5, date2, date, new BigInteger(128, JCEUtil.getSecureRandom()), oracleCertExtension2, string17);
                                                            }
                                                            break block164;
                                                        }
                                                        if (string17 == null) {
                                                            if (bl9) {
                                                                oracleWallet.createSelfSigned(new X500Principal(string3), n3, date2, date, bigInteger, oracleCertExtension2);
                                                                break block164;
                                                            } else {
                                                                oracleWallet.createSelfSigned(new X500Principal(string3), string5, date2, date, bigInteger, oracleCertExtension2);
                                                            }
                                                            break block164;
                                                        } else if (bl9) {
                                                            oracleWallet.createSelfSigned(new X500Principal(string3), n3, date2, date, bigInteger, oracleCertExtension2, string17);
                                                            break block164;
                                                        } else {
                                                            oracleWallet.createSelfSigned(new X500Principal(string3), string5, date2, date, bigInteger, oracleCertExtension2, string17);
                                                        }
                                                        break block164;
                                                    }
                                                    if (bl6) break block172;
                                                    if (string17 == null) {
                                                        if (bl9) {
                                                            oracleWallet.createSelfSigned(new X500Principal(string3), n3, date2, date);
                                                            break block164;
                                                        } else {
                                                            oracleWallet.createSelfSigned(new X500Principal(string3), string5, date2, date);
                                                        }
                                                        break block164;
                                                    } else if (bl9) {
                                                        oracleWallet.createSelfSigned(new X500Principal(string3), n3, date2, date, new BigInteger(128, JCEUtil.getSecureRandom()), string17);
                                                        break block164;
                                                    } else {
                                                        oracleWallet.createSelfSigned(new X500Principal(string3), string5, date2, date, new BigInteger(128, JCEUtil.getSecureRandom()), string17);
                                                    }
                                                    break block164;
                                                }
                                                if (string17 == null) {
                                                    if (bl9) {
                                                        oracleWallet.createSelfSigned(new X500Principal(string3), n3, date2, date, bigInteger);
                                                        break block164;
                                                    } else {
                                                        oracleWallet.createSelfSigned(new X500Principal(string3), string5, date2, date, bigInteger);
                                                    }
                                                    break block164;
                                                } else if (bl9) {
                                                    oracleWallet.createSelfSigned(new X500Principal(string3), n3, date2, date, bigInteger, string17);
                                                    break block164;
                                                } else {
                                                    oracleWallet.createSelfSigned(new X500Principal(string3), string5, date2, date, bigInteger, string17);
                                                }
                                                break block164;
                                            }
                                            if (!bl7 && string15 == null && !bl8 && string16 == null && null == arrayList) break block173;
                                            oracleCertExtension = new OracleCertExtension();
                                            if (bl7) {
                                                oracleCertExtension.setSubjectKeyId(true);
                                            }
                                            if (string15 != null) {
                                                oracleCertExtension.setKeyUsage(string15);
                                            }
                                            if (bl8) {
                                                oracleCertExtension.setBasicConstraints(bl8);
                                            }
                                            if (string16 != null) {
                                                oracleCertExtension.setBasicConstraints(string16);
                                            }
                                            if (null != arrayList) {
                                                oracleCertExtension.setSubjectAlternativeNamesList(arrayList);
                                            }
                                            if (bl6) break block174;
                                            if (string17 == null) {
                                                if (bl9) {
                                                    oracleWallet.createSelfSigned(new X500Principal(string3), n3, n2, new BigInteger(128, JCEUtil.getSecureRandom()), oracleCertExtension);
                                                    break block164;
                                                } else {
                                                    oracleWallet.createSelfSigned(new X500Principal(string3), string5, n2, new BigInteger(128, JCEUtil.getSecureRandom()), oracleCertExtension);
                                                }
                                                break block164;
                                            } else if (bl9) {
                                                oracleWallet.createSelfSigned(new X500Principal(string3), n3, n2, new BigInteger(128, JCEUtil.getSecureRandom()), oracleCertExtension, string17);
                                                break block164;
                                            } else {
                                                oracleWallet.createSelfSigned(new X500Principal(string3), string5, n2, new BigInteger(128, JCEUtil.getSecureRandom()), oracleCertExtension, string17);
                                            }
                                            break block164;
                                        }
                                        if (string17 == null) {
                                            if (bl9) {
                                                oracleWallet.createSelfSigned(new X500Principal(string3), n3, n2, bigInteger, oracleCertExtension);
                                                break block164;
                                            } else {
                                                oracleWallet.createSelfSigned(new X500Principal(string3), string5, n2, bigInteger, oracleCertExtension);
                                            }
                                            break block164;
                                        } else if (bl9) {
                                            oracleWallet.createSelfSigned(new X500Principal(string3), n3, n2, bigInteger, oracleCertExtension, string17);
                                            break block164;
                                        } else {
                                            oracleWallet.createSelfSigned(new X500Principal(string3), string5, n2, bigInteger, oracleCertExtension, string17);
                                        }
                                        break block164;
                                    }
                                    if (bl6) break block175;
                                    if (string17 == null) {
                                        if (bl9) {
                                            oracleWallet.createSelfSigned(new X500Principal(string3), n3, n2);
                                            break block164;
                                        } else {
                                            oracleWallet.createSelfSigned(new X500Principal(string3), string5, n2);
                                        }
                                        break block164;
                                    } else if (bl9) {
                                        oracleWallet.createSelfSigned(new X500Principal(string3), n3, n2, new BigInteger(128, JCEUtil.getSecureRandom()), string17);
                                        break block164;
                                    } else {
                                        oracleWallet.createSelfSigned(new X500Principal(string3), string5, n2, new BigInteger(128, JCEUtil.getSecureRandom()), string17);
                                    }
                                    break block164;
                                }
                                if (string17 == null) {
                                    if (bl9) {
                                        oracleWallet.createSelfSigned(new X500Principal(string3), n3, n2, bigInteger);
                                    } else {
                                        oracleWallet.createSelfSigned(new X500Principal(string3), string5, n2, bigInteger);
                                    }
                                } else if (bl9) {
                                    oracleWallet.createSelfSigned(new X500Principal(string3), n3, n2, bigInteger, string17);
                                } else {
                                    oracleWallet.createSelfSigned(new X500Principal(string3), string5, n2, bigInteger, string17);
                                }
                            }
                            if (oracleWallet.areTrustFlagsEnabled()) {
                                string14 = bl8 || string16 != null ? OraclePKIMsgID.ba : OraclePKIMsgID.bb;
                            } else if (!oracleWallet.areTrustFlagsEnabled() && string14 != null) {
                                throw new Exception(a.getString("PKI-02015"));
                            }
                            if (oracleWallet.areTrustFlagsEnabled()) {
                                if (!bl6) {
                                    oracleWallet.assignTrustFlagstoCertificate(string3, string3, null, string14);
                                } else {
                                    oracleWallet.assignTrustFlagstoCertificate(string3, string3, string13, string14);
                                }
                            }
                            oracleWallet.save();
                            if (string12 != null) {
                                OraclePKIGenFunc.updateSerialNum(string12, bigInteger);
                            }
                            break block165;
                        }
                        catch (Exception exception) {
                            System.out.println(exception.getLocalizedMessage());
                            if (!OraclePKIDebug.getDebugFlag()) return -1;
                            exception.printStackTrace();
                            return -1;
                        }
                    }
                    if (string10 != null) {
                        try {
                            InputStream inputStream;
                            try {
                                inputStream = new URL(string10).openStream();
                            }
                            catch (MalformedURLException malformedURLException) {
                                inputStream = new FileInputStream(string10);
                            }
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            int n4 = inputStream.read();
                            while (n4 != -1) {
                                byteArrayOutputStream.write((byte)n4);
                                n4 = inputStream.read();
                            }
                            if (bl2) {
                                try {
                                    if (!oracleWallet.areTrustFlagsEnabled() && string14 != null) {
                                        throw new Exception(a.getString("PKI-02015"));
                                    }
                                    if (oracleWallet.areTrustFlagsEnabled() && string14 == null) {
                                        string14 = OraclePKIMsgID.be;
                                    }
                                    if (string17 == null) {
                                        oracleWallet.importCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), true, null, string14);
                                    }
                                    oracleWallet.importCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), true, string17, string14);
                                }
                                catch (Exception exception) {
                                    System.out.println("Could not install trusted cert at" + string10);
                                    System.out.println(exception.getLocalizedMessage());
                                    if (!OraclePKIDebug.getDebugFlag()) return -1;
                                    exception.printStackTrace();
                                    return -1;
                                }
                            } else if (bl3) {
                                try {
                                    if (!oracleWallet.areTrustFlagsEnabled() && string14 != null) {
                                        throw new Exception(a.getString("PKI-02015"));
                                    }
                                    if (oracleWallet.areTrustFlagsEnabled()) {
                                        string14 = OraclePKIMsgID.bc;
                                    }
                                    if (string17 == null) {
                                        oracleWallet.importCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), false);
                                    } else {
                                        oracleWallet.importCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), false, string17, null);
                                    }
                                }
                                catch (Exception exception) {
                                    System.out.println(exception.getLocalizedMessage());
                                    System.out.println("Could not install user cert at" + string10);
                                    System.out.println("Please add all trusted certificates before adding the user certificate");
                                    return -1;
                                }
                            }
                            oracleWallet.saveAs(string);
                            break block165;
                        }
                        catch (IOException iOException) {
                            System.out.println("Unable to read certificate at " + string10);
                            return -1;
                        }
                    }
                    if (string3 == null) break block176;
                    int n5 = 0;
                    boolean bl10 = true;
                    if (string2 == null || string2.equals("RSA")) {
                        if (string4 == null) {
                            throw new IOException(a.getString("PKI-070010"));
                        }
                        n5 = Integer.parseInt(string4);
                    } else if (string2.equals("ECC")) {
                        if (string5 == null) {
                            throw new IOException(a.getString("PKI-07011"));
                        }
                        bl10 = false;
                    }
                    if (string18 != null) {
                        oracleWallet.setCertSignAlgorithm(string18);
                    }
                    try {
                        block167: {
                            block177: {
                                if (!bl7 && string15 == null && !bl8 && string16 == null && null == arrayList) break block177;
                                OracleCertExtension oracleCertExtension = new OracleCertExtension();
                                if (bl7) {
                                    oracleCertExtension.setSubjectKeyId(true);
                                }
                                if (string15 != null) {
                                    oracleCertExtension.setKeyUsage(string15);
                                }
                                if (bl8) {
                                    oracleCertExtension.setBasicConstraints(bl8);
                                }
                                if (string16 != null) {
                                    oracleCertExtension.setBasicConstraints(string16);
                                }
                                if (null != arrayList) {
                                    oracleCertExtension.setSubjectAlternativeNamesList(arrayList);
                                }
                                if (string17 == null) {
                                    if (bl10) {
                                        oracleWallet.addCertRequest(new X500Principal(string3), n5, oracleCertExtension);
                                        break block167;
                                    } else {
                                        oracleWallet.addCertRequest(new X500Principal(string3), string5, oracleCertExtension);
                                    }
                                    break block167;
                                } else if (bl10) {
                                    oracleWallet.addCertRequest(new X500Principal(string3), n5, oracleCertExtension, string17);
                                    break block167;
                                } else {
                                    oracleWallet.addCertRequest(new X500Principal(string3), string5, oracleCertExtension, string17);
                                }
                                break block167;
                            }
                            if (string17 == null) {
                                if (bl10) {
                                    oracleWallet.addCertRequest(new X500Principal(string3), n5);
                                } else {
                                    oracleWallet.addCertRequest(new X500Principal(string3), string5);
                                }
                            } else if (bl10) {
                                oracleWallet.addCertRequest(new X500Principal(string3), n5, string17);
                            } else {
                                oracleWallet.addCertRequest(new X500Principal(string3), string5, string17);
                            }
                        }
                        oracleWallet.saveAs(string);
                        break block165;
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getLocalizedMessage());
                        return -1;
                    }
                }
                if (string10 == null) {
                    // empty if block
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                return -1;
            }
        }
        System.out.println(a.getString("SUCCESSFUL_OPERATION"));
        return n;
    }

    public static int importPvtKey(String[] stringArray) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        char[] cArray = null;
        byte[] byArray = null;
        int n = 1000;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        int n2 = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n2 = -1;
            return n2;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-pvtkeyfile")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-alias")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pvtkeypwd")) {
                    cArray = stringArray[++i].toCharArray();
                    continue;
                }
                if (stringArray[i].equals("-salt")) {
                    byArray = stringArray[++i].getBytes();
                    continue;
                }
                if (stringArray[i].equals("-cert")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-cacert")) {
                    string7 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n2 = -1;
                return n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n2 = -1;
            return n2;
        }
        OracleWallet oracleWallet = null;
        Object var16_18 = null;
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, bl);
        }
        catch (Exception exception) {
            try {
                oracleWallet = new OracleWallet();
                oracleWallet.open(string, null);
                if (oracleWallet.isAutoLoginOnly()) {
                    System.out.println("Found Auto Login Only (ALO) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                } else {
                    System.out.println("Found Auto Login (AL) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                }
            }
            catch (Exception exception2) {
                System.out.println(exception2.getLocalizedMessage());
                if (OraclePKIDebug.getDebugFlag()) {
                    exception2.printStackTrace();
                }
                n2 = -1;
                return n2;
            }
        }
        if (null != string6) {
            int n3;
            ByteArrayOutputStream byteArrayOutputStream;
            InputStream inputStream;
            block46: {
                try {
                    try {
                        inputStream = new URL(string6).openStream();
                    }
                    catch (MalformedURLException malformedURLException) {
                        inputStream = new FileInputStream(string6);
                    }
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    n3 = inputStream.read();
                    while (n3 != -1) {
                        byteArrayOutputStream.write((byte)n3);
                        n3 = inputStream.read();
                    }
                    string8 = new String(byteArrayOutputStream.toByteArray());
                }
                catch (IOException iOException) {
                    System.out.println("Unable to read certificate at " + string6);
                    n2 = -1;
                    return n2;
                }
                try {
                    if (string7 == null) break block46;
                    try {
                        inputStream = new URL(string7).openStream();
                    }
                    catch (MalformedURLException malformedURLException) {
                        inputStream = new FileInputStream(string7);
                    }
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    n3 = inputStream.read();
                    while (n3 != -1) {
                        byteArrayOutputStream.write((byte)n3);
                        n3 = inputStream.read();
                    }
                    string9 = new String(byteArrayOutputStream.toByteArray());
                }
                catch (IOException iOException) {
                    System.out.println("Unable to read CA certificate at " + string7);
                    n2 = -1;
                    return n2;
                }
            }
            try {
                try {
                    inputStream = new URL(string3).openStream();
                }
                catch (MalformedURLException malformedURLException) {
                    inputStream = new FileInputStream(string3);
                }
                byteArrayOutputStream = new ByteArrayOutputStream();
                n3 = inputStream.read();
                while (n3 != -1) {
                    byteArrayOutputStream.write((byte)n3);
                    n3 = inputStream.read();
                }
                string5 = new String(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                System.out.println("Unable to read private key file at " + string3);
                n2 = -1;
                return n2;
            }
            try {
                if (cArray == null) {
                    cArray = OraclePKIGenFunc.getPassword("PVTKEY_PASSWORD_PROMPT");
                }
                if (byArray != null) {
                    oracleWallet.importPrivateKeyB64(string4, string5, cArray, byArray, n, string8, string9);
                } else {
                    oracleWallet.importPrivateKeyB64(string4, string5, cArray, string8, string9);
                }
                oracleWallet.saveAs(string);
            }
            catch (Exception exception) {
                if (null != exception.getCause() && null != exception.getCause().getLocalizedMessage()) {
                    System.out.println(a.getString("PKI-07014") + " " + exception.getCause().getLocalizedMessage());
                } else if (null != exception.getLocalizedMessage()) {
                    System.out.println(a.getString("PKI-07014") + " " + exception.getLocalizedMessage());
                } else {
                    System.out.println(a.getString("PKI-07014"));
                }
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                n2 = -1;
                return n2;
            }
        }
        System.out.println(a.getString("PKI-07015"));
        n2 = -1;
        return n2;
        System.out.println(a.getString("SUCCESSFUL_OPERATION"));
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int exportPvtKey(String[] stringArray) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        char[] cArray = null;
        byte[] byArray = null;
        Object var8_8 = null;
        int n = 0;
        int n2 = 1000;
        String string5 = null;
        FileWriter fileWriter = null;
        if (stringArray.length == 0) {
            System.out.println(b);
            return -1;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-pvtkeyfile")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-alias")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pvtkeypwd")) {
                    cArray = stringArray[++i].toCharArray();
                    continue;
                }
                if (!stringArray[i].equals("-salt")) {
                    System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                    System.out.println(b);
                    return -1;
                }
                byArray = stringArray[++i].getBytes();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return -1;
        }
        if (cArray == null) {
            System.out.println("Private key password:");
            cArray = OraclePKIGenFunc.getCreatePassword();
        }
        OracleWallet oracleWallet = null;
        Object var14_16 = null;
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, bl);
        }
        catch (Exception exception) {
            try {
                oracleWallet = new OracleWallet();
                oracleWallet.open(string, null);
                if (oracleWallet.isAutoLoginOnly()) {
                    System.out.println("Found Auto Login Only (ALO) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                } else {
                    System.out.println("Found Auto Login (AL) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                }
            }
            catch (Exception exception2) {
                System.out.println(exception2.getLocalizedMessage());
                if (!OraclePKIDebug.getDebugFlag()) return -1;
                exception.printStackTrace();
                return -1;
            }
        }
        try {
            if (cArray == null) {
                cArray = OraclePKIGenFunc.getPassword("PVTKEY_PASSWORD_PROMPT");
            }
            if (null == string4) {
                System.out.println(a.getString("PKI-07018"));
                return -1;
            }
            string5 = byArray != null ? oracleWallet.exportPrivateKeyB64(string4, cArray, byArray, n2) : oracleWallet.exportPrivateKeyB64(string4, cArray);
            if (null == string5) {
                System.out.println(a.getString("PKI-07017"));
                return -1;
            }
            if (null != string3) {
                fileWriter = new FileWriter(string3);
                fileWriter.write(string5);
                fileWriter.flush();
                return n;
            }
            System.out.println(a.getString("PKI-07016"));
            return -1;
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            if (!OraclePKIDebug.getDebugFlag()) return -1;
            exception.printStackTrace();
            return -1;
        }
    }

    public static int export(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl = false;
        X500Principal x500Principal = null;
        String string8 = null;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-dn")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-request")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-cert")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-alias")) {
                    string8 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-issuer_dn")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-serial_num")) {
                    string7 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            if (string2 != null) {
                x500Principal = new X500Principal(string2);
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Please provide : -dn [dn]");
            n = -1;
            return n;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Please provide proper DN.");
            n = -1;
            return n;
        }
        OracleWallet oracleWallet = null;
        KeyStore keyStore = null;
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string5, bl);
            keyStore = oracleWallet.getKeyStore();
        }
        catch (Exception exception) {
            try {
                oracleWallet = new OracleWallet();
                oracleWallet.open(string, null);
                keyStore = oracleWallet.getKeyStore();
                if (oracleWallet.isAutoLoginOnly()) {
                    System.out.println("Found Auto Login Only (ALO) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                } else {
                    System.out.println("Found Auto Login (AL) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                }
            }
            catch (Exception exception2) {
                System.out.println(exception.getLocalizedMessage());
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                n = -1;
                return n;
            }
        }
        if (string4 != null) {
            try {
                String string9 = null;
                if (x500Principal != null) {
                    string9 = oracleWallet.exportCertB64(x500Principal, string6, string7);
                } else if (string8 != null) {
                    string9 = oracleWallet.exportCertB64(string8);
                } else {
                    System.out.println("Please provide DN or alias");
                    n = -1;
                    return n;
                }
                if (string9 == null) {
                    System.out.println("Please check DN, could not found certificate with matching DN.");
                    n = -1;
                    return n;
                }
                FileWriter fileWriter = new FileWriter(string4);
                fileWriter.write(string9);
                fileWriter.flush();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                n = -1;
                return n;
            }
        }
        if (string3 != null) {
            try {
                String string10 = null;
                if (x500Principal != null) {
                    string10 = oracleWallet.exportCertReqB64(x500Principal);
                } else if (string8 != null) {
                    string10 = oracleWallet.exportCertReqB64(string8);
                } else {
                    System.out.println("Please provide DN or alias");
                    n = -1;
                    return n;
                }
                if (string10 == null) {
                    System.out.println("Please check DN, could not found certificate request with matching DN.");
                    n = -1;
                    return n;
                }
                FileWriter fileWriter = new FileWriter(string3);
                fileWriter.write(string10);
                fileWriter.flush();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                n = -1;
                return n;
            }
        }
        System.out.println(a.getString("SUCCESSFUL_OPERATION"));
        return n;
    }

    public static int exportchain(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-dn")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-certchain")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-alias")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-issuer_dn")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-serial_num")) {
                    string7 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return n;
        }
        OracleWallet oracleWallet = null;
        String string8 = null;
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string4, bl);
        }
        catch (Exception exception) {
            try {
                oracleWallet = new OracleWallet();
                oracleWallet.open(string, null);
                if (oracleWallet.isAutoLoginOnly()) {
                    System.out.println("Found Auto Login Only (ALO) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                } else {
                    System.out.println("Found Auto Login (AL) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                }
            }
            catch (Exception exception2) {
                System.out.println(exception.getLocalizedMessage());
                if (OraclePKIDebug.getDebugFlag()) {
                    exception.printStackTrace();
                }
                n = -1;
                return n;
            }
        }
        try {
            string8 = string2 != null ? oracleWallet.exportCertChainB64(new X500Principal(string2), string6, string7) : (string5 != null ? oracleWallet.exportCertChainB64(string5) : oracleWallet.exportUserCertChainB64());
            if (null != string8) {
                if (null == string3) {
                    System.out.println(a.getString("PKI-07019"));
                    n = -1;
                    return n;
                }
            } else {
                System.out.println(a.getString("PKI-07020"));
                n = -1;
                return n;
            }
            FileWriter fileWriter = new FileWriter(string3);
            fileWriter.write(string8);
            fileWriter.flush();
        }
        catch (Exception exception) {
            System.out.println("Unable to export trust chain.");
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            n = -1;
            return n;
        }
        System.out.println(a.getString("SUCCESSFUL_OPERATION"));
        return n;
    }

    private static char[] a() {
        boolean bl;
        char[] cArray = null;
        char[] cArray2 = null;
        do {
            bl = (cArray = OraclePKIGenFunc.getPassword("ENTER_PASSWORD")).length == (cArray2 = OraclePKIGenFunc.getPassword("ENTER_PASSWORD_AGAIN")).length;
            for (int i = 0; i < cArray.length && bl; ++i) {
                bl = cArray[i] == cArray2[i];
            }
            if (bl) continue;
            System.out.println(a.getString("PKI-01003"));
        } while (!bl);
        return cArray;
    }

    public static int isTrustedCertUsedInChain(String[] stringArray) {
        int n = 0;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nis_tcert_used_in_chain [-wallet [wallet]] [-pwd [pwd]] [-dn [dn]]\nhelp");
            n = -1;
            return n;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-dn")) {
                string3 = stringArray[++i];
                continue;
            }
            System.out.println("wallet:\nis_tcert_used_in_chain [-wallet [wallet]] [-pwd [pwd]] [-dn [dn]]\nhelp");
            n = -1;
            return n;
        }
        try {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
            System.out.println("Result of isTrustedCertUsedInChain = " + oracleWallet.isTrustedCertUsedInChain(new X500Principal(string3)));
        }
        catch (Exception exception) {
            System.out.println("Exception in isTrustedCertUsedInChain : " + exception);
            n = -1;
        }
        return n;
    }

    public static int getCertreqInfo(String[] stringArray) {
        int n = 0;
        String string = null;
        String string2 = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nget_certreq_info [-wallet [wallet]] [-pwd [pwd]]\nhelp");
            n = -1;
            return n;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string2 = stringArray[++i];
                continue;
            }
            System.out.println("wallet:\nget_certreq_info [-wallet [wallet]] [-pwd [pwd]]\nhelp");
            n = -1;
            return n;
        }
        try {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
            String[] stringArray2 = oracleWallet.getCertReqInfo(0, 1);
            System.out.println("DN      : " + stringArray2[0]);
            System.out.println("keySize : " + stringArray2[1]);
            System.out.println("keyType : " + stringArray2[2]);
            System.out.println("alias   : " + stringArray2[3]);
        }
        catch (Exception exception) {
            System.out.println("Exception in getCertreqInfo : " + exception);
            n = -1;
        }
        return n;
    }

    public static int getCertReqCountDNs(String[] stringArray) {
        int n = 0;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nget_certreq_count_dns [-wallet [wallet]] [-pwd [pwd]] [-isNonissuedCertOnly [true|false]]\nhelp");
            n = -1;
            return n;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-isNonissuedCertOnly")) {
                string3 = stringArray[++i];
                continue;
            }
            System.out.println("wallet:\nget_certreq_count_dns [-wallet [wallet]] [-pwd [pwd]] [-isNonissuedCertOnly [true|false]]\nhelp");
            n = -1;
            return n;
        }
        try {
            Boolean bl = Boolean.valueOf(string3);
            boolean bl2 = bl;
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
            int n2 = oracleWallet.getCertReqCount(0, bl2);
            System.out.println("Certificate Request Count = " + n2);
            X500Principal[] x500PrincipalArray = oracleWallet.getCertReqDNs(0, bl2);
            System.out.println("Certificate Request DNs info : ");
            for (int i = 0; i < x500PrincipalArray.length; ++i) {
                System.out.println("Subject : " + x500PrincipalArray[i]);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in getCertReqCountDNs : " + exception);
            n = -1;
        }
        return n;
    }

    public static int isValidPassword(String[] stringArray) {
        int n = 0;
        String string = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nvalidate_pswd [-pwd [pwd]]\nhelp");
            n = -1;
            return n;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-pwd")) {
                System.out.println("wallet:\nvalidate_pswd [-pwd [pwd]]\nhelp");
                n = -1;
                return n;
            }
            string = stringArray[++i];
        }
        if (OracleWallet.isValidPassword(string.toCharArray())) {
            System.out.println("Result : Valid Password");
        } else {
            System.out.println(a.getString("PKI-01002"));
            n = -1;
        }
        return n;
    }

    public static int getKeysizes(String[] stringArray) {
        int n = 0;
        if (stringArray.length == 0) {
            int[] nArray = OracleWallet.getKeysizes();
            System.out.print("Supported keysizes : ");
            for (int i = 0; i < nArray.length; ++i) {
                System.out.print("\t" + nArray[i]);
            }
            System.out.println();
            n = -1;
        } else {
            System.out.println("wallet:\nget_keysizes\nhelp");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int importPKCS12ToOracleWallet(String[] stringArray) {
        int n;
        int n2;
        char[] cArray;
        block33: {
            OracleWallet oracleWallet;
            char[] cArray2;
            String string;
            block31: {
                int n3;
                int n4;
                block32: {
                    String string2 = "wallet:\nimport_pkcs12 [-wallet <wallet>] [[-pwd <pwd>] | [-auto_login_only]] [-pkcs12file <pkcs12Loc>] [-pkcs12pwd <pkcs12Pwd>]\nhelp";
                    String string3 = null;
                    string = null;
                    boolean bl = false;
                    cArray2 = null;
                    cArray = null;
                    n2 = 0;
                    boolean bl2 = false;
                    if (stringArray.length == 0) {
                        System.out.println(string2);
                        n2 = -1;
                        return n2;
                    }
                    try {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i].equals("-wallet")) {
                                string3 = stringArray[++i];
                                continue;
                            }
                            if (stringArray[i].equals("-pwd")) {
                                cArray2 = stringArray[++i].toCharArray();
                                continue;
                            }
                            if (stringArray[i].equals("-obpwd")) {
                                bl = true;
                                continue;
                            }
                            if (stringArray[i].equals("-auto_login_only")) {
                                bl2 = true;
                                continue;
                            }
                            if (stringArray[i].equals("-pkcs12file")) {
                                string = stringArray[++i];
                                continue;
                            }
                            if (stringArray[i].equals("-pkcs12pwd")) {
                                cArray = stringArray[++i].toCharArray();
                                continue;
                            }
                            System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                            System.out.println(string2);
                            n2 = -1;
                            return n2;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.out.println(b);
                        n2 = -1;
                        return n2;
                    }
                    if (bl2 && cArray2 != null) {
                        System.out.println(b);
                        n2 = -1;
                        return n2;
                    }
                    oracleWallet = new OracleWallet();
                    oracleWallet = cArray2 == null ? OraclePKIGenFunc.openAWallet(string3, null, bl, true) : OraclePKIGenFunc.openAWallet(string3, new String(cArray2), bl, true);
                    if ((!oracleWallet.isAutoLoginOnly() || bl2) && (oracleWallet.isAutoLoginOnly() || !bl2)) break block31;
                    System.out.println(b);
                    n4 = n2 = -1;
                    if (cArray2 == null) break block32;
                    for (n3 = 0; n3 < cArray2.length; ++n3) {
                        cArray2[n3] = '\u0000';
                    }
                }
                if (cArray != null) {
                    for (n3 = 0; n3 < cArray.length; ++n3) {
                        cArray[n3] = '\u0000';
                    }
                }
                return n4;
            }
            try {
                if (cArray == null) {
                    cArray = OraclePKIGenFunc.getPassword("PKCS12_FILE_PASSWORD_PROMPT");
                }
                n2 = oracleWallet.importPKCS12File(string, cArray);
                oracleWallet.save();
                System.out.println("orapki command import_pkcs12 executed successfully.");
                if (cArray2 == null) break block33;
            }
            catch (Exception exception) {
                int n5;
                int n6;
                block34: {
                    try {
                        System.out.println(exception.getMessage());
                        if (OraclePKIDebug.getDebugFlag()) {
                            exception.printStackTrace();
                        }
                        n6 = n2 = -1;
                        if (cArray2 == null) break block34;
                    }
                    catch (Throwable throwable) {
                        int n7;
                        if (cArray2 != null) {
                            for (n7 = 0; n7 < cArray2.length; ++n7) {
                                cArray2[n7] = '\u0000';
                            }
                        }
                        if (cArray != null) {
                            for (n7 = 0; n7 < cArray.length; ++n7) {
                                cArray[n7] = false;
                            }
                        }
                        throw throwable;
                    }
                    for (n5 = 0; n5 < cArray2.length; ++n5) {
                        cArray2[n5] = '\u0000';
                    }
                }
                if (cArray != null) {
                    for (n5 = 0; n5 < cArray.length; ++n5) {
                        cArray[n5] = '\u0000';
                    }
                }
                return n6;
            }
            for (n = 0; n < cArray2.length; ++n) {
                cArray2[n] = '\u0000';
            }
        }
        if (cArray != null) {
            for (n = 0; n < cArray.length; ++n) {
                cArray[n] = '\u0000';
            }
        }
        return n2;
    }
}

