/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ssl;

import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.X509;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OraclePKIX509CrlDPStore;
import oracle.security.pki.OraclePKIX509CrlFileStore;
import oracle.security.pki.OraclePKIX509CrlStore;
import oracle.security.pki.ssl.OracleSSLCrlCache;
import oracle.security.pki.ssl.OracleSSLDebug;
import oracle.security.pki.ssl.OracleSSLX509TrustManager;

final class OracleSSLX509CrlTrustManagerImpl
implements OracleSSLX509TrustManager {
    Vector a = new Vector();
    OraclePKIX509CrlStore[] b = null;
    OracleSSLCrlCache c = null;
    static ResourceBundle d = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");

    OracleSSLX509CrlTrustManagerImpl(KeyStore keyStore, String string, String string2, int n) throws KeyStoreException {
        Object object;
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!keyStore.isCertificateEntry((String)object)) continue;
            if (keyStore.getCertificate((String)object) instanceof OraclePKIX509CertImpl) {
                this.a.add(keyStore.getCertificate((String)object));
                OracleSSLDebug.a("OracleSSLX509TrustManager: added trusted cert at alias " + (String)object);
            }
            if (!(keyStore.getCertificate((String)object) instanceof X509Certificate)) continue;
            try {
                X509 x509 = new X509(((X509Certificate)keyStore.getCertificate((String)object)).getEncoded());
                this.a.addElement(new OraclePKIX509CertImpl(x509));
                OracleSSLDebug.a("OracleSSLX509TrustManager: added trusted cert at alias " + (String)object);
            }
            catch (Exception exception) {
                OracleSSLDebug.a("OracleX509CrlTrustManagaer: Invalid cert at alias " + (String)object);
            }
        }
        object = new Vector();
        if (string != null && !string.equals("")) {
            OracleSSLDebug.a("OracleSSLX509TrustManager: Adding CRL File location " + string);
            try {
                ((Vector)object).addElement(new OraclePKIX509CrlFileStore(new File(string)));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(string + " is not a valid location.");
            }
        }
        if (string2 != null) {
            OracleSSLDebug.a("OracleSSLX509TrustManager: Adding CRL Ldap location " + string2 + ":" + n);
        }
        ((Vector)object).addElement(new OraclePKIX509CrlDPStore());
        OracleSSLDebug.a("OracleSSLX509TrustManager: using " + ((Vector)object).size() + " CRL Stores");
        this.b = ((Vector)object).toArray(new OraclePKIX509CrlStore[((Vector)object).size()]);
        OracleSSLDebug.a("OracleSSLX509TrustManager: Created");
        this.c = new OracleSSLCrlCache();
    }

    @Override
    public final void a(X509Certificate[] x509CertificateArray) throws CertificateException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl;
        OraclePKIX509CertImpl oraclePKIX509CertImpl2;
        block10: {
            oraclePKIX509CertImpl2 = null;
            oraclePKIX509CertImpl = null;
            try {
                oraclePKIX509CertImpl2 = new OraclePKIX509CertImpl(new X509(x509CertificateArray[0].getEncoded()));
                OracleSSLDebug.a("OracleSSLX509TrustManager: Checking revocation status of " + oraclePKIX509CertImpl2.getSubjectDN());
                OracleSSLDebug.a("OracleSSLX509TrustManager: looking for signer");
                oraclePKIX509CertImpl = this.a(oraclePKIX509CertImpl2);
                if (oraclePKIX509CertImpl != null) break block10;
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    OracleSSLDebug.a("OracleSSLX509TrustManager: Is it : " + x509CertificateArray[i].getSubjectDN() + " ? " + oraclePKIX509CertImpl2.getIssuerDN().equals(x509CertificateArray[i].getSubjectDN()));
                    if (!oraclePKIX509CertImpl2.getIssuerDN().equals(x509CertificateArray[i].getSubjectDN())) continue;
                    X509 x509 = new X509(x509CertificateArray[i].getEncoded());
                    oraclePKIX509CertImpl = new OraclePKIX509CertImpl(x509);
                    break;
                }
            }
            catch (IOException iOException) {
                throw new CertificateException("Invalid certificate in chain");
            }
        }
        if (oraclePKIX509CertImpl == null) {
            throw new CertificateException("Unable to find signer of peer");
        }
        OracleSSLDebug.a("OracleSSLX509TrustManager: Looking for CRL");
        CRL cRL = this.c.a(oraclePKIX509CertImpl2);
        if (cRL == null || !cRL.verifyDate()) {
            for (int i = 0; i < this.b.length; ++i) {
                try {
                    CRL cRL2 = this.b[i].getCrlFor(oraclePKIX509CertImpl2);
                    cRL2.setPublicKey(oraclePKIX509CertImpl.getX509().getPublicKey());
                    OracleSSLDebug.a("OracleSSLX509TrustManager: found candidate CRL in store " + i);
                    if (!cRL2.verify()) continue;
                    cRL = cRL2;
                    break;
                }
                catch (Exception exception) {
                    OracleSSLDebug.a("OracleSSLX509TrustManager: no valid crl in crl store " + i);
                    OracleSSLDebug.a("OracleSSLX509TrustManager: " + exception.toString());
                }
            }
            if (cRL == null) {
                throw new CertificateException("Unable to find CRL for peer");
            }
            this.c.a(cRL);
        }
        OracleSSLDebug.a("OracleSSLX509TrustManager: found CRL");
        if (cRL.isRevoked(oraclePKIX509CertImpl2.getSerialNumber())) {
            throw new CertificateException(d.getString("PKI-07007"));
        }
    }

    private final OraclePKIX509CertImpl a(X509Certificate x509Certificate) {
        OracleSSLDebug.a("OracleX509TrustManager: Looking for trusted certificate: " + x509Certificate.getSubjectDN());
        for (int i = 0; i < this.a.size(); ++i) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.a.elementAt(i);
            OracleSSLDebug.a("OracleX509TrustManager: Is it : " + oraclePKIX509CertImpl + " ? " + x509Certificate.getIssuerDN().equals(oraclePKIX509CertImpl.getSubjectDN()));
            if (!x509Certificate.getIssuerDN().equals(oraclePKIX509CertImpl.getSubjectDN())) continue;
            return oraclePKIX509CertImpl;
        }
        return null;
    }

    @Override
    public final void b(X509Certificate[] x509CertificateArray) throws CertificateException, CertificateExpiredException, CertificateNotYetValidException {
        this.a(x509CertificateArray);
    }

    @Override
    public final X509Certificate[] a() {
        return this.a.toArray(new X509Certificate[this.a.size()]);
    }
}

