/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.mysql.MySQLDatabase;
import org.flywaydb.core.internal.database.mysql.MySQLNamedLockTemplate;
import org.flywaydb.core.internal.database.mysql.MySQLSchema;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.util.StringUtils;

public class MySQLConnection
extends org.flywaydb.core.internal.database.base.Connection<MySQLDatabase> {
    private static final Log LOG = LogFactory.getLog(MySQLConnection.class);
    private static final String USER_VARIABLES_TABLE_MARIADB = "information_schema.user_variables";
    private static final String USER_VARIABLES_TABLE_MYSQL = "performance_schema.user_variables_by_thread";
    private static final String FOREIGN_KEY_CHECKS = "foreign_key_checks";
    private static final String SQL_SAFE_UPDATES = "sql_safe_updates";
    private final String userVariablesQuery;
    private final boolean canResetUserVariables;
    private final int originalForeignKeyChecks;
    private final int originalSqlSafeUpdates;

    public MySQLConnection(MySQLDatabase database, Connection connection) {
        super(database, connection);
        this.userVariablesQuery = "SELECT variable_name FROM " + (database.isMariaDB() ? USER_VARIABLES_TABLE_MARIADB : USER_VARIABLES_TABLE_MYSQL) + " WHERE variable_value IS NOT NULL";
        this.canResetUserVariables = this.hasUserVariableResetCapability();
        this.originalForeignKeyChecks = this.getIntVariableValue(FOREIGN_KEY_CHECKS);
        this.originalSqlSafeUpdates = this.getIntVariableValue(SQL_SAFE_UPDATES);
    }

    private int getIntVariableValue(String varName) {
        try {
            return this.jdbcTemplate.queryForInt("SELECT @@" + varName, new String[0]);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine value for '" + varName + "' variable", e);
        }
    }

    private boolean hasUserVariableResetCapability() {
        if (((MySQLDatabase)this.database).isMariaDB() && !((MySQLDatabase)this.database).getVersion().isAtLeast("10.2")) {
            LOG.debug("Disabled user variable reset as it is only available from MariaDB 10.2 onwards");
            return false;
        }
        if (!((MySQLDatabase)this.database).isMariaDB() && !((MySQLDatabase)this.database).getVersion().isAtLeast("5.7")) {
            LOG.debug("Disabled user variable reset as it is only available from MySQL 5.7 onwards");
            return false;
        }
        try {
            this.jdbcTemplate.queryForStringList(this.userVariablesQuery, new String[0]);
            return true;
        }
        catch (SQLException e) {
            LOG.debug("Disabled user variable reset as " + (((MySQLDatabase)this.database).isMariaDB() ? USER_VARIABLES_TABLE_MARIADB : USER_VARIABLES_TABLE_MYSQL) + "cannot be queried (SQL State: " + e.getSQLState() + ", Error Code: " + e.getErrorCode() + ")");
            return false;
        }
    }

    @Override
    protected void doRestoreOriginalState() throws SQLException {
        this.resetUserVariables();
        this.jdbcTemplate.execute("SET foreign_key_checks=?, sql_safe_updates=?", this.originalForeignKeyChecks, this.originalSqlSafeUpdates);
    }

    private void resetUserVariables() throws SQLException {
        List<String> userVariables;
        if (this.canResetUserVariables && !(userVariables = this.jdbcTemplate.queryForStringList(this.userVariablesQuery, new String[0])).isEmpty()) {
            boolean first = true;
            StringBuilder setStatement = new StringBuilder("SET ");
            for (String userVariable : userVariables) {
                if (first) {
                    first = false;
                } else {
                    setStatement.append(",");
                }
                setStatement.append("@").append(userVariable).append("=NULL");
            }
            this.jdbcTemplate.executeStatement(setStatement.toString());
        }
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT DATABASE()", new String[0]);
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        if (StringUtils.hasLength(schema)) {
            this.jdbcTemplate.getConnection().setCatalog(schema);
        } else {
            try {
                String newDb = ((MySQLDatabase)this.database).quote(UUID.randomUUID().toString());
                this.jdbcTemplate.execute("CREATE SCHEMA " + newDb, new Object[0]);
                this.jdbcTemplate.execute("USE " + newDb, new Object[0]);
                this.jdbcTemplate.execute("DROP SCHEMA " + newDb, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Unable to restore connection to having no default schema: " + e.getMessage());
            }
        }
    }

    @Override
    protected Schema doGetCurrentSchema() throws SQLException {
        String schemaName = this.getCurrentSchemaNameOrSearchPath();
        return schemaName == null ? null : this.getSchema(schemaName);
    }

    @Override
    public Schema getSchema(String name) {
        return new MySQLSchema(this.jdbcTemplate, (MySQLDatabase)this.database, name);
    }

    @Override
    public <T> T lock(Table table, Callable<T> callable) {
        if (this.canUseNamedLockTemplate()) {
            return new MySQLNamedLockTemplate(this.jdbcTemplate, table.toString().hashCode()).execute(callable);
        }
        return super.lock(table, callable);
    }

    protected boolean canUseNamedLockTemplate() {
        return !((MySQLDatabase)this.database).isPxcStrict();
    }
}

