/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.bigquery;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.StringCharacterIterator;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeRequiredException;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.DataUnits;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.database.bigquery.BigQueryConnection;

public class BigQueryDatabase
extends Database<BigQueryConnection> {
    private static final Log LOG = LogFactory.getLog(BigQueryDatabase.class);
    private static final long TEN_GB_DATASET_SIZE_LIMIT = DataUnits.GIGABYTE.toBytes(10L);
    private static final long NINE_GB_DATASET_SIZE = DataUnits.GIGABYTE.toBytes(9L);

    public BigQueryDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected BigQueryConnection doGetConnection(Connection connection) {
        return new BigQueryConnection(this, connection);
    }

    public final void ensureSupported() {
        if (VersionPrinter.EDITION == Edition.COMMUNITY) {
            long totalDatasetSize = 0L;
            for (String dataset : this.configuration.getSchemas()) {
                totalDatasetSize += this.getDatasetSize(dataset);
            }
            String byteCount = this.humanReadableByteCountSI(totalDatasetSize);
            if (totalDatasetSize > TEN_GB_DATASET_SIZE_LIMIT) {
                throw new FlywayTeamsUpgradeRequiredException("Google BigQuery databases that exceed the 10 GB dataset size limit (Calculated size: " + byteCount + ")");
            }
            String usageLimitMessage = "Google BigQuery databases have a 10 GB dataset size limit in Flyway " + Edition.COMMUNITY + ".\nYou have used " + byteCount + " / 10 GB\nConsider upgrading to Flyway " + Edition.ENTERPRISE + " for unlimited usage: " + "https://rd.gt/3CWAuTb";
            if (totalDatasetSize >= NINE_GB_DATASET_SIZE) {
                LOG.warn(usageLimitMessage);
            } else {
                LOG.info(usageLimitMessage);
            }
        }
    }

    private String humanReadableByteCountSI(long bytes) {
        if (-1000L < bytes && bytes < 1000L) {
            return bytes + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950L || bytes >= 999950L) {
            bytes /= 1000L;
            ci.next();
        }
        return String.format("%.1f %cB", (double)bytes / 1000.0, Character.valueOf(ci.current()));
    }

    private long getDatasetSize(String dataset) {
        try {
            return this.jdbcTemplate.queryForLong("select sum(size_bytes) from " + dataset + ".__TABLES__", new String[0]);
        }
        catch (SQLException e) {
            return 0L;
        }
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + table + " (\n    `installed_rank` INT64 NOT NULL,\n    `version` STRING,\n    `description` STRING NOT NULL,\n    `type` STRING NOT NULL,\n    `script` STRING NOT NULL,\n    `checksum` INT64,\n    `installed_by` STRING NOT NULL,\n    `installed_on` TIMESTAMP,\n    `execution_time` INT64 NOT NULL,\n    `success` BOOL NOT NULL\n);\n" + (baseline ? this.getBaselineStatement(table) + ";\n" : "");
    }

    public String getInsertStatement(Table table) {
        return "INSERT INTO " + table + " (" + this.quote(new String[]{"installed_rank"}) + ", " + this.quote(new String[]{"version"}) + ", " + this.quote(new String[]{"description"}) + ", " + this.quote(new String[]{"type"}) + ", " + this.quote(new String[]{"script"}) + ", " + this.quote(new String[]{"checksum"}) + ", " + this.quote(new String[]{"installed_by"}) + ", " + this.quote(new String[]{"installed_on"}) + ", " + this.quote(new String[]{"execution_time"}) + ", " + this.quote(new String[]{"success"}) + ") VALUES (?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP(), ?, ?)";
    }

    protected String doGetCurrentUser() throws SQLException {
        return ((BigQueryConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT SESSION_USER() as user;", new String[0]);
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public boolean supportsChangingCurrentSchema() {
        return false;
    }

    public String getBooleanTrue() {
        return "TRUE";
    }

    public String getBooleanFalse() {
        return "FALSE";
    }

    public String doQuote(String identifier) {
        return BigQueryDatabase.bigQueryQuote(identifier);
    }

    static String bigQueryQuote(String identifier) {
        return "`" + StringUtils.replaceAll((String)identifier, (String)"`", (String)"\\`") + "`";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public boolean supportsMultiStatementTransactions() {
        return false;
    }

    public boolean useSingleConnection() {
        return true;
    }
}

