/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.license;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.ServiceLoader;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.FlywayExtension;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.FlywayTrialExpiredException;
import org.flywaydb.core.internal.license.teams.LicenseInfo;
import org.flywaydb.core.internal.license.teams.LicenseType;
import org.flywaydb.core.internal.util.DateUtils;
import org.flywaydb.core.internal.util.FileCopyUtils;

public class VersionPrinter {
    private static final Log LOG = LogFactory.getLog(VersionPrinter.class);
    public static ClassLoader classLoader = VersionPrinter.class.getClassLoader();
    private static final String version = VersionPrinter.readVersion();
    public static final Edition EDITION = Edition.ENTERPRISE;

    private VersionPrinter() {
    }

    public static String getVersion() {
        return version;
    }

    public static void printVersion(String licenseKey) {
        VersionPrinter.printLicenseInfo(licenseKey);
    }

    public static void printVersionOnly() {
        LOG.info((Object)((Object)EDITION) + " " + version + " by Redgate");
        VersionPrinter.printExtensionVersions();
    }

    private static void printExtensionVersions() {
        ServiceLoader<FlywayExtension> loader = ServiceLoader.load(FlywayExtension.class, classLoader);
        for (FlywayExtension extension : loader) {
            LOG.info(">\t" + extension.getDescription());
        }
    }

    private static void printLicenseInfo(String licenseKey) {
        LicenseInfo licenseInfo = new LicenseInfo(licenseKey);
        LicenseType licenseType = licenseInfo.getLicenseType();
        LOG.info((Object)((Object)licenseType) + " " + version + " by Redgate licensed to " + licenseInfo.getLicensedTo() + " until " + DateUtils.toDateString(licenseInfo.getValidUntil()));
        if (Edition.PRO.equals((Object)licenseType.getEdition())) {
            LOG.info("Your Flyway license is upgraded to Flyway Teams.");
        }
        VersionPrinter.printExtensionVersions();
        if (licenseType == LicenseType.TRIAL) {
            if (licenseInfo.getValidUntil().before(new Date())) {
                throw new FlywayTrialExpiredException(EDITION);
            }
            long daysRemaining = ChronoUnit.DAYS.between(new Date().toInstant(), licenseInfo.getValidUntil().toInstant());
            String days = daysRemaining + " day";
            if (daysRemaining != 1L) {
                days = days + "s";
            }
            LOG.warn("You are using a 30 day limited Flyway trial license, valid until " + licenseInfo.getValidUntil() + ".  In " + days + " you must either upgrade to a full " + (Object)((Object)EDITION) + " license or downgrade to " + (Object)((Object)Edition.COMMUNITY) + ".");
        } else if (licenseInfo.getValidUntil().before(new Date())) {
            LOG.error("Your " + (Object)((Object)EDITION) + " license has expired and is no longer valid. You must renew your license immediately to keep on using this software.");
        }
    }

    private static String readVersion() {
        try {
            return FileCopyUtils.copyToString(VersionPrinter.class.getClassLoader().getResourceAsStream("org/flywaydb/core/internal/version.txt"), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to read Flyway version: " + e.getMessage(), e);
        }
    }
}

