/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.schemahistory;

import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.schemahistory.JdbcTableSchemaHistory;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.schemahistory.teams.InMemorySchemaHistory;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;

public class SchemaHistoryFactory {
    private SchemaHistoryFactory() {
    }

    public static SchemaHistory getSchemaHistory(Configuration configuration, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, Database database, Schema schema, StatementInterceptor statementInterceptor) {
        Table table = schema.getTable(configuration.getTable());
        JdbcTableSchemaHistory jdbcTableSchemaHistory = new JdbcTableSchemaHistory(sqlScriptExecutorFactory, sqlScriptFactory, database, table);
        if (configuration.getDryRunOutput() != null) {
            return new InMemorySchemaHistory(jdbcTableSchemaHistory.exists(), jdbcTableSchemaHistory.allAppliedMigrations(), table, database.getInstalledBy(), statementInterceptor, configuration);
        }
        return jdbcTableSchemaHistory;
    }
}

