/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.firebird;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.firebird.FirebirdDatabase;
import org.flywaydb.core.internal.database.firebird.FirebirdTable;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.RowMapper;

public class FirebirdSchema
extends Schema<FirebirdDatabase, FirebirdTable> {
    public FirebirdSchema(JdbcTemplate jdbcTemplate, FirebirdDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return true;
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        return 0 == this.jdbcTemplate.queryForInt("select count(*)\nfrom (\n  -- views and tables\n  select RDB$RELATION_NAME AS OBJECT_NAME\n  from RDB$RELATIONS\n  where (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n  union all\n  -- stored procedures\n  select RDB$PROCEDURE_NAME\n  from RDB$PROCEDURES\n  where (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n  union all\n  -- triggers\n  select RDB$TRIGGER_NAME\n  from RDB$TRIGGERS\n  where (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n  union all\n  -- functions\n  select RDB$FUNCTION_NAME\n  from RDB$FUNCTIONS\n  where (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n  union all\n  -- sequences\n  select RDB$GENERATOR_NAME\n  from RDB$GENERATORS\n  where (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n  union all\n  -- exceptions\n  select RDB$EXCEPTION_NAME\n  from RDB$EXCEPTIONS\n  where (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n  union all\n  -- domains\n  select RDB$FIELD_NAME\n  from RDB$FIELDS\n  where RDB$FIELD_NAME not starting with 'RDB$'\n  and (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\nunion all\n-- packages\nselect RDB$PACKAGE_NAME\nfrom RDB$PACKAGES\nwhere (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)) a", new String[0]);
    }

    @Override
    protected void doCreate() throws SQLException {
    }

    @Override
    protected void doDrop() throws SQLException {
        this.doClean();
    }

    @Override
    protected void doClean() throws SQLException {
        for (String dropPackageStmt : this.generateDropPackageStatements()) {
            this.jdbcTemplate.execute(dropPackageStmt, new Object[0]);
        }
        for (String dropProcedureStmt : this.generateDropProcedureStatements()) {
            this.jdbcTemplate.execute(dropProcedureStmt, new Object[0]);
        }
        for (String dropViewStmt : this.generateDropViewStatements()) {
            this.jdbcTemplate.execute(dropViewStmt, new Object[0]);
        }
        for (String dropConstraintStmt : this.generateDropConstraintStatements()) {
            this.jdbcTemplate.execute(dropConstraintStmt, new Object[0]);
        }
        for (FirebirdTable table : (FirebirdTable[])this.allTables()) {
            table.drop();
        }
        for (String dropTriggerStmt : this.generateDropTriggerStatements()) {
            this.jdbcTemplate.execute(dropTriggerStmt, new Object[0]);
        }
        for (String dropFunctionStmt : this.generateDropFunctionStatements()) {
            this.jdbcTemplate.execute(dropFunctionStmt, new Object[0]);
        }
        for (String dropSequenceStmt : this.generateDropSequenceStatements()) {
            this.jdbcTemplate.execute(dropSequenceStmt, new Object[0]);
        }
        for (String dropExceptionStmt : this.generateDropExceptionStatements()) {
            this.jdbcTemplate.execute(dropExceptionStmt, new Object[0]);
        }
        for (String dropDomainStmt : this.generateDropDomainStatements()) {
            this.jdbcTemplate.execute(dropDomainStmt, new Object[0]);
        }
    }

    private List<String> generateDropConstraintStatements() throws SQLException {
        return this.jdbcTemplate.query("select RDB$RELATION_NAME, RDB$CONSTRAINT_NAME\nfrom RDB$RELATION_CONSTRAINTS\nwhere RDB$RELATION_NAME NOT LIKE 'RDB$%'\nand RDB$CONSTRAINT_TYPE='FOREIGN KEY'", new RowMapper<String>(){

            @Override
            public String mapRow(ResultSet rs) throws SQLException {
                String tableName = rs.getString(1);
                String constraintName = rs.getString(2);
                return "ALTER TABLE " + tableName + " DROP CONSTRAINT " + constraintName;
            }
        }, new Object[0]);
    }

    private List<String> generateDropPackageStatements() throws SQLException {
        List<String> packageNames = this.jdbcTemplate.queryForStringList("select RDB$PACKAGE_NAME as packageName\nfrom RDB$PACKAGES\nwhere (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)", new String[0]);
        return this.generateDropStatements("package", packageNames);
    }

    private List<String> generateDropProcedureStatements() throws SQLException {
        List<String> procedureNames = this.jdbcTemplate.queryForStringList("select RDB$PROCEDURE_NAME as procedureName\nfrom RDB$PROCEDURES\nwhere (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\nand RDB$PACKAGE_NAME is null", new String[0]);
        return this.generateDropStatements("procedure", procedureNames);
    }

    private List<String> generateDropViewStatements() throws SQLException {
        List<String> viewNames = this.jdbcTemplate.queryForStringList("select RDB$RELATION_NAME as viewName\nfrom RDB$RELATIONS\nwhere RDB$VIEW_BLR is not null\nand (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)", new String[0]);
        return this.generateDropStatements("view", viewNames);
    }

    private List<String> generateDropTriggerStatements() throws SQLException {
        List<String> triggerNames = this.jdbcTemplate.queryForStringList("select RDB$TRIGGER_NAME as triggerName\nfrom RDB$TRIGGERS\nwhere (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n", new String[0]);
        return this.generateDropStatements("trigger", triggerNames);
    }

    private List<String> generateDropFunctionStatements() throws SQLException {
        List<String> functionNames = this.jdbcTemplate.queryForStringList("select RDB$FUNCTION_NAME as functionName\nfrom RDB$FUNCTIONS\nwhere (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)", new String[0]);
        String functionTypeName = ((FirebirdDatabase)this.database).getVersion().isAtLeast("3.0") ? "function" : "external function";
        return this.generateDropStatements(functionTypeName, functionNames);
    }

    private List<String> generateDropSequenceStatements() throws SQLException {
        List<String> sequenceNames = this.jdbcTemplate.queryForStringList("select RDB$GENERATOR_NAME as sequenceName\nfrom RDB$GENERATORS\nwhere (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n", new String[0]);
        return this.generateDropStatements("sequence", sequenceNames);
    }

    private List<String> generateDropExceptionStatements() throws SQLException {
        List<String> exceptionNames = this.jdbcTemplate.queryForStringList("select RDB$EXCEPTION_NAME as exceptionName\nfrom RDB$EXCEPTIONS\nwhere (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n", new String[0]);
        return this.generateDropStatements("exception", exceptionNames);
    }

    private List<String> generateDropDomainStatements() throws SQLException {
        List<String> domainNames = this.jdbcTemplate.queryForStringList("select RDB$FIELD_NAME as domainName\nfrom RDB$FIELDS\nwhere RDB$FIELD_NAME not starting with 'RDB$'\nand (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n", new String[0]);
        return this.generateDropStatements("domain", domainNames);
    }

    private List<String> generateDropStatements(String objectType, List<String> objectNames) {
        ArrayList<String> statements = new ArrayList<String>(objectNames.size());
        for (String objectName : objectNames) {
            statements.add("drop " + objectType + " " + ((FirebirdDatabase)this.database).quote(objectName));
        }
        return statements;
    }

    protected FirebirdTable[] doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("select RDB$RELATION_NAME as tableName\nfrom RDB$RELATIONS\nwhere RDB$VIEW_BLR is null\nand (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)", new String[0]);
        FirebirdTable[] tables = new FirebirdTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = this.getTable(tableNames.get(i));
        }
        return tables;
    }

    @Override
    public FirebirdTable getTable(String tableName) {
        return new FirebirdTable(this.jdbcTemplate, (FirebirdDatabase)this.database, this, tableName);
    }
}

