/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.filesystem;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.filesystem.FileSystemResource;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;

public class FileSystemScanner {
    private static final Log LOG = LogFactory.getLog(FileSystemScanner.class);
    private final Charset defaultEncoding;
    private final boolean stream;

    public FileSystemScanner(Charset encoding, boolean stream) {
        this.defaultEncoding = encoding;
        this.stream = stream;
    }

    public Collection<LoadableResource> scanForResources(Location location) {
        String path = location.getRootPath();
        LOG.debug("Scanning for filesystem resources at '" + path + "'");
        File dir = new File(path);
        if (!dir.exists()) {
            LOG.error("Skipping filesystem location:" + path + " (not found).");
            return Collections.emptyList();
        }
        if (!dir.canRead()) {
            LOG.error("Skipping filesystem location:" + path + " (not readable).");
            return Collections.emptyList();
        }
        if (!dir.isDirectory()) {
            LOG.error("Skipping filesystem location:" + path + " (not a directory).");
            return Collections.emptyList();
        }
        TreeSet<LoadableResource> resources = new TreeSet<LoadableResource>();
        for (String resourceName : this.findResourceNamesFromFileSystem(path, new File(path))) {
            FileSystemResource metadataResource;
            SqlScriptMetadata metadata;
            if (!location.matchesPath(resourceName)) continue;
            Charset encoding = this.defaultEncoding;
            String encodingBlurb = "";
            if (new File(resourceName + ".conf").exists() && (metadata = SqlScriptMetadata.fromResource(metadataResource = new FileSystemResource(location, resourceName + ".conf", this.defaultEncoding, false), null)).encoding() != null) {
                encoding = Charset.forName(metadata.encoding());
                encodingBlurb = " (with overriding encoding " + encoding + ")";
            }
            resources.add(new FileSystemResource(location, resourceName, encoding, this.stream));
            LOG.debug("Found filesystem resource: " + resourceName + encodingBlurb);
        }
        return resources;
    }

    private Set<String> findResourceNamesFromFileSystem(String scanRootLocation, File folder) {
        File[] files;
        LOG.debug("Scanning for resources in path: " + folder.getPath() + " (" + scanRootLocation + ")");
        TreeSet<String> resourceNames = new TreeSet<String>();
        for (File file : files = folder.listFiles()) {
            if (!file.canRead()) continue;
            if (file.isDirectory()) {
                if (file.isHidden()) {
                    LOG.debug("Skipping hidden directory: " + file.getAbsolutePath());
                    continue;
                }
                resourceNames.addAll(this.findResourceNamesFromFileSystem(scanRootLocation, file));
                continue;
            }
            resourceNames.add(file.getPath());
        }
        return resourceNames;
    }
}

