/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.pro;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.oracle.OracleResults;
import org.flywaydb.core.internal.database.oracle.OracleSqlScriptExecutor;
import org.flywaydb.core.internal.database.oracle.pro.AbstractSQLPlusParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusSpoolData;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;

public class SQLPlusSpoolParsedSqlStatement
extends AbstractSQLPlusParsedSqlStatement {
    private static final Log LOG = LogFactory.getLog(SQLPlusSpoolParsedSqlStatement.class);
    private final String transformedSql;
    private SPOOLMode mode;
    private String file = null;
    private boolean append = false;

    public SQLPlusSpoolParsedSqlStatement(int pos, int line, int col, String sql, List<Token> tokens) {
        super(pos, line, col, sql);
        tokens = this.filterTokens(tokens);
        this.transformedSql = this.createTransformedSql(tokens);
        this.determineSpoolMode(tokens);
    }

    private String createTransformedSql(List<Token> tokens) {
        StringBuilder sqlBuilder = new StringBuilder();
        for (int i = 1; i < tokens.size(); ++i) {
            sqlBuilder.append(tokens.get(i).getRawText());
            sqlBuilder.append(' ');
        }
        return sqlBuilder.toString().trim();
    }

    private void determineSpoolMode(List<Token> tokens) {
        if (tokens.size() == 1) {
            this.mode = SPOOLMode.STATE;
        } else {
            String modeText = tokens.get(1).getText();
            if ("OFF".equalsIgnoreCase(modeText)) {
                this.mode = SPOOLMode.OFF;
            } else if ("OUT".equalsIgnoreCase(modeText)) {
                this.mode = SPOOLMode.OUT;
            } else {
                this.mode = SPOOLMode.ON;
                this.file = modeText;
                this.append = tokens.size() > 2 && tokens.get(2).getText().toUpperCase(Locale.ENGLISH).startsWith("APP");
            }
        }
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        LOG.info(this.getTransformedSql());
        OracleSqlScriptExecutor oracleExecutor = (OracleSqlScriptExecutor)sqlScriptExecutor;
        SQLPlusSpoolData spoolData = oracleExecutor.getSpoolData();
        if (this.mode == SPOOLMode.STATE) {
            if (spoolData == null) {
                LOG.info("SPOOL OFF");
            } else {
                LOG.info("SPOOL ON");
            }
        } else {
            if (spoolData != null) {
                try {
                    spoolData.close();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), e);
                }
            }
            if (this.mode == SPOOLMode.ON) {
                OracleResults results = new OracleResults();
                results.setSpoolData(new SQLPlusSpoolData(this.file, this.append));
                return results;
            }
            if (this.mode == SPOOLMode.OUT && spoolData != null) {
                try {
                    spoolData.printFileContents();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), e);
                }
            }
        }
        return new OracleResults();
    }

    String getTransformedSql() {
        return this.transformedSql;
    }

    static enum SPOOLMode {
        STATE,
        ON,
        OFF,
        OUT;

    }
}

