/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.authentication.mysql.enterprise;

import java.util.Properties;
import org.flywaydb.core.internal.authentication.ExternalAuthFileReader;
import org.flywaydb.core.internal.authentication.ExternalAuthPropertiesProvider;
import org.flywaydb.core.internal.util.StringUtils;

public class MySQLPropertiesProvider
implements ExternalAuthPropertiesProvider {
    private final ExternalAuthFileReader mysqlAuthFileReader;

    public MySQLPropertiesProvider(ExternalAuthFileReader mysqlAuthFileReader) {
        this.mysqlAuthFileReader = mysqlAuthFileReader;
    }

    @Override
    public Properties get() {
        Properties properties = new Properties();
        for (String authFileContents : this.mysqlAuthFileReader.getAllContents()) {
            authFileContents = authFileContents.replace("\r\n", "\n");
            boolean groupAccepted = false;
            for (String optionFileLine : authFileContents.split("\n")) {
                if (optionFileLine.startsWith(";") || optionFileLine.startsWith("#") || !StringUtils.hasText(optionFileLine)) continue;
                if ((optionFileLine = this.removeComments(optionFileLine)).startsWith("[") && optionFileLine.endsWith("]")) {
                    groupAccepted = this.isGroupAccepted(optionFileLine);
                    continue;
                }
                String parameter = optionFileLine.split("=")[0].trim();
                if (!groupAccepted || !this.isParameterAccepted(parameter)) continue;
                String value = optionFileLine.split("=")[1].trim().replaceAll("^\"|\"$", "");
                properties.put(parameter, this.convertEscapeSequences(value));
            }
        }
        return properties;
    }

    private String removeComments(String line) {
        int commentStart = line.indexOf("#");
        if (commentStart == -1) {
            return line.trim();
        }
        return line.substring(0, commentStart).trim();
    }

    private boolean isGroupAccepted(String group) {
        return group.equalsIgnoreCase("[client]") || group.equalsIgnoreCase("[flyway]");
    }

    private boolean isParameterAccepted(String parameter) {
        return parameter.equalsIgnoreCase("user") || parameter.equalsIgnoreCase("password");
    }

    private String convertEscapeSequences(String value) {
        return value.replaceAll("\\\\b", "\b").replaceAll("\\\\t", "\t").replaceAll("\\\\n", "\n").replaceAll("\\\\r", "\r").replace("\\\\", "\\").replaceAll("\\\\s", " ");
    }
}

