/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.jdbc.JdbcDataType;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.rpc.Code;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class JdbcArray
implements java.sql.Array {
    private static final String FREE_EXCEPTION = "free() has been called, array is no longer available";
    private final JdbcDataType type;
    private Object data;
    private boolean freed = false;
    private static final String RESULTSET_NOT_SUPPORTED = "Getting a ResultSet from an array is not supported";

    static JdbcArray createArray(String typeName, Object[] elements) throws SQLException {
        for (JdbcDataType type : JdbcDataType.values()) {
            if (!type.getTypeName().equalsIgnoreCase(typeName)) continue;
            return new JdbcArray(type, elements);
        }
        throw JdbcSqlExceptionFactory.of("Data type " + typeName + " is unknown", Code.INVALID_ARGUMENT);
    }

    static JdbcArray createArray(JdbcDataType type, List<? extends Object> elements) {
        return new JdbcArray(type, elements);
    }

    private JdbcArray(JdbcDataType type, Object[] elements) throws SQLException {
        this.type = type;
        if (elements != null) {
            this.data = Array.newInstance(type.getJavaClass(), elements.length);
            try {
                System.arraycopy(elements, 0, this.data, 0, elements.length);
            }
            catch (Exception e) {
                throw JdbcSqlExceptionFactory.of("Could not copy array elements. Make sure the supplied array only contains elements of class " + type.getJavaClass().getName(), Code.UNKNOWN, e);
            }
        }
    }

    private JdbcArray(JdbcDataType type, List<? extends Object> elements) {
        this.type = type;
        if (elements != null) {
            this.data = Array.newInstance(type.getJavaClass(), elements.size());
            elements.toArray((Object[])this.data);
        }
    }

    private void checkFree() throws SQLException {
        if (this.freed) {
            throw JdbcSqlExceptionFactory.of(FREE_EXCEPTION, Code.FAILED_PRECONDITION);
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        this.checkFree();
        return this.type.getTypeName();
    }

    @Override
    public int getBaseType() throws SQLException {
        this.checkFree();
        return this.type.getSqlType();
    }

    @Override
    public Object getArray() throws SQLException {
        this.checkFree();
        return this.data;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        this.checkFree();
        return this.data;
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        this.checkFree();
        return this.getArray(index, count, null);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        this.checkFree();
        if (this.data != null) {
            Object res = Array.newInstance(this.type.getJavaClass(), count);
            System.arraycopy(this.data, (int)index - 1, res, 0, count);
            return res;
        }
        return null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new SQLFeatureNotSupportedException(RESULTSET_NOT_SUPPORTED);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(RESULTSET_NOT_SUPPORTED);
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException(RESULTSET_NOT_SUPPORTED);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(RESULTSET_NOT_SUPPORTED);
    }

    @Override
    public void free() throws SQLException {
        this.freed = true;
        this.data = null;
    }

    public String toString() {
        if (this.data == null) {
            return "null";
        }
        boolean first = true;
        StringBuilder builder = new StringBuilder("{");
        for (Object o : (Object[])this.data) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            if (o == null) {
                builder.append("null");
                continue;
            }
            builder.append(o.toString());
        }
        builder.append("}");
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof JdbcArray)) {
            return false;
        }
        JdbcArray array = (JdbcArray)other;
        return this.type == array.type && Arrays.deepEquals((Object[])this.data, (Object[])array.data);
    }

    public int hashCode() {
        return this.type.hashCode() ^ Arrays.deepHashCode((Object[])this.data);
    }
}

