/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.jdbc.JdbcConnection;
import com.google.cloud.spanner.jdbc.JdbcParameterStore;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.cloud.spanner.jdbc.JdbcStatement;
import com.google.cloud.spanner.jdbc.JdbcTypeConverter;
import com.google.rpc.Code;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

abstract class AbstractJdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement {
    private static final String METHOD_NOT_ON_PREPARED_STATEMENT = "This method may not be called on a PreparedStatement";
    private final JdbcParameterStore parameters = new JdbcParameterStore();

    AbstractJdbcPreparedStatement(JdbcConnection connection) {
        super(connection);
    }

    JdbcParameterStore getParameters() {
        return this.parameters;
    }

    private <T> T checkClosedAndThrowNotOnPreparedStatement() throws SQLException {
        this.checkClosed();
        throw JdbcSqlExceptionFactory.of(METHOD_NOT_ON_PREPARED_STATEMENT, Code.INVALID_ARGUMENT);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return (ResultSet)this.checkClosedAndThrowNotOnPreparedStatement();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return (Integer)this.checkClosedAndThrowNotOnPreparedStatement();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return (Boolean)this.checkClosedAndThrowNotOnPreparedStatement();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosedAndThrowNotOnPreparedStatement();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, null, sqlType, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 16);
    }

    @Override
    public void setByte(int parameterIndex, byte value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, -6);
    }

    @Override
    public void setShort(int parameterIndex, short value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 5);
    }

    @Override
    public void setInt(int parameterIndex, int value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 4);
    }

    @Override
    public void setLong(int parameterIndex, long value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, -5);
    }

    @Override
    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, Float.valueOf(value), 6);
    }

    @Override
    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 8);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 3);
    }

    @Override
    public void setString(int parameterIndex, String value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, -9);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, -2);
    }

    @Override
    public void setDate(int parameterIndex, Date value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 91);
    }

    @Override
    public void setTime(int parameterIndex, Time value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 92);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 93);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value, int length) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 12, length);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream value, int length) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, -9, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, int length) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, -2, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClosed();
        this.parameters.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object value, int targetSqlType) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, targetSqlType, null);
    }

    @Override
    public void setObject(int parameterIndex, Object value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, null);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, reader, -9, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 2006);
    }

    @Override
    public void setBlob(int parameterIndex, Blob value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 2004);
    }

    @Override
    public void setClob(int parameterIndex, Clob value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 2005);
    }

    @Override
    public void setArray(int parameterIndex, Array value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 2003);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        try (ResultSet rs = this.executeQuery();){
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            return resultSetMetaData;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date value, Calendar cal) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 91);
    }

    @Override
    public void setTime(int parameterIndex, Time value, Calendar cal) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 92);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp value, Calendar cal) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, cal == null ? value : JdbcTypeConverter.setTimestampInCalendar(value, cal), 93);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, null, sqlType, null);
    }

    @Override
    public void setURL(int parameterIndex, URL value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, -9);
    }

    @Override
    public void setRowId(int parameterIndex, RowId value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, -8);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, -9);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, -9);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 2011);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, reader, 2005);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, inputStream, 2004);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, reader, 2011);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, xmlObject, 2009);
    }

    @Override
    public void setObject(int parameterIndex, Object value, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value, long length) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 12);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, long length) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, -2);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, reader, -9);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, 12);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, -2);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, reader, -9);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, value, -9);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, reader, 2005);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, inputStream, 2004);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkClosed();
        this.parameters.setParameter(parameterIndex, reader, -9);
    }
}

