/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc.pro;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.util.FeatureDetector;

public class GcsOutputStream
extends ByteArrayOutputStream {
    private static final Log LOG = LogFactory.getLog(GcsOutputStream.class);
    private final String location;
    private final String bucket;
    private final String key;

    public GcsOutputStream(String location) {
        this.location = location;
        int i = location.indexOf("/");
        this.bucket = location.substring(4, i);
        this.key = location.substring(i + 1);
    }

    @Override
    public void close() throws IOException {
        FeatureDetector fd = new FeatureDetector(Thread.currentThread().getContextClassLoader());
        if (fd.isGCSAvailable()) {
            Storage storage = (Storage)StorageOptions.getDefaultInstance().getService();
            BlobId blobId = BlobId.of((String)this.bucket, (String)this.key);
            BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).setContentType("text/plain").build();
            Blob blob = storage.create(blobInfo, this.toByteArray(), new Storage.BlobTargetOption[0]);
        } else {
            LOG.error("Can't write to location " + this.location + "; Google Cloud Storage SDK not found");
        }
    }
}

