/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.enterprise.script;

import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.executor.Context;
import org.flywaydb.core.api.executor.MigrationExecutor;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.DatabaseExecutionStrategy;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.database.base.DatabaseType;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.util.FileCopyUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class ScriptMigrationExecutor
implements MigrationExecutor {
    private static final Log LOG = LogFactory.getLog(ScriptMigrationExecutor.class);
    private final LoadableResource resource;

    public ScriptMigrationExecutor(LoadableResource resource) {
        this.resource = resource;
    }

    @Override
    public void execute(Context context) throws SQLException {
        DatabaseType databaseType = DatabaseTypeRegister.getDatabaseTypeForConnection(context.getConnection());
        DatabaseExecutionStrategy strategy = databaseType.createExecutionStrategy(context.getConnection());
        strategy.execute(() -> {
            this.executeOnce(context);
            return true;
        });
    }

    private void executeOnce(Context context) {
        try {
            this.runScript(context);
        }
        catch (Exception e) {
            throw new FlywayException("Migration failed !", e);
        }
    }

    private String join(String joiner, List<String> strings) {
        if (strings.size() == 1) {
            return strings.get(0);
        }
        StringBuilder output = new StringBuilder();
        for (String s : strings) {
            output.append(s).append(joiner);
        }
        return output.toString();
    }

    private List<String> getProcessArgs() {
        String resourcePath = this.resource.getAbsolutePathOnDisk();
        String resourceExt = StringUtils.getFileExtension(resourcePath);
        ArrayList<String> args = new ArrayList<String>();
        if ("bat".equals(resourceExt) || "cmd".equals(resourceExt)) {
            args.add("cmd");
            args.add("/c");
            args.add(resourcePath);
        } else if ("ps1".equals(resourceExt)) {
            args.add("powershell");
            args.add(resourcePath);
        } else if ("py".equals(resourceExt)) {
            args.add("python");
            args.add(resourcePath);
        } else if ("sh".equals(resourceExt)) {
            args.add("sh");
            args.add(resourcePath);
        } else if ("bash".equals(resourceExt)) {
            args.add("bash");
            args.add(resourcePath);
        } else {
            File file = new File(resourcePath);
            if (!file.canExecute()) {
                file.setExecutable(true, true);
            }
            args.add(resourcePath);
        }
        return args;
    }

    private void setIfNotNull(ProcessBuilder builder, String property, String value) {
        if (value != null && !value.isEmpty()) {
            builder.environment().put(property, value);
        }
    }

    private void runScript(Context context) throws Exception {
        List<String> args = this.getProcessArgs();
        LOG.debug("Executing " + this.join(" ", args));
        String url = context.getConfiguration().getUrl();
        String username = context.getConfiguration().getUser();
        String password = context.getConfiguration().getPassword();
        if (url == null) {
            try {
                url = context.getConnection().getMetaData().getURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (username == null) {
            try {
                username = context.getConnection().getMetaData().getUserName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ProcessBuilder builder = new ProcessBuilder(args);
        this.setIfNotNull(builder, "FLYWAY_URL", url);
        this.setIfNotNull(builder, "FLYWAY_USER", username);
        this.setIfNotNull(builder, "FLYWAY_PASSWORD", password);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        String stdOut = FileCopyUtils.copyToString(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        int returnCode = process.waitFor();
        LOG.debug(stdOut);
        if (returnCode != 0) {
            throw new FlywayException(stdOut);
        }
    }

    @Override
    public boolean canExecuteInTransaction() {
        return true;
    }
}

